/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxserver.web;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.media.video.Video;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResourceReference;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxserver.web.AbstractBasePage;

public class VideoPage
extends AbstractBasePage {
    private String moviePath;
    private Movie movie;

    public VideoPage(Movie movie, String moviePath) {
        this.movie = movie;
        this.moviePath = moviePath;
        this.moviePath = this.moviePath.replace(" ", "%20");
        this.moviePath = this.moviePath.replace("#", "%23");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (Serializable)((Object)this.movie.getTitle()))});
        try {
            Path path = FileSystemResourceReference.getPath((URI)URI.create("file:///" + this.moviePath));
            FileSystemResourceReference ref = new FileSystemResourceReference("video" + new Date().toString(), path);
            Video video = new Video("video", (ResourceReference)ref);
            video.setAutoplay(true);
            video.setLooping(true);
            if (!this.movie.getScenes().isEmpty()) {
                int startTime = ((Scene)this.movie.getScenes().get(0)).getStartTime();
                startTime = this.getStarttimeForSceneUsingSmartStart((Scene)this.movie.getScenes().get(0), startTime);
                video.setStartTime("" + startTime);
            }
            this.add(new Component[]{video});
        }
        catch (Exception ex) {
            Logger.getLogger(VideoPage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getStarttimeForSceneUsingSmartStart(Scene scene, int startTime) {
        if (this.db.getScenerixxSettings().isUseSmartStart()) {
            for (Bookmark sceneBookmark : scene.getBookmarks(false)) {
                if (BookmarkType.STORY.equals((Object)sceneBookmark.getType()) && this.db.getScenerixxSettings().isSkipStory()) {
                    startTime = sceneBookmark.getEndTime();
                    break;
                }
                if (!BookmarkType.INTERVIEW.equals((Object)sceneBookmark.getType()) || !this.db.getScenerixxSettings().isSkipInterview()) continue;
                startTime = sceneBookmark.getEndTime();
                break;
            }
        }
        return startTime;
    }
}

