/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.NoResultPanel;
import xxx.scenerixx.scenerixxhub.web.Paginator;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxhub.web.SearchResultRowPanel;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;

public class SearchResultPanel
extends Panel {
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private IModel<List<Long>> movies;
    protected transient DB db = DB.getInstance();
    int index = 0;

    public SearchResultPanel(String id) {
        super(id);
    }

    public SearchResultPanel(String id, IModel<List<Long>> movies) {
        super(id);
        this.LOGGER.info("movie IDs passed: " + ((List)movies.getObject()).size());
        this.movies = movies;
        ArrayList<Long> tmpIds = new ArrayList<Long>();
        for (Long movieId : (List)movies.getObject()) {
            Movie m = (Movie)this.db.getEntityService().load(Movie.class, movieId.longValue());
            List mediumFiles = this.db.getMediumFiles(m, ScenerixxHubSession.get().isUnlocked());
            for (MediumFile mf : mediumFiles) {
                if (!Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    this.LOGGER.info(mf.getFileCompletePath() + " does not exists or is online");
                    continue;
                }
                if (!mf.getFileExtension().equalsIgnoreCase("mp4") && !mf.getFileExtension().equalsIgnoreCase("m4v")) {
                    this.LOGGER.info(mf.getFileCompletePath() + " has an unsupported format");
                    continue;
                }
                tmpIds.add(movieId);
            }
        }
        movies.setObject(tmpIds);
    }

    protected void onInitialize() {
        super.onInitialize();
        int itemsPerRow = 4;
        int totalRows = 3;
        WebMarkupContainer wmc = new WebMarkupContainer("wmc");
        PageableListView<Long> movieCards = new PageableListView<Long>("movieCards", this.movies, 12L){

            protected void populateItem(ListItem<Long> item) {
                if (item.getIndex() % 12 == 0) {
                    SearchResultPanel.this.LOGGER.info("populating " + item.getIndex() + " - " + Math.min(item.getIndex() * 4 + 4, ((List)SearchResultPanel.this.movies.getObject()).size()) + " - movsize " + ((List)SearchResultPanel.this.movies.getObject()).size());
                    List subList = ((List)SearchResultPanel.this.movies.getObject()).subList(Math.min(item.getIndex(), ((List)SearchResultPanel.this.movies.getObject()).size()), Math.min(item.getIndex() + 4, ((List)SearchResultPanel.this.movies.getObject()).size()));
                    List subList2 = ((List)SearchResultPanel.this.movies.getObject()).subList(Math.min(item.getIndex() + subList.size(), ((List)SearchResultPanel.this.movies.getObject()).size()), Math.min(item.getIndex() + subList.size() + 4, ((List)SearchResultPanel.this.movies.getObject()).size()));
                    List subList3 = ((List)SearchResultPanel.this.movies.getObject()).subList(Math.min(item.getIndex() + subList.size() + subList2.size(), ((List)SearchResultPanel.this.movies.getObject()).size()), Math.min(item.getIndex() + subList.size() + subList2.size() + 4, ((List)SearchResultPanel.this.movies.getObject()).size()));
                    RepeatingView rows = new RepeatingView("rows");
                    rows.add(new Component[]{new SearchResultRowPanel(rows.newChildId(), (IModel<List<Long>>)Model.ofList(subList))});
                    rows.add(new Component[]{new SearchResultRowPanel(rows.newChildId(), (IModel<List<Long>>)Model.ofList(subList2))});
                    rows.add(new Component[]{new SearchResultRowPanel(rows.newChildId(), (IModel<List<Long>>)Model.ofList(subList3))});
                    item.add(new Component[]{rows});
                } else {
                    SearchResultPanel.this.LOGGER.info("no result found");
                    item.add(new Component[]{new EmptyPanel("rows")});
                }
            }
        };
        Paginator paginator = new Paginator("navigator", (IPageable)movieCards);
        wmc.add(new Component[]{paginator});
        if (((List)this.movies.getObject()).isEmpty()) {
            this.LOGGER.info("empty panel");
            WebMarkupContainer wmcEmpty = new WebMarkupContainer("movieCards");
            wmcEmpty.add(new Component[]{new NoResultPanel("rows")});
            wmc.add(new Component[]{wmcEmpty});
            paginator.setVisible(false);
        } else {
            this.LOGGER.info("add movies");
            wmc.add(new Component[]{movieCards});
        }
        wmc.setOutputMarkupId(true);
        this.add(new Component[]{wmc});
    }
}

