/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;

public class ChartLine
implements ChartPart {
    protected XChartPanel chartPanel;
    protected Chart chart;
    protected Rectangle bounds;
    protected boolean visible = true;
    protected Color color = new Color(114, 147, 203);
    protected BasicStroke stroke = SOLID_STROKE;
    protected double value;
    protected boolean vertical;
    protected boolean valueInScreenCoordinate = false;

    public ChartLine(double value, boolean vertical, boolean valueInScreenCoordinate) {
        this.value = value;
        this.vertical = vertical;
        this.valueInScreenCoordinate = valueInScreenCoordinate;
    }

    public void init(XChartPanel<XYChart> chartPanel) {
        this.chartPanel = chartPanel;
        this.chart = chartPanel.getChart();
        this.chart.addPlotPart(this);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.bounds = g.getClipBounds();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.vertical) {
            y1 = (int)this.bounds.getY();
            y2 = (int)(this.bounds.getY() + this.bounds.getHeight());
        } else {
            x1 = (int)this.bounds.getX();
            x2 = (int)(this.bounds.getX() + this.bounds.getWidth());
        }
        if (this.valueInScreenCoordinate) {
            if (this.vertical) {
                x2 = x1 = (int)this.value;
            } else {
                y2 = y1 = (int)this.value;
            }
        } else if (this.vertical) {
            x2 = x1 = (int)this.chart.getScreenXFromChart(this.value);
        } else {
            y2 = y1 = (int)this.chart.getScreenYFromChart(this.value);
        }
        g.setStroke(this.stroke);
        g.setColor(this.color);
        g.drawLine(x1, y1, x2, y2);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }
}

