/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import xxx.scenerixx.scenerixxlib.db.DB;

public class MediaInformation {
    public static final Logger LOG = Logger.getLogger(MediaInformation.class.getName());
    private final DB db = DB.getInstance();

    public String getMediaInfoValue(String param, String file) throws Exception {
        String result = "";
        ProcessBuilder ps = new ProcessBuilder(this.db.getScenerixxSettings().getPathToMediaInfo() + "mediainfo", param, file);
        ps.redirectErrorStream(true);
        Process pr = ps.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String line = "";
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            LOG.fine("Result for " + param + ": " + line);
            result = line;
        }
        pr.waitFor();
        in.close();
        return result;
    }

    public boolean isMoovFirst(String file) throws Exception {
        String result = "";
        ProcessBuilder ps = new ProcessBuilder(this.db.getScenerixxSettings().getPathToFfmpeg() + "ffprobe", "-v", "trace", file);
        ps.redirectErrorStream(true);
        Process pr = ps.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String line = "";
        boolean moovFound = false;
        boolean mdatFound = false;
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (line.toLowerCase().contains("moov")) {
                moovFound = true;
                break;
            }
            if (line.toLowerCase().contains("mdat")) {
                mdatFound = true;
                break;
            }
            LOG.finest("[isMoov] " + line);
            result = line;
        }
        in.close();
        return moovFound;
    }
}

