/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static final Logger LOG = LoggerFactory.getLogger(Downloader.class);

    public static boolean download(String url, String fileName) throws Exception {
        boolean result = false;
        try (InputStream in = URI.create(url).toURL().openStream();){
            Files.copy(in, Paths.get(fileName, new String[0]), new CopyOption[0]);
            result = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadWithUserAgent(String urlString, String path) throws IOException {
        LOG.info("Downloading " + path + " from " + urlString);
        boolean result = false;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int length;
            URL url = new URL(urlString);
            String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36";
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", USER_AGENT);
            int contentLength = con.getContentLength();
            LOG.info("File contentLength = " + contentLength + " bytes");
            inputStream = con.getInputStream();
            outputStream = new FileOutputStream(path);
            byte[] buffer = new byte[2048];
            int downloaded = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                downloaded += length;
            }
            result = true;
        }
        catch (Exception ex) {
            LOG.error("Could not download. Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result;
    }
}

