/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.service;

import com.querydsl.core.types.Predicate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.playlist.QPlaylist;
import xxx.scenerixx.scenerixxlib.model.playlist.QPlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;

public class PlaylistService {
    private final Logger LOGGER = LoggerFactory.getLogger(PlaylistService.class);
    private final DB db = DB.getInstance();

    public Playlist getDefaultPlaylist(boolean unlocked) {
        Playlist playlist;
        EntityService.Finder find = this.db.getEntityService().find(QPlaylist.playlist);
        if (!unlocked) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if ((playlist = (Playlist)find.filter(f -> f.defaultPlaylist.isTrue()).findFirst()) == null) {
            playlist = new Playlist();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            playlist.setName("[New Playlist " + df.format(LocalDateTime.now()) + "]");
            playlist.setDefaultPlaylist(true);
        }
        return playlist;
    }

    public boolean contains(IPlayable playable, Playlist playlist, boolean showSecrets) {
        boolean contains = false;
        this.LOGGER.info("checking: " + playable.getId() + " - size : " + playlist.getPlayables(showSecrets).size());
        for (IPlayablePlaylistItems tmpPlayable : playlist.getPlayables(showSecrets)) {
            this.LOGGER.debug("currently checking: " + tmpPlayable.getId());
            if (!playable.getClass().equals(tmpPlayable.getClass()) || tmpPlayable.getId() == null || playable.getId() == null || tmpPlayable.getId().longValue() != playable.getId().longValue()) continue;
            this.LOGGER.info("playable ID '" + tmpPlayable.getId() + "' is already on playlist " + playlist.getName());
            contains = true;
            break;
        }
        return contains;
    }

    public boolean contains(IPlayable playable, boolean showSecrets) {
        boolean contains = false;
        for (Playlist playlist : this.getPlaylists(true, true, false)) {
            if (!this.contains(playable, playlist, showSecrets)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean contains(Person person, Playlist playlist, boolean unlocked) {
        boolean contains = false;
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getPerson() == null || pe.getPerson().getId().longValue() != person.getId().longValue()) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean contains(Studio studio, Playlist playlist, boolean unlocked) {
        boolean contains = false;
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getStudio() == null || pe.getStudio().getId().longValue() != studio.getId().longValue()) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean contains(PlaylistEntry entry, Playlist playlist, boolean unlocked) {
        boolean contains = false;
        if (entry.getMediumFile() != null) {
            return this.contains(entry.getMediumFile(), playlist, unlocked);
        }
        if (entry.getStudio() != null) {
            return this.contains(entry.getStudio(), playlist, unlocked);
        }
        if (entry.getMovie() != null) {
            return this.contains(entry.getMovie(), playlist, unlocked);
        }
        if (entry.getScene() != null) {
            return this.contains(entry.getScene(), playlist, unlocked);
        }
        if (entry.getBookmark() != null) {
            return this.contains(entry.getBookmark(), playlist, unlocked);
        }
        return contains;
    }

    public int getPositionInPlaylist(IPlayablePlaylistItems playable, Playlist playlist, boolean showSecrets) {
        boolean contains = false;
        int i = 1;
        this.LOGGER.info("position size: " + playlist.getPlayables(showSecrets).size());
        for (IPlayablePlaylistItems tmpPlayable : playlist.getPlayables(showSecrets)) {
            this.LOGGER.info("- " + tmpPlayable.getId() + " - " + playable.getId());
            if (tmpPlayable.getId() != null && playable.getId() != null && tmpPlayable.getId().longValue() == playable.getId().longValue()) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            i = -1;
        }
        return i;
    }

    public int getPositionInPlaylist(Person person, Playlist playlist, boolean unlocked) {
        boolean contains = false;
        int i = 1;
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getPerson() != null && pe.getPerson().getId().longValue() == person.getId().longValue()) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            i = -1;
        }
        return i;
    }

    public int getPositionInPlaylist(Studio studio, Playlist playlist, boolean unlocked) {
        boolean contains = false;
        int i = 1;
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getStudio() != null && pe.getStudio().getId().longValue() == studio.getId().longValue()) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            i = -1;
        }
        return i;
    }

    public void addPlaylistEntry(PlaylistEntry pe, boolean unlocked) {
        Playlist playlist = this.getDefaultPlaylist(unlocked);
        if (playlist.getId() == null && playlist.isDefaultPlaylist()) {
            this.saveAsNewDefaultPlaylist(playlist);
        }
        this.addPlaylistEntry(pe, playlist, unlocked);
    }

    public Playlist addPlaylistEntry(PlaylistEntry pe, Playlist playlist, boolean unlocked) {
        int lastPosition = -1;
        if (!playlist.getEntries(unlocked).isEmpty()) {
            lastPosition = playlist.getEntries(unlocked).get(playlist.getEntries(unlocked).size() - 1).getPos();
        }
        pe.setPos(lastPosition + 1);
        pe.setPlaylist(playlist);
        playlist.getEntries(unlocked).add(pe);
        playlist = this.db.getEntityService().save(playlist);
        return playlist;
    }

    public List<Playlist> getPlaylists(boolean showSecret, boolean orderByDateOfCreation) {
        return this.getPlaylists(showSecret, orderByDateOfCreation, true, true);
    }

    public List<Playlist> getPlaylists(boolean showSecret, boolean orderByDateOfCreation, boolean showArchived) {
        return this.getPlaylists(showSecret, orderByDateOfCreation, true, showArchived);
    }

    public List<Playlist> getPlaylists(boolean showSecret, boolean orderByDateOfCreation, boolean showSpecialLists, boolean showArchived) {
        EntityService.Finder find = this.db.getEntityService().find(QPlaylist.playlist);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (!showArchived) {
            find = find.filter(f -> f.archived.ne((Object)true));
        }
        ArrayList<Playlist> result = new ArrayList<Playlist>();
        find = orderByDateOfCreation ? find.order(p -> p.dateOfCreation.desc()) : find.order(p -> p.name.asc());
        List tmpResult = find.find();
        for (Playlist p2 : tmpResult) {
            if (p2.isDefaultPlaylist() || p2.isHistoryPlaylist() || p2.isSecretHistoryPlaylist()) {
                if (!showSpecialLists) continue;
                result.add(0, p2);
                continue;
            }
            result.add(p2);
        }
        return result;
    }

    public List<Playlist> getPlaylists(boolean showSecret, Movie movie) {
        EntityService.Finder find = this.db.getEntityService().find(QPlaylist.playlist);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = find.filter(f -> ((QPlaylistEntry)f.entries.any()).movie.isNotNull().and((Predicate)((QPlaylistEntry)f.entries.any()).movie.eq(movie)).or((Predicate)((QPlaylistEntry)f.entries.any()).scene.isNotNull().and((Predicate)((QPlaylistEntry)f.entries.any()).scene.movie.eq(movie))).or((Predicate)((QPlaylistEntry)f.entries.any()).bookmark.isNotNull().and((Predicate)((QPlaylistEntry)f.entries.any()).bookmark.movie.eq(movie))));
        ArrayList<Playlist> result = new ArrayList<Playlist>();
        List tmpResult = find.find();
        for (Playlist p : tmpResult) {
            if (p.isHistoryPlaylist() || p.isSecretHistoryPlaylist()) continue;
            result.add(p);
        }
        return result;
    }

    public List<PlaylistEntry> getPlaylistEntries(boolean showSecret, IPlayable playable) {
        EntityService.Finder find = this.db.getEntityService().find(QPlaylistEntry.playlistEntry);
        if (!showSecret) {
            find = find.filter(f -> f.playlist.secret.ne((Object)true));
        }
        if (playable instanceof Movie) {
            find = find.filter(f -> f.movie.isNotNull().and((Predicate)f.movie.id.eq((Object)playable.getId())));
        } else if (playable instanceof Scene) {
            find = find.filter(f -> f.scene.isNotNull().and((Predicate)f.scene.id.eq((Object)playable.getId())));
        } else if (playable instanceof Bookmark) {
            find = find.filter(f -> f.bookmark.isNotNull().and((Predicate)f.bookmark.id.eq((Object)playable.getId())));
        }
        find = find.filter(f -> f.playlist.name.notLike("[TEMPORARY PLAYLIST]").and((Predicate)f.playlist.name.notLike("History")));
        find = find.order(p -> p.playlist.name.asc());
        return find.find();
    }

    public Playlist saveAsNewDefaultPlaylist(Playlist playlist) {
        for (Playlist p : this.getPlaylists(true, true)) {
            p.setDefaultPlaylist(false);
            this.db.getEntityService().save(p);
        }
        playlist.setDefaultPlaylist(true);
        return this.db.getEntityService().save(playlist);
    }

    public Playlist getHistoryPlaylist() {
        Playlist historyPlaylist = (Playlist)this.db.getEntityService().find(QPlaylist.playlist).filter(f -> f.name.eq((Object)"History")).findFirst();
        if (historyPlaylist == null) {
            historyPlaylist = new Playlist();
            historyPlaylist.setName("History");
            historyPlaylist.setDateOfCreation(LocalDateTime.now());
            historyPlaylist = this.db.getEntityService().save(historyPlaylist);
        }
        return historyPlaylist;
    }

    public Playlist getSecretHistoryPlaylist() {
        Playlist secretHistoryPlaylist = (Playlist)this.db.getEntityService().find(QPlaylist.playlist).filter(f -> f.name.eq((Object)"Secret History")).findFirst();
        if (secretHistoryPlaylist == null) {
            secretHistoryPlaylist = new Playlist();
            secretHistoryPlaylist.setName("Secret History");
            secretHistoryPlaylist.setSecret(true);
            secretHistoryPlaylist.setDateOfCreation(LocalDateTime.now());
            secretHistoryPlaylist = this.db.getEntityService().save(secretHistoryPlaylist);
        }
        return secretHistoryPlaylist;
    }

    public List<PlaylistEntry> getHistoryPlaylistEntries(boolean unlocked) {
        EntityService.Finder find = this.db.getEntityService().find(QPlaylistEntry.playlistEntry);
        List<PlaylistEntry> entries = find.filter(f -> f.playlist.eq(this.getHistoryPlaylist())).filter(f -> f.playlist.eq(this.getHistoryPlaylist())).order(f -> f.dateOfCreation.desc()).find();
        if (unlocked) {
            return entries;
        }
        ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
        for (PlaylistEntry pe : entries) {
            if (pe.getMovie() != null && pe.getMovie().isSecret() || pe.getBookmark() != null && pe.getBookmark().isSecret() || pe.getScene() != null && pe.getScene().getMovieAssociated() != null && pe.getScene().getMovieAssociated().isSecret() || pe.getMediumFile() != null && pe.getMediumFile().isSecret()) continue;
            tmpList.add(pe);
        }
        return tmpList;
    }

    public List<PlaylistEntry> getSecretHistoryPlaylistEntries() {
        EntityService.Finder find = this.db.getEntityService().find(QPlaylistEntry.playlistEntry);
        return find.filter(f -> f.playlist.eq(this.getSecretHistoryPlaylist())).order(f -> f.dateOfCreation.desc()).find();
    }

    public void addHistoryEntry(IPlayable playable, boolean unlocked) {
        if (playable instanceof Movie && ((Movie)playable).isSecret() || playable instanceof Bookmark && ((Bookmark)playable).isSecret()) {
            this.addSecretHistoryEntry(playable, unlocked);
        } else {
            Playlist historyPlaylist = this.getHistoryPlaylist();
            PlaylistEntry pe = new PlaylistEntry();
            pe.setDateOfCreation(LocalDateTime.now());
            pe.setPlaylist(historyPlaylist);
            if (playable instanceof Movie) {
                Movie movie = (Movie)playable;
                pe.setMovie(movie);
            }
            if (playable instanceof Scene) {
                Scene scene = (Scene)playable;
                pe.setScene(scene);
            }
            if (playable instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)playable;
                pe.setBookmark(bookmark);
            }
            pe.setDateOfCreation(LocalDateTime.now());
            pe.setPos(1);
            if (!historyPlaylist.getEntries(unlocked).isEmpty()) {
                pe.setPos(historyPlaylist.getEntries(unlocked).get(0).getPos() + 1);
            }
            pe = this.db.getEntityService().save(pe);
            historyPlaylist.getEntries(unlocked).add(pe);
            historyPlaylist.setDateOfLastModification(LocalDateTime.now());
            this.db.getEntityService().save(historyPlaylist);
        }
    }

    private void addSecretHistoryEntry(IPlayable playable, boolean unlocked) {
        Playlist secretHistoryPlaylist = this.getSecretHistoryPlaylist();
        PlaylistEntry pe = new PlaylistEntry();
        pe.setDateOfCreation(LocalDateTime.now());
        pe.setPlaylist(secretHistoryPlaylist);
        if (playable instanceof Movie) {
            Movie movie = (Movie)playable;
            pe.setMovie(movie);
        }
        if (playable instanceof Scene) {
            Scene scene = (Scene)playable;
            pe.setScene(scene);
        }
        if (playable instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)playable;
            pe.setBookmark(bookmark);
        }
        pe.setDateOfCreation(LocalDateTime.now());
        pe.setPos(1);
        if (!secretHistoryPlaylist.getEntries(unlocked).isEmpty()) {
            pe.setPos(secretHistoryPlaylist.getEntries(unlocked).get(0).getPos() + 1);
        }
        pe = this.db.getEntityService().save(pe);
        secretHistoryPlaylist.getEntries(unlocked).add(pe);
        secretHistoryPlaylist.setDateOfLastModification(LocalDateTime.now());
        this.db.getEntityService().save(secretHistoryPlaylist);
    }

    public void mergePlaylist(Playlist source, Playlist target, boolean unlocked) {
        int newPosition = target.getEntries(unlocked).size();
        for (PlaylistEntry pe : source.getEntries(unlocked)) {
            pe.setPos(newPosition++);
        }
        target.getEntries(unlocked).addAll(source.getEntries(unlocked));
        for (PlaylistEntry pe : target.getEntries(unlocked)) {
            pe.setPlaylist(target);
        }
        this.deletePlaylist(source);
        target = this.db.getEntityService().save(target);
    }

    public void copyPlaylist(Playlist source, Playlist target, boolean unlocked) {
        for (PlaylistEntry pe : source.getEntries(unlocked)) {
            this.db.getEntityService().getEntityManager().detach((Object)pe);
            PlaylistEntry peNew = pe;
            peNew.setId(null);
            this.addPlaylistEntry(peNew, target, unlocked);
        }
    }

    public void copyPlaylistEntry(PlaylistEntry pe, Playlist target, boolean unlocked) {
        this.db.getEntityService().getEntityManager().detach((Object)pe);
        PlaylistEntry peNew = pe;
        peNew.setId(null);
        target = this.addPlaylistEntry(peNew, target, unlocked);
    }

    public void movePlaylistEntry(PlaylistEntry pe, Playlist target, boolean unlocked) {
        Long id = pe.getId();
        PlaylistEntry peNew = pe;
        peNew.setId(null);
        target = this.addPlaylistEntry(peNew, target, unlocked);
        pe.setId(id);
        this.deletePlaylistEntry(pe, true, unlocked);
    }

    public void deletePlaylist(Playlist playlist) {
        Statistic stat = (Statistic)this.db.getEntityService().find(QStatistic.statistic).filter(f -> f.playlist.eq(playlist)).findFirst();
        if (stat != null) {
            this.db.getEntityService().delete(stat);
        }
        for (PlaylistEntry pe : playlist.getEntries(true)) {
            this.db.getEntityService().delete(pe);
        }
        this.db.getEntityService().delete(playlist);
    }

    public boolean deletePlaylistEntries(List<PlaylistEntry> list, boolean reposition, boolean unlocked) {
        boolean reload = false;
        this.LOGGER.info("PLAYLISTSERVICE remove entries");
        ArrayList<Playlist> playlistList = new ArrayList<Playlist>();
        for (PlaylistEntry pe : list) {
            pe.getPlaylist().getEntries(unlocked).remove(pe);
            if (playlistList.contains(pe.getPlaylist())) continue;
            playlistList.add(pe.getPlaylist());
        }
        for (Playlist p : playlistList) {
            p = this.db.getEntityService().save(p);
        }
        for (PlaylistEntry pe : list) {
            this.db.getEntityService().delete(pe);
        }
        for (Playlist playlist : playlistList) {
            if (!reposition || playlist.isHistoryPlaylist()) continue;
            this.LOGGER.info("Resetting positions");
            int i = 0;
            for (PlaylistEntry entry : playlist.getEntries(true)) {
                entry.setPos(i);
                this.LOGGER.info("pos: " + entry.getPos() + " - " + entry.getNameOfPlayable());
                ++i;
                entry = this.db.getEntityService().save(entry);
            }
            this.LOGGER.info("Playlist is in dirty state. Needs reload.");
            reload = true;
        }
        return reload;
    }

    public boolean deletePlaylistEntry(PlaylistEntry pe, boolean reposition) {
        return this.deletePlaylistEntry(pe, reposition, true);
    }

    public boolean deletePlaylistEntry(PlaylistEntry pe, boolean reposition, boolean unlocked) {
        ArrayList<PlaylistEntry> peList = new ArrayList<PlaylistEntry>();
        peList.add(pe);
        return this.deletePlaylistEntries(peList, reposition, unlocked);
    }

    public boolean exists(String name) {
        Playlist findFirst = (Playlist)this.db.getEntityService().find(QPlaylist.playlist).filter(f -> f.name.equalsIgnoreCase(name)).findFirst();
        return findFirst != null;
    }

    public Playlist correctAllPositions(Playlist playlist, boolean unlocked) {
        playlist = this.db.getEntityService().load(Playlist.class, playlist.getId());
        List<PlaylistEntry> entries = playlist.getEntries(unlocked);
        this.LOGGER.info("Correct positions in playlist " + playlist.getName() + " - " + entries.size() + " entries");
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).setPos(i);
            entries.set(i, this.db.getEntityService().save(entries.get(i)));
            this.LOGGER.info(i + " - " + playlist.getName() + " - " + entries.get(i).getNameOfPlayable() + " - new position: " + entries.get(i).getPos());
        }
        playlist = this.db.getEntityService().save(playlist);
        return playlist;
    }
}

