/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.persistence.annotations.Index;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.PersonWebsites;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPartSize;
import xxx.scenerixx.scenerixxlib.model.enums.CauseOfDeath;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.HairColor;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.enums.PersonHeight;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.person.FavoriteTimespan;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;

@Entity
public class Person
extends AbstractEntity
implements INode,
Cloneable,
Serializable,
IPlayablePlaylistItems,
Comparable<Person> {
    @Enumerated(value=EnumType.STRING)
    private Gender gender;
    @Enumerated(value=EnumType.STRING)
    private HairColor hairColor;
    @Enumerated(value=EnumType.STRING)
    private Nationality nationality;
    @Enumerated(value=EnumType.STRING)
    private Ethnicity ethnicity;
    @Index
    private String name;
    private String realName;
    @Lob
    private String comment;
    private String twitter;
    private String officialHomepage;
    private String instagram;
    private String iafd;
    private String wikipedia;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="person")
    @JsonManagedReference
    private List<PersonWebsites> personWebsites = new ArrayList<PersonWebsites>();
    @Lob
    private String otherUrls;
    private Integer birthYear;
    private Integer birthMonth;
    private Integer birthDay;
    private Integer deathYear;
    private Integer deathMonth;
    private Integer deathDay;
    @Enumerated(value=EnumType.STRING)
    private CauseOfDeath causeOfDeath;
    @Lob
    private String causeOfDeathComment;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="person")
    private List<PersonBody> personBodys = new ArrayList<PersonBody>();
    @Enumerated(value=EnumType.STRING)
    private BodyPartSize dickSize;
    @Enumerated(value=EnumType.STRING)
    private Differentiator dickSizeDifferentiator;
    private boolean remindsMeOfFlag;
    @OneToOne
    private Person remindsMeOfPerson1;
    @OneToOne
    private Person remindsMeOfPerson2;
    @OneToOne
    private Person remindsMeOfPerson3;
    @Enumerated(value=EnumType.STRING)
    private PersonHeight personHeight;
    @Enumerated(value=EnumType.STRING)
    private Differentiator personHeightDifferentiator;
    private Integer heightInCm;
    private transient String creditedAs;
    private transient boolean alias;
    private transient int similarityScore;
    private String remindsMeOf;
    private MediumFile picture;
    private boolean secret;
    private boolean favorite;
    private boolean wizardGenerated = false;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="person", fetch=FetchType.LAZY)
    private List<FavoriteTimespan> favorites = new ArrayList<FavoriteTimespan>();
    private Integer ratingAss;
    private Integer ratingTits;
    private Integer ratingPussy;
    private Integer ratingFace;
    private Integer ratingSmile;
    private Integer ratingLaugh;
    private Integer ratingEyes;
    private Integer ratingVoice;
    private Integer ratingCharacter;
    private Integer ratingSympathy;
    private Integer ratingFeet;
    private Integer ratingTeeth;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingAssDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingTitsDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingPussyDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingFaceDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingSmileDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingLaughDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingEyesDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingVoiceDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingCharacterDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingSympathyDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingFeetDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Differentiator ratingTeethDifferentiator;
    private transient boolean noDbConnection = false;

    public Person() {
    }

    public Person(Gender gender, String name, String comment) {
        this.gender = gender;
        this.name = name;
        this.comment = comment;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public HairColor getHairColor() {
        return this.hairColor;
    }

    public void setHairColor(HairColor hairColor) {
        this.hairColor = hairColor;
    }

    public Nationality getNationality() {
        return this.nationality;
    }

    public void setNationality(Nationality nationality) {
        this.nationality = nationality;
    }

    public Ethnicity getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(Ethnicity ethnicity) {
        this.ethnicity = ethnicity;
    }

    public PersonBody getDefaultPersonBody() {
        return DB.getInstance().getDefaultPersonBody(this);
    }

    public String getDisplayedName() {
        if (this.getCreditedAs() != null && !this.getCreditedAs().isEmpty()) {
            return this.name + " as " + this.getCreditedAs();
        }
        return this.name;
    }

    public String getHtmlDisplayedName() {
        return this.getHtmlDisplayedName(false);
    }

    public String getHtmlDisplayedName(boolean showSecrets) {
        return this.getHtmlDisplayedName(showSecrets, false, false, null);
    }

    public String getHtmlDisplayedName(boolean showSecrets, Scene scene) {
        SceneDetails details = scene.getDetails(this);
        boolean nonSex = false;
        boolean cuck = false;
        if (details != null) {
            if (details.isNonSex() != null && details.isNonSex().booleanValue()) {
                nonSex = true;
            }
            if (details.isCuck() != null && details.isCuck().booleanValue()) {
                cuck = true;
            }
        }
        return this.getHtmlDisplayedName(showSecrets, nonSex, cuck, details);
    }

    public String getHtmlDisplayedName(boolean showSecrets, boolean nonSex, boolean cuck, SceneDetails details) {
        String color = "";
        if (Gender.FEMALE.equals(this.gender)) {
            color = "#F8708C";
            if (cuck) {
                color = "#CC66FF";
            }
            if (nonSex) {
                color = "#D3B6D3";
            }
        }
        if (Gender.MALE.equals(this.gender)) {
            color = "#196EBF";
            if (cuck) {
                color = "#6693AD";
            }
            if (nonSex) {
                color = "#66D7FF";
            }
        }
        if (this.remindsMeOfFlag) {
            color = "#3BBF19";
        }
        Object coloredName = "<font color=\"" + color + "\">" + this.name + "</font>";
        if (Gender.TS.equals(this.gender)) {
            coloredName = this.getColoredTsName(this.name);
        }
        if (this.getCreditedAs() != null && !this.getCreditedAs().isEmpty()) {
            coloredName = (String)coloredName + " as " + this.getCreditedAs();
        }
        if (this.hasBirthday()) {
            coloredName = (String)coloredName + " (turns <font color=\"" + ScenerixxCommonLib.RED + "\">" + this.calculateAge() + "</font> today)";
        }
        if (showSecrets && this.getRemindsMeOf() != null && !this.getRemindsMeOf().isEmpty()) {
            coloredName = (String)coloredName + " (<font color=\"#3BBF19\">" + this.getRemindsMeOf() + "</font>)";
        }
        ArrayList<Person> rmo = new ArrayList<Person>();
        if (details != null && (details.getRemindsMeOf1() != null || details.getRemindsMeOf2() != null || details.getRemindsMeOf3() != null)) {
            if (details.getRemindsMeOf1() != null && (details.getRemindsMeOf1().isSecret() && showSecrets || !details.getRemindsMeOf1().isSecret())) {
                rmo.add(details.getRemindsMeOf1());
            }
            if (details.getRemindsMeOf2() != null && (details.getRemindsMeOf2().isSecret() && showSecrets || !details.getRemindsMeOf2().isSecret())) {
                rmo.add(details.getRemindsMeOf2());
            }
            if (details.getRemindsMeOf3() != null && (details.getRemindsMeOf3().isSecret() && showSecrets || !details.getRemindsMeOf3().isSecret())) {
                rmo.add(details.getRemindsMeOf3());
            }
        } else {
            if (this.getRemindsMeOfPerson1() != null && (this.getRemindsMeOfPerson1().isSecret() && showSecrets || !this.getRemindsMeOfPerson1().isSecret())) {
                rmo.add(this.getRemindsMeOfPerson1());
            }
            if (this.getRemindsMeOfPerson2() != null && (this.getRemindsMeOfPerson2().isSecret() && showSecrets || !this.getRemindsMeOfPerson2().isSecret())) {
                rmo.add(this.getRemindsMeOfPerson2());
            }
            if (this.getRemindsMeOfPerson3() != null && (this.getRemindsMeOfPerson3().isSecret() && showSecrets || !this.getRemindsMeOfPerson3().isSecret())) {
                rmo.add(this.getRemindsMeOfPerson3());
            }
        }
        if (!rmo.isEmpty()) {
            coloredName = (String)coloredName + " (" + rmo.stream().map(person -> "<font color=\"#3BBF19\">" + person.getName() + "</font>").collect(Collectors.joining(" & ")) + ") ";
        }
        return coloredName;
    }

    public String getColoredTsName(String name) {
        Object tmpName = "";
        String color1 = "#F8708C";
        String color2 = "#196EBF";
        for (int i = 0; i <= name.length() - 1; ++i) {
            tmpName = i % 2 == 0 ? (String)tmpName + "<font color=\"" + color1 + "\">" + name.charAt(i) + "</font>" : (String)tmpName + "<font color=\"" + color2 + "\">" + name.charAt(i) + "</font>";
        }
        String coloredName = tmpName;
        return coloredName;
    }

    public String getNameWithBirthdayInXDays(boolean isBirthdayToday) {
        int dayDifference;
        if (this.getBirthYear() == null) {
            return this.getHtmlDisplayedName();
        }
        if (isBirthdayToday) {
            return this.getHtmlDisplayedName() + " turns <font color=\"" + ScenerixxCommonLib.RED + "\">" + this.calculateAge() + "</font> today \ud83c\udf89";
        }
        Date today = new Date();
        int month = 1;
        int day = 1;
        if (this.getBirthMonth() != null) {
            month = this.getBirthMonth() - 1;
        }
        if (this.getBirthDay() != null) {
            day = this.getBirthDay();
        }
        if ((dayDifference = Person.dayDifference(today, new Date(today.getYear(), month, day))) < 0) {
            dayDifference = Person.dayDifference(today, new Date(today.getYear() + 1, month, day));
        }
        return this.getName() + " - turns <font color=\"" + ScenerixxCommonLib.RED + "\">" + (this.calculateAge() + 1) + "</font> in " + dayDifference + " days";
    }

    public String getNameWithBirthtoday(boolean isBirthdayToday) {
        if (isBirthdayToday) {
            return this.getHtmlDisplayedName();
        }
        return this.getName();
    }

    public int calculateAge() {
        Date today = new Date();
        today.setHours(0);
        today.setMinutes(0);
        today.setSeconds(0);
        Date birthdate = new Date();
        if (this.getBirthYear() != null) {
            birthdate.setYear(this.getBirthYear() - 1900);
            if (this.getBirthMonth() != null) {
                birthdate.setMonth(this.getBirthMonth() - 1);
            }
            if (this.getBirthDay() != null) {
                birthdate.setDate(this.getBirthDay());
            }
            birthdate.setMinutes(0);
            birthdate.setSeconds(0);
            return Person.yearDifference(birthdate, today);
        }
        return 0;
    }

    public static int yearDifference(Date first, Date second) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        int d1 = Integer.parseInt(formatter.format(first));
        int d2 = Integer.parseInt(formatter.format(second));
        int age = (d2 - d1) / 10000;
        return age;
    }

    public static int dayDifference(Date startDate, Date endDate) {
        GregorianCalendar startCal = new GregorianCalendar();
        GregorianCalendar endCal = new GregorianCalendar();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        ((Calendar)endCal).add(1, -startCal.get(1));
        ((Calendar)endCal).add(2, -startCal.get(2));
        ((Calendar)endCal).add(5, -startCal.get(5));
        int daysDifference = endCal.get(6);
        return daysDifference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTwitter() {
        return this.twitter;
    }

    public void setTwitter(String twitter) {
        this.twitter = twitter;
    }

    public String getOfficialHomepage() {
        return this.officialHomepage;
    }

    public void setOfficialHomepage(String officialHomepage) {
        this.officialHomepage = officialHomepage;
    }

    public String getInstagram() {
        return this.instagram;
    }

    public void setInstagram(String instagram) {
        this.instagram = instagram;
    }

    public String getIafd() {
        return this.iafd;
    }

    public void setIafd(String iafd) {
        this.iafd = iafd;
    }

    public String getWikipedia() {
        return this.wikipedia;
    }

    public void setWikipedia(String wikipedia) {
        this.wikipedia = wikipedia;
    }

    public List<PersonWebsites> getPersonWebsites() {
        return this.personWebsites;
    }

    public void setPersonWebsites(List<PersonWebsites> personWebsites) {
        this.personWebsites = personWebsites;
    }

    public String getOtherUrls() {
        return this.otherUrls;
    }

    public void setOtherUrls(String otherUrls) {
        this.otherUrls = otherUrls;
    }

    public Integer getBirthYear() {
        return this.birthYear;
    }

    public void setBirthYear(Integer birthYear) {
        this.birthYear = birthYear;
    }

    public Integer getBirthMonth() {
        return this.birthMonth;
    }

    public void setBirthMonth(Integer birthMonth) {
        this.birthMonth = birthMonth;
    }

    public Integer getBirthDay() {
        return this.birthDay;
    }

    public void setBirthDay(Integer birthDay) {
        this.birthDay = birthDay;
    }

    public Integer getDeathYear() {
        return this.deathYear;
    }

    public void setDeathYear(Integer deathYear) {
        this.deathYear = deathYear;
    }

    public Integer getDeathMonth() {
        return this.deathMonth;
    }

    public void setDeathMonth(Integer deathMonth) {
        this.deathMonth = deathMonth;
    }

    public Integer getDeathDay() {
        return this.deathDay;
    }

    public void setDeathDay(Integer deathDay) {
        this.deathDay = deathDay;
    }

    public CauseOfDeath getCauseOfDeath() {
        return this.causeOfDeath;
    }

    public void setCauseOfDeath(CauseOfDeath causeOfDeath) {
        this.causeOfDeath = causeOfDeath;
    }

    public String getCauseOfDeathComment() {
        return this.causeOfDeathComment;
    }

    public void setCauseOfDeathComment(String causeOfDeathComment) {
        this.causeOfDeathComment = causeOfDeathComment;
    }

    public List<PersonBody> getPersonBodys() {
        return this.personBodys;
    }

    public void setPersonBodys(List<PersonBody> personBodys) {
        this.personBodys = personBodys;
    }

    public BodyPartSize getDickSize() {
        return this.dickSize;
    }

    public void setDickSize(BodyPartSize dickSize) {
        this.dickSize = dickSize;
    }

    public Differentiator getDickSizeDifferentiator() {
        return this.dickSizeDifferentiator;
    }

    public void setDickSizeDifferentiator(Differentiator dickSizeDifferentiator) {
        this.dickSizeDifferentiator = dickSizeDifferentiator;
    }

    public String getCreditedAs() {
        return this.creditedAs;
    }

    public void setCreditedAs(String creditedAs) {
        this.creditedAs = creditedAs;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    public int getSimilarityScore() {
        return this.similarityScore;
    }

    public void setSimilarityScore(int similarityScore) {
        this.similarityScore = similarityScore;
    }

    public String getRealNameInsteadOfAlias() {
        String result = this.name;
        if (this.isAlias()) {
            result = this.name.substring(this.name.indexOf(" is ") + " is ".length());
        }
        return result;
    }

    public void setAliasName(String realName, String aliasName) {
        this.name = aliasName + " is " + realName;
    }

    public String getRemindsMeOf() {
        return this.remindsMeOf;
    }

    public void setRemindsMeOf(String remindsMeOf) {
        this.remindsMeOf = remindsMeOf;
    }

    public MediumFile getPicture() {
        return this.picture;
    }

    public void setPicture(MediumFile picture) {
        this.picture = picture;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isWizardGenerated() {
        return this.wizardGenerated;
    }

    public void setWizardGenerated(boolean wizardGenerated) {
        this.wizardGenerated = wizardGenerated;
    }

    public List<FavoriteTimespan> getFavorites() {
        return this.favorites;
    }

    public void setFavorites(List<FavoriteTimespan> favorites) {
        this.favorites = favorites;
    }

    public Integer getRatingAss() {
        return this.ratingAss;
    }

    public void setRatingAss(Integer ratingAss) {
        this.ratingAss = ratingAss;
    }

    public Integer getRatingTits() {
        return this.ratingTits;
    }

    public void setRatingTits(Integer ratingTits) {
        this.ratingTits = ratingTits;
    }

    public Integer getRatingPussy() {
        return this.ratingPussy;
    }

    public void setRatingPussy(Integer ratingPussy) {
        this.ratingPussy = ratingPussy;
    }

    public Integer getRatingFace() {
        return this.ratingFace;
    }

    public void setRatingFace(Integer ratingFace) {
        this.ratingFace = ratingFace;
    }

    public Integer getRatingSmile() {
        return this.ratingSmile;
    }

    public void setRatingSmile(Integer ratingSmile) {
        this.ratingSmile = ratingSmile;
    }

    public Integer getRatingLaugh() {
        return this.ratingLaugh;
    }

    public void setRatingLaugh(Integer ratingLaugh) {
        this.ratingLaugh = ratingLaugh;
    }

    public Integer getRatingEyes() {
        return this.ratingEyes;
    }

    public void setRatingEyes(Integer ratingEyes) {
        this.ratingEyes = ratingEyes;
    }

    public Integer getRatingVoice() {
        return this.ratingVoice;
    }

    public void setRatingVoice(Integer ratingVoice) {
        this.ratingVoice = ratingVoice;
    }

    public Integer getRatingCharacter() {
        return this.ratingCharacter;
    }

    public void setRatingCharacter(Integer ratingCharacter) {
        this.ratingCharacter = ratingCharacter;
    }

    public Integer getRatingSympathy() {
        return this.ratingSympathy;
    }

    public void setRatingSympathy(Integer ratingSympathy) {
        this.ratingSympathy = ratingSympathy;
    }

    public Integer getRatingFeet() {
        return this.ratingFeet;
    }

    public void setRatingFeet(Integer ratingFeet) {
        this.ratingFeet = ratingFeet;
    }

    public Integer getRatingTeeth() {
        return this.ratingTeeth;
    }

    public void setRatingTeeth(Integer ratingTeeth) {
        this.ratingTeeth = ratingTeeth;
    }

    public Differentiator getRatingAssDifferentiator() {
        return this.ratingAssDifferentiator;
    }

    public void setRatingAssDifferentiator(Differentiator ratingAssDifferentiator) {
        this.ratingAssDifferentiator = ratingAssDifferentiator;
    }

    public Differentiator getRatingTitsDifferentiator() {
        return this.ratingTitsDifferentiator;
    }

    public void setRatingTitsDifferentiator(Differentiator ratingTitsDifferentiator) {
        this.ratingTitsDifferentiator = ratingTitsDifferentiator;
    }

    public Differentiator getRatingPussyDifferentiator() {
        return this.ratingPussyDifferentiator;
    }

    public void setRatingPussyDifferentiator(Differentiator ratingPussyDifferentiator) {
        this.ratingPussyDifferentiator = ratingPussyDifferentiator;
    }

    public Differentiator getRatingFaceDifferentiator() {
        return this.ratingFaceDifferentiator;
    }

    public void setRatingFaceDifferentiator(Differentiator ratingFaceDifferentiator) {
        this.ratingFaceDifferentiator = ratingFaceDifferentiator;
    }

    public Differentiator getRatingSmileDifferentiator() {
        return this.ratingSmileDifferentiator;
    }

    public void setRatingSmileDifferentiator(Differentiator ratingSmileDifferentiator) {
        this.ratingSmileDifferentiator = ratingSmileDifferentiator;
    }

    public Differentiator getRatingLaughDifferentiator() {
        return this.ratingLaughDifferentiator;
    }

    public void setRatingLaughDifferentiator(Differentiator ratingLaughDifferentiator) {
        this.ratingLaughDifferentiator = ratingLaughDifferentiator;
    }

    public Differentiator getRatingEyesDifferentiator() {
        return this.ratingEyesDifferentiator;
    }

    public void setRatingEyesDifferentiator(Differentiator ratingEyesDifferentiator) {
        this.ratingEyesDifferentiator = ratingEyesDifferentiator;
    }

    public Differentiator getRatingVoiceDifferentiator() {
        return this.ratingVoiceDifferentiator;
    }

    public void setRatingVoiceDifferentiator(Differentiator ratingVoiceDifferentiator) {
        this.ratingVoiceDifferentiator = ratingVoiceDifferentiator;
    }

    public Differentiator getRatingCharacterDifferentiator() {
        return this.ratingCharacterDifferentiator;
    }

    public void setRatingCharacterDifferentiator(Differentiator ratingCharacterDifferentiator) {
        this.ratingCharacterDifferentiator = ratingCharacterDifferentiator;
    }

    public Differentiator getRatingSympathyDifferentiator() {
        return this.ratingSympathyDifferentiator;
    }

    public void setRatingSympathyDifferentiator(Differentiator ratingSympathyDifferentiator) {
        this.ratingSympathyDifferentiator = ratingSympathyDifferentiator;
    }

    public Differentiator getRatingFeetDifferentiator() {
        return this.ratingFeetDifferentiator;
    }

    public void setRatingFeetDifferentiator(Differentiator ratingFeetDifferentiator) {
        this.ratingFeetDifferentiator = ratingFeetDifferentiator;
    }

    public Differentiator getRatingTeethDifferentiator() {
        return this.ratingTeethDifferentiator;
    }

    public void setRatingTeethDifferentiator(Differentiator ratingTeethDifferentiator) {
        this.ratingTeethDifferentiator = ratingTeethDifferentiator;
    }

    public List<INode> getScenesAsINode(boolean showSecret) {
        if (this.noDbConnection) {
            return new ArrayList<INode>();
        }
        ArrayList<INode> result = new ArrayList<INode>();
        for (Scene s : DB.getInstance().getScenes(this, showSecret)) {
            result.add(s);
        }
        return result;
    }

    public List<Scene> getScenes(boolean showSecret) {
        if (this.noDbConnection) {
            return new ArrayList<Scene>();
        }
        return DB.getInstance().getScenes(this, showSecret);
    }

    public int getIcame() {
        return DB.getInstance().getIcame(this);
    }

    public boolean isRemindsMeOfFlag() {
        return this.remindsMeOfFlag;
    }

    public void setRemindsMeOfFlag(boolean remindsMeOfFlag) {
        this.remindsMeOfFlag = remindsMeOfFlag;
    }

    public Person getRemindsMeOfPerson1() {
        return this.remindsMeOfPerson1;
    }

    public void setRemindsMeOfPerson1(Person remindsMeOfPerson1) {
        this.remindsMeOfPerson1 = remindsMeOfPerson1;
    }

    public Person getRemindsMeOfPerson2() {
        return this.remindsMeOfPerson2;
    }

    public void setRemindsMeOfPerson2(Person remindsMeOfPerson2) {
        this.remindsMeOfPerson2 = remindsMeOfPerson2;
    }

    public Person getRemindsMeOfPerson3() {
        return this.remindsMeOfPerson3;
    }

    public void setRemindsMeOfPerson3(Person remindsMeOfPerson3) {
        this.remindsMeOfPerson3 = remindsMeOfPerson3;
    }

    public PersonHeight getPersonHeight() {
        return this.personHeight;
    }

    public void setPersonHeight(PersonHeight personHeight) {
        this.personHeight = personHeight;
    }

    public Differentiator getPersonHeightDifferentiator() {
        return this.personHeightDifferentiator;
    }

    public void setPersonHeightDifferentiator(Differentiator personHeightDifferentiator) {
        this.personHeightDifferentiator = personHeightDifferentiator;
    }

    public Integer getHeightInCm() {
        return this.heightInCm;
    }

    public void setHeightInCm(Integer heightInCm) {
        this.heightInCm = heightInCm;
    }

    public boolean isNoDbConnection() {
        return this.noDbConnection;
    }

    public void setNoDbConnection(boolean noDbConnection) {
        this.noDbConnection = noDbConnection;
    }

    public boolean hasBirthday() {
        Date today = new Date();
        return this.getBirthDay() != null && this.getBirthMonth() != null && today.getDate() == this.getBirthDay().intValue() && today.getMonth() + 1 == this.getBirthMonth();
    }

    public boolean hasDeathday() {
        Date today = new Date();
        return this.getDeathDay() != null && this.getDeathMonth() != null && today.getDate() == this.getDeathDay().intValue() && today.getMonth() + 1 == this.getDeathMonth();
    }

    public String toString() {
        Object birthday = "";
        if (this.getBirthYear() != null) {
            birthday = String.valueOf(this.getBirthDay() != null ? this.getBirthDay() : "??") + "." + String.valueOf(this.getBirthMonth() != null ? this.getBirthMonth() : "??") + "." + this.getBirthYear();
        }
        return this.getName() + " (" + String.valueOf(this.getGender()) + ") " + (String)birthday;
    }

    public Person clone() {
        try {
            return (Person)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Person.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Person)) {
            return false;
        }
        if (this.birthDay != null && !this.birthDay.equals(((Person)other).getBirthDay())) {
            return false;
        }
        if (this.birthMonth != null && !this.birthMonth.equals(((Person)other).getBirthMonth())) {
            return false;
        }
        if (this.birthYear != null && !this.birthYear.equals(((Person)other).getBirthYear())) {
            return false;
        }
        if (this.deathDay != null && !this.deathDay.equals(((Person)other).getDeathDay())) {
            return false;
        }
        if (this.deathMonth != null && !this.deathMonth.equals(((Person)other).getDeathMonth())) {
            return false;
        }
        if (this.deathYear != null && !this.deathYear.equals(((Person)other).getDeathYear())) {
            return false;
        }
        if (this.causeOfDeath != null && !this.causeOfDeath.equals(((Person)other).getCauseOfDeath())) {
            return false;
        }
        if (this.causeOfDeathComment != null && !this.causeOfDeathComment.equals(((Person)other).getCauseOfDeathComment())) {
            return false;
        }
        if (this.ethnicity != null && !this.ethnicity.equals(((Person)other).getEthnicity())) {
            return false;
        }
        if (this.hairColor != null && !this.hairColor.equals(((Person)other).getHairColor())) {
            return false;
        }
        if (this.gender != null && !this.gender.equals(((Person)other).getGender())) {
            return false;
        }
        if (this.name != null && !this.name.equals(((Person)other).getName())) {
            return false;
        }
        if (this.realName != null && !this.realName.equals(((Person)other).getRealName())) {
            return false;
        }
        if (this.remindsMeOf != null && !this.remindsMeOf.equals(((Person)other).getRemindsMeOf())) {
            return false;
        }
        if (!this.remindsMeOfFlag == ((Person)other).isRemindsMeOfFlag()) {
            return false;
        }
        if (this.otherUrls != null && !this.otherUrls.equals(((Person)other).getOtherUrls())) {
            return false;
        }
        if (this.comment != null && !this.comment.equals(((Person)other).getComment())) {
            return false;
        }
        if (this.iafd != null && !this.iafd.equals(((Person)other).getIafd())) {
            return false;
        }
        if (this.instagram != null && !this.instagram.equals(((Person)other).getInstagram())) {
            return false;
        }
        if (this.officialHomepage != null && !this.officialHomepage.equals(((Person)other).getOfficialHomepage())) {
            return false;
        }
        if (this.twitter != null && !this.twitter.equals(((Person)other).getTwitter())) {
            return false;
        }
        return this.wikipedia == null || this.wikipedia.equals(((Person)other).getWikipedia());
    }

    @Override
    public int compareTo(Person o) {
        return Comparator.comparing(Person::getName).compare(this, o);
    }
}

