/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.db;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberExpression;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.comparator.MovieComparator;
import xxx.scenerixx.scenerixxlib.comparator.PersonComparator;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Cumshot;
import xxx.scenerixx.scenerixxlib.model.Goldenshower;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.QBookmark;
import xxx.scenerixx.scenerixxlib.model.QCumshot;
import xxx.scenerixx.scenerixxlib.model.QGoldenshower;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QPersonBody;
import xxx.scenerixx.scenerixxlib.model.QScene;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Resolution;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPart;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPartSize;
import xxx.scenerixx.scenerixxlib.model.enums.BodyType;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.HairColor;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MovieTypeFilter;
import xxx.scenerixx.scenerixxlib.model.medium.Dvd;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QDvd;
import xxx.scenerixx.scenerixxlib.model.medium.QMedium;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;
import xxx.scenerixx.scenerixxlib.model.person.ChartPosition;
import xxx.scenerixx.scenerixxlib.model.person.ChartPositionType;
import xxx.scenerixx.scenerixxlib.model.person.QChartPosition;
import xxx.scenerixx.scenerixxlib.model.person.QFavoriteTimespan;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.playlist.QPlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.search.QSearch;
import xxx.scenerixx.scenerixxlib.model.search.Search;
import xxx.scenerixx.scenerixxlib.model.settings.QScenerixxSettings;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;

public class DB {
    private static final EntityService entityService = new EntityService();
    private final Logger LOGGER = LoggerFactory.getLogger(DB.class);
    private int maxResults = Integer.MAX_VALUE;
    private static ScenerixxSettings scenerixxSettings = null;

    private DB() {
    }

    public static DB getInstance() {
        return new DB();
    }

    public boolean addPersonToScene(Person p, Scene scene) {
        return this.addPersonToScene(p, scene, false);
    }

    public boolean addPersonToScene(Person p, Scene scene, boolean alwaysAdd) {
        boolean result = false;
        scene = this.getEntityService().load(Scene.class, scene.getId());
        if (scene.getPersons(true).contains(p) && !alwaysAdd) {
            result = false;
        } else {
            SceneDetails sd = new SceneDetails();
            sd.setDateOfCreation(LocalDateTime.now());
            sd.setScene(scene);
            sd.setPerson(p);
            scene.getDetails().add(sd);
            this.getEntityService().save(scene);
            this.LOGGER.debug("added " + p.getName() + " to movie " + scene.getMovie().getTitle() + " scene " + scene.getPos());
            result = true;
        }
        return result;
    }

    public Person getPersons(Long externalId) {
        EntityService.Finder find = entityService.find(QPerson.person);
        return (Person)find.filter(p -> p.externalId.isNotNull().and((Predicate)p.externalId.eq((Object)externalId))).order(p -> p.name.lower().asc()).findFirst();
    }

    public Person getPerson(String name, boolean showSecrets) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        return (Person)find.filter(p -> p.name.equalsIgnoreCase(name)).order(p -> p.name.lower().asc()).findFirst();
    }

    public List<Person> getPersons(boolean showSecrets) {
        return this.getPersons(showSecrets, Long.MAX_VALUE);
    }

    public List<Person> getPersons(boolean showSecrets, long limit) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        return find.order(p -> p.name.lower().asc()).find(limit);
    }

    public int getPersonsCount(boolean showSecrets) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        return (int)find.count();
    }

    public int getScenesMissingRuntimeCount(boolean showSecrets, boolean runtimeMissing) {
        EntityService.Finder find = entityService.find(QScene.scene);
        if (!showSecrets) {
            find = find.filter(p -> p.movie.secret.ne((Object)true));
        }
        if (runtimeMissing) {
            find.filter(f -> f.endTime.isNull());
        } else {
            find.filter(f -> f.endTime.isNotNull());
        }
        return (int)find.count();
    }

    private List<Person> mergeAliases(List<Person> persons) {
        ArrayList<Person> aliases = new ArrayList<Person>();
        for (Person p : persons) {
            for (String alias : this.getKnowAliases(p)) {
                Person aliasPerson = p.clone();
                aliasPerson.setAlias(true);
                aliasPerson.setAliasName(aliasPerson.getName(), alias);
                if (aliases.contains(aliasPerson)) continue;
                aliases.add(aliasPerson);
            }
        }
        persons.addAll(aliases);
        persons.sort(new PersonComparator());
        return persons;
    }

    public List<Person> getPersons(boolean withAliases, boolean showSecrets) {
        return this.getPersons(withAliases, showSecrets, Long.MAX_VALUE);
    }

    public List<Person> getPersons(boolean withAliases, boolean showSecrets, long limit) {
        List<Person> result = this.getPersons(showSecrets, limit);
        if (withAliases) {
            result = this.mergeAliases(result);
        }
        return result;
    }

    public List<Person> getFavoritePersons(boolean withAliases, String searchTerm, boolean showSecrets) {
        return this.getFavoritePersons(withAliases, searchTerm, showSecrets, Long.MAX_VALUE);
    }

    public List<Person> getFavoritePersons(boolean withAliases, String searchTerm, boolean showSecrets, long limit) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        List<Person> result = find.filter(f -> f.favorite.isTrue()).order(p -> p.name.lower().asc()).find(limit);
        if (withAliases) {
            result = this.mergeAliases(result);
        }
        return this.applySearchTerms(result, searchTerm);
    }

    public List<Person> getAllTimeFavoritePersons() {
        return this.getAllTimeFavoritePersons(Long.MAX_VALUE);
    }

    public List<Person> getAllTimeFavoritePersons(long limit) {
        List<Person> favoritePersons = this.getPersons(null, false, "", false, limit);
        ArrayList<Person> tmpPersons = new ArrayList<Person>();
        tmpPersons.addAll(favoritePersons);
        for (Person p : tmpPersons) {
            if (p.isFavorite()) continue;
            favoritePersons.remove(p);
        }
        List persons = this.getEntityService().find(QFavoriteTimespan.favoriteTimespan).find().stream().map(f -> f.getPerson()).distinct().collect(Collectors.toList());
        for (Person p : persons) {
            if (favoritePersons.contains(p)) continue;
            favoritePersons.add(p);
        }
        return favoritePersons;
    }

    private List<Person> applySearchTerms(List<Person> inputList, String searchTerm) {
        return this.applySearchTerms(inputList, searchTerm, Long.MAX_VALUE);
    }

    private List<Person> applySearchTerms(List<Person> inputList, String searchTerm, long limit) {
        if (searchTerm == null || searchTerm.isBlank()) {
            return inputList;
        }
        String normalizedSearch = searchTerm.replaceAll("(?i)\\s+and\\s+", "&").replace(",", "&");
        String[] termGroups = normalizedSearch.split("&");
        HashSet<Person> matchedPersons = new HashSet<Person>();
        block0: for (String termGroup : termGroups) {
            String trimmedTerm = termGroup.trim();
            if (trimmedTerm.isEmpty()) continue;
            String[] words = trimmedTerm.split("\\s+");
            for (Person person : inputList) {
                if ((long)matchedPersons.size() >= limit) continue block0;
                if (!this.containsSearchTerm(words, person, true)) continue;
                matchedPersons.add(person);
            }
        }
        return new ArrayList<Person>(matchedPersons);
    }

    public List<Person> getPersonsByBirthdate(Gender gender, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        find = find.filter(f -> f.birthMonth.isNotNull());
        return find.order(p -> p.birthMonth.asc(), p -> p.birthDay.asc(), p -> p.name.lower().asc()).find();
    }

    public List<Person> getPersonsByBirthyear(Gender gender, boolean withAliases, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        List<Person> personList = find.order(p -> p.birthYear.desc(), p -> p.name.lower().asc()).find();
        if (withAliases) {
            personList = this.mergeAliases(personList);
            Collections.sort(personList, (one, other) -> {
                if (other.getBirthYear() == null) {
                    return -1;
                }
                if (one.getBirthYear() == null) {
                    return 1;
                }
                return other.getBirthYear().compareTo(one.getBirthYear());
            });
        }
        return personList;
    }

    public List<Person> getPersonsByBirthyear(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        List<Person> result = this.getPersonsByBirthyear(gender, withAliases, showSecret);
        return this.applySearchTerms(result, searchTerm);
    }

    public boolean containsSearchTerm(String[] split, Person p, boolean findAllTerms) {
        boolean foundSearchTerm = false;
        for (String st : split) {
            if (split.length > 1 && st.trim().isEmpty()) continue;
            if (split.length == 1 && st.trim().isEmpty()) {
                foundSearchTerm = true;
                break;
            }
            if (p.getName().toLowerCase().contains(st.trim().toLowerCase())) {
                foundSearchTerm = true;
                if (findAllTerms) continue;
                break;
            }
            if (!findAllTerms) continue;
            foundSearchTerm = false;
            break;
        }
        return foundSearchTerm;
    }

    public boolean containsSearchTerm(String[] split, Person p) {
        return this.containsSearchTerm(split, p, false);
    }

    public boolean containsAllSearchTerms(String searchTerms, Movie m) {
        searchTerms = searchTerms.replaceAll("  ", " ");
        String[] terms = searchTerms.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        String title = m.getTitle() != null ? m.getTitle().toLowerCase() : "";
        String altTitle = m.getAlternativeTitle() != null ? m.getAlternativeTitle().toLowerCase() : "";
        String typeTitles = Stream.of(m.getType(), m.getType2(), m.getType3(), m.getType4(), m.getType5(), m.getType6()).filter(Objects::nonNull).map(t -> t.getTitle().toLowerCase()).collect(Collectors.joining(" "));
        String movieTypes = m.getMovietypes() != null ? m.getMovietypes().stream().map(t -> t.getTitle().toLowerCase()).collect(Collectors.joining(" ")) : "";
        String personNames = m.getScenes().stream().flatMap(s -> s.getPersons(false).stream()).map(p -> p.getName().toLowerCase()).collect(Collectors.joining(" "));
        for (String term : terms) {
            if ((term = term.replace("\"", "").trim()).isEmpty()) continue;
            if (term.startsWith("--")) {
                if (!title.contains(term.substring(2).toLowerCase())) continue;
                return false;
            }
            if (term.startsWith("++")) {
                char nextChar;
                String search = term.substring(2).toLowerCase();
                int idx = title.indexOf(search);
                if (idx == -1) {
                    return false;
                }
                int end = Math.min(idx + search.length(), title.length());
                char c = nextChar = end < title.length() ? (char)title.charAt(end) : (char)' ';
                if (nextChar == File.separatorChar || nextChar == '.' || Character.isWhitespace(nextChar)) continue;
                return false;
            }
            String lowerTerm = term.toLowerCase();
            if (title.contains(lowerTerm) || altTitle.contains(lowerTerm) || typeTitles.contains(lowerTerm) || movieTypes.contains(lowerTerm) || personNames.contains(lowerTerm)) continue;
            return false;
        }
        return true;
    }

    public List<Person> getPersonsByAppearance(Gender gender, boolean withAliases, boolean showSecret) {
        return this.getPersonsByAppearance(gender, withAliases, showSecret, true);
    }

    public List<Person> getPersonsByAppearance(Gender gender, boolean withAliases, boolean showSecret, boolean showUnknown) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (!showUnknown) {
            find = find.filter(f -> f.name.containsIgnoreCase("[Unknown").not());
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        List<Person> personList = find.find();
        if (withAliases) {
            personList = this.mergeAliases(personList);
        }
        HashMap<Long, List<Person>> x = new HashMap<Long, List<Person>>();
        Long highestNumberOfAppearance = 0L;
        for (Person p : personList) {
            long numberOfAppearance = this.getNumberOfAppearance(p, showSecret);
            if (numberOfAppearance > highestNumberOfAppearance) {
                highestNumberOfAppearance = numberOfAppearance;
            }
            this.addOrIncrementAppearance(x, numberOfAppearance, p);
        }
        personList.clear();
        Long i = highestNumberOfAppearance;
        while (i >= 0L) {
            if (x.containsKey(i)) {
                Collections.sort((List)x.get(i), new PersonComparator());
                for (Person p : (List)x.get(i)) {
                    personList.add(p);
                }
            }
            Long l = i;
            i = i - 1L;
        }
        return personList;
    }

    public List<Person> getPersonsByNationality(Gender gender, boolean withAliases, boolean showSecret, boolean showUnknown) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (!showUnknown) {
            find = find.filter(f -> f.name.containsIgnoreCase("[Unknown").not());
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        List<Person> personList = find.find();
        if (withAliases) {
            personList = this.mergeAliases(personList);
        }
        HashMap<Long, List<Person>> x = new HashMap<Long, List<Person>>();
        Long highestNumberOfAppearance = 0L;
        for (Person p : personList) {
            long numberOfAppearance = this.getNumberOfNationality(p.getNationality(), showSecret);
            if (numberOfAppearance > highestNumberOfAppearance) {
                highestNumberOfAppearance = numberOfAppearance;
            }
            this.addOrIncrementAppearance(x, numberOfAppearance, p);
        }
        personList.clear();
        Long i = highestNumberOfAppearance;
        while (i >= 0L) {
            if (x.containsKey(i)) {
                Collections.sort((List)x.get(i), new PersonComparator());
                for (Person p : (List)x.get(i)) {
                    personList.add(p);
                }
            }
            Long l = i;
            i = i - 1L;
        }
        return personList;
    }

    private void addOrIncrementAppearance(Map<Long, List<Person>> x, long numberOfEntityToOrderBy, Person p) {
        if (x.containsKey(numberOfEntityToOrderBy)) {
            x.get(numberOfEntityToOrderBy).add(p);
        } else {
            x.put(numberOfEntityToOrderBy, new ArrayList());
            x.get(numberOfEntityToOrderBy).add(p);
        }
    }

    public List<Person> getPersonsByAppearance(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        List<Person> result = this.getPersonsByAppearance(gender, withAliases, showSecret);
        return this.applySearchTerms(result, searchTerm);
    }

    public List<Person> getPersonsByDateOfCreation(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        List<Person> result = find.order(f -> f.dateOfCreation.desc()).find();
        result = this.applySearchTerms(result, searchTerm);
        return result;
    }

    public List<Person> getPersonsByRating(Gender gender, boolean withAliases, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        find = find.filter(f -> f.rating.isNotNull());
        QPerson p = QPerson.person;
        NumberExpression differentiatorOrder = (NumberExpression)new CaseBuilder().when((Predicate)p.ratingDifferentiator.eq((Object)Differentiator.MORE)).then((Number)0).when((Predicate)p.ratingDifferentiator.eq((Object)Differentiator.SAME)).then((Object)1).when((Predicate)p.ratingDifferentiator.isNull()).then((Object)1).when((Predicate)p.ratingDifferentiator.eq((Object)Differentiator.LESS)).then((Object)2).otherwise((Object)3);
        find = find.order(mx -> mx.rating.desc(), mx -> differentiatorOrder.asc(), mx -> mx.name.lower().asc());
        List<Person> personList = find.find();
        if (withAliases) {
            personList = this.mergeAliases(personList);
        }
        return personList;
    }

    public List<Person> getPersonsByRatingOrg(Gender gender, boolean withAliases, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        List<Person> personList = find.find();
        if (withAliases) {
            personList = this.mergeAliases(personList);
        }
        HashMap<Long, List<Person>> x = new HashMap<Long, List<Person>>();
        Long highestNumberOfRating = 0L;
        for (Person p : personList) {
            long rating = -1L;
            if (p.getRating() != null) {
                rating = p.getRating().intValue();
            }
            if (rating > highestNumberOfRating) {
                highestNumberOfRating = rating;
            }
            this.addOrIncrementAppearance(x, rating, p);
        }
        personList.clear();
        Long i = highestNumberOfRating;
        while (i >= -1L) {
            if (x.containsKey(i)) {
                Collections.sort((List)x.get(i), new PersonComparator());
                for (Person p : (List)x.get(i)) {
                    personList.add(p);
                }
            }
            Long l = i;
            i = i - 1L;
        }
        return personList;
    }

    public List<Person> getPersonsByRating(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        List<Person> result = this.getPersonsByRating(gender, withAliases, showSecret);
        result = this.applySearchTerms(result, searchTerm);
        return result;
    }

    public PersonBody getDefaultPersonBody(Person person) {
        PersonBody personBody = new PersonBody();
        if (person.getId() != null) {
            EntityService.Finder find = entityService.find(QPersonBody.personBody);
            find.filter(f -> f.defaultPersonBody.isTrue());
            find.filter(f -> f.person.id.eq((Object)person.getId()));
            personBody = (PersonBody)find.findFirst();
            if (personBody == null) {
                personBody = new PersonBody();
            }
        }
        return personBody;
    }

    public TreeMap<Integer, List<Person>> getPersonsByAge(Gender gender) {
        EntityService.Finder find = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.isNotNull());
        if (gender != null) {
            find = find.filter(f -> f.person.gender.eq((Object)gender));
        }
        List sdList = find.find();
        HashMap sdMap = new HashMap();
        for (SceneDetails sd : sdList) {
            Integer age = ScenerixxCommonLib.calculateAge(sd.getScene(), sd.getPerson());
            if (age == null) continue;
            if (sdMap.containsKey(age)) {
                ((List)sdMap.get(age)).add(sd);
                continue;
            }
            sdMap.put(age, new ArrayList());
            ((List)sdMap.get(age)).add(sd);
        }
        TreeMap<Integer, List<Person>> t = new TreeMap<Integer, List<Person>>();
        Integer curAge = 100;
        while (curAge >= 0) {
            if (sdMap.containsKey(curAge)) {
                for (int j = 0; j < ((List)sdMap.get(curAge)).size(); ++j) {
                    Person p = ((SceneDetails)((List)sdMap.get(curAge)).get(j)).getPerson();
                    if (t.containsKey(curAge)) {
                        if (t.get(curAge).contains(p)) continue;
                        t.get(curAge).add(p);
                        continue;
                    }
                    t.put(curAge, new ArrayList());
                    t.get(curAge).add(p);
                }
                Collections.sort(t.get(curAge), new PersonComparator());
            }
            Integer n = curAge;
            curAge = curAge - 1;
        }
        return t;
    }

    public int getIcameBlahBlah() {
        int result = 0;
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.likes.isNotEmpty()).order(f -> ((DateTimePath)f.likes.get(0)).asc()).findFirst();
        if (stat != null) {
            result = stat.getLikes().size();
        }
        return result;
    }

    public int getIcame(Person p) {
        int result = 0;
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.person.eq(p)).findFirst();
        if (stat != null) {
            result = stat.getLikes().size();
        }
        List sceneDetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.eq(p)).find();
        List tmpScenes = sceneDetails.stream().map(f -> f.getScene()).filter(Objects::nonNull).collect(Collectors.toList());
        List statScenes = entityService.find(QStatistic.statistic).filter(f -> f.scene.in(tmpScenes)).find();
        for (Statistic s : statScenes) {
            result += s.getLikes().size();
        }
        return result;
    }

    public LocalDateTime getLastIcame(Person p) {
        List stat = entityService.find(QStatistic.statistic).filter(f -> f.person.eq(p)).find();
        List sceneDetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.eq(p)).find();
        List tmpScenes = sceneDetails.stream().map(f -> f.getScene()).filter(Objects::nonNull).collect(Collectors.toList());
        List statScenes = entityService.find(QStatistic.statistic).filter(f -> f.scene.in(tmpScenes)).find();
        stat.addAll(statScenes);
        ArrayList<LocalDateTime> likes = new ArrayList<LocalDateTime>();
        for (Statistic s : stat) {
            likes.addAll(s.getLikes());
        }
        Collections.sort(likes);
        if (stat.isEmpty() || likes.isEmpty()) {
            return null;
        }
        return (LocalDateTime)likes.getLast();
    }

    public int getIcameDirect(Person p) {
        int result = 0;
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.person.eq(p)).findFirst();
        if (stat != null) {
            result = stat.getLikes().size();
        }
        return result;
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, boolean showSecret) {
        return this.getPersonsByICame(gender, withAliases, showSecret, true);
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, boolean showSecret, boolean showUnknown) {
        return this.getPersonsByICame(gender, withAliases, showSecret, showUnknown, false, Long.MAX_VALUE);
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, boolean showSecret, boolean showUnknown, boolean onlyWithIcame) {
        return this.getPersonsByICame(gender, withAliases, showSecret, showUnknown, onlyWithIcame, Long.MAX_VALUE);
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, boolean showSecret, boolean showUnknown, boolean onlyWithIcame, long limit) {
        LocalDateTime now = LocalDateTime.now();
        ArrayList<Person> personList = new ArrayList<Person>();
        HashMap<Long, List<Person>> x = new HashMap<Long, List<Person>>();
        Long highestNumberOfICame = 0L;
        for (Person p : this.getPersons(gender, withAliases, showSecret, limit)) {
            if (!showUnknown && p.getName().toLowerCase().contains("unknown")) continue;
            long iCame = -1L;
            iCame = p.getIcame();
            if (iCame > highestNumberOfICame) {
                highestNumberOfICame = iCame;
            }
            this.addOrIncrementAppearance(x, iCame, p);
        }
        this.LOGGER.debug("getPersons xxx " + Duration.between(LocalDateTime.now(), now).toString());
        personList.clear();
        int min = -1;
        if (onlyWithIcame) {
            min = 1;
        }
        Long i = highestNumberOfICame;
        while (i >= (long)min) {
            if (x.containsKey(i)) {
                Collections.sort((List)x.get(i), new PersonComparator());
                for (Person p : (List)x.get(i)) {
                    personList.add(p);
                }
            }
            Long l = i;
            i = i - 1L;
        }
        this.LOGGER.debug("personlist 2: " + personList.size());
        this.LOGGER.debug("getPersons done " + Duration.between(LocalDateTime.now(), now).toString());
        return personList;
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        return this.getPersonsByICame(gender, withAliases, searchTerm, showSecret, Long.MAX_VALUE);
    }

    public List<Person> getPersonsByICame(Gender gender, boolean withAliases, String searchTerm, boolean showSecret, long limit) {
        List<Person> result = this.getPersonsByICame(gender, withAliases, showSecret);
        result = this.applySearchTerms(result, searchTerm);
        return result;
    }

    public List<Person> getPersonsByRuntime(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        return this.getPersonsByRuntime(gender, withAliases, searchTerm, showSecret, true);
    }

    public List<Person> getPersonsByRuntime(Gender gender, boolean withAliases, String searchTerm, boolean showSecret, boolean showUnknown) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        if (!showUnknown) {
            find = find.filter(f -> f.name.containsIgnoreCase("[Unknown").not());
        }
        List<Person> personList = find.find();
        personList = this.applySearchTerms(personList, searchTerm);
        if (withAliases) {
            personList = this.mergeAliases(personList);
        }
        HashMap<Long, List<Person>> x = new HashMap<Long, List<Person>>();
        Long highestNumberOfRuntime = 0L;
        for (Person p : personList) {
            Long runtime = 0L;
            for (Scene s : this.getScenes(p, showSecret)) {
                if (s.getTotalRuntime() <= 0) continue;
                runtime = runtime + (long)s.getTotalRuntime();
            }
            if (runtime > highestNumberOfRuntime) {
                highestNumberOfRuntime = runtime;
            }
            this.addOrIncrementAppearance(x, runtime, p);
        }
        personList.clear();
        Long i = highestNumberOfRuntime;
        while (i >= -1L) {
            if (x.containsKey(i)) {
                Collections.sort((List)x.get(i), new PersonComparator());
                for (Person p : (List)x.get(i)) {
                    personList.add(p);
                }
            }
            Long l = i;
            i = i - 1L;
        }
        return personList;
    }

    public List<Person> getPersonsByHairColor(Gender gender, HairColor hairColor, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByHairColorFinder(showSecret, gender, hairColor);
        return find.order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByHairColorCount(Gender gender, HairColor hairColor, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByHairColorFinder(showSecret, gender, hairColor);
        return find.count();
    }

    private EntityService.Finder<QPerson, Person> getPersonsByHairColorFinder(boolean showSecret, Gender gender, HairColor hairColor) {
        EntityService.Finder<QPerson, Person> find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        if (hairColor != null) {
            find = find.filter(f -> f.hairColor.eq((Object)hairColor));
        }
        return find;
    }

    public List<Person> getPersonsByWizardGenerated(Gender gender, boolean generated, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        find = find.filter(f -> f.wizardGenerated.eq(Boolean.valueOf(generated)));
        return find.order(f -> f.name.lower().asc()).find();
    }

    private EntityService.Finder<QPerson, Person> getPersonsByEthnicityFinder(boolean showSecret, Gender gender, Ethnicity eth) {
        EntityService.Finder<QPerson, Person> find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        if (eth != null) {
            find = find.filter(f -> f.ethnicity.eq((Object)eth));
        }
        return find;
    }

    public List<Person> getPersonsByEthnicity(Gender gender, Ethnicity eth, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByEthnicityFinder(showSecret, gender, eth);
        return find.order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByEthnicityCount(Gender gender, Ethnicity eth, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByEthnicityFinder(showSecret, gender, eth);
        return find.count();
    }

    public List<Person> getPersonsByNationality(Gender gender, Nationality nationality, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        if (nationality != null) {
            find = find.filter(f -> f.nationality.eq((Object)nationality));
        }
        return find.order(f -> f.name.lower().asc()).find();
    }

    public List<Person> getPersonsWithoutNationality(Gender gender, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        return find.filter(f -> f.nationality.isNull()).order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByNationalityCount(Gender gender, Nationality nationality, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        find = find.filter(f -> f.name.containsIgnoreCase("[unknown").not());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        find = nationality == null || Nationality.NotSet.equals(nationality) ? find.filter(f -> f.nationality.isNull()) : find.filter(f -> f.nationality.eq((Object)nationality));
        return find.count();
    }

    public List<Person> getPersonsByBodyType(Gender gender, BodyType bodyType, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByBodyCountFinder(showSecret, bodyType);
        return find.order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByBodyTypeCount(Gender gender, BodyType bodyType, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByBodyCountFinder(showSecret, bodyType);
        return find.count();
    }

    private EntityService.Finder<QPerson, Person> getPersonsByBodyCountFinder(boolean showSecret, BodyType bodyType) {
        EntityService.Finder<QPerson, Person> find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = find.filter(f -> f.gender.ne((Object)Gender.MALE));
        find = bodyType == null || BodyType.NotSet.equals(bodyType) ? find.filter(f -> ((QPersonBody)f.personBodys.any()).bodyType.isNull()) : find.filter(f -> ((QPersonBody)f.personBodys.any()).bodyType.eq((Object)bodyType));
        return find;
    }

    private EntityService.Finder<QPerson, Person> getPersonsByAppearanceFinder(boolean showSecret, Appearance appearance) {
        EntityService.Finder<QPerson, Person> find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = find.filter(f -> f.gender.ne((Object)Gender.MALE));
        if (appearance == null) {
            find = find.filter(f -> ((QPersonBody)f.personBodys.any()).appearance.isEmpty());
            this.LOGGER.info("without app");
        } else {
            this.LOGGER.info("with app");
            find = find.filter(f -> ((EnumPath)((QPersonBody)f.personBodys.any()).appearance.any()).in(Collections.singleton(appearance)));
        }
        return find;
    }

    public List<Person> getPersonsByAppearance(Gender gender, Appearance appearance, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByAppearanceFinder(showSecret, appearance);
        return find.order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByAppearanceCount(Gender gender, Appearance appearance, boolean showSecret) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByAppearanceFinder(showSecret, appearance);
        return find.count();
    }

    private EntityService.Finder<QPerson, Person> getPersonsByBodyPartSizeFinder(boolean showSecret, Gender gender, BodyPartSize bodyPartSize, BodyPart bodyPart) {
        EntityService.Finder<QPerson, Person> find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        if (bodyPartSize != null) {
            if (BodyPart.Tits.equals(bodyPart)) {
                find = find.filter(f -> ((QPersonBody)f.personBodys.any()).titsSize.eq((Object)bodyPartSize));
            } else if (BodyPart.Ass.equals(bodyPart)) {
                find = find.filter(f -> ((QPersonBody)f.personBodys.any()).assSize.eq((Object)bodyPartSize));
            }
        }
        return find;
    }

    public List<Person> getPersonsByBodyPartSize(Gender gender, BodyPartSize bodyPartSize, boolean showSecret, BodyPart bodyPart) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByBodyPartSizeFinder(showSecret, gender, bodyPartSize, bodyPart);
        return find.order(f -> f.name.lower().asc()).find();
    }

    public Long getPersonsByBodyPartSizeCount(Gender gender, BodyPartSize bodyPartSize, boolean showSecret, BodyPart bodyPart) {
        EntityService.Finder<QPerson, Person> find = this.getPersonsByBodyPartSizeFinder(showSecret, gender, bodyPartSize, bodyPart);
        return find.count();
    }

    public List<Studio> getStudios() {
        return entityService.find(QStudio.studio).order(p -> p.name.lower().asc()).find();
    }

    public List<Studio> getStudios(String searchTerm) {
        EntityService.Finder find = entityService.find(QStudio.studio);
        if (searchTerm != null && !searchTerm.isBlank()) {
            find = find.filter(f -> f.name.contains(searchTerm.toLowerCase()));
        }
        List<Studio> result = find.order(p -> p.name.lower().asc()).find();
        return result;
    }

    public List<Search> getSearches() {
        return entityService.find(QSearch.search).find();
    }

    public Search getDefaultSearch() {
        return (Search)entityService.find(QSearch.search).filter(f -> f.defaultSearch.isTrue()).findFirst();
    }

    public List<Medium> getMediums(Movie movie, boolean showSecret) {
        EntityService.Finder find = entityService.find(QMedium.medium);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.movie.id.eq((Object)movie.getId())).order(f -> f.part.asc()).find();
    }

    public List<MediumFile> getMediumFiles(boolean showSecret) {
        return this.getMediumFiles(showSecret, true);
    }

    public List<MediumFile> getMediumFiles(boolean showSecret, boolean order) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (order) {
            find = find.order(p -> p.fileName.lower().asc());
        }
        return find.find(this.maxResults);
    }

    public int getMediumFilesCount(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.count();
    }

    public Dvd getDvd(Movie m, boolean showSecret) {
        EntityService.Finder find = entityService.find(QDvd.dvd);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (Dvd)find.filter(f -> f.movie.id.eq((Object)m.getId())).order(p -> p.part.asc()).findFirst();
    }

    public Dvd getDvd(String hash, boolean showSecret) {
        EntityService.Finder find = entityService.find(QDvd.dvd);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (Dvd)find.filter(f -> f.hashValue.eq((Object)hash)).order(p -> p.part.asc()).findFirst();
    }

    public MediumFile getMediumFile(String hash, boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (MediumFile)find.filter(f -> f.hashValue.eq((Object)hash)).order(p -> p.part.asc()).findFirst();
    }

    public List<MediumFile> getMediumFiles(Movie m, boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.movie.id.eq((Object)m.getId())).order(p -> p.part.asc()).find(this.maxResults);
    }

    public List<MediumFile> getMediumFilesOrderedByScene(Movie m, boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        List<MediumFile> find1 = find.filter(f -> f.movie.id.eq((Object)m.getId())).order(p -> p.part.asc()).find(this.maxResults);
        ArrayList<MediumFile> result = new ArrayList<MediumFile>();
        for (Scene s : m.getScenes()) {
            boolean found = false;
            if (s.getStartMedium() != null && !result.contains(s.getStartMedium())) {
                result.add((MediumFile)s.getStartMedium());
                found = true;
            }
            if (s.getEndMedium() != null && !s.getEndMedium().equals(s.getStartMedium()) && !result.contains(s.getEndMedium())) {
                result.add((MediumFile)s.getEndMedium());
                found = true;
            }
            if (found) continue;
            this.LOGGER.info(m.getTitle() + " has at least one scene which is not associated to a medium file. Return unorded list.");
            result.clear();
            result.addAll(find1);
            break;
        }
        if (result.isEmpty()) {
            return find1;
        }
        return result;
    }

    public List<MediumFile> getMediumFiles(String searchTerm, boolean movies, boolean pix, boolean showSecret, OrderBy orderby) {
        return this.getMediumFiles(searchTerm, movies, pix, this.maxResults, false, false, showSecret, orderby, false);
    }

    public List<MediumFile> getMediumFiles(String searchTerm, boolean movies, boolean pix, boolean hideAssociatedFiles, boolean showSecret, OrderBy orderby, boolean unknown) {
        return this.getMediumFiles(searchTerm, movies, pix, this.maxResults, hideAssociatedFiles, false, showSecret, orderby, unknown);
    }

    public List<MediumFile> getMediumFiles(String searchTerm, boolean movies, boolean pix, boolean hideAssociatedFiles, boolean hideHashedFiles, boolean showSecret, OrderBy orderby) {
        return this.getMediumFiles(searchTerm, movies, pix, this.maxResults, hideAssociatedFiles, hideHashedFiles, showSecret, orderby, false);
    }

    public List<MediumFile> getMediumFiles(String searchTerm, boolean movies, boolean pix, boolean hideAssociatedFiles, boolean hideHashedFiles, boolean showSecret, OrderBy orderby, boolean unknown) {
        return this.getMediumFiles(searchTerm, movies, pix, this.maxResults, hideAssociatedFiles, hideHashedFiles, showSecret, orderby, unknown);
    }

    public List<MediumFile> getMediumFiles(String searchTerm, boolean movies, boolean pix, int customMaxResult, boolean hideAssociatedFiles, boolean hideHashedFiles, boolean showSecret, OrderBy orderby, boolean unknown) {
        String[] terms;
        EntityService.Finder<QMediumFile, Object> finder = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            finder = finder.filter(f -> f.secret.ne((Object)true));
        }
        if (pix && !movies) {
            finder = this.getPixFinder(showSecret);
        }
        if (!pix && movies) {
            finder = this.getMediumFileFinder(showSecret);
        }
        if (!pix && !movies && unknown) {
            finder = this.getUnknownFinder(showSecret);
        }
        searchTerm = searchTerm.replaceAll("  ", " ");
        for (String term : terms = searchTerm.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String tmpTerm;
            if ((term = term.replaceAll("\"", "")).startsWith("--")) {
                tmpTerm = term.substring(2);
                this.LOGGER.info("search term which should be excluded: " + tmpTerm);
                finder = finder.filter(f -> f.fileName.containsIgnoreCase(tmpTerm).not());
                continue;
            }
            tmpTerm = term;
            finder = finder.filter(f -> f.fileName.containsIgnoreCase(tmpTerm).or((Predicate)f.fileCompletePath.containsIgnoreCase(tmpTerm)));
        }
        if (hideAssociatedFiles) {
            finder = finder.filter(f -> f.movie.isNull());
        }
        if (hideHashedFiles) {
            finder = finder.filter(f -> f.hashValue.isNull());
        }
        if (orderby == null || OrderBy.TITLE.equals((Object)orderby)) {
            finder = finder.order(p -> p.fileName.lower().asc());
        }
        if (OrderBy.RUNTIME.equals((Object)orderby)) {
            finder = finder.order(p -> p.duration.desc());
        }
        if (OrderBy.RATING.equals((Object)orderby)) {
            finder = finder.order(p -> p.rating.desc(), p -> p.ratingDifferentiator.desc(), p -> p.fileName.lower().asc());
        }
        if (OrderBy.LASTMODIFICATION.equals((Object)orderby)) {
            finder = finder.order(p -> p.dateOfLastModification.desc());
        }
        if (OrderBy.CREATED.equals((Object)orderby)) {
            finder = finder.order(p -> p.dateOfCreation.desc());
        }
        if (OrderBy.FILESIZE.equals((Object)orderby)) {
            finder = finder.order(p -> p.fileSize.desc());
        }
        if (OrderBy.FILEEXTENSION.equals((Object)orderby)) {
            finder = finder.order(p -> p.fileExtension.lower().asc(), p -> p.fileName.lower().asc());
        }
        if (OrderBy.RESOLUTION.equals((Object)orderby)) {
            finder = finder.order(p -> p.height.desc(), p -> p.width.desc(), p -> p.fileName.lower().asc());
        }
        return finder.find(customMaxResult);
    }

    public List<MediumFile> getMediumFilesByHash(String hash) {
        if (hash.length() != 40) {
            this.LOGGER.warn("Passed string is not 40 characters long");
            return new ArrayList<MediumFile>();
        }
        EntityService.Finder finder = entityService.find(QMediumFile.mediumFile);
        finder = finder.filter(f -> f.hashValue.isNotNull().and((Predicate)f.hashValue.equalsIgnoreCase(hash)));
        return finder.find(Long.MAX_VALUE);
    }

    public Movie getMovieByHash(String hash) {
        if (hash.length() != 40) {
            this.LOGGER.warn("Passed hash is not 40 characters long");
            return null;
        }
        EntityService.Finder finder = entityService.find(QMediumFile.mediumFile);
        finder = finder.filter(f -> f.hashValue.isNotNull().and((Predicate)f.hashValue.equalsIgnoreCase(hash)));
        List mfs = finder.find(Long.MAX_VALUE);
        for (MediumFile mf : mfs) {
            if (mf.getMovie() == null) continue;
            return mf.getMovie();
        }
        return null;
    }

    public int getMediumFilesCount(boolean pix, boolean hideAssociatedFiles, boolean hideHashedFiles, boolean showSecret) {
        EntityService.Finder<QMediumFile, Object> finder = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            finder = finder.filter(f -> f.secret.ne((Object)true));
        }
        if (!pix) {
            finder = this.getMediumFileFinder(showSecret);
        }
        if (hideAssociatedFiles) {
            finder = finder.filter(f -> f.movie.isNull());
        }
        if (hideHashedFiles) {
            finder = finder.filter(f -> f.hashValue.isNull());
        }
        return (int)finder.count();
    }

    private EntityService.Finder<QMediumFile, MediumFile> getMediumFileFinder(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.fileExtension.eq((Object)"avi").or((Predicate)f.fileExtension.eq((Object)"mkv").or((Predicate)f.fileExtension.eq((Object)"mpeg").or((Predicate)f.fileExtension.eq((Object)"asf").or((Predicate)f.fileExtension.eq((Object)"divx").or((Predicate)f.fileExtension.eq((Object)"mp4").or((Predicate)f.fileExtension.eq((Object)"mp7").or((Predicate)f.fileExtension.eq((Object)"f4v").or((Predicate)f.fileExtension.eq((Object)"flv").or((Predicate)f.fileExtension.eq((Object)"wma").or((Predicate)f.fileExtension.eq((Object)"wmv").or((Predicate)f.fileExtension.eq((Object)"m4v").or((Predicate)f.fileExtension.eq((Object)"mov").or((Predicate)f.fileExtension.eq((Object)"iso").or((Predicate)f.fileExtension.eq((Object)"vid").or((Predicate)f.fileExtension.eq((Object)"rmvb").or((Predicate)f.fileExtension.eq((Object)"rm").or((Predicate)f.fileExtension.eq((Object)"mpe").or((Predicate)f.fileExtension.eq((Object)"mpg"))))))))))))))))))));
    }

    private EntityService.Finder<QMediumFile, MediumFile> getUnknownFinder(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.fileExtension.ne((Object)"avi").and((Predicate)f.fileExtension.ne((Object)"mkv").and((Predicate)f.fileExtension.ne((Object)"mpeg").and((Predicate)f.fileExtension.ne((Object)"asf").and((Predicate)f.fileExtension.ne((Object)"divx").and((Predicate)f.fileExtension.ne((Object)"mp4").and((Predicate)f.fileExtension.ne((Object)"mp7").and((Predicate)f.fileExtension.ne((Object)"f4v").and((Predicate)f.fileExtension.ne((Object)"flv").and((Predicate)f.fileExtension.ne((Object)"wma").and((Predicate)f.fileExtension.ne((Object)"wmv").and((Predicate)f.fileExtension.ne((Object)"m4v").and((Predicate)f.fileExtension.ne((Object)"mov").and((Predicate)f.fileExtension.ne((Object)"iso").and((Predicate)f.fileExtension.ne((Object)"vid").and((Predicate)f.fileExtension.ne((Object)"rmvb").and((Predicate)f.fileExtension.ne((Object)"rm").and((Predicate)f.fileExtension.ne((Object)"mpe").and((Predicate)f.fileExtension.ne((Object)"mpg").and((Predicate)f.fileExtension.ne((Object)"jpg").and((Predicate)f.fileExtension.ne((Object)"jpeg").and((Predicate)f.fileExtension.ne((Object)"webp").and((Predicate)f.fileExtension.ne((Object)"gif").and((Predicate)f.fileExtension.ne((Object)"bmp").and((Predicate)f.fileExtension.ne((Object)"png"))))))))))))))))))))))))));
    }

    private EntityService.Finder<QMediumFile, MediumFile> getStreamableeMovieFinder(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.fileExtension.eq((Object)"mp4").or((Predicate)f.fileExtension.eq((Object)"m4v")));
    }

    private EntityService.Finder<QMediumFile, MediumFile> getPixFinder(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMediumFile.mediumFile);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.fileExtension.eq((Object)"jpg").or((Predicate)f.fileExtension.eq((Object)"jpeg").or((Predicate)f.fileExtension.eq((Object)"webp").or((Predicate)f.fileExtension.eq((Object)"gif").or((Predicate)f.fileExtension.eq((Object)"bmp").or((Predicate)f.fileExtension.eq((Object)"png")))))));
    }

    public List<Movie> getMovies(boolean showSecret) {
        return this.getMovies(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getMovies(boolean showSecret, long limit) {
        return this.getMovies(OrderBy.TITLE, showSecret, limit);
    }

    public Movie getMovie(String filename) {
        MediumFile mf = (MediumFile)entityService.find(QMediumFile.mediumFile).filter(f -> f.fileCompletePath.isNotNull().and((Predicate)f.fileCompletePath.eq((Object)filename))).findFirst();
        if (mf != null) {
            return mf.getMovie();
        }
        return null;
    }

    public List<Movie> getMovies(OrderBy orderBy, boolean showSecret) {
        return this.getMovies(orderBy, showSecret, Long.MAX_VALUE);
    }

    public List<Movie> getFavoriteMovies(String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        return this.getFavoriteMovies(searchTerm, orderBy, showSecret, null, null, null, null, movieTypeFilter, limit);
    }

    public List<Movie> getFavoriteMovies(String searchTerm, OrderBy orderBy, boolean showSecret, LocalDateTime modificationFrom, LocalDateTime modificationTill, LocalDateTime createdFrom, LocalDateTime createdTill, MovieTypeFilter movieTypeFilter, long limit) {
        LocalDateTime tmpTill;
        LocalDateTime tmpFrom;
        EntityService.Finder<QScene, Scene> findFavoriteScenes = entityService.find(QScene.scene);
        EntityService.Finder<QMovie, Movie> findFavoriteMovies = entityService.find(QMovie.movie);
        if (!showSecret) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.secret.ne((Object)true));
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.secret.ne((Object)true));
        }
        findFavoriteMovies = findFavoriteMovies.filter(f -> f.favorite.isTrue());
        if (modificationFrom != null || modificationTill != null) {
            if (modificationFrom == null) {
                modificationFrom = LocalDateTime.now().minusYears(100L);
            }
            if (modificationTill == null) {
                modificationTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = modificationFrom;
            tmpTill = modificationTill;
            this.LOGGER.info("Modified: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.dateOfLastModification.between((Comparable)tmpFrom, (Comparable)tmpTill));
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.dateOfLastModification.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (createdFrom != null || createdTill != null) {
            if (createdFrom == null) {
                createdFrom = LocalDateTime.now().minusYears(100L);
            }
            if (createdTill == null) {
                createdTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = createdFrom;
            tmpTill = createdTill;
            this.LOGGER.info("Created: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.dateOfCreation.between((Comparable)tmpFrom, (Comparable)tmpTill));
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.dateOfCreation.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.snippet.isNotNull()).filter(f -> f.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.vr.isNotNull()).filter(f -> f.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.threeD.isNotNull()).filter(f -> f.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.interactive.isNotNull()).filter(f -> f.movie.interactive.isTrue());
        }
        findFavoriteMovies = this.applySearchTerms(searchTerm, findFavoriteMovies);
        findFavoriteMovies = this.addMoviesOrderByClause(orderBy, findFavoriteMovies);
        findFavoriteScenes = findFavoriteScenes.filter(f -> f.favorite.isTrue());
        findFavoriteScenes = this.addScenesOrderByClause(orderBy, findFavoriteScenes);
        List<Movie> movies = findFavoriteMovies.find();
        List<Scene> scenes = findFavoriteScenes.find();
        Set movieIds = movies.stream().filter(Objects::nonNull).map(AbstractEntity::getId).collect(Collectors.toSet());
        for (Scene scene : scenes) {
            Movie associated = scene.getMovieAssociated();
            if (associated == null) {
                this.LOGGER.warn("Scene {} has no associated movie", (Object)scene);
                continue;
            }
            if (!movieIds.add(associated.getId())) continue;
            movies.add(associated);
        }
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getSecretMovies(String searchTerm, OrderBy orderBy, boolean showSecret, LocalDateTime modificationFrom, LocalDateTime modificationTill, LocalDateTime createdFrom, LocalDateTime createdTill, MovieTypeFilter movieTypeFilter, long limit) {
        LocalDateTime tmpTill;
        LocalDateTime tmpFrom;
        if (!showSecret) {
            return new ArrayList<Movie>();
        }
        EntityService.Finder<QScene, Scene> findFavoriteScenes = entityService.find(QScene.scene);
        EntityService.Finder<QMovie, Movie> findFavoriteMovies = entityService.find(QMovie.movie);
        findFavoriteMovies = findFavoriteMovies.filter(f -> f.secret.isTrue());
        findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.secret.isTrue());
        if (modificationFrom != null || modificationTill != null) {
            if (modificationFrom == null) {
                modificationFrom = LocalDateTime.now().minusYears(100L);
            }
            if (modificationTill == null) {
                modificationTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = modificationFrom;
            tmpTill = modificationTill;
            this.LOGGER.info("Modified: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.dateOfLastModification.between((Comparable)tmpFrom, (Comparable)tmpTill));
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.dateOfLastModification.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (createdFrom != null || createdTill != null) {
            if (createdFrom == null) {
                createdFrom = LocalDateTime.now().minusYears(100L);
            }
            if (createdTill == null) {
                createdTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = createdFrom;
            tmpTill = createdTill;
            this.LOGGER.info("Created: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.dateOfCreation.between((Comparable)tmpFrom, (Comparable)tmpTill));
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.dateOfCreation.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.snippet.isNotNull()).filter(f -> f.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.vr.isNotNull()).filter(f -> f.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.threeD.isNotNull()).filter(f -> f.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
            findFavoriteScenes = findFavoriteScenes.filter(f -> f.movie.interactive.isNotNull()).filter(f -> f.movie.interactive.isTrue());
        }
        findFavoriteMovies = this.applySearchTerms(searchTerm, findFavoriteMovies);
        findFavoriteMovies = this.addMoviesOrderByClause(orderBy, findFavoriteMovies);
        findFavoriteScenes = this.addScenesOrderByClause(orderBy, findFavoriteScenes);
        List<Movie> movies = findFavoriteMovies.find();
        List<Scene> scenes = findFavoriteScenes.find();
        for (Scene s : scenes) {
            boolean found = false;
            for (Movie m : movies) {
                if (m.getId().longValue() != s.getMovieAssociated().getId().longValue()) continue;
                found = true;
            }
            if (found) continue;
            movies.add(s.getMovieAssociated());
        }
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getLastCameMovies(String searchTerm, OrderBy orderBy, boolean showSecret, LocalDateTime modificationFrom, LocalDateTime modificationTill, LocalDateTime createdFrom, LocalDateTime createdTill, MovieTypeFilter movieTypeFilter, long limit) {
        List bookmarks = entityService.find(QBookmark.bookmark).filter(f -> f.type.eq((Object)BookmarkType.ICAME)).order(f -> f.dateOfCreation.desc()).find();
        TreeMap map = new TreeMap();
        for (Bookmark b : bookmarks) {
            if (!map.containsKey(b.getDateOfCreation())) {
                map.put(b.getDateOfCreation(), new ArrayList());
            }
            ((List)map.get(b.getDateOfCreation())).add(b.getMovieAssociated());
        }
        EntityService.Finder finder = entityService.find(QStatistic.statistic).filter(f -> f.scene.isNotNull()).filter(f -> f.likes.size().goe((Number)1));
        List movstat = finder.find();
        for (Statistic s : movstat) {
            if (!map.containsKey(s.getLikes().getLast())) {
                map.put(s.getLikes().getLast(), new ArrayList());
            }
            ((List)map.get(s.getLikes().getLast())).add(s.getScene().getMovieAssociated());
        }
        ArrayList movies = new ArrayList();
        map.values().stream().forEach(f -> movies.addAll(f));
        return movies.reversed().subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    private EntityService.Finder<QScene, Scene> addScenesOrderByClause(OrderBy orderBy, EntityService.Finder<QScene, Scene> findFavoriteScenes) {
        findFavoriteScenes = orderBy.equals((Object)OrderBy.TITLE) ? findFavoriteScenes.order(s -> s.movie.title.lower().asc()) : (orderBy.equals((Object)OrderBy.LASTMODIFICATION) ? findFavoriteScenes.order(s -> s.dateOfLastModification.desc(), s -> s.movie.title.lower().asc()) : (orderBy.equals((Object)OrderBy.CREATED) ? findFavoriteScenes.order(s -> s.dateOfCreation.desc(), m -> m.movie.title.lower().asc()) : (orderBy.equals((Object)OrderBy.RATING) ? findFavoriteScenes.order(s -> s.rating.desc(), s -> s.ratingDifferentiator.desc(), m -> m.movie.title.lower().asc()) : (orderBy.equals((Object)OrderBy.DATEOFSHOOT) ? findFavoriteScenes.order(s -> s.movie.releaseYear.desc(), s -> s.movie.releaseMonth.desc(), s -> s.movie.releaseDay.desc(), s -> s.movie.title.lower().asc()) : findFavoriteScenes.order(s -> s.movie.title.lower().asc())))));
        return findFavoriteScenes;
    }

    public List<Movie> getWizardGeneratedMovies(boolean wizardGenerated, String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        EntityService.Finder<QMovie, Movie> findFavoriteMovies = this.getMovieFinder(showSecret);
        findFavoriteMovies = findFavoriteMovies.filter(f -> f.wizardGenerated.eq(Boolean.valueOf(wizardGenerated)));
        findFavoriteMovies = this.applySearchTerms(searchTerm, findFavoriteMovies);
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.snippet.isNotNull()).filter(f -> QMovie.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.vr.isNotNull()).filter(f -> QMovie.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.threeD.isNotNull()).filter(f -> QMovie.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findFavoriteMovies = findFavoriteMovies.filter(f -> QMovie.movie.interactive.isNotNull()).filter(f -> QMovie.movie.interactive.isTrue());
        }
        findFavoriteMovies = orderBy.equals((Object)OrderBy.TITLE) ? findFavoriteMovies.order(m -> m.title.lower().asc()) : (orderBy.equals((Object)OrderBy.LASTMODIFICATION) ? findFavoriteMovies.order(m -> m.dateOfLastModification.desc(), m -> m.title.lower().asc()) : (orderBy.equals((Object)OrderBy.CREATED) ? findFavoriteMovies.order(m -> m.dateOfCreation.desc(), m -> m.title.lower().asc()) : (orderBy.equals((Object)OrderBy.RATING) ? findFavoriteMovies.order(m -> m.rating.desc(), m -> m.ratingDifferentiator.desc(), m -> m.title.lower().asc()) : (orderBy.equals((Object)OrderBy.DATEOFSHOOT) ? findFavoriteMovies.order(m -> m.releaseYear.desc(), m -> m.releaseMonth.desc(), m -> m.releaseDay.desc(), s -> s.title.lower().asc()) : findFavoriteMovies.order(s -> QMovie.movie.title.lower().asc())))));
        List<Movie> movies = findFavoriteMovies.find();
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        this.filterForDvds(movieTypeFilter, movies, showSecret, tmpMovies);
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getMoviesPersonsCompleted(boolean personSet, String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        LocalDateTime now = LocalDateTime.now();
        EntityService.Finder<QScene, Scene> findScenes = entityService.find(QScene.scene);
        findScenes = personSet ? findScenes.filter(f -> ((QSceneDetails)f.details.any()).person.isNull().not()) : findScenes.filter(f -> f.details.isEmpty());
        if (!showSecret) {
            findScenes = findScenes.filter(f -> f.movie.secret.ne((Object)true));
        }
        this.applySearchTermsForScenes(searchTerm, findScenes);
        if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findScenes = findScenes.filter(f -> f.movie.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findScenes = findScenes.filter(f -> f.movie.snippet.isNotNull()).filter(f -> f.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findScenes = findScenes.filter(f -> f.movie.vr.isNotNull()).filter(f -> f.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findScenes = findScenes.filter(f -> f.movie.threeD.isNotNull()).filter(f -> f.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findScenes = findScenes.filter(f -> f.movie.interactive.isNotNull()).filter(f -> f.movie.interactive.isTrue());
        }
        findScenes = orderBy.equals((Object)OrderBy.TITLE) ? findScenes.order(s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.LASTMODIFICATION) ? findScenes.order(m -> m.movie.dateOfLastModification.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.CREATED) ? findScenes.order(m -> m.movie.dateOfCreation.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.RATING) ? findScenes.order(m -> m.movie.rating.desc(), s -> s.ratingDifferentiator.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.DATEOFSHOOT) ? findScenes.order(m -> m.movie.releaseYear.desc(), m -> m.movie.releaseMonth.desc(), m -> m.movie.releaseDay.desc(), s -> s.movie.title.asc()) : findScenes.order(s -> s.movie.title.asc())))));
        List<Movie> result = findScenes.find(limit).stream().map(f -> f.getMovie()).collect(Collectors.toList());
        this.orderByRuntime(orderBy, result);
        if (personSet) {
            ArrayList<Movie> tmpList = new ArrayList<Movie>();
            tmpList.addAll(result);
            for (Movie m2 : tmpList) {
                System.out.println(m2.getScenes().size() + " movie " + m2.getTitle());
                boolean found = true;
                for (Scene s2 : m2.getScenes()) {
                    if (!s2.getPersons(showSecret).isEmpty()) continue;
                    found = false;
                }
                if (found) continue;
                System.out.println("remove");
                result.remove(m2);
            }
        }
        List noDuplicates = result.stream().distinct().collect(Collectors.toList());
        result.clear();
        result.addAll(noDuplicates);
        this.LOGGER.info("getMoviesPersonsCompleted - end " + Duration.between(LocalDateTime.now(), now).toString());
        return result.subList(0, result.size() > (int)limit ? (int)limit : result.size());
    }

    public List<Movie> getMoviesSceneLengthSet(boolean sceneLengthSet, String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        LocalDateTime now = LocalDateTime.now();
        EntityService.Finder<QScene, Scene> findScenes = entityService.find(QScene.scene);
        findScenes = sceneLengthSet ? findScenes.filter(f -> f.endTime.isNotNull().and((Predicate)f.endTime.gt((Number)0))) : findScenes.filter(f -> f.endTime.isNull().or((Predicate)f.endTime.eq((Object)0)));
        if (!showSecret) {
            findScenes = findScenes.filter(f -> f.movie.secret.ne((Object)true));
        }
        this.applySearchTermsForScenes(searchTerm, findScenes);
        if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findScenes = findScenes.filter(f -> f.movie.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findScenes = findScenes.filter(f -> f.movie.snippet.isNotNull()).filter(f -> f.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findScenes = findScenes.filter(f -> f.movie.vr.isNotNull()).filter(f -> f.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findScenes = findScenes.filter(f -> f.movie.threeD.isNotNull()).filter(f -> f.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findScenes = findScenes.filter(f -> f.movie.interactive.isNotNull()).filter(f -> f.movie.interactive.isTrue());
        }
        findScenes = orderBy.equals((Object)OrderBy.TITLE) ? findScenes.order(s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.LASTMODIFICATION) ? findScenes.order(m -> m.movie.dateOfLastModification.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.CREATED) ? findScenes.order(m -> m.movie.dateOfCreation.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.RATING) ? findScenes.order(m -> m.movie.rating.desc(), s -> s.ratingDifferentiator.desc(), s -> s.movie.title.asc()) : (orderBy.equals((Object)OrderBy.DATEOFSHOOT) ? findScenes.order(m -> m.movie.releaseYear.desc(), m -> m.movie.releaseMonth.desc(), m -> m.movie.releaseDay.desc(), s -> s.movie.title.asc()) : findScenes.order(s -> s.movie.title.asc())))));
        this.LOGGER.info("getMoviesSceneLengthSet - find now scenes " + Duration.between(LocalDateTime.now(), now).toString());
        List<Scene> scenes = findScenes.find();
        this.LOGGER.info("getMoviesSceneLengthSet - collected scenes " + scenes.size() + " - " + Duration.between(LocalDateTime.now(), now).toString());
        ArrayList<Movie> result = new ArrayList<Movie>();
        for (Scene s2 : scenes) {
            if (result.contains(s2.getMovieAssociated())) continue;
            result.add(s2.getMovieAssociated());
        }
        this.LOGGER.info("getMoviesSceneLengthSet - collected movies " + result.size() + " - " + Duration.between(LocalDateTime.now(), now).toString());
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            this.LOGGER.info("checking scene length set movies, only movies: " + result.size());
            for (Movie m2 : result) {
                if (m2.getScenes().size() <= 1 || this.getDvd(m2, showSecret) != null) continue;
                boolean add = true;
                this.LOGGER.debug("m: " + m2.getTitle());
                for (Scene scene : m2.getScenes()) {
                    this.LOGGER.debug("sc: " + scene.getNameOfPlayable() + " - " + scene.getEndTime());
                    if (scene.getEndTime() > 0) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                tmpMovies.add(m2);
            }
            result.clear();
            result.addAll(tmpMovies);
        }
        if (movieTypeFilter == MovieTypeFilter.Dvd) {
            for (Movie m2 : result) {
                Dvd dvd = this.getDvd(m2, showSecret);
                if (dvd == null) continue;
                boolean add = true;
                for (Scene s4 : m2.getScenes()) {
                    if (s4.getEndTime() > 0) continue;
                    add = false;
                }
                if (!add) continue;
                tmpMovies.add(m2);
            }
            result.clear();
            result.addAll(tmpMovies);
        }
        this.orderByRuntime(orderBy, result);
        if (sceneLengthSet) {
            this.LOGGER.info("clearing " + tmpMovies.size());
            tmpMovies.clear();
            this.LOGGER.info("getMoviesSceneLengthSet - collect scenes (set) start " + Duration.between(LocalDateTime.now(), now).toString());
            for (Movie m2 : result) {
                boolean add = true;
                for (Scene scene : m2.getScenes()) {
                    if (scene.getEndTime() > 0) continue;
                    add = false;
                    break;
                }
                if (!add || tmpMovies.contains(m2)) continue;
                tmpMovies.add(m2);
            }
            this.LOGGER.info("getMoviesSceneLengthSet - collect scenes (set) end " + Duration.between(LocalDateTime.now(), now).toString());
            result.clear();
            result.addAll(tmpMovies);
        }
        this.LOGGER.info("getMoviesSceneLengthSet: " + result.size() + " - " + Duration.between(LocalDateTime.now(), now).toString());
        return result.subList(0, result.size() > (int)limit ? (int)limit : result.size());
    }

    public List<Movie> getRegrettablyAwesomeMovies(boolean regrettablyAwesome, String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        this.LOGGER.info("regrettable awesome: " + String.valueOf(movieTypeFilter));
        EntityService.Finder<QMovie, Movie> findRegrettablyAwesomeMovies = entityService.find(QMovie.movie);
        EntityService.Finder findRegrettablyAwesomeScenes = entityService.find(QScene.scene);
        if (!showSecret) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.secret.ne((Object)true));
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.movie.secret.ne((Object)true));
        }
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.movie.snippet.isNotNull()).filter(f -> f.movie.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.movie.vr.isNotNull()).filter(f -> f.movie.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.movie.threeD.isNotNull()).filter(f -> f.movie.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.movie.interactive.isNotNull()).filter(f -> f.movie.interactive.isTrue());
        }
        findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.filter(f -> f.regrettablyAwesome.eq(Boolean.valueOf(regrettablyAwesome)));
        findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.filter(f -> f.regrettablyAwesome.eq(Boolean.valueOf(regrettablyAwesome)));
        findRegrettablyAwesomeMovies = this.applySearchTerms(searchTerm, findRegrettablyAwesomeMovies);
        if (orderBy.equals((Object)OrderBy.TITLE)) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.title.lower().asc());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.order(m -> m.movie.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.LASTMODIFICATION)) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.dateOfLastModification.desc(), m -> m.title.lower().asc());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.order(m -> m.movie.dateOfLastModification.desc(), m -> m.movie.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.CREATED)) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.dateOfCreation.desc(), m -> m.title.lower().asc());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.order(m -> m.movie.dateOfCreation.desc(), m -> m.movie.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.RATING)) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.rating.desc(), m -> m.ratingDifferentiator.desc(), m -> m.title.lower().asc());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.order(m -> m.rating.desc(), m -> m.ratingDifferentiator.desc(), m -> m.movie.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.DATEOFSHOOT)) {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.releaseYear.desc(), m -> m.releaseMonth.desc(), m -> m.releaseDay.desc(), m -> m.title.lower().asc());
            findRegrettablyAwesomeScenes = findRegrettablyAwesomeScenes.order(m -> m.movie.releaseYear.desc(), m -> m.movie.releaseMonth.desc(), m -> m.movie.releaseDay.desc(), m -> m.movie.title.lower().asc());
        } else {
            findRegrettablyAwesomeMovies = findRegrettablyAwesomeMovies.order(m -> m.title.lower().asc());
        }
        List<Movie> movies = findRegrettablyAwesomeMovies.find();
        List scenes = findRegrettablyAwesomeScenes.find();
        for (Scene s : scenes) {
            boolean contains = false;
            for (Movie m2 : movies) {
                if (m2.getId().longValue() != s.getMovieAssociated().getId().longValue()) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            movies.add(s.getMovieAssociated());
        }
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        if (movieTypeFilter == MovieTypeFilter.Scenes) {
            this.LOGGER.info("checking awesome movies, only scenes: " + movies.size());
            for (Movie m3 : movies) {
                if (m3.getScenes().size() != 1) continue;
                tmpMovies.add(m3);
            }
            movies.clear();
            movies.addAll(tmpMovies);
        }
        this.filterForDvds(movieTypeFilter, movies, showSecret, tmpMovies);
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getMoviesWithMissingStudios(String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        EntityService.Finder<QMovie, Movie> findMoviesWithMissingStudios = this.getMovieFinder(showSecret);
        findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.studio.isNull());
        findMoviesWithMissingStudios = this.applySearchTerms(searchTerm, findMoviesWithMissingStudios);
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findMoviesWithMissingStudios = findMoviesWithMissingStudios.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        }
        findMoviesWithMissingStudios = this.addMoviesOrderByClause(orderBy, findMoviesWithMissingStudios);
        List<Movie> movies = findMoviesWithMissingStudios.find();
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        this.filterForDvds(movieTypeFilter, movies, showSecret, tmpMovies);
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    private void filterForDvds(MovieTypeFilter movieTypeFilter, List<Movie> movies, boolean showSecret, List<Movie> tmpMovies) {
        if (movieTypeFilter == MovieTypeFilter.Dvd) {
            for (Movie m : movies) {
                Dvd dvd = this.getDvd(m, showSecret);
                if (dvd == null) continue;
                tmpMovies.add(m);
            }
            movies.clear();
            movies.addAll(tmpMovies);
        }
    }

    private void orderByRuntime(OrderBy orderBy, List<Movie> movies) {
        if (orderBy.equals((Object)OrderBy.RUNTIME)) {
            Collections.sort(movies, (one, other) -> Integer.valueOf(other.getTotalRuntime()).compareTo(one.getTotalRuntime()));
        }
    }

    public List<Movie> getMoviesWithMissingMediumFile(String searchTerm, OrderBy orderBy, boolean showSecret) {
        return this.getMoviesWithMissingMediumFile(searchTerm, orderBy, showSecret, MovieTypeFilter.All, Long.MAX_VALUE);
    }

    public List<Movie> getMoviesWithMissingMediumFile(String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        EntityService.Finder<QMovie, Movie> findMoviesWithMissingMediumFile = this.getMovieFinder(showSecret);
        findMoviesWithMissingMediumFile = this.applySearchTerms(searchTerm, findMoviesWithMissingMediumFile);
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findMoviesWithMissingMediumFile = findMoviesWithMissingMediumFile.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        }
        findMoviesWithMissingMediumFile = this.addMoviesOrderByClause(orderBy, findMoviesWithMissingMediumFile);
        List<Movie> possibleMovies = findMoviesWithMissingMediumFile.find();
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Movie m : possibleMovies) {
            if (this.getEntityService().find(QMediumFile.mediumFile).filter(f -> f.movie.eq(m)).count() != 0L || this.getDvd(m, true) != null) continue;
            movies.add(m);
        }
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        this.filterForDvds(movieTypeFilter, movies, showSecret, tmpMovies);
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getMoviesWithSeveralMediumFilesAssigned(String searchTerm, OrderBy orderBy, boolean showSecret, MovieTypeFilter movieTypeFilter, long limit) {
        EntityService.Finder<QMovie, Movie> findMoviesWithSeveralMediumFiles = this.getMovieFinder(showSecret);
        findMoviesWithSeveralMediumFiles = this.applySearchTerms(searchTerm, findMoviesWithSeveralMediumFiles);
        if (movieTypeFilter == MovieTypeFilter.Scenes) {
            findMoviesWithSeveralMediumFiles = findMoviesWithSeveralMediumFiles.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            findMoviesWithSeveralMediumFiles = findMoviesWithSeveralMediumFiles.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            findMoviesWithSeveralMediumFiles = findMoviesWithSeveralMediumFiles.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            findMoviesWithSeveralMediumFiles = findMoviesWithSeveralMediumFiles.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            findMoviesWithSeveralMediumFiles = findMoviesWithSeveralMediumFiles.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        }
        findMoviesWithSeveralMediumFiles = this.addMoviesOrderByClause(orderBy, findMoviesWithSeveralMediumFiles);
        List<Movie> possibleMovies = findMoviesWithSeveralMediumFiles.find();
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Movie m : possibleMovies) {
            this.LOGGER.info("Check: " + String.valueOf(m));
            if (this.getMediumFiles(m, showSecret).size() <= 1) continue;
            this.LOGGER.info("Okay add");
            movies.add(m);
        }
        this.orderByRuntime(orderBy, movies);
        return movies.subList(0, movies.size() > (int)limit ? (int)limit : movies.size());
    }

    public List<Movie> getMovies(String searchTerm, OrderBy orderBy, boolean showSecret, long limit) {
        return this.getMovies(searchTerm, orderBy, showSecret, limit, null, null, null, null);
    }

    public List<Movie> getMovies(String searchTerm, OrderBy orderBy, boolean showSecret, long limit, LocalDateTime modificationFrom, LocalDateTime modificationTill, LocalDateTime createdFrom, LocalDateTime createdTill) {
        return this.getMovies(searchTerm, orderBy, showSecret, false, limit, modificationFrom, modificationTill, createdFrom, createdTill, null);
    }

    public List<Movie> getMovies(String searchTerm, OrderBy orderBy, boolean showSecret, boolean onlyScenes, long limit, LocalDateTime modificationFrom, LocalDateTime modificationTill, LocalDateTime createdFrom, LocalDateTime createdTill, MovieTypeFilter movieTypeFilter) {
        LocalDateTime tmpTill;
        LocalDateTime tmpFrom;
        this.LOGGER.info("dates for getMovies: " + String.valueOf(modificationFrom) + " - " + String.valueOf(modificationTill) + " :: " + String.valueOf(createdFrom) + " - " + String.valueOf(createdTill) + " - orderBy: " + String.valueOf((Object)orderBy));
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        if (modificationFrom != null || modificationTill != null) {
            if (modificationFrom == null) {
                modificationFrom = LocalDateTime.now().minusYears(100L);
            }
            if (modificationTill == null) {
                modificationTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = modificationFrom;
            tmpTill = modificationTill;
            this.LOGGER.info("Modified: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            find = find.filter(f -> f.dateOfLastModification.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (createdFrom != null || createdTill != null) {
            if (createdFrom == null) {
                createdFrom = LocalDateTime.now().minusYears(100L);
            }
            if (createdTill == null) {
                createdTill = LocalDateTime.now().plusDays(1L);
            }
            tmpFrom = createdFrom;
            tmpTill = createdTill;
            this.LOGGER.info("Created: " + String.valueOf(tmpFrom) + " - " + String.valueOf(tmpTill));
            find = find.filter(f -> f.dateOfCreation.between((Comparable)tmpFrom, (Comparable)tmpTill));
        }
        if (onlyScenes) {
            find = find.filter(f -> f.scenes.size().eq((Object)1));
        }
        find = this.applySearchTerms(searchTerm, find);
        if (movieTypeFilter == MovieTypeFilter.Movies) {
            find = find.filter(f -> f.scenes.size().gt((Number)1));
        } else if (movieTypeFilter == MovieTypeFilter.Scenes) {
            find = find.filter(f -> f.scenes.size().eq((Object)1));
        } else if (movieTypeFilter == MovieTypeFilter.Snippets) {
            find = find.filter(f -> f.snippet.isNotNull()).filter(f -> f.snippet.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.VR) {
            find = find.filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.ThreeD) {
            find = find.filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        } else if (movieTypeFilter == MovieTypeFilter.Interactive) {
            find = find.filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        }
        if (orderBy != OrderBy.HOWOFTENSTARTED) {
            find = this.addMoviesOrderByClause(orderBy, find);
        }
        List<Movie> movies = find.find(limit);
        this.LOGGER.info("Found " + movies.size() + " movies");
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>();
        this.filterForDvds(movieTypeFilter, movies, showSecret, tmpMovies);
        this.orderByRuntime(orderBy, movies);
        if (orderBy == OrderBy.HOWOFTENSTARTED) {
            HashMap<Movie, Integer> map = new HashMap<Movie, Integer>();
            ArrayList<Movie> tmpList = new ArrayList<Movie>();
            for (Movie m : movies) {
                Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.movie.eq(m)).findFirst();
                if (stat == null) continue;
                int n = stat.getStarted().size();
                if (m.getScenes().size() != 1) {
                    for (Scene s : m.getScenes()) {
                        Statistic statScene = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.scene.eq(s)).findFirst();
                        if (statScene == null) continue;
                        n += statScene.getStarted().size();
                    }
                }
                map.put(m, n);
            }
            Set set = map.entrySet();
            ArrayList list = new ArrayList(set);
            Collections.sort(list, new Comparator<Map.Entry<Movie, Integer>>(this){

                @Override
                public int compare(Map.Entry<Movie, Integer> o1, Map.Entry<Movie, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            for (Map.Entry entry : list) {
                tmpList.add((Movie)entry.getKey());
            }
            movies.clear();
            movies.addAll(tmpList);
        }
        return movies;
    }

    private EntityService.Finder<QMovie, Movie> addMoviesOrderByClause(OrderBy orderBy, EntityService.Finder<QMovie, Movie> find) {
        if (orderBy.equals((Object)OrderBy.TITLE)) {
            find = find.order(m -> m.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.LASTMODIFICATION)) {
            find = find.order(m -> m.dateOfLastModification.desc(), m -> m.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.CREATED)) {
            find = find.order(m -> m.dateOfCreation.desc(), m -> m.title.lower().asc());
        } else if (orderBy.equals((Object)OrderBy.RATING)) {
            QMovie m2 = QMovie.movie;
            NumberExpression differentiatorOrder = (NumberExpression)new CaseBuilder().when((Predicate)m2.ratingDifferentiator.eq((Object)Differentiator.MORE)).then((Number)0).when((Predicate)m2.ratingDifferentiator.eq((Object)Differentiator.SAME)).then((Object)1).when((Predicate)m2.ratingDifferentiator.isNull()).then((Object)1).when((Predicate)m2.ratingDifferentiator.eq((Object)Differentiator.LESS)).then((Object)2).otherwise((Object)3);
            find = find.order(mx -> mx.rating.desc(), mx -> differentiatorOrder.asc(), mx -> mx.title.lower().asc());
        } else {
            find = orderBy.equals((Object)OrderBy.DATEOFSHOOT) ? find.order(m -> m.releaseYear.desc(), m -> m.releaseMonth.desc(), m -> m.releaseDay.desc(), m -> m.title.lower().asc()) : find.order(m -> m.title.lower().asc());
        }
        return find;
    }

    private EntityService.Finder<QMovie, Movie> applySearchTerms(String searchTerm, EntityService.Finder<QMovie, Movie> find) {
        if (searchTerm != null && !searchTerm.isEmpty()) {
            String[] terms;
            searchTerm = searchTerm.replaceAll("  ", " ");
            for (String term : terms = searchTerm.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                term = term.replaceAll("\"", "");
                if (terms.length > 1 && term.trim().isEmpty()) continue;
                String tmpTerm = term;
                this.LOGGER.info("search term: " + tmpTerm);
                ArrayList<MovieType> movieTypeToConsider = new ArrayList<MovieType>();
                String movieTerm = term;
                if (term.startsWith("--") || term.startsWith("++")) {
                    movieTerm = term.substring(2);
                }
                for (MovieType mt : MovieType.values()) {
                    if (!mt.getTitle().toLowerCase().contains(movieTerm)) continue;
                    this.LOGGER.info("Consider movie type: " + String.valueOf(mt));
                    movieTypeToConsider.add(mt);
                }
                this.LOGGER.info("movie types to consider/ignore: " + movieTypeToConsider.size());
                if (term.startsWith("--")) {
                    find = find.filter(f -> f.title.containsIgnoreCase(tmpTerm.substring(2)).not().and((Predicate)f.alternativeTitle.isNull().or((Predicate)f.alternativeTitle.isNotNull().and((Predicate)f.alternativeTitle.containsIgnoreCase(tmpTerm).not()))).and((Predicate)f.type.isNull().or((Predicate)f.type.isNotNull().and((Predicate)f.type.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.type2.isNull().or((Predicate)f.type2.isNotNull().and((Predicate)f.type2.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.type3.isNull().or((Predicate)f.type3.isNotNull().and((Predicate)f.type3.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.type4.isNull().or((Predicate)f.type4.isNotNull().and((Predicate)f.type4.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.type5.isNull().or((Predicate)f.type5.isNotNull().and((Predicate)f.type5.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.type6.isNull().or((Predicate)f.type6.isNotNull().and((Predicate)f.type6.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movietypes.isEmpty().or((Predicate)((EnumPath)f.movietypes.any()).notIn((Collection)movieTypeToConsider))).and((Predicate)((QSceneDetails)((QScene)f.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm.substring(2)).not()));
                    continue;
                }
                if (term.startsWith("++")) {
                    this.LOGGER.info("EXACT movie");
                    find = find.filter(f -> f.title.containsIgnoreCase(tmpTerm.substring(2)).or((Predicate)f.alternativeTitle.isNotNull().and((Predicate)f.alternativeTitle.containsIgnoreCase(tmpTerm.substring(2))).or((Predicate)f.type.isNotNull().and((Predicate)f.type.in((Collection)movieTypeToConsider))).or((Predicate)f.type2.isNotNull().and((Predicate)f.type2.in((Collection)movieTypeToConsider))).or((Predicate)f.type3.isNotNull().and((Predicate)f.type3.in((Collection)movieTypeToConsider))).or((Predicate)f.type4.isNotNull().and((Predicate)f.type4.in((Collection)movieTypeToConsider))).or((Predicate)f.type5.isNotNull().and((Predicate)f.type5.in((Collection)movieTypeToConsider))).or((Predicate)f.type6.isNotNull().and((Predicate)f.type6.in((Collection)movieTypeToConsider))).or((Predicate)((EnumPath)f.movietypes.any()).in((Collection)movieTypeToConsider))).or((Predicate)((QSceneDetails)((QScene)f.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm.substring(2))));
                    continue;
                }
                this.LOGGER.info("TEEEEEEEEEEEASSSSSSSSSSSSSSSSSSSSEEEEEEEEEEEEEE");
                find = find.filter(f -> f.title.containsIgnoreCase(tmpTerm).or((Predicate)f.alternativeTitle.isNotNull().and((Predicate)f.alternativeTitle.containsIgnoreCase(tmpTerm)).or((Predicate)f.type.isNotNull().and((Predicate)f.type.in((Collection)movieTypeToConsider))).or((Predicate)f.type2.isNotNull().and((Predicate)f.type2.in((Collection)movieTypeToConsider))).or((Predicate)f.type3.isNotNull().and((Predicate)f.type3.in((Collection)movieTypeToConsider))).or((Predicate)f.type4.isNotNull().and((Predicate)f.type4.in((Collection)movieTypeToConsider))).or((Predicate)f.type5.isNotNull().and((Predicate)f.type5.in((Collection)movieTypeToConsider))).or((Predicate)f.type6.isNotNull().and((Predicate)f.type6.in((Collection)movieTypeToConsider))).or((Predicate)((EnumPath)f.movietypes.any()).in((Collection)movieTypeToConsider)).or((Predicate)((QSceneDetails)((QScene)f.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm))));
            }
        }
        return find;
    }

    private EntityService.Finder<QScene, Scene> applySearchTermsForScenes(String searchTerm, EntityService.Finder<QScene, Scene> find) {
        if (searchTerm != null && !searchTerm.isEmpty()) {
            String[] terms;
            searchTerm = searchTerm.replaceAll("  ", " ");
            for (String term : terms = searchTerm.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                term = term.replaceAll("\"", "");
                if (terms.length > 1 && term.trim().isEmpty()) continue;
                String tmpTerm = term;
                this.LOGGER.info("search term: " + tmpTerm);
                ArrayList<MovieType> movieTypeToConsider = new ArrayList<MovieType>();
                String movieTerm = term;
                if (term.startsWith("--") || term.startsWith("++")) {
                    movieTerm = term.substring(2);
                } else {
                    for (MovieType mt : MovieType.values()) {
                        if (!mt.getTitle().toLowerCase().contains(movieTerm)) continue;
                        this.LOGGER.info("Consider movie type: " + String.valueOf(mt));
                        movieTypeToConsider.add(mt);
                    }
                }
                if (term.startsWith("--")) {
                    find = find.filter(f -> f.movie.title.containsIgnoreCase(tmpTerm.substring(2)).not().and((Predicate)f.movie.alternativeTitle.isNull().or((Predicate)f.movie.alternativeTitle.isNotNull().and((Predicate)f.movie.alternativeTitle.containsIgnoreCase(tmpTerm).not()))).and((Predicate)f.movie.type.isNull().or((Predicate)f.movie.type.isNotNull().and((Predicate)f.movie.type.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.type2.isNull().or((Predicate)f.movie.type2.isNotNull().and((Predicate)f.movie.type2.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.type3.isNull().or((Predicate)f.movie.type3.isNotNull().and((Predicate)f.movie.type3.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.type4.isNull().or((Predicate)f.movie.type4.isNotNull().and((Predicate)f.movie.type4.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.type5.isNull().or((Predicate)f.movie.type5.isNotNull().and((Predicate)f.movie.type5.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.type6.isNull().or((Predicate)f.movie.type6.isNotNull().and((Predicate)f.movie.type6.notIn((Collection)movieTypeToConsider)))).and((Predicate)f.movie.movietypes.isEmpty().or((Predicate)((EnumPath)f.movie.movietypes.any()).notIn((Collection)movieTypeToConsider))).and((Predicate)((QSceneDetails)((QScene)f.movie.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm.substring(2)).not()));
                    continue;
                }
                if (term.startsWith("++")) {
                    this.LOGGER.info("EXACT scene");
                    find = find.filter(f -> f.movie.title.containsIgnoreCase(tmpTerm.substring(2)).or((Predicate)f.movie.alternativeTitle.isNotNull().and((Predicate)f.movie.alternativeTitle.containsIgnoreCase(tmpTerm.substring(2))).or((Predicate)f.type.isNotNull().and((Predicate)f.type.in((Collection)movieTypeToConsider))).or((Predicate)f.type2.isNotNull().and((Predicate)f.type2.in((Collection)movieTypeToConsider))).or((Predicate)f.type3.isNotNull().and((Predicate)f.type3.in((Collection)movieTypeToConsider))).or((Predicate)f.type4.isNotNull().and((Predicate)f.type4.in((Collection)movieTypeToConsider))).or((Predicate)f.type5.isNotNull().and((Predicate)f.type5.in((Collection)movieTypeToConsider))).or((Predicate)f.type6.isNotNull().and((Predicate)f.type6.in((Collection)movieTypeToConsider))).or((Predicate)((EnumPath)f.movietypes.any()).in((Collection)movieTypeToConsider))).or((Predicate)((QSceneDetails)((QScene)f.movie.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm.substring(2))));
                    continue;
                }
                this.LOGGER.info("TEEEEEEEEEEEASSSSSSSSSSSSSSSSSSSSEEEEEEEEEEEEEE");
                find = find.filter(f -> f.movie.title.containsIgnoreCase(tmpTerm).or((Predicate)f.movie.alternativeTitle.isNotNull().and((Predicate)f.movie.alternativeTitle.containsIgnoreCase(tmpTerm)).or((Predicate)f.type.isNotNull().and((Predicate)f.type.in((Collection)movieTypeToConsider))).or((Predicate)f.type2.isNotNull().and((Predicate)f.type2.in((Collection)movieTypeToConsider))).or((Predicate)f.type3.isNotNull().and((Predicate)f.type3.in((Collection)movieTypeToConsider))).or((Predicate)f.type4.isNotNull().and((Predicate)f.type4.in((Collection)movieTypeToConsider))).or((Predicate)f.type5.isNotNull().and((Predicate)f.type5.in((Collection)movieTypeToConsider))).or((Predicate)f.type6.isNotNull().and((Predicate)f.type6.in((Collection)movieTypeToConsider))).or((Predicate)((EnumPath)f.movietypes.any()).in((Collection)movieTypeToConsider))).or((Predicate)((QSceneDetails)((QScene)f.movie.scenes.any()).details.any()).person.name.containsIgnoreCase(tmpTerm)));
            }
        }
        return find;
    }

    public List<Movie> getMovies(int minRuntime, int maxRuntime, boolean showSecret) {
        List<Movie> movies = this.getMovies(OrderBy.RUNTIME, showSecret, Long.MAX_VALUE);
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>(movies);
        for (Movie m : tmpMovies) {
            if (m.getTotalRuntime() < minRuntime) {
                movies.remove(m);
            }
            if (m.getTotalRuntime() <= maxRuntime) continue;
            movies.remove(m);
        }
        return movies;
    }

    public List<Movie> getMoviesLastXDays(LocalDateTime offset, boolean showSecret, long limit) {
        List<Movie> movies = this.getMovies(OrderBy.CREATED, showSecret, Long.MAX_VALUE);
        ArrayList<Movie> tmpMovies = new ArrayList<Movie>(movies);
        for (Movie m : tmpMovies) {
            if (!m.getDateOfCreation().isBefore(offset)) continue;
            movies.remove(m);
        }
        return movies;
    }

    public SortedMap<Integer, Set<Long>> getMoviesBetweenDatesForDuplicateFinder(String path, LocalDateTime startDateTime, LocalDateTime endDateTime, boolean showSecret, int startSecond, int endSecond, int diffSeconds, String screencapDirectory, long limit) {
        List<Movie> tmpMovies = this.getMovies(startSecond, endSecond, showSecret);
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Movie m : tmpMovies) {
            MediumFile mf;
            Medium medium;
            if (m.getStartMedium() == null || !((medium = m.getStartMedium()) instanceof MediumFile) || !(mf = (MediumFile)medium).getFileCompletePath().startsWith(path)) continue;
            movies.add(m);
        }
        return this.getMoviesBetweenDatesForDuplicateFinder(movies, startDateTime, endDateTime, showSecret, startSecond, endSecond, diffSeconds, screencapDirectory, limit);
    }

    public SortedMap<Integer, Set<Long>> getMoviesBetweenDatesForDuplicateFinder(LocalDateTime startDateTime, LocalDateTime endDateTime, boolean showSecret, int startSecond, int endSecond, int diffSeconds, String screencapDirectory, long limit) {
        List<Movie> movies = this.getMovies(startSecond, endSecond, showSecret);
        return this.getMoviesBetweenDatesForDuplicateFinder(movies, startDateTime, endDateTime, showSecret, startSecond, endSecond, diffSeconds, screencapDirectory, limit);
    }

    public SortedMap<Integer, Set<Long>> getMoviesBetweenDatesForDuplicateFinder(List<Movie> movies, LocalDateTime startDateTime, LocalDateTime endDateTime, boolean showSecret, int startSecond, int endSecond, int diffSeconds, String screencapDirectory, long limit) {
        TreeMap map = new TreeMap();
        for (Movie movie : movies) {
            if (movie.getTotalRuntime() < startSecond) {
                this.LOGGER.info("Runtime is too short: " + movie.getTotalRuntime() + ". Skip " + movie.getTitle());
                continue;
            }
            if (!Files.exists(Paths.get(screencapDirectory + movie.getId() + "_1.png", new String[0]), LinkOption.NOFOLLOW_LINKS) && ScenerixxCommonLib.doesFileWithIndexExist(screencapDirectory + movie.getId(), 100) == null) continue;
            if (!map.containsKey(movie.getTotalRuntime())) {
                map.put(movie.getTotalRuntime(), new HashSet());
            }
            if (!map.containsKey(movie.getTotalRuntime())) continue;
            ((Set)map.get(movie.getTotalRuntime())).add(movie.getId());
        }
        this.LOGGER.info("map size " + map.size() + " different runtimes to check");
        TreeMap<Integer, Set<Long>> tmpMap = new TreeMap<Integer, Set<Long>>();
        tmpMap.putAll(map);
        this.LOGGER.info("start-/end-datetime " + String.valueOf(startDateTime) + " - " + String.valueOf(endDateTime));
        LocalDateTime startDate = startDateTime;
        LocalDateTime endDate = endDateTime;
        this.LOGGER.info("start-/end-date " + String.valueOf(startDate) + " - " + String.valueOf(endDate));
        for (Integer runtimeKey : map.keySet()) {
            for (int i = runtimeKey.intValue(); i <= runtimeKey + diffSeconds; ++i) {
                if (map.get(i) == null) continue;
                boolean keep = false;
                for (Long id : (Set)map.get(i)) {
                    Movie tmpMovie = entityService.load(Movie.class, id);
                    if (!tmpMovie.getDateOfCreation().isAfter(startDate) || !tmpMovie.getDateOfCreation().isBefore(endDate)) continue;
                    this.LOGGER.info(tmpMovie.getTitle() + " was created on " + String.valueOf(tmpMovie.getDateOfCreation()));
                    keep = true;
                    break;
                }
                if (keep) continue;
                tmpMap.remove(i);
            }
        }
        return tmpMap;
    }

    public List<Movie> getMovies(OrderBy orderBy, boolean showSecret, long limit) {
        return this.getMovies("", orderBy, showSecret, limit, null, null, null, null);
    }

    public List<Movie> getMovies(Studio studio, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        List<Movie> movies = find.filter(f -> f.studio.eq(studio)).order(m -> m.title.lower().asc()).find();
        return movies;
    }

    public List<Movie> getMovies(Studio studio, Person person, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        List<Movie> movies = find.filter(f -> f.studio.eq(studio).and((Predicate)((QSceneDetails)((QScene)f.scenes.any()).details.any()).person.name.containsIgnoreCase(person.getName()))).order(m -> m.title.lower().asc()).find();
        return movies;
    }

    public List<PlaylistEntry> getPlaylistEntries(Studio studio) {
        EntityService.Finder find = entityService.find(QPlaylistEntry.playlistEntry);
        List<PlaylistEntry> pes = find.filter(f -> f.studio.eq(studio)).find();
        return pes;
    }

    public List<Studio> getStudios(Studio parent) {
        return entityService.find(QStudio.studio).filter(f -> f.parent.eq(parent)).find();
    }

    public Studio getStudio(Long externalId) {
        return (Studio)entityService.find(QStudio.studio).filter(f -> f.externalId.isNotNull().and((Predicate)f.externalId.eq((Object)externalId))).findFirst();
    }

    public Studio getStudio(String name) {
        EntityService.Finder find = entityService.find(QStudio.studio);
        Studio studio = (Studio)find.filter(f -> f.name.eq((Object)name)).findFirst();
        return studio;
    }

    public List<Studio> getStudios(MovieType mt) {
        return entityService.find(QStudio.studio).filter(f -> f.type1.eq((Object)mt).or((Predicate)f.type2.eq((Object)mt)).or((Predicate)f.type3.eq((Object)mt)).or((Predicate)f.type4.eq((Object)mt)).or((Predicate)f.type5.eq((Object)mt)).or((Predicate)f.type6.eq((Object)mt))).find();
    }

    public List<Movie> getMoviesWithoutStudio(boolean showSecret) {
        return this.getMovieFinder(showSecret).filter(f -> f.studio.isNull()).order(m -> m.title.lower().asc()).find();
    }

    public List<Movie> getMovies(MovieType movieType, boolean showSecret) {
        return this.getMovieFinder(showSecret, movieType).order(m -> m.title.lower().asc()).find();
    }

    public long countMediaInfosMissing(boolean showSecret) {
        EntityService.Finder<QMediumFile, MediumFile> find = this.getMediumFileFinder(showSecret);
        find = find.filter(f -> f.width.isNull().or((Predicate)f.height.isNull()).or((Predicate)f.duration.isNull()));
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.count();
    }

    public long countMediaInfosSet(boolean showSecret) {
        EntityService.Finder<QMediumFile, MediumFile> find = this.getMediumFileFinder(showSecret);
        find = find.filter(f -> f.width.isNotNull().and((Predicate)f.height.isNotNull()).and((Predicate)f.duration.isNotNull()));
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.count();
    }

    public long countWizardGeneratedDataNotConfirmed(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMovie.movie);
        find = find.filter(f -> f.wizardGenerated.isNotNull().and((Predicate)f.wizardGenerated.isTrue()));
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.count();
    }

    public long countWizardGeneratedDataConfirmed(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMovie.movie);
        find = find.filter(f -> f.wizardGenerated.isNotNull().and((Predicate)f.wizardGenerated.isFalse()));
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.count();
    }

    public int countScenesLength(boolean showSecret, boolean missing) {
        EntityService.Finder find = entityService.find(QScene.scene);
        if (!showSecret) {
            find = find.filter(f -> f.movie.secret.ne((Object)true));
        }
        find = missing ? find.filter(f -> f.endTime.isNull().or((Predicate)f.endTime.loe((Number)0))) : find.filter(f -> f.endTime.isNotNull().and((Predicate)f.endTime.gt((Number)0)));
        return (int)find.count();
    }

    public int countDateOfShoot(boolean showSecret, boolean missing) {
        EntityService.Finder find = entityService.find(QScene.scene);
        if (!showSecret) {
            find = find.filter(f -> f.movie.secret.ne((Object)true));
        }
        find = missing ? find.filter(f -> f.dateOfShootYear.isNull()) : find.filter(f -> f.dateOfShootYear.isNotNull());
        return (int)find.count();
    }

    public long countPersons(boolean showSecret, boolean missing) {
        EntityService.Finder find = entityService.find(QScene.scene);
        if (!showSecret) {
            find = find.filter(f -> f.movie.secret.ne((Object)true));
        }
        find = missing ? (!showSecret ? find.filter(f -> f.details.isEmpty().or((Predicate)((QSceneDetails)f.details.any()).person.isNull())) : find.filter(f -> f.details.isEmpty().or((Predicate)((QSceneDetails)f.details.any()).person.isNull()))) : (!showSecret ? find.filter(f -> ((QSceneDetails)f.details.any()).person.secret.ne((Object)true)) : find.filter(f -> ((QSceneDetails)f.details.any()).person.isNotNull()));
        return find.count();
    }

    public int countAssociatedStudios(boolean showSecret, boolean missing) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        find = missing ? find.filter(f -> f.studio.isNull()) : find.filter(f -> f.studio.isNotNull());
        return (int)find.count();
    }

    public int countAssociatedScenes(boolean showSecret, boolean missing) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        find = missing ? find.filter(f -> f.scenes.isEmpty()) : find.filter(f -> f.scenes.isNotEmpty());
        return (int)find.count();
    }

    public List<Movie> getAssociatedScenes(boolean showSecret, boolean missing, long limit) {
        EntityService.Finder<QMovie, Movie> finder = this.getMovieFinder(showSecret);
        finder = missing ? finder.filter(f -> f.scenes.isEmpty()) : finder.filter(f -> f.scenes.isNotEmpty());
        this.LOGGER.info("Find : " + finder.count());
        return finder.find(limit);
    }

    public long countMovies(MovieType movieType, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret, movieType);
        return find.count();
    }

    private EntityService.Finder<QMovie, Movie> getMovieFinder(boolean showSecret, MovieType movieType) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        find = movieType.equals(MovieType.UNDEFINED) ? find.filter(f -> f.type.isNull().or((Predicate)f.type.eq((Object)movieType))) : find.filter(f -> f.type.eq((Object)movieType).or((Predicate)f.type2.eq((Object)movieType).or((Predicate)f.type3.eq((Object)movieType)).or((Predicate)f.type4.eq((Object)movieType)).or((Predicate)f.type5.eq((Object)movieType)).or((Predicate)f.type6.eq((Object)movieType)).or((Predicate)((EnumPath)f.movietypes.any()).eq((Object)movieType))));
        return find;
    }

    public List<MediumFile> getMediumFilesWithoutDuration(String searchTerm, boolean showSecret) {
        String[] split;
        EntityService.Finder<QMediumFile, MediumFile> finder = this.getMediumFileFinder(showSecret);
        for (String st : split = searchTerm.split(" ")) {
            finder = finder.filter(f -> f.fileName.containsIgnoreCase(st).or((Predicate)f.fileCompletePath.containsIgnoreCase(st)));
        }
        return finder.filter(f -> f.duration.isNull()).order(p -> p.fileName.lower().asc()).find(this.maxResults);
    }

    public List<Movie> getDvds(boolean showSecret) {
        return this.getDvds(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getDvds(OrderBy orderBy, boolean showSecret) {
        List<Movie> movies = this.getMovies(orderBy, showSecret);
        ArrayList<Movie> returnList = new ArrayList<Movie>();
        for (Movie m : movies) {
            Dvd dvd = this.getDvd(m, showSecret);
            if (dvd == null) continue;
            returnList.add(m);
        }
        return returnList;
    }

    public List<Movie> getSingleScenes(OrderBy orderBy, boolean showSecret) {
        return this.getMovies("", orderBy, showSecret, true, Long.MAX_VALUE, null, null, null, null, null);
    }

    public List<Movie> getCompleteMovies(boolean showSecret) {
        return this.getCompleteMovies(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getCompleteMovies(OrderBy orderBy, boolean showSecret) {
        List<Movie> movies = this.getMovies(orderBy, showSecret);
        ArrayList<Movie> returnList = new ArrayList<Movie>();
        for (Movie m : movies) {
            if (m.getScenes().size() <= 1 || this.getDvd(m, showSecret) != null) continue;
            returnList.add(m);
        }
        return returnList;
    }

    public List<Movie> getSnippets(boolean showSecret) {
        return this.getSnippets(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getSnippets(OrderBy orderBy, boolean showSecret) {
        List<Movie> movies = this.getMovies(orderBy, showSecret);
        ArrayList<Movie> returnList = new ArrayList<Movie>();
        for (Movie m : movies) {
            if (!m.isSnippet()) continue;
            returnList.add(m);
        }
        return returnList;
    }

    public List<Movie> get3D(boolean showSecret) {
        return this.get3D(OrderBy.TITLE, showSecret);
    }

    public List<Movie> get3D(OrderBy orderBy, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = entityService.find(QMovie.movie).filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = this.addMoviesOrderByClause(orderBy, find);
        List<Movie> movies = find.find(Long.MAX_VALUE);
        this.orderByRuntime(orderBy, movies);
        return movies;
    }

    public int get3DCount(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMovie.movie).filter(f -> f.threeD.isNotNull()).filter(f -> f.threeD.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.count();
    }

    public List<Movie> getVR(boolean showSecret) {
        return this.getVR(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getVR(OrderBy orderBy, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = entityService.find(QMovie.movie).filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = this.addMoviesOrderByClause(orderBy, find);
        List<Movie> movies = find.find(Long.MAX_VALUE);
        this.orderByRuntime(orderBy, movies);
        return movies;
    }

    public int getVRCount(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMovie.movie).filter(f -> f.vr.isNotNull()).filter(f -> f.vr.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.count();
    }

    public List<Movie> getInteractive(boolean showSecret) {
        return this.getInteractive(OrderBy.TITLE, showSecret);
    }

    public List<Movie> getInteractive(OrderBy orderBy, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = entityService.find(QMovie.movie).filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        find = this.addMoviesOrderByClause(orderBy, find);
        List<Movie> movies = find.find(Long.MAX_VALUE);
        this.orderByRuntime(orderBy, movies);
        return movies;
    }

    public int getInteractiveCount(boolean showSecret) {
        EntityService.Finder find = entityService.find(QMovie.movie).filter(f -> f.interactive.isNotNull()).filter(f -> f.interactive.isTrue());
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.count();
    }

    public void evictCache() {
        entityService.getEntityManager().clear();
        entityService.getEntityManager().getEntityManagerFactory().getCache().evictAll();
    }

    public void evictCache(Class clazz) {
        entityService.getEntityManager().clear();
        entityService.getEntityManager().getEntityManagerFactory().getCache().evict(clazz.getClass());
    }

    public int getPersonCount(Gender gender, boolean showSecret) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.filter(f -> f.gender.eq((Object)gender)).count();
    }

    public int getPersonCount(boolean showSecret, Gender gender, Nationality nationality) {
        if (nationality == null) {
            return 0;
        }
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return (int)find.filter(f -> f.gender.eq((Object)gender)).filter(f -> f.nationality.isNotNull()).filter(f -> f.nationality.eq((Object)nationality)).count();
    }

    private List<Person> getPersons(Gender gender, boolean showSecret) {
        return this.getPersons(gender, showSecret, Long.MAX_VALUE);
    }

    private List<Person> getPersons(Gender gender, boolean showSecret, long limit) {
        EntityService.Finder find = entityService.find(QPerson.person);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        if (gender != null) {
            find = find.filter(f -> f.gender.eq((Object)gender));
        }
        return find.order(p -> p.name.lower().asc()).find(limit);
    }

    public List<Person> getPersons(Gender gender, boolean withAliases, boolean showSecret) {
        return this.getPersons(gender, withAliases, showSecret, Long.MAX_VALUE);
    }

    public List<Person> getPersons(Gender gender, boolean withAliases, boolean showSecret, long limit) {
        List<Person> result = this.getPersons(gender, showSecret, limit);
        if (withAliases) {
            result = this.mergeAliases(result);
        }
        return result;
    }

    public List<Person> getPersons(Gender gender, boolean withAliases, String searchTerm, boolean showSecret) {
        return this.getPersons(gender, withAliases, searchTerm, showSecret, Long.MAX_VALUE);
    }

    public List<Person> getPersons(Gender gender, boolean withAliases, String searchTerm, boolean showSecret, long limit) {
        List<Person> result = this.getPersons(gender, showSecret, Long.MAX_VALUE);
        if (withAliases) {
            result = this.mergeAliases(result);
        }
        result = this.applySearchTerms(result, searchTerm, limit);
        return result;
    }

    public List<Scene> getScenes(Studio studio, boolean showSecret) {
        List<Movie> movies = this.getMovies(studio, showSecret);
        ArrayList<Scene> result = new ArrayList<Scene>();
        for (Movie m : movies) {
            result.addAll(m.getScenes());
        }
        return result;
    }

    public List<Scene> getScenes(Person p, boolean showSecret) {
        ArrayList<Scene> result = new ArrayList<Scene>();
        EntityService.Finder filter = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.eq(p));
        if (!showSecret) {
            filter = filter.filter(f -> f.scene.movie.secret.ne((Object)true));
        }
        List scenedetails = filter.order(f -> f.scene.movie.title.lower().asc()).find();
        for (SceneDetails sd : scenedetails) {
            if (sd.getScene() == null) continue;
            result.add(sd.getScene());
        }
        return result;
    }

    public List<Scene> getScenesForRemindsMeOf(Person p, boolean showSecrets) {
        ArrayList<Scene> result = new ArrayList<Scene>();
        List scenedetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.remindsMeOf1.eq(p).or((Predicate)f.remindsMeOf2.eq(p).or((Predicate)f.remindsMeOf3.eq(p)))).order(f -> f.scene.movie.title.lower().asc()).find();
        for (SceneDetails sd : scenedetails) {
            if (sd.getScene() == null) continue;
            result.add(sd.getScene());
        }
        List persons = entityService.find(QPerson.person).filter(f -> f.remindsMeOfPerson1.eq(p).or((Predicate)f.remindsMeOfPerson2.eq(p).or((Predicate)f.remindsMeOfPerson3.eq(p)))).find();
        result.addAll(p.getScenes(showSecrets));
        for (Person p1 : persons) {
            result.addAll(p1.getScenes(showSecrets));
        }
        return result;
    }

    public List<String> getKnowAliases(Person p) {
        ArrayList<String> result = new ArrayList<String>();
        List scenedetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.creditedAs.isNotEmpty()).filter(f -> f.person.eq(p)).find();
        for (SceneDetails sd : scenedetails) {
            if (sd.getCreditedAs() == null || sd.getCreditedAs().isEmpty() || result.contains(sd.getCreditedAs())) continue;
            result.add(sd.getCreditedAs());
        }
        return result;
    }

    public List<Person> getRemindsMeOf(boolean showSecret) {
        List<Person> result = showSecret ? entityService.find(QPerson.person).filter(f -> f.remindsMeOfFlag.isTrue()).order(f -> f.name.lower().asc()).find() : entityService.find(QPerson.person).filter(f -> f.remindsMeOfFlag.isTrue()).filter(f -> f.secret.isFalse()).order(f -> f.name.lower().asc()).find();
        List scenedetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.remindsMeOf1.isNotNull().or((Predicate)f.remindsMeOf2.isNotNull()).or((Predicate)f.remindsMeOf3.isNotNull())).find();
        for (SceneDetails sd : scenedetails) {
            if (sd.getRemindsMeOf1() != null && !result.contains(sd.getRemindsMeOf1()) && (sd.getRemindsMeOf1().isSecret() && showSecret || !sd.getRemindsMeOf1().isSecret())) {
                result.add(sd.getRemindsMeOf1());
            }
            if (sd.getRemindsMeOf2() != null && !result.contains(sd.getRemindsMeOf2()) && (sd.getRemindsMeOf2().isSecret() && showSecret || !sd.getRemindsMeOf2().isSecret())) {
                result.add(sd.getRemindsMeOf2());
            }
            if (sd.getRemindsMeOf3() == null || result.contains(sd.getRemindsMeOf3()) || (!sd.getRemindsMeOf3().isSecret() || !showSecret) && sd.getRemindsMeOf3().isSecret()) continue;
            result.add(sd.getRemindsMeOf3());
        }
        result.sort(new PersonComparator());
        return result;
    }

    public List<Scene> getScenes(boolean showSecret) {
        return this.getScenes(showSecret, Long.MAX_VALUE);
    }

    public List<Scene> getScenes(boolean showSecret, long limit) {
        if (showSecret) {
            return entityService.find(QScene.scene).find();
        }
        return entityService.find(QScene.scene).filter(f -> f.movie.secret.isFalse()).find(limit);
    }

    public int getSceneCount(boolean showSecret) {
        if (showSecret) {
            return (int)entityService.find(QScene.scene).count();
        }
        return (int)entityService.find(QScene.scene).filter(f -> f.movie.secret.isFalse()).count();
    }

    public int getBookmarks(boolean showSecret) {
        if (showSecret) {
            return (int)entityService.find(QBookmark.bookmark).count();
        }
        return (int)entityService.find(QBookmark.bookmark).filter(f -> f.secret.isFalse()).count();
    }

    public List<Bookmark> getBookmarks() {
        return entityService.find(QBookmark.bookmark).find();
    }

    public List<Person> getPersons(Scene s, boolean unlocked) {
        ArrayList<Person> result = new ArrayList<Person>();
        if (s.getId() != null) {
            List scenedetails = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.scene.id.isNotNull()).filter(f -> f.scene.id.eq((Object)s.getId())).find();
            for (SceneDetails sd : scenedetails) {
                if (sd.getCreditedAs() != null && !sd.getCreditedAs().isEmpty()) {
                    sd.getPerson().setCreditedAs(sd.getCreditedAs());
                } else {
                    sd.getPerson().setCreditedAs(null);
                }
                if ((!sd.getPerson().isSecret() || !unlocked) && sd.getPerson().isSecret()) continue;
                result.add(sd.getPerson());
            }
        }
        return result;
    }

    public long getNumberOfAppearance(Person p, boolean showSecret) {
        EntityService.Finder filter = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.eq(p));
        if (!showSecret) {
            filter = filter.filter(f -> f.scene.movie.secret.ne((Object)true));
        }
        return filter.count();
    }

    public long getNumberOfNationality(Nationality n, boolean showSecret) {
        EntityService.Finder filter = entityService.find(QPerson.person).filter(f -> f.nationality.eq((Object)n));
        if (!showSecret) {
            filter = filter.filter(f -> f.secret.ne((Object)true));
        }
        return filter.count();
    }

    public void deleteBookmark(Bookmark b) {
        Goldenshower gs;
        Bookmark tmpBookmark = b;
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.bookmark.eq(tmpBookmark)).findFirst();
        if (stat != null) {
            entityService.delete(stat);
        }
        List playlistEntries = entityService.find(QPlaylistEntry.playlistEntry).filter(f -> f.bookmark.eq(tmpBookmark)).find();
        PlaylistService ps = new PlaylistService();
        for (PlaylistEntry pe : playlistEntries) {
            ps.deletePlaylistEntry(pe, false);
        }
        Cumshot cs = (Cumshot)entityService.find(QCumshot.cumshot).filter(f -> f.bookmark.eq(tmpBookmark)).findFirst();
        if (cs != null) {
            entityService.delete(cs);
        }
        if ((gs = (Goldenshower)entityService.find(QGoldenshower.goldenshower).filter(f -> f.bookmark.eq(tmpBookmark)).findFirst()) != null) {
            entityService.delete(gs);
        }
        for (Bookmark subbookmark : b.getChildren(true)) {
            subbookmark.setParent(null);
            subbookmark = entityService.save(subbookmark);
            this.deleteBookmark(subbookmark);
        }
        if (b.getScene() != null) {
            b.getScene().getBookmarks(true).remove(b);
            entityService.save(b.getScene());
        }
        if (b.getMovie() != null) {
            b.getMovie().getBookmarks(true).remove(b);
            entityService.save(b.getMovie());
        }
        if (b.getMedium() != null) {
            b.setMedium(null);
            b = entityService.save(b);
        }
        if (b.getEndMedium() != null) {
            b.setEndMedium(null);
            b = entityService.save(b);
        }
        List<Object> bookmarks = new ArrayList();
        if (b.getScene() != null) {
            bookmarks = b.getScene().getBookmarks(true);
        }
        if (b.getMovie() != null) {
            bookmarks = b.getMovie().getBookmarks(true);
        }
        if (b.getParent() != null) {
            bookmarks = b.getParent().getChildren(true);
        }
        bookmarks.remove(b);
        entityService.delete(b);
        int i = 0;
        for (Bookmark bookmark : bookmarks) {
            bookmark.setPosition(i);
            ++i;
            entityService.save(bookmark);
        }
    }

    public boolean deleteMediumFile(MediumFile mf, boolean resetAssociations) {
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.medium.eq(mf)).findFirst();
        if (stat != null) {
            entityService.delete(stat);
        }
        List playlistEntries = entityService.find(QPlaylistEntry.playlistEntry).filter(f -> f.mediumFile.eq(mf)).find();
        PlaylistService ps = new PlaylistService();
        for (Object pe : playlistEntries) {
            ps.deletePlaylistEntry((PlaylistEntry)pe, false);
        }
        if (resetAssociations) {
            mf.setMovie(null);
            List endMediumSet = entityService.find(QScene.scene).filter(f -> f.endMedium.eq(mf)).find();
            for (Object s : endMediumSet) {
                ((Scene)s).setEndMedium(null);
                s = entityService.save(s);
            }
            List startMediumSet = entityService.find(QScene.scene).filter(f -> f.startMedium.eq(mf)).find();
            for (Object s : startMediumSet) {
                ((Scene)s).setStartMedium(null);
                s = entityService.save(s);
            }
            List bookmarkStartMediumSet = entityService.find(QBookmark.bookmark).filter(f -> f.medium.eq(mf)).find();
            for (Bookmark b : bookmarkStartMediumSet) {
                b.setMedium(null);
                b = entityService.save(b);
            }
            List bookmarkEndMediumSet = entityService.find(QBookmark.bookmark).filter(f -> f.endMedium.eq(mf)).find();
            for (Bookmark b : bookmarkEndMediumSet) {
                b.setEndMedium(null);
                b = entityService.save(b);
            }
        }
        return entityService.delete(mf);
    }

    public boolean deleteMediumFileCascaded(MediumFile mf) {
        List endMediumSet = entityService.find(QScene.scene).filter(f -> f.endMedium.eq(mf)).find();
        for (Scene s : endMediumSet) {
            s.setEndMedium(null);
            s = entityService.save(s);
        }
        List startMediumSet = entityService.find(QScene.scene).filter(f -> f.startMedium.eq(mf)).find();
        for (Scene s : startMediumSet) {
            s.setStartMedium(null);
            s = entityService.save(s);
        }
        if (mf.getMovie() != null) {
            this.deleteMovie(mf.getMovie());
        }
        return this.deleteMediumFile(mf, true);
    }

    public void deleteScene(Scene s) {
        List<Bookmark> bookmarks = s.getBookmarks(true);
        ArrayList<Bookmark> tmpbookmarks = new ArrayList<Bookmark>(bookmarks);
        for (Bookmark b : tmpbookmarks) {
            for (Bookmark bookmark : b.getChildren(true)) {
                this.deleteBookmark(bookmark);
            }
            this.deleteBookmark(b);
        }
        Statistic stat = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.scene.eq(s)).findFirst();
        if (stat != null) {
            entityService.delete(stat);
        }
        PlaylistService ps = new PlaylistService();
        List playlistEntries = entityService.find(QPlaylistEntry.playlistEntry).filter(f -> f.scene.eq(s)).find();
        for (PlaylistEntry pe : playlistEntries) {
            ps.deletePlaylistEntry(pe, false);
        }
        EntityManager entityManager = entityService.getEntityManager();
        EntityTransaction tx = entityManager.getTransaction();
        try {
            tx.begin();
            ArrayList<SceneDetails> detailsToRemove = new ArrayList<SceneDetails>(s.getDetails());
            for (SceneDetails sd : detailsToRemove) {
                SceneDetails managed = entityManager.contains((Object)sd) ? sd : (SceneDetails)entityManager.find(SceneDetails.class, (Object)sd.getId());
                if (managed == null) continue;
                entityManager.remove((Object)managed);
            }
            s.getDetails().clear();
            entityManager.flush();
            s.getMovie().getScenes().remove(s);
            entityManager.merge((Object)s.getMovie());
            entityManager.remove(entityManager.contains((Object)s) ? s : entityManager.merge((Object)s));
            tx.commit();
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
        this.LOGGER.debug("Delete scene with ID " + s.getId());
        entityService.delete(s);
        int i = 1;
        for (Scene scene : s.getMovie().getScenes()) {
            scene.setPos(i);
            ++i;
            scene = entityService.save(scene);
        }
    }

    public void deleteMovie(Movie m) {
        this.LOGGER.info("Deleting bookmarks of movie " + m.getTitle());
        ArrayList<Bookmark> tmpBookmarks = new ArrayList<Bookmark>(m.getBookmarks(true));
        for (Bookmark bookmark : tmpBookmarks) {
            this.deleteBookmark(bookmark);
        }
        this.LOGGER.info("Deleting scenes of movie " + m.getTitle());
        ArrayList<Scene> tmpList = new ArrayList<Scene>(m.getScenes());
        for (Scene s : tmpList) {
            this.deleteScene(s);
        }
        Statistic statistic = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.movie.eq(m)).findFirst();
        if (statistic != null) {
            this.LOGGER.info("Deleting statistic of movie " + m.getTitle());
            entityService.delete(statistic);
        }
        PlaylistService ps = new PlaylistService();
        List playlistEntries = entityService.find(QPlaylistEntry.playlistEntry).filter(f -> f.movie.eq(m)).find();
        this.LOGGER.info("Deleting playlistentries of movie " + m.getTitle() + ": " + playlistEntries.size());
        for (Object pe : playlistEntries) {
            ps.deletePlaylistEntry((PlaylistEntry)pe, true);
        }
        List dvdMediumfiles = entityService.find(QDvd.dvd).filter(f -> f.movie.eq(m)).find();
        this.LOGGER.info("Deleting DVD mediumfiles of movie " + m.getTitle());
        for (Object dvd : dvdMediumfiles) {
            entityService.delete(dvd);
        }
        List mediumfiles = entityService.find(QMediumFile.mediumFile).filter(f -> f.movie.eq(m)).find();
        this.LOGGER.info("Deleting mediumfile associations of movie " + m.getTitle());
        for (MediumFile mf : mediumfiles) {
            mf.setMovie(null);
            entityService.save(mf);
        }
        this.LOGGER.info("Deleting movie itself");
        Movie movToDelete = entityService.load(Movie.class, m.getId());
        if (movToDelete != null) {
            entityService.delete(movToDelete);
        } else {
            this.LOGGER.warn("Could not delete movie. The reload failed.");
        }
    }

    public void updateStatistic(MediumFile mf) {
        Statistic statistic = (Statistic)entityService.find(QStatistic.statistic).filter(f -> f.medium.eq(mf)).findFirst();
        if (statistic == null) {
            statistic = new Statistic();
            statistic = entityService.save(statistic);
        }
        statistic.setMedium(mf);
        statistic.getStarted().add(LocalDateTime.now());
        entityService.save(statistic);
    }

    public long countMovies(Studio studio, boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        return find.filter(f -> f.studio.eq(studio)).count();
    }

    public long countMoviesWithoutStudios(boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = this.getMovieFinder(showSecret);
        return find.filter(f -> f.studio.isNull()).count();
    }

    private EntityService.Finder<QMovie, Movie> getMovieFinder(boolean showSecret) {
        EntityService.Finder<QMovie, Movie> find = entityService.find(QMovie.movie);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find;
    }

    public List<Bookmark> getChildrenBookmarks(Bookmark bookmark, boolean showSecret) {
        EntityService.Finder find = entityService.find(QBookmark.bookmark);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        return find.filter(f -> f.parent.eq(bookmark)).find();
    }

    public ScenerixxSettings getScenerixxSettings() {
        if (scenerixxSettings == null && (scenerixxSettings = (ScenerixxSettings)entityService.find(QScenerixxSettings.scenerixxSettings).findFirst()) == null) {
            scenerixxSettings = new ScenerixxSettings();
        }
        return scenerixxSettings;
    }

    public void setScenerixxSettings(ScenerixxSettings settings) {
        scenerixxSettings = settings;
    }

    public List<Long> getPlaylistBookmarkIds(boolean defaultPlaylist) {
        return this.getPlaylistBookmarkIds("BOOKMARK_ID", defaultPlaylist);
    }

    public List<Long> getPlaylistSceneIds(boolean defaultPlaylist) {
        return this.getPlaylistBookmarkIds("SCENE_ID", defaultPlaylist);
    }

    public List<Long> getPlaylistMovieIds(boolean defaultPlaylist) {
        return this.getPlaylistBookmarkIds("MOVIE_ID", defaultPlaylist);
    }

    private List<Long> getPlaylistBookmarkIds(String field, boolean defaultPlaylist) {
        PlaylistService ps = new PlaylistService();
        Playlist defaultPlaylist1 = ps.getDefaultPlaylist(false);
        String sql = "SELECT " + field + " FROM PLAYLISTENTRY ";
        sql = defaultPlaylist ? sql + "WHERE PLAYLIST_ID=" + defaultPlaylist1.getId() + " AND " : sql + "WHERE ";
        sql = sql + field + " IS NOT NULL";
        this.LOGGER.info("sql: " + sql);
        List resultList = entityService.getEntityManager().createNativeQuery(sql).getResultList();
        ArrayList<Long> playlist = new ArrayList<Long>();
        int i = 0;
        for (Object o : resultList) {
            if (o == null) continue;
            this.LOGGER.debug(++i + " " + (Long)o);
            Long id = (Long)o;
            playlist.add(id);
        }
        return playlist;
    }

    public List<Resolution> getResolutions() {
        List resultList = entityService.getEntityManager().createNativeQuery("SELECT DISTINCT * FROM (SELECT WIDTH, HEIGHT FROM MEDIUM) AS X WHERE WIDTH IS NOT NULL AND HEIGHT IS NOT NULL ORDER BY WIDTH DESC").getResultList();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        for (Object o : resultList) {
            if (o == null) continue;
            this.LOGGER.debug(String.valueOf(((Object[])o)[0]) + " x " + String.valueOf(((Object[])o)[1]));
            Integer width = (Integer)((Object[])o)[0];
            Integer height = (Integer)((Object[])o)[1];
            resolutions.add(new Resolution(width, height));
        }
        return resolutions;
    }

    public Map<Resolution, List<Movie>> getMoviesByResolution(String searchTerm) {
        HashMap<Resolution, List<Movie>> x = new HashMap<Resolution, List<Movie>>();
        List<Resolution> resolutions = this.getResolutions();
        this.LOGGER.info("got " + resolutions.size() + " resolutions - start iterating");
        for (Resolution res : resolutions) {
            this.LOGGER.info("res");
            List mediums = entityService.find(QMedium.medium).filter(f -> f.width.isNotNull()).filter(f -> f.height.isNotNull()).filter(f -> f.width.eq((Object)res.getWidth())).filter(f -> f.height.eq((Object)res.getHeight())).find();
            Stream<Movie> filter = mediums.stream().map(f -> f.getMovie()).filter(Objects::nonNull);
            if (searchTerm != null && !searchTerm.isBlank()) {
                filter = filter.filter(f -> f.getTitle().toLowerCase().contains(searchTerm.toLowerCase()));
            }
            this.LOGGER.debug("get movies");
            List movies = filter.sorted(new MovieComparator()).collect(Collectors.toList());
            this.LOGGER.debug("get movies finished");
            Resolution resolution = new Resolution(res.getWidth(), res.getHeight());
            if (!movies.isEmpty()) {
                x.put(resolution, movies);
            }
            this.LOGGER.info("Added " + movies.size() + " movies for resolution " + String.valueOf(resolution));
        }
        return x;
    }

    public TreeMap<Integer, List<Movie>> getMoviesByResolutionReducedWidth(String searchTerm) {
        Map<Resolution, List<Movie>> moviesByResolution = this.getMoviesByResolution(searchTerm);
        TreeMap<Integer, List<Movie>> t = new TreeMap<Integer, List<Movie>>();
        int i = 0;
        for (Resolution r : moviesByResolution.keySet()) {
            if (!t.containsKey(r.getWidth())) {
                this.LOGGER.info(++i + ". Add width " + r.getWidth());
                System.out.println(++i + ". Add width " + r.getWidth());
                t.put(r.getWidth(), new ArrayList());
            }
            t.get(r.getWidth()).addAll((Collection<Movie>)moviesByResolution.get(r));
        }
        for (Integer key : t.keySet()) {
            Collections.sort(t.get(key), new MovieComparator());
        }
        return t;
    }

    public TreeMap<Integer, List<Movie>> getMoviesByResolutionReducedHeight(String searchTerm) {
        Map<Resolution, List<Movie>> moviesByResolution = this.getMoviesByResolution(searchTerm);
        TreeMap<Integer, List<Movie>> t = new TreeMap<Integer, List<Movie>>();
        int i = 0;
        for (Resolution r : moviesByResolution.keySet()) {
            if (!t.containsKey(r.getHeight())) {
                this.LOGGER.info(++i + ". Add Height " + r.getHeight());
                t.put(r.getHeight(), new ArrayList());
            }
            t.get(r.getHeight()).addAll((Collection<Movie>)moviesByResolution.get(r));
        }
        for (Integer key : t.keySet()) {
            Collections.sort(t.get(key), new MovieComparator());
        }
        return t;
    }

    public int getChartPositionHighest(Person p, ChartPositionType type) {
        ChartPosition find = (ChartPosition)entityService.find(QChartPosition.chartPosition).filter(f -> f.person.eq(p)).filter(f -> f.type.eq((Object)type)).order(f -> f.position.asc()).findFirst();
        if (find != null) {
            return find.getPosition();
        }
        return -1;
    }

    public int getChartPositionLowest(Person p, ChartPositionType type) {
        ChartPosition find = (ChartPosition)entityService.find(QChartPosition.chartPosition).filter(f -> f.person.eq(p)).filter(f -> f.type.eq((Object)type)).order(f -> f.position.desc()).findFirst();
        if (find != null) {
            return find.getPosition();
        }
        return -1;
    }

    public int getChartPositionDiff(Person p, ChartPositionType type) {
        List find = entityService.find(QChartPosition.chartPosition).filter(f -> f.person.eq(p)).filter(f -> f.type.eq((Object)type)).order(f -> f.dateOfCreation.desc()).find();
        if (find != null) {
            if (find.size() == 1) {
                return ((ChartPosition)find.get(0)).getPosition();
            }
            if (find.size() > 1) {
                return ((ChartPosition)find.get(0)).getPosition() - ((ChartPosition)find.get(1)).getPosition();
            }
            return 0;
        }
        return -1;
    }

    public int getChartPositionCurrent(Person p, ChartPositionType type) {
        List find = entityService.find(QChartPosition.chartPosition).filter(f -> f.person.eq(p)).filter(f -> f.type.eq((Object)type)).order(f -> f.dateOfCreation.desc()).find();
        if (find != null && find.size() > 0) {
            return ((ChartPosition)find.get(0)).getPosition();
        }
        return 0;
    }

    public EntityService getEntityService() {
        return entityService;
    }

    public static enum OrderBy {
        TITLE,
        RUNTIME,
        DATEOFSHOOT,
        CREATED,
        LASTMODIFICATION,
        RESOLUTION,
        RATING,
        HOWOFTENSTARTED,
        FILESIZE,
        FILEEXTENSION;

    }
}

