/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.statistic;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.statistic.QScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.ScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;

public class StatisticService {
    private static final Logger LOG = Logger.getLogger(StatisticService.class.getName());
    private final DB db = DB.getInstance();
    private DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final String neutralColor = "#B2BEB5";

    public String loadStatistics(boolean slowStatistic) {
        LOG.info("1");
        DecimalFormat df = new DecimalFormat("0.00");
        ScenerixxStatistic scenerixxStat = (ScenerixxStatistic)this.db.getEntityService().find((EntityPathBase)QScenerixxStatistic.scenerixxStatistic).findFirst();
        LOG.info("2");
        StatisticInternal lastStat = null;
        StatisticInternal reallyLastStat = null;
        List stats = this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{f -> f.dateOfCreation.desc()}).find(2L);
        if (stats.size() == 2) {
            lastStat = (StatisticInternal)stats.get(1);
            reallyLastStat = (StatisticInternal)stats.get(0);
        }
        LOG.info("3");
        String lastDate = "???";
        Object daysAgo = "";
        if (lastStat == null) {
            LOG.info("Did not find any previous statistic data. Cancel loading.");
            return "Did not find any previous statistic data. Cancel loading. Make sure you have at least one file imported and click 'Generate first statistic first.'";
        }
        lastDate = this.sdf.format(reallyLastStat.getDateOfCreation());
        long between = ChronoUnit.DAYS.between(reallyLastStat.getDateOfCreation(), LocalDateTime.now());
        daysAgo = " -> " + ScenerixxCommon.singularPlural(between, "day", "days", true) + " ago";
        LOG.info("4");
        Object s = "<html><b>Statistic</b> (from " + lastDate + (String)daysAgo + ")<br><br>";
        s = (String)s + "You started Scenerixx already " + scenerixxStat.getStarted().size() + " times.<br><br>";
        s = this.statisticFast((String)s, lastStat, slowStatistic);
        LOG.info("5");
        if (slowStatistic) {
            LOG.info("show slow statistic");
            s = this.statisticSlow((String)s, lastStat, df);
        }
        s = (String)s + "</html>";
        LOG.info("6");
        LOG.info((String)s);
        return s;
    }

    private String statisticFast(String s, StatisticInternal lastStat, boolean slowStat) {
        s = (String)s + "<table>";
        int mediumFilesWithoutSecret = 0;
        BigDecimal fileSizeWithoutSecrets = BigDecimal.ZERO;
        if (slowStat) {
            LOG.info("start medium");
            Query createNativeQuery = this.db.getEntityService().getEntityManager().createNativeQuery("SELECT SUM(FILESIZE) FROM MEDIUM");
            List resultList = createNativeQuery.getResultList();
            if (resultList.size() == 1) {
                BigDecimal fileSizeWithoutSecretsbig = (BigDecimal)resultList.getFirst();
                LOG.info("fileSizeWithoutSecrets BIG " + String.valueOf(fileSizeWithoutSecretsbig));
            }
            LOG.info("fileSizeWithoutSecrets " + String.valueOf(fileSizeWithoutSecrets));
            Query createNativeQueryWithoutSecrets = this.db.getEntityService().getEntityManager().createNativeQuery("SELECT SUM(FILESIZE) FROM MEDIUM WHERE SECRET=FALSE");
            List resultListWithoutSecrets = createNativeQueryWithoutSecrets.getResultList();
            if (resultListWithoutSecrets.size() == 1) {
                fileSizeWithoutSecrets = (BigDecimal)resultListWithoutSecrets.getFirst();
                LOG.info("fileSizeWithoutSecrets BIG" + String.valueOf(fileSizeWithoutSecrets));
            }
            LOG.info("fileSizeWithoutSecrets " + String.valueOf(fileSizeWithoutSecrets));
            mediumFilesWithoutSecret = Scenerixx.statisticInternal.getMediumfilesWithoutSecrets();
            String mediumFilesWithoutSecretDiff = this.getDiffString(Scenerixx.statisticInternal.getMediumfilesWithoutSecrets() - lastStat.getMediumfilesWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Database.png")) + "'></td><td>Medium Files</td><td>" + String.format("%,d", mediumFilesWithoutSecret) + mediumFilesWithoutSecretDiff + " (" + ScenerixxCommon.readableFileSize(fileSizeWithoutSecrets) + ")</td></tr>";
        }
        if (Scenerixx.unlocked) {
            if (slowStat) {
                int mediumFilesWithSecret = Scenerixx.statisticInternal.getMediumfilesWithSecrets();
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Database.png")) + "'></td><td>Secret Medium Files</td><td>" + String.format("%,d", mediumFilesWithSecret - mediumFilesWithoutSecret) + " (" + ScenerixxCommon.readableFileSize(fileSizeWithoutSecrets) + ")</td></tr>";
                String sRuntime = ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithSecrets());
                String sRuntimeDiff = "";
                if (Scenerixx.statisticInternal.getTotalRuntimeWithSecrets() - lastStat.getTotalRuntimeWithSecrets() > 0L) {
                    sRuntimeDiff = this.coloredString(ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithSecrets() - lastStat.getTotalRuntimeWithSecrets()), true);
                } else if (Scenerixx.statisticInternal.getTotalRuntimeWithSecrets() - lastStat.getTotalRuntimeWithSecrets() < 0L) {
                    sRuntimeDiff = this.coloredString(ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithSecrets() - lastStat.getTotalRuntimeWithSecrets()), false);
                }
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Stopwatch.png")) + "'></td><td>Total runtime</td><td>" + sRuntime + sRuntimeDiff + "</td></tr>";
            }
            int persons = Scenerixx.statisticInternal.getPersonsWithSecrets();
            String personsDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsWithSecrets() - lastStat.getPersonsWithSecrets(), true);
            int secretPersonsCount = lastStat.getPersonsWithSecrets() - lastStat.getPersonsWithoutSecrets();
            Object secretPersons = " (" + secretPersonsCount + " secrets) ";
            if (secretPersonsCount == 0) {
                secretPersons = "";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/persons.png")) + "'></td><td> Persons</td><td>" + String.format("%,d", persons) + (String)secretPersons + personsDiff + "</td><td></tr>";
            int female = Scenerixx.statisticInternal.getFemalesWithSecrets();
            String femalesDiff = this.getDiffString(Scenerixx.statisticInternal.getFemalesWithSecrets() - lastStat.getFemalesWithSecrets(), true);
            int secretFemalesCount = lastStat.getFemalesWithSecrets() - lastStat.getFemalesWithoutSecrets();
            Object secretFemales = " (" + secretFemalesCount + " secrets) ";
            if (secretFemalesCount == 0) {
                secretFemales = "";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/female.png")) + "'></td><td> Female Persons</td><td>" + String.format("%,d", female) + (String)secretFemales + femalesDiff + "</td><td></tr>";
            int male = Scenerixx.statisticInternal.getMalesWithSecrets();
            String malesDiff = this.getDiffString(Scenerixx.statisticInternal.getMalesWithSecrets() - lastStat.getMalesWithSecrets(), true);
            int secretMaleCount = lastStat.getMalesWithSecrets() - lastStat.getMalesWithoutSecrets();
            Object secretMales = " (" + secretMaleCount + " secrets) ";
            if (secretMaleCount == 0) {
                secretMales = "";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/male.png")) + "'></td><td> Male Persons</td><td>" + String.format("%,d", male) + (String)secretMales + malesDiff + "</td><td></tr>";
            int ts = Scenerixx.statisticInternal.getTsWithSecrets();
            String tsDiff = this.getDiffString(Scenerixx.statisticInternal.getTsWithSecrets() - lastStat.getTsWithSecrets(), true);
            int secretTSCount = lastStat.getTsWithSecrets() - lastStat.getTsWithoutSecrets();
            Object secretTS = " (" + secretTSCount + " secrets) ";
            if (secretTSCount == 0) {
                secretTS = "";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons2/transgender.png")) + "'></td><td> TS Persons</td><td>" + String.format("%,d", ts) + (String)secretTS + tsDiff + "</td><td></tr>";
            int movies = Scenerixx.statisticInternal.getMoviesWithSecrets();
            String moviesDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithSecrets() - lastStat.getMoviesWithSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/film.png")) + "'></td><td>Movies</td><td>" + String.format("%,d", movies) + moviesDiff + "</td><td></tr>";
            if (this.db.getScenerixxSettings().isShowRare()) {
                int threeDmovies = Scenerixx.statisticInternal.getThreeDmoviesWithSecrets();
                String threeDDiff = this.getDiffString(Scenerixx.statisticInternal.getThreeDmoviesWithSecrets() - lastStat.getThreeDmoviesWithSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/male.png")) + "'></td><td>3D Movies</td><td>" + String.format("%,d", threeDmovies) + threeDDiff + "</td><td></tr>";
                int interactiveMovies = Scenerixx.statisticInternal.getInteractiveMoviesWithSecrets();
                String interactiveDiff = this.getDiffString(Scenerixx.statisticInternal.getInteractiveMoviesWithSecrets() - lastStat.getInteractiveMoviesWithSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/game-controller.png")) + "'></td><td>Interactive Movies</td><td>" + String.format("%,d", interactiveMovies) + interactiveDiff + "</td><td></tr>";
                int vrMovies = Scenerixx.statisticInternal.getVrMoviesWithSecrets();
                String vrDiff = this.getDiffString(Scenerixx.statisticInternal.getVrMoviesWithSecrets() - lastStat.getVrMoviesWithSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/microsoft-hololens.png")) + "'></td><td>VR Movies</td><td>" + String.format("%,d", vrMovies) + vrDiff + "</td><td></tr>";
            }
            int scenes = Scenerixx.statisticInternal.getScenesWithSecrets();
            String scenesDiff = this.getDiffString(Scenerixx.statisticInternal.getScenesWithSecrets() - lastStat.getScenesWithSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/bluebookmark.png")) + "'></td><td> Scenes</td><td>" + String.format("%,d", scenes) + scenesDiff + "</td><td></tr>";
            int bookmarks = Scenerixx.statisticInternal.getBookmarksWithSecrets();
            String bookmarksDiff = this.getDiffString(Scenerixx.statisticInternal.getBookmarksWithSecrets() - lastStat.getBookmarksWithSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/greenbookmark.png")) + "'></td><td> Bookmarks</td><td>" + String.format("%,d", bookmarks) + bookmarksDiff + "</td></tr>";
            int studios = Scenerixx.statisticInternal.getStudios();
            String studiosDiff = this.getDiffString(Scenerixx.statisticInternal.getStudios() - lastStat.getStudios(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/home.png")) + "'></td><td> Studios</td><td>" + String.format("%,d", studios) + studiosDiff + "</td></tr>";
            String savedBytes = ScenerixxCommon.readableFileSize(Scenerixx.statisticInternal.getSavedBytes());
            Object savedBytesDiff = "";
            if (Scenerixx.statisticInternal.getSavedBytes() - lastStat.getSavedBytes() != 0L) {
                savedBytesDiff = " (<font color=\"#B2BEB5\">+" + ScenerixxCommon.readableFileSize(Scenerixx.statisticInternal.getSavedBytes() - lastStat.getSavedBytes()) + "</font>)";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Delete.png")) + "'></td><td>Deleted bytes</td><td>" + savedBytes + (String)savedBytesDiff + "</td></tr>";
        } else if (lastStat != null) {
            String sRuntime = ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithoutSecrets());
            String sRuntimeDiff = "";
            if (Scenerixx.statisticInternal.getTotalRuntimeWithoutSecrets() - lastStat.getTotalRuntimeWithoutSecrets() > 0L) {
                sRuntimeDiff = this.coloredString(ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithoutSecrets() - lastStat.getTotalRuntimeWithoutSecrets()), true);
            } else if (Scenerixx.statisticInternal.getTotalRuntimeWithoutSecrets() - lastStat.getTotalRuntimeWithoutSecrets() < 0L) {
                sRuntimeDiff = this.coloredString(ScenerixxCommon.readableRuntime(Scenerixx.statisticInternal.getTotalRuntimeWithoutSecrets() - lastStat.getTotalRuntimeWithoutSecrets()), false);
            }
            LOG.info("medium2");
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Stopwatch.png")) + "'></td><td>Total runtime</td><td>" + sRuntime + sRuntimeDiff + "</td></tr>";
            int persons = Scenerixx.statisticInternal.getPersonsWithoutSecrets();
            String personsDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsWithoutSecrets() - lastStat.getPersonsWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/persons.png")) + "'></td><td> Persons</td><td>" + String.format("%,d", persons) + personsDiff + "</td><td></tr>";
            LOG.info("medium2");
            int female = Scenerixx.statisticInternal.getFemalesWithoutSecrets();
            String femalesDiff = this.getDiffString(Scenerixx.statisticInternal.getFemalesWithoutSecrets() - lastStat.getFemalesWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/female.png")) + "'></td><td> Female Persons</td><td>" + String.format("%,d", female) + femalesDiff + "</td><td></tr>";
            LOG.info("medium2111111111111");
            int male = Scenerixx.statisticInternal.getMalesWithoutSecrets();
            String malesDiff = this.getDiffString(Scenerixx.statisticInternal.getMalesWithoutSecrets() - lastStat.getMalesWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/male.png")) + "'></td><td> Male Persons</td><td>" + String.format("%,d", male) + malesDiff + "</td><td></tr>";
            LOG.info("medium2");
            int ts = Scenerixx.statisticInternal.getTsWithoutSecrets();
            String tsDiff = this.getDiffString(Scenerixx.statisticInternal.getTsWithoutSecrets() - lastStat.getTsWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons2/transgender.png")) + "'></td><td> TS Persons</td><td>" + String.format("%,d", ts) + tsDiff + "</td><td></tr>";
            LOG.info("medium22");
            int movies = Scenerixx.statisticInternal.getMoviesWithoutSecrets();
            String moviesDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithoutSecrets() - lastStat.getMoviesWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/film.png")) + "'></td><td>Movies</td><td>" + String.format("%,d", movies) + moviesDiff + "</td><td></tr>";
            LOG.info("medium23333");
            if (this.db.getScenerixxSettings().isShowRare()) {
                int threeDmovies = Scenerixx.statisticInternal.getThreeDmoviesWithoutSecrets();
                String threeDDiff = this.getDiffString(Scenerixx.statisticInternal.getThreeDmoviesWithoutSecrets() - lastStat.getThreeDmoviesWithoutSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/3d-glasses.png")) + "'></td><td>3D Movies</td><td>" + String.format("%,d", threeDmovies) + threeDDiff + "</td><td></tr>";
                int interactiveMovies = Scenerixx.statisticInternal.getInteractiveMoviesWithoutSecrets();
                String interactiveDiff = this.getDiffString(Scenerixx.statisticInternal.getInteractiveMoviesWithoutSecrets() - lastStat.getInteractiveMoviesWithoutSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/game-controller.png")) + "'></td><td>Interactive Movies</td><td>" + String.format("%,d", interactiveMovies) + interactiveDiff + "</td><td></tr>";
                int vrMovies = Scenerixx.statisticInternal.getVrMoviesWithoutSecrets();
                String vrDiff = this.getDiffString(Scenerixx.statisticInternal.getVrMoviesWithoutSecrets() - lastStat.getVrMoviesWithoutSecrets(), true);
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/microsoft-hololens.png")) + "'></td><td>VR Movies</td><td>" + String.format("%,d", vrMovies) + vrDiff + "</td><td></tr>";
            }
            int scenes = Scenerixx.statisticInternal.getScenesWithoutSecrets();
            String scenesDiff = this.getDiffString(Scenerixx.statisticInternal.getScenesWithoutSecrets() - lastStat.getScenesWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/bluebookmark.png")) + "'></td><td> Scenes</td><td>" + String.format("%,d", scenes) + scenesDiff + "</td><td></tr>";
            LOG.info("medium233");
            int bookmarks = Scenerixx.statisticInternal.getBookmarksWithoutSecrets();
            String bookmarksDiff = this.getDiffString(Scenerixx.statisticInternal.getBookmarksWithoutSecrets() - lastStat.getBookmarksWithoutSecrets(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/greenbookmark.png")) + "'></td><td> Bookmarks</td><td>" + String.format("%,d", bookmarks) + bookmarksDiff + "</td></tr>";
            int studios = Scenerixx.statisticInternal.getStudios();
            String studiosDiff = this.getDiffString(Scenerixx.statisticInternal.getStudios() - lastStat.getStudios(), true);
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/home.png")) + "'></td><td> Studios</td><td>" + String.format("%,d", studios) + studiosDiff + "</td></tr>";
            LOG.info("medium24434");
            String savedBytes = ScenerixxCommon.readableFileSize(Scenerixx.statisticInternal.getSavedBytes());
            Object savedBytesDiff = "";
            if (Scenerixx.statisticInternal.getSavedBytes() - lastStat.getSavedBytes() != 0L) {
                savedBytesDiff = " (<font color=\"#B2BEB5\">+" + ScenerixxCommon.readableFileSize(Scenerixx.statisticInternal.getSavedBytes() - lastStat.getSavedBytes()) + "</font>)";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Delete.png")) + "'></td><td>Deleted bytes</td><td>" + savedBytes + (String)savedBytesDiff + "</td></tr>";
        } else {
            LOG.info("it's the very first time, no previous statistic we can diff to");
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/persons.png")) + "'></td><td> Persons</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getPersonsWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/female.png")) + "'></td><td> Female Persons</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getFemalesWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/male.png")) + "'></td><td> Male Persons</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getMalesWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons2/transgender.png")) + "'></td><td> TS Persons</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getTsWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/film.png")) + "'></td><td>Movies</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getMoviesWithoutSecrets()) + "</td></tr>";
            if (this.db.getScenerixxSettings().isShowRare()) {
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/3d-glasses.png")) + "'></td><td>3D Movies</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getThreeDmoviesWithoutSecrets()) + "</td></tr>";
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/game-controller.png")) + "'></td><td>Interactive Movies</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getInteractiveMoviesWithoutSecrets()) + "</td></tr>";
                s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons8/microsoft-hololens.png")) + "'></td><td>VR Movies</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getVrMoviesWithoutSecrets()) + "</td></tr>";
            }
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/bluebookmark.png")) + "'></td><td> Scenes</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getScenesWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/greenbookmark.png")) + "'></td><td> Bookmarks</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getBookmarksWithoutSecrets()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/home.png")) + "'></td><td> Studios</td><td>" + String.format("%,d", Scenerixx.statisticInternal.getStudios()) + "</td></tr>";
            s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource("/icons/Delete.png")) + "'>Deleted bytes</td><td>" + ScenerixxCommon.readableFileSize(Scenerixx.statisticInternal.getSavedBytes()) + "</td></tr>";
        }
        s = (String)s + "</table>";
        return s;
    }

    private String statisticSlow(String s, StatisticInternal lastStat, DecimalFormat df1) {
        s = (String)s + "<table>";
        s = (String)s + "<th></th>";
        s = (String)s + "<th></th>";
        s = (String)s + "<th>Completed</th>";
        s = (String)s + "<th>Missing</th>";
        s = (String)s + "<th colspan='2'>%</th>";
        s = (String)s + "<th>1%</th>";
        int hashed = 0;
        int hashedMissing = 0;
        String hashedDiff = "";
        String hashedMissingDiff = "";
        if (Scenerixx.unlocked) {
            hashed = Scenerixx.statisticInternal.getHashedFileCompletedWithSecrets();
            hashedMissing = Scenerixx.statisticInternal.getHashedFileMissingWithSecrets();
            hashedDiff = this.getDiffString(Scenerixx.statisticInternal.getHashedFileCompletedWithSecrets() - lastStat.getHashedFileCompletedWithSecrets(), true);
            hashedMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getHashedFileMissingWithSecrets() - lastStat.getHashedFileMissingWithSecrets(), false);
        } else {
            hashed = Scenerixx.statisticInternal.getHashedFileCompletedWithoutSecrets();
            hashedMissing = Scenerixx.statisticInternal.getHashedFileMissingWithoutSecrets();
            hashedDiff = this.getDiffString(Scenerixx.statisticInternal.getHashedFileCompletedWithoutSecrets() - lastStat.getHashedFileCompletedWithoutSecrets(), true);
            hashedMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getHashedFileMissingWithoutSecrets() - lastStat.getHashedFileMissingWithoutSecrets(), false);
        }
        s = this.getConfirmedRatioString("Hashed files", "/icons.fatcow/script_binary.png", hashedMissing, hashed, (String)s, hashedDiff, hashedMissingDiff, df1);
        int associated = 0;
        int associatedMissing = 0;
        String associatedDiff = "";
        String associatedMissingDiff = "";
        if (Scenerixx.unlocked) {
            associated = Scenerixx.statisticInternal.getAssociatedMovieFilesCompletedWithSecrets();
            associatedMissing = Scenerixx.statisticInternal.getAssociatedMovieFilesMissingWithSecrets();
            associatedDiff = this.getDiffString(Scenerixx.statisticInternal.getAssociatedMovieFilesCompletedWithSecrets() - lastStat.getAssociatedMovieFilesCompletedWithSecrets(), true);
            associatedMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getAssociatedMovieFilesMissingWithSecrets() - lastStat.getAssociatedMovieFilesMissingWithSecrets(), false);
        } else {
            associated = Scenerixx.statisticInternal.getAssociatedMovieFilesCompletedWithSecrets();
            associatedMissing = Scenerixx.statisticInternal.getAssociatedMovieFilesMissingWithoutSecrets();
            associatedDiff = this.getDiffString(Scenerixx.statisticInternal.getAssociatedMovieFilesCompletedWithoutSecrets() - lastStat.getAssociatedMovieFilesCompletedWithoutSecrets(), true);
            associatedMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getAssociatedMovieFilesMissingWithoutSecrets() - lastStat.getAssociatedMovieFilesMissingWithoutSecrets(), false);
        }
        s = this.getConfirmedRatioString("Associated movie files", "/icons/Database.png", associatedMissing, associated, (String)s, associatedDiff, associatedMissingDiff, df1);
        int scenes = 0;
        int scenesMissing = 0;
        String scenesDiff = "";
        String scenesMissingDiff = "";
        if (Scenerixx.unlocked) {
            scenes = Scenerixx.statisticInternal.getMoviesWithAssociatedScenesCompletedWithSecrects();
            scenesMissing = Scenerixx.statisticInternal.getMoviesWithAssociatedScenesMissingWithSecrects();
            scenesDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithAssociatedScenesCompletedWithSecrects() - lastStat.getMoviesWithAssociatedScenesCompletedWithSecrects(), true);
            scenesMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithAssociatedScenesMissingWithSecrects() - lastStat.getMoviesWithAssociatedScenesMissingWithSecrects(), false);
        } else {
            scenes = Scenerixx.statisticInternal.getMoviesWithAssociatedScenesCompletedWithoutSecrects();
            scenesMissing = Scenerixx.statisticInternal.getMoviesWithAssociatedScenesMissingWithoutSecrects();
            scenesDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithAssociatedScenesCompletedWithoutSecrects() - lastStat.getMoviesWithAssociatedScenesCompletedWithoutSecrects(), true);
            scenesMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getMoviesWithAssociatedScenesMissingWithoutSecrects() - lastStat.getMoviesWithAssociatedScenesMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Movies with associated scenes", "/icons/bluebookmark.png", scenesMissing, scenes, (String)s, scenesDiff, scenesMissingDiff, df1);
        int lengthSet = 0;
        int lengthMissing = 0;
        String lengthDiff = "";
        String lengthMissingDiff = "";
        if (Scenerixx.unlocked) {
            lengthSet = Scenerixx.statisticInternal.getSceneLengthSetCompletedWithSecrects();
            lengthMissing = Scenerixx.statisticInternal.getSceneLengthSetMissingWithSecrects();
            lengthDiff = this.getDiffString(Scenerixx.statisticInternal.getSceneLengthSetCompletedWithSecrects() - lastStat.getSceneLengthSetCompletedWithSecrects(), true);
            lengthMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getSceneLengthSetMissingWithSecrects() - lastStat.getSceneLengthSetMissingWithSecrects(), false);
        } else {
            lengthSet = Scenerixx.statisticInternal.getSceneLengthSetCompletedWithoutSecrects();
            lengthMissing = Scenerixx.statisticInternal.getSceneLengthSetMissingWithoutSecrects();
            lengthDiff = this.getDiffString(Scenerixx.statisticInternal.getSceneLengthSetCompletedWithoutSecrects() - lastStat.getSceneLengthSetCompletedWithoutSecrects(), true);
            lengthMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getSceneLengthSetMissingWithoutSecrects() - lastStat.getSceneLengthSetMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Scene length set", "/icons.fatcow/clock_add.png", lengthMissing, lengthSet, (String)s, lengthDiff, lengthMissingDiff, df1);
        int person = 0;
        int personMissing = 0;
        String personDiff = "";
        String personMissingDiff = "";
        if (Scenerixx.unlocked) {
            person = Scenerixx.statisticInternal.getPersonsAssociatedCompletedWithSecrects();
            personMissing = Scenerixx.statisticInternal.getPersonsAssociatedMissingWithSecrects();
            personDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsAssociatedCompletedWithSecrects() - lastStat.getPersonsAssociatedCompletedWithSecrects(), true);
            personMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsAssociatedMissingWithSecrects() - lastStat.getPersonsAssociatedMissingWithSecrects(), false);
        } else {
            person = Scenerixx.statisticInternal.getPersonsAssociatedCompletedWithoutSecrects();
            personMissing = Scenerixx.statisticInternal.getPersonsAssociatedMissingWithoutSecrects();
            personDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsAssociatedCompletedWithoutSecrects() - lastStat.getPersonsAssociatedCompletedWithoutSecrects(), true);
            personMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getPersonsAssociatedMissingWithoutSecrects() - lastStat.getPersonsAssociatedMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Persons associated", "/icons/persons.png", personMissing, person, (String)s, personDiff, personMissingDiff, df1);
        int dateOfShoot = 0;
        int dateOfShootMissing = 0;
        String dateOfShootDiff = "";
        String dateOfShootMissingDiff = "";
        if (Scenerixx.unlocked) {
            dateOfShoot = Scenerixx.statisticInternal.getDateOfShootSetCompletedWithSecrects();
            dateOfShootMissing = Scenerixx.statisticInternal.getDateOfShootSetMissingWithSecrects();
            dateOfShootDiff = this.getDiffString(Scenerixx.statisticInternal.getDateOfShootSetCompletedWithSecrects() - lastStat.getDateOfShootSetCompletedWithSecrects(), true);
            dateOfShootMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getDateOfShootSetMissingWithSecrects() - lastStat.getDateOfShootSetMissingWithSecrects(), false);
        } else {
            dateOfShoot = Scenerixx.statisticInternal.getDateOfShootSetCompletedWithoutSecrects();
            dateOfShootMissing = Scenerixx.statisticInternal.getDateOfShootSetMissingWithoutSecrects();
            dateOfShootDiff = this.getDiffString(Scenerixx.statisticInternal.getDateOfShootSetCompletedWithoutSecrects() - lastStat.getDateOfShootSetCompletedWithoutSecrects(), true);
            dateOfShootMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getDateOfShootSetMissingWithoutSecrects() - lastStat.getDateOfShootSetMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Date of shoot set", "/icons.silk/calendar_view_day.png", dateOfShootMissing, dateOfShoot, (String)s, dateOfShootDiff, dateOfShootMissingDiff, df1);
        int studios = 0;
        int studiosMissing = 0;
        String studioDiff = "";
        String studioMissingDiff = "";
        if (Scenerixx.unlocked) {
            studios = Scenerixx.statisticInternal.getStudioCompletedWithSecrects();
            studiosMissing = Scenerixx.statisticInternal.getStudioMissingWithSecrects();
            studioDiff = this.getDiffString(Scenerixx.statisticInternal.getStudioCompletedWithSecrects() - lastStat.getStudioCompletedWithSecrects(), true);
            studioMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getStudioMissingWithSecrects() - lastStat.getStudioMissingWithSecrects(), false);
        } else {
            studios = Scenerixx.statisticInternal.getStudioCompletedWithoutSecrects();
            studiosMissing = Scenerixx.statisticInternal.getStudioMissingWithoutSecrects();
            studioDiff = this.getDiffString(Scenerixx.statisticInternal.getStudioCompletedWithoutSecrects() - lastStat.getStudioCompletedWithoutSecrects(), true);
            studioMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getStudioMissingWithoutSecrects() - lastStat.getStudioMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Studio", "/icons/home.png", studiosMissing, studios, (String)s, studioDiff, studioMissingDiff, df1);
        int screencaps = 0;
        int screencapsMissing = 0;
        String screencapsDiff = "";
        String screencapsMissingDiff = "";
        if (Scenerixx.unlocked) {
            screencaps = Scenerixx.statisticInternal.getScreencapsCompletedWithSecrects();
            screencapsMissing = Scenerixx.statisticInternal.getScreencapsMissingWithSecrects();
            screencapsDiff = this.getDiffString(Scenerixx.statisticInternal.getScreencapsCompletedWithSecrects() - lastStat.getScreencapsCompletedWithSecrects(), true);
            screencapsMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getScreencapsMissingWithSecrects() - lastStat.getScreencapsMissingWithSecrects(), false);
        } else {
            screencaps = Scenerixx.statisticInternal.getScreencapsCompletedWithoutSecrects();
            screencapsMissing = Scenerixx.statisticInternal.getScreencapsMissingWithoutSecrects();
            screencapsDiff = this.getDiffString(Scenerixx.statisticInternal.getScreencapsCompletedWithoutSecrects() - lastStat.getScreencapsCompletedWithoutSecrects(), true);
            screencapsMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getScreencapsMissingWithoutSecrects() - lastStat.getScreencapsMissingWithoutSecrects(), false);
        }
        s = screencaps == -1 || screencapsMissing == -1 ? (String)s + "<tr><td></td><td>Screencaps</td><td>n/a</td><td>n/a</td><td>n/a % / n/a %</td><td>n/a</tr>" : this.getConfirmedRatioString("Screencaps", "/icons2/66camera.png", screencapsMissing, screencaps, (String)s, screencapsDiff, screencapsMissingDiff, df1);
        int mediainfo = 0;
        int mediainfoMissing = 0;
        String mediainfoDiff = "";
        String mediainfoMissingDiff = "";
        if (Scenerixx.unlocked) {
            mediainfo = Scenerixx.statisticInternal.getMediaInformationCompletedWithSecrects();
            mediainfoMissing = Scenerixx.statisticInternal.getMediaInformationMissingWithSecrects();
            mediainfoDiff = this.getDiffString(Scenerixx.statisticInternal.getMediaInformationCompletedWithSecrects() - lastStat.getMediaInformationCompletedWithSecrects(), true);
            mediainfoMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getMediaInformationMissingWithSecrects() - lastStat.getMediaInformationMissingWithSecrects(), false);
        } else {
            mediainfo = Scenerixx.statisticInternal.getMediaInformationCompletedWithoutSecrects();
            mediainfoMissing = Scenerixx.statisticInternal.getMediaInformationMissingWithoutSecrects();
            mediainfoDiff = this.getDiffString(Scenerixx.statisticInternal.getMediaInformationCompletedWithoutSecrects() - lastStat.getMediaInformationCompletedWithoutSecrects(), true);
            mediainfoMissingDiff = this.getDiffString(Scenerixx.statisticInternal.getMediaInformationMissingWithoutSecrects() - lastStat.getMediaInformationMissingWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Media information", "/icons/Stopwatch.png", mediainfoMissing, mediainfo, (String)s, mediainfoDiff, mediainfoMissingDiff, df1);
        int wizardConfirmed = 0;
        int wizardNotConfirmed = 0;
        String wizardConfirmedDiff = "";
        String wizardNotConfirmedDiff = "";
        if (Scenerixx.unlocked) {
            wizardConfirmed = Scenerixx.statisticInternal.getWizardDataConfirmedWithSecrects();
            wizardNotConfirmed = Scenerixx.statisticInternal.getWizardDataNotConfirmedWithSecrects();
            wizardConfirmedDiff = this.getDiffString(Scenerixx.statisticInternal.getWizardDataConfirmedWithSecrects() - lastStat.getWizardDataConfirmedWithSecrects(), true);
            wizardNotConfirmedDiff = this.getDiffString(Scenerixx.statisticInternal.getWizardDataNotConfirmedWithSecrects() - lastStat.getWizardDataNotConfirmedWithSecrects(), false);
        } else {
            wizardConfirmed = Scenerixx.statisticInternal.getWizardDataConfirmedWithoutSecrects();
            wizardNotConfirmed = Scenerixx.statisticInternal.getWizardDataNotConfirmedWithoutSecrects();
            wizardConfirmedDiff = this.getDiffString(Scenerixx.statisticInternal.getWizardDataConfirmedWithoutSecrects() - lastStat.getWizardDataConfirmedWithoutSecrects(), true);
            wizardNotConfirmedDiff = this.getDiffString(Scenerixx.statisticInternal.getWizardDataNotConfirmedWithoutSecrects() - lastStat.getWizardDataNotConfirmedWithoutSecrects(), false);
        }
        s = this.getConfirmedRatioString("Wizard generated data confirmed", "/icons.silk/wand.png", wizardNotConfirmed, wizardConfirmed, (String)s, wizardConfirmedDiff, wizardNotConfirmedDiff, df1);
        s = (String)s + "</table>";
        return s;
    }

    private String getConfirmedRatioString(String caption, String icon, int notConfirmed, int confirmed, String s, String confirmedDiff, String notConfirmedDiff, DecimalFormat df1) {
        double wizardConfirmedRatio = 0.0;
        double wizardNotConfirmedRatio = 0.0;
        if (notConfirmed == 0) {
            wizardConfirmedRatio = 100.0;
        } else if (confirmed == 0) {
            wizardNotConfirmedRatio = 100.0;
        } else {
            wizardConfirmedRatio = (double)(confirmed * 100) / (double)(confirmed + notConfirmed);
            wizardNotConfirmedRatio = (double)(notConfirmed * 100) / (double)(confirmed + notConfirmed);
        }
        s = (String)s + "<tr><td><img src='" + String.valueOf(this.getClass().getResource(icon)) + "'></td><td> " + caption + "</td><td align='right'>" + String.format("%,d", confirmed) + confirmedDiff + "</td><td align='right'>" + String.format("%,d", notConfirmed) + notConfirmedDiff + "</td><td align='right'>" + df1.format(wizardConfirmedRatio) + "%</td><td align='right'>" + df1.format(wizardNotConfirmedRatio) + "%</td><td align='right'>" + df1.format((double)(confirmed + notConfirmed) / 100.0) + "</tr>";
        return s;
    }

    private String getDiffString(int diff, boolean completed) {
        return this.getDiffString((long)diff, completed);
    }

    private String getDiffString(long diff, boolean completed) {
        String positive = "#30ca5f";
        String negative = "#ff3066";
        if (!completed) {
            negative = positive;
            positive = "ff3066";
        } else {
            negative = "#B2BEB5";
        }
        if (diff == 0L) {
            return "";
        }
        if (diff > 0L) {
            return " (<font color=\"" + positive + "\">+" + diff + "</font>)";
        }
        return " (<font color=\"" + negative + "\">" + diff + "</font>)";
    }

    private String coloredString(String s, boolean positive) {
        if (positive) {
            return " (+<font color=\"#30ca5f\">" + s + "</font>)";
        }
        return " (<font color=\"#B2BEB5\">" + s + "</font>)";
    }
}

