/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.indexing;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.ScenerixxLib;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.DBInternal;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QDeletedMedium;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxlib.util.Hashing;
import xxx.scenerixx.scenerixxlib.util.MediaInformation;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.ScreencapService;
import xxx.scenerixx.scenerixxmodule.util.gui.Figlets;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.indexing.ScenerixxWizardOptionsPanel;

public class ScenerixxWizardPanel
extends JPanel {
    public static final Logger LOG = Logger.getLogger(ScenerixxWizardPanel.class.getName());
    public DB db;
    private boolean discIsFull = false;
    private boolean abort = false;
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqPersons = new LinkedBlockingQueue();
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqStudios = new LinkedBlockingQueue();
    private LinkedBlockingDeque<SwingWorker<String, String>> lbqHashing = new LinkedBlockingDeque();
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqMediaInformation = new LinkedBlockingQueue();
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqDuplicates = new LinkedBlockingQueue();
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqScreencap = new LinkedBlockingQueue();
    private LinkedBlockingQueue<SwingWorker<String, String>> lbqCreateSceneOrMovie = new LinkedBlockingQueue();
    private AtomicBoolean personExecuting = new AtomicBoolean(false);
    private AtomicBoolean studiosExecuting = new AtomicBoolean(false);
    private AtomicBoolean hashingExecuting = new AtomicBoolean(false);
    private AtomicBoolean mediaInformationExecuting = new AtomicBoolean(false);
    private AtomicBoolean duplicatesExecuting = new AtomicBoolean(false);
    private AtomicBoolean screencapExecuting = new AtomicBoolean(false);
    private AtomicBoolean createSceneOrMovieExecuting = new AtomicBoolean(false);
    private int indexingCounter = 0;
    private int movieFilesCounter = 0;
    private int personCounter = 0;
    private int studiosCounter = 0;
    private int studioSetCounter = 0;
    private int hashingCounter = 0;
    private int onceDeletedCounter = 0;
    private int mediaInformationCounter = 0;
    private int duplicatesCounter = 0;
    private int screencapCounter = 0;
    private int createMovieCounter = 0;
    private int createSceneCounter = 0;
    private int vrCounter = 0;
    private int soloCounter = 0;
    private int lesbianCounter = 0;
    private int multiFileCounter = 0;
    private int allPersonsCounter = 0;
    private int hashingFailedAttemps = 0;
    private int mediaInformationFailedAttemps = 0;
    private int duplicatesFailedAttemps = 0;
    private int personFailedAttemps = 0;
    private int studiosFailedAttemps = 0;
    private int screencapFailedAttemps = 0;
    private int createSceneOrMovieFailedAttemps = 0;
    private boolean stillIndexing = false;
    private boolean lesbianExisting = false;
    private boolean soloExisting = false;
    private boolean allPersonsExisting = false;
    private boolean studioExisting = false;
    private boolean tagsExisting = false;
    private boolean useMasterDb = false;
    private List<Person> personCache = null;
    private List<Studio> studioCache = null;
    private String currentHashingDirectory = null;
    private String updateStatistic = "Dirty hack";
    private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
    private List<String> alreadyProcessedFiles = new ArrayList<String>();
    private List<String> failedFiles = new ArrayList<String>();
    private boolean closedWindow = false;
    private ScenerixxWizardOptionsPanel optionsPanel = null;
    private IndexingTopComponent indexingTopComponent = null;
    private List<Studio> studios = new ArrayList<Studio>();
    private LocalDateTime starttime = LocalDateTime.now();
    private JButton btnAbort;
    private JButton btnApplyWizardOnExistingData;
    private JButton btnChooseDirectory;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lbStatus;
    private JLabel lbTippTitle;
    private JLabel lbTitle;
    private JTextArea taLog;

    public ScenerixxWizardPanel() {
        this.initComponents();
        LOG.info("Design time: " + Beans.isDesignTime());
        if (!Beans.isDesignTime()) {
            this.optionsPanel = new ScenerixxWizardOptionsPanel();
            TopComponent indexingTC = WindowManager.getDefault().findTopComponent("IndexingTopComponent");
            if (indexingTC != null && indexingTC instanceof IndexingTopComponent) {
                LOG.info("Fetched IndexingTC");
                this.indexingTopComponent = (IndexingTopComponent)indexingTC;
            } else {
                LOG.info("Create new IndexingTC");
                this.indexingTopComponent = new IndexingTopComponent();
            }
            Font font = new Font("Monospaced", 0, 13);
            this.taLog.setFont(font);
            this.toggleAbort(false);
            ScenerixxSettings settings = this.getDB().getScenerixxSettings();
            this.optionsPanel.cbPrefixWithDirectoryName.setSelected(settings.isWizardPrefixDirectory());
            this.optionsPanel.cbApplyTags.setSelected(settings.isWizardApplyTags());
            this.optionsPanel.cbApplyTagsWithHash.setSelected(settings.isWizardApplyTagsOnlyWithPrefixedHash());
            this.optionsPanel.cbAssociateAllPersons.setSelected(settings.isWizardAlwaysAssociatePersons());
            this.optionsPanel.cbCheckForMultifileMovies.setSelected(settings.isWizardMultifile());
            this.optionsPanel.cbStartDuplicateFinder.setSelected(settings.isWizardRunDuplicateFinder());
            this.optionsPanel.cbSelectedFolderOnly.setSelected(settings.isWizardRunDuplicateFinderOnlySelectedFolder());
            this.optionsPanel.tfDuplicateFinderDiffInSeconds.setText("" + settings.getWizardDuplicateFinderDiffInSeconds());
            if (settings.getWizardDuplicateFinderThreshold() == 0.0) {
                this.optionsPanel.tfDuplicateFinderThreshold.setText("18.0");
            } else {
                this.optionsPanel.tfDuplicateFinderThreshold.setText("" + settings.getWizardDuplicateFinderThreshold());
            }
            if (Scenerixx.firstRun) {
                this.btnApplyWizardOnExistingData.setVisible(false);
            }
            this.optionsPanel.toggleIcons();
            this.studios = DB.getInstance().getEntityService().find((EntityPathBase)QStudio.studio).find();
            List<Studio> loadStudioFiles = this.loadStudioFiles();
            for (Studio s : loadStudioFiles) {
                boolean found = false;
                for (Studio s1 : this.studios) {
                    if (!s1.getName().equals(s.getName())) continue;
                    found = true;
                }
                if (found) continue;
                this.studios.add(s);
            }
        }
    }

    private DB getDB() {
        if (this.db == null) {
            this.db = DB.getInstance();
        }
        return this.db;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnAbort = new JButton();
        this.btnChooseDirectory = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taLog = new JTextArea();
        this.btnApplyWizardOnExistingData = new JButton();
        this.lbTitle = new JLabel();
        this.lbTippTitle = new JLabel();
        this.lbStatus = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnAbort.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAbort, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.btnAbort.text"));
        this.btnAbort.setToolTipText(NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.btnAbort.toolTipText"));
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScenerixxWizardPanel.this.btnAbortActionPerformed(evt);
            }
        });
        this.btnChooseDirectory.setIcon(new ImageIcon(this.getClass().getResource("/icons/Folder.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChooseDirectory, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.btnChooseDirectory.text"));
        this.btnChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScenerixxWizardPanel.this.btnChooseDirectoryActionPerformed(evt);
            }
        });
        this.taLog.setColumns(20);
        this.taLog.setRows(5);
        this.taLog.setText(NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.taLog.text"));
        this.jScrollPane1.setViewportView(this.taLog);
        this.btnApplyWizardOnExistingData.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/wand.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyWizardOnExistingData, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.btnApplyWizardOnExistingData.text"));
        this.btnApplyWizardOnExistingData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScenerixxWizardPanel.this.btnApplyWizardOnExistingDataActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnChooseDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnApplyWizardOnExistingData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAbort)).addComponent(this.jScrollPane1, -2, 976, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnChooseDirectory).addComponent(this.btnAbort).addComponent(this.btnApplyWizardOnExistingData)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 510, Short.MAX_VALUE).addContainerGap()));
        this.lbTitle.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lbTitle, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.lbTitle.text"));
        this.lbTitle.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((JLabel)this.lbTippTitle, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.lbTippTitle.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbStatus, (String)NbBundle.getMessage(ScenerixxWizardPanel.class, (String)"ScenerixxWizardPanel.lbStatus.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbTitle, -1, 325, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbTippTitle).addComponent(this.lbStatus)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.lbStatus).addGap(9, 9, 9).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbTippTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbTitle, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    public void closePanel() {
        LOG.info("Closing Wizard panel");
    }

    private void btnChooseDirectoryActionPerformed(ActionEvent evt) {
        this.showOptionsImport();
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.toggleAbort(true);
    }

    private void btnApplyWizardOnExistingDataActionPerformed(ActionEvent evt) {
        this.applyWizardToExistingData();
    }

    private void showOptionsImport() {
        try {
            this.starttime = LocalDateTime.now();
            this.optionsPanel.toggleBtnPrefix.setVisible(true);
            this.optionsPanel.cbPrefixWithDirectoryName.setVisible(true);
            this.optionsPanel.toggleBtnMultiFiles.setVisible(true);
            this.optionsPanel.cbCheckForMultifileMovies.setVisible(true);
            this.optionsPanel.jSeparator4.setVisible(true);
            this.optionsPanel.jFileChooser1.setVisible(true);
            this.optionsPanel.toggleIcons();
            this.optionsPanel.setAbort(false);
            EventQueue.invokeLater(() -> {
                JDialog frame = new JDialog((Frame)null, "Scenerixx Wizard - Options to import new files", true);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ScenerixxWizardPanel.this.closedWindow = true;
                    }
                });
                JScrollPane scrollPane = new JScrollPane(this.optionsPanel);
                scrollPane.setHorizontalScrollBarPolicy(30);
                scrollPane.setVerticalScrollBarPolicy(20);
                frame.add(scrollPane);
                frame.getContentPane().add(scrollPane);
                frame.pack();
                frame.setLocationRelativeTo(this);
                frame.setVisible(true);
                if (!this.optionsPanel.isAbort() && !this.closedWindow) {
                    ScenerixxSettings scenerixxSettings = this.getDB().getScenerixxSettings();
                    File[] selectedFiles = this.optionsPanel.jFileChooser1.getSelectedFiles();
                    if (selectedFiles.length == 0 && this.optionsPanel.jFileChooser1.getCurrentDirectory() != null) {
                        LOG.info("Use current directory: " + String.valueOf(this.optionsPanel.jFileChooser1.getCurrentDirectory()));
                        selectedFiles = new File[]{this.optionsPanel.jFileChooser1.getCurrentDirectory()};
                    } else if (selectedFiles.length == 0 && scenerixxSettings.getLastIndexDirectory() != null) {
                        LOG.info("Use last directory: " + scenerixxSettings.getLastIndexDirectory());
                        selectedFiles = new File[]{new File(scenerixxSettings.getLastIndexDirectory())};
                    }
                    for (File selFile : selectedFiles) {
                        scenerixxSettings.setLastIndexDirectory(selFile.getAbsolutePath());
                        scenerixxSettings = (ScenerixxSettings)this.getDB().getEntityService().save((AbstractEntity)scenerixxSettings);
                        LOG.finest("Start indexing at root directory " + String.valueOf(selFile));
                    }
                    if (Scenerixx.registered) {
                        LOG.info("Trying to download master DB");
                        this.useMasterDb = ScenerixxCommon.downloadMasterDB(false);
                        LOG.info("Download of master DB: " + this.useMasterDb);
                    }
                    new IndexingWorker(selectedFiles).execute();
                } else {
                    LOG.info("User decided to abort");
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateWindows() {
        SwingUtilities.invokeLater(() -> {
            AbstractTopComponent.dirtyMovieList();
            AbstractTopComponent.dirtyPersonList();
            AbstractTopComponent.dirtyMediumFileList();
            AbstractTopComponent.dirtyStudiolist();
        });
    }

    private boolean containsPersonName(MediumFile mf, Person p) {
        return this.containsPersonName(mf.getFileName(), p.getName());
    }

    private boolean containsPersonName(String mfName, String personName) {
        return mfName.toLowerCase().contains(personName.toLowerCase()) || mfName.toLowerCase().contains(personName.replace(" ", "").toLowerCase()) || mfName.toLowerCase().contains(personName.replace(" ", "_").toLowerCase()) || mfName.toLowerCase().contains(personName.replace(" ", ".").toLowerCase());
    }

    private List<Person> loadPersonFiles() {
        if (this.personCache == null) {
            this.personCache = this.loadPersonFilesFromScenerixxFiles();
            if (this.useMasterDb) {
                DBInternal db = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
                for (Person p : db.getPersons(true)) {
                    if (!this.personCache.contains(p)) {
                        this.personCache.add(p);
                        continue;
                    }
                    LOG.info(p.getName() + " is already in cache");
                }
            }
        }
        return this.personCache;
    }

    private List<Person> loadPersonFilesFromScenerixxFiles() {
        ArrayList<Person> tmpPersons = new ArrayList<Person>();
        Importer imp = new Importer();
        LOG.fine("Loading Scenerixx-files (person)");
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirPersons, new String[0]), new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    LOG.finest("Found a file: " + filePath.toString());
                    if (!filePath.toString().endsWith("person.scenerixx") && !filePath.toString().endsWith("person.private.scenerixx")) continue;
                    Person importPersonFile = imp.importPersonFile(filePath.toString(), false);
                    LOG.finest("Check if person is already imported.");
                    if (this.getDB().getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.equalsIgnoreCase(importPersonFile.getName())).count() != 0L) continue;
                    LOG.finest("Was not yet imported");
                    tmpPersons.add(importPersonFile);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
        }
        return tmpPersons;
    }

    private List<Studio> loadStudioFiles() {
        if (this.studioCache == null) {
            this.studioCache = this.loadStudioFilesFromScenerixxFiles();
            if (this.useMasterDb) {
                DBInternal db = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
                for (Studio s : db.getStudios()) {
                    if (!this.studioCache.contains(s)) {
                        this.studioCache.add(s);
                        continue;
                    }
                    LOG.info(s.getName() + " is already in cache");
                }
            }
        }
        return this.studioCache;
    }

    private List<Studio> loadStudioFilesFromScenerixxFiles() {
        ArrayList<Studio> tmpStudio = new ArrayList<Studio>();
        Importer imp = new Importer();
        LOG.fine("Loading Scenerixx-files (studios)");
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirStudio, new String[0]), new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    LOG.finest("Found a file: " + filePath.toString());
                    if (!filePath.toString().endsWith("studio.scenerixx")) continue;
                    LOG.finer("Loading " + filePath.toString());
                    tmpStudio.add(imp.importStudioFile(filePath.toString()));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
        }
        return tmpStudio;
    }

    private void toggleAbort(boolean bAbort) {
        if (bAbort) {
            this.indexingTopComponent.abortIndexing();
        }
        this.abort = bAbort;
        this.btnAbort.setEnabled(!bAbort);
    }

    private void askToClose() {
        if (this.db.getScenerixxSettings().isPlaySoundAfterWizardFinished()) {
            LOG.fine("play sound");
            try {
                URL url = this.getClass().getClassLoader().getResource("sound/telephone-ring-3.wav");
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
                Clip clip = AudioSystem.getClip();
                clip.open(audioIn);
                clip.start();
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.updateWindows();
        if (this.optionsPanel.cbShutdown.isSelected()) {
            LOG.info("Shutdown ...");
            try {
                ScenerixxCommon.shutdown();
            }
            catch (IOException | RuntimeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private Movie applyTags(Movie movie, String filename, boolean save) {
        ArrayList<MovieType> foundTypes = new ArrayList<MovieType>();
        for (MovieType mt : MovieType.values()) {
            String movietype = mt.getTitle().toLowerCase();
            if (mt.equals((Object)MovieType.LESBIANS)) {
                movietype = "lesbian";
            }
            if (mt.equals((Object)MovieType.BIGCOCK)) {
                movietype = "bbc";
            }
            if (mt.equals((Object)MovieType.ASSES_BIG)) {
                movietype = "bigass";
            }
            if (mt.equals((Object)MovieType.AMATEUR)) {
                movietype = "amateur";
            }
            if (this.optionsPanel.cbApplyTagsWithHash.isSelected() && filename.toLowerCase().contains("#" + movietype) || !this.optionsPanel.cbApplyTagsWithHash.isSelected() && filename.toLowerCase().contains(movietype)) {
                foundTypes.add(mt);
                LOG.info("Found tag for movie '" + movie.getTitle() + "': " + mt.getTitle());
                continue;
            }
            if ((!this.optionsPanel.cbApplyTagsWithHash.isSelected() || !movietype.contains(" ") || !filename.toLowerCase().contains("#" + movietype.replace(" ", ""))) && (this.optionsPanel.cbApplyTagsWithHash.isSelected() || !movietype.contains(" ") || !filename.toLowerCase().contains(movietype.replace(" ", "")))) continue;
            foundTypes.add(mt);
            LOG.info("Found tag for movie '" + movie.getTitle() + "': " + mt.getTitle());
        }
        LOG.info("Found " + foundTypes.size() + " matching tags");
        for (MovieType mt : foundTypes) {
            if (movie.getType() == mt || movie.getType2() == mt || movie.getType3() == mt || movie.getType4() == mt || movie.getType5() == mt || movie.getType6() == mt || movie.getMovietypes().contains(mt)) continue;
            if (movie.getType() == null) {
                movie.setType(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            if (movie.getType2() == null) {
                movie.setType2(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            if (movie.getType3() == null) {
                movie.setType3(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            if (movie.getType4() == null) {
                movie.setType4(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            if (movie.getType5() == null) {
                movie.setType5(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            if (movie.getType6() == null) {
                movie.setType6(mt);
                movie.setWizardGenerated(true);
                continue;
            }
            movie.getMovietypes().add(mt);
        }
        if (save && movie.isWizardGenerated()) {
            movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
        }
        return movie;
    }

    private void applyWizardToExistingData() {
        this.starttime = LocalDateTime.now();
        this.optionsPanel.toggleBtnPrefix.setVisible(false);
        this.optionsPanel.lbPrefix.setVisible(false);
        this.optionsPanel.cbPrefixWithDirectoryName.setVisible(false);
        this.optionsPanel.toggleBtnMultiFiles.setVisible(false);
        this.optionsPanel.lbTryToFind.setVisible(false);
        this.optionsPanel.cbCheckForMultifileMovies.setVisible(false);
        this.optionsPanel.jSeparator4.setVisible(false);
        this.optionsPanel.jFileChooser1.setVisible(false);
        this.optionsPanel.setAbort(false);
        try {
            EventQueue.invokeLater(() -> {
                JDialog frame = new JDialog((Frame)null, "Scenerixx Wizard - Options to apply on existing data", true);
                JScrollPane scrollPane = new JScrollPane(this.optionsPanel);
                scrollPane.setHorizontalScrollBarPolicy(30);
                scrollPane.setVerticalScrollBarPolicy(20);
                frame.getContentPane().add(scrollPane);
                frame.pack();
                frame.setLocationRelativeTo(this);
                frame.setVisible(true);
                LOG.info("2apply tags" + this.optionsPanel.cbApplyTags.isSelected());
                LOG.info("2prefix" + this.optionsPanel.cbPrefixWithDirectoryName.isSelected());
                if (!this.optionsPanel.isAbort()) {
                    if (0 == JOptionPane.showConfirmDialog(null, "Do you really want to apply the wizard to existing data?\nThis operation cannot be reverted.", "Apply wizard on existing data?", 0)) {
                        LOG.info("Gather information");
                        List mediumFilesWithoutDuration = this.db.getMediumFilesWithoutDuration("", true);
                        for (Object mf : mediumFilesWithoutDuration) {
                            this.lbqMediaInformation.add(new UpdateMediaInformationWorker((MediumFile)mf));
                        }
                        List mediumFilesWithoutHash = this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.hashValue.isNull()).find();
                        for (MediumFile mf : mediumFilesWithoutHash) {
                            this.lbqHashing.add(new HashingWorker(mf));
                        }
                        List mediumFiles = this.db.getMediumFiles(true);
                        for (MediumFile mf : mediumFiles) {
                            this.lbqPersons.add(new CheckForPersonsToImportWorker(mf));
                        }
                        new QueueWorker().execute();
                        new CheckForLesbiansExistingDataWorker().execute();
                        new CheckForSoloExistingDataWorker().execute();
                        if (this.optionsPanel.cbAssociateAllPersons.isSelected()) {
                            new CheckForAllPersonsExistingDataWorker().execute();
                        } else {
                            this.allPersonsExisting = true;
                        }
                        new CheckForStudioExistingDataWorker().execute();
                        new CheckForTagsExistingDataWorker().execute();
                        this.indexingTopComponent.new IndexingTopComponent.GenerateScreencapsWorker().execute();
                    }
                } else {
                    LOG.info("User decided to abort");
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateLog(List<String> item) {
        for (String s : item) {
            this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s + "\n");
            if (this.taLog.getLineCount() <= 1000) continue;
            try {
                this.taLog.setText(this.taLog.getText(this.taLog.getLineCount() - 1000, 1000));
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private boolean isBlacklistedStudio(Studio studio) {
        return studio.getName().toLowerCase().equalsIgnoreCase("ggg") || studio.getName().toLowerCase().equalsIgnoreCase("private") || studio.getName().toLowerCase().equalsIgnoreCase("colette") || studio.getName().toLowerCase().equalsIgnoreCase("hardcore gangbang") || studio.getName().toLowerCase().equalsIgnoreCase("babes") || studio.getName().toLowerCase().equalsIgnoreCase("nympho") || studio.getName().toLowerCase().equalsIgnoreCase("666");
    }

    private boolean checkForStudioNameAndAlternatives(String studioName, String mediumFileName) {
        return mediumFileName.toLowerCase().contains(studioName.toLowerCase()) || mediumFileName.replaceAll("'", "").toLowerCase().contains(studioName.replaceAll("'", "").toLowerCase()) || mediumFileName.replaceAll(" ", "").toLowerCase().contains(studioName.replaceAll(" ", "").toLowerCase()) || mediumFileName.replaceAll(" ", "").replaceAll("'", "").toLowerCase().contains(studioName.replaceAll(" ", "").replaceAll("'", "").toLowerCase()) || mediumFileName.contains(studioName.replaceAll(".com", "").toLowerCase()) && !studioName.toLowerCase().contains("gonzo") || "Harmony Films".equalsIgnoreCase(studioName) && mediumFileName.toLowerCase().contains("harmony vision") || "Harmony Films".equalsIgnoreCase(studioName) && mediumFileName.toLowerCase().contains("harmonyvision") || "MomPov.com".equalsIgnoreCase(studioName) && mediumFileName.toLowerCase().contains("mompov") || "GirlsDoPorn.com".equalsIgnoreCase(studioName) && mediumFileName.toLowerCase().contains("girlsdoporn") || "3rd Degree Films".equalsIgnoreCase(studioName) && mediumFileName.toLowerCase().contains("third degree films");
    }

    public class UpdateMediaInformationWorker
    extends SwingWorker<String, String> {
        private MediaInformation media = new MediaInformation();
        private MediumFile mf;

        public UpdateMediaInformationWorker(MediumFile mf) {
            this.mf = mf;
        }

        @Override
        protected String doInBackground() throws Exception {
            boolean save = false;
            LOG.finer("Try to retrieve media information for file " + this.mf.getFileCompletePath());
            if (this.mf.getHeight() == null || this.mf.getWidth() == null || this.mf.getDuration() == null) {
                this.publish("Try to retrieve media information for file " + this.mf.getFileCompletePath());
            }
            try {
                String duration;
                String width;
                String height;
                if (this.mf.getHeight() == null && !(height = this.media.getMediaInfoValue("--Inform=Video;%Height%", this.mf.getFileCompletePath())).isEmpty()) {
                    this.mf.setHeight(Integer.valueOf(Integer.parseInt(height)));
                    save = true;
                }
                if (this.mf.getWidth() == null && !(width = this.media.getMediaInfoValue("--Inform=Video;%Width%", this.mf.getFileCompletePath())).isEmpty()) {
                    this.mf.setWidth(Integer.valueOf(Integer.parseInt(width)));
                    save = true;
                }
                if (this.mf.getDuration() == null && !(duration = this.media.getMediaInfoValue("--Inform=Video;%Duration%", this.mf.getFileCompletePath())).isEmpty()) {
                    if (duration.contains(".")) {
                        duration = duration.substring(0, duration.indexOf("."));
                    }
                    this.mf.setDuration(Integer.valueOf(Integer.parseInt(duration)));
                    save = true;
                }
            }
            catch (Exception ex) {
                AbstractTopComponent.notify("Could not retrieve media information: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
            }
            if (save) {
                this.mf = (MediumFile)ScenerixxWizardPanel.this.getDB().getEntityService().save((AbstractEntity)this.mf);
                ++ScenerixxWizardPanel.this.mediaInformationCounter;
                LOG.fine("Updated media information for file: " + this.mf.getFileCompletePath());
                this.publish("Updated media information for file: " + this.mf.getFileCompletePath() + ": " + this.mf.getWidth() + "x" + this.mf.getHeight() + " - " + this.mf.getDuration());
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("mediaInfo thread finished");
            ScenerixxWizardPanel.this.mediaInformationExecuting.set(false);
        }
    }

    public class HashingWorker
    extends SwingWorker<String, String> {
        private Hashing hashing = new Hashing();
        private MediumFile mf;

        public HashingWorker(MediumFile mf) {
            this.mf = mf;
        }

        @Override
        protected String doInBackground() throws Exception {
            MediumFile findFirst = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.hashValue.isNotNull()).filter(f -> f.fileCompletePath.eq((Object)this.mf.getFileCompletePath())).findFirst();
            if (findFirst != null) {
                this.publish(this.mf.getFileCompletePath() + " was already hashed");
                return null;
            }
            this.hashing.hashFile(this.mf);
            ++ScenerixxWizardPanel.this.hashingCounter;
            long count = ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QDeletedMedium.deletedMedium).filter(f -> f.hashValue.isNotNull()).filter(f -> f.hashValue.eq((Object)this.mf.getHashValue())).count();
            if (count > 0L) {
                this.publish("'" + this.mf.getFileCompletePath() + "' was already once deleted by you. We skip this file in the further process.");
                ++ScenerixxWizardPanel.this.onceDeletedCounter;
            } else {
                this.publish("Hashed " + this.mf.getFileName() + ". Checking next for duplicates.");
                ScenerixxWizardPanel.this.currentHashingDirectory = new File(this.mf.getFileCompletePath()).getParentFile().getAbsolutePath();
                LOG.info("Hashed " + this.mf.getFileName() + ". Checking next for duplicates. - currentHashingDirectory: " + ScenerixxWizardPanel.this.currentHashingDirectory);
                ScenerixxWizardPanel.this.lbqDuplicates.add(new CheckForDuplicatesWorker(this.mf));
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("hashing thread finished");
            ScenerixxWizardPanel.this.hashingExecuting.set(false);
        }
    }

    public class CheckForPersonsToImportWorker
    extends SwingWorker<String, String> {
        private MediumFile mf;

        public CheckForPersonsToImportWorker(MediumFile mf) {
            this.mf = mf;
        }

        @Override
        protected String doInBackground() throws Exception {
            for (Person p : ScenerixxWizardPanel.this.loadPersonFiles()) {
                if (!ScenerixxWizardPanel.this.containsPersonName(this.mf.getFileName(), p.getName()) || DB.getInstance().getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.equalsIgnoreCase(p.getName())).findFirst() != null) continue;
                DB.getInstance().getEntityService().save((AbstractEntity)p);
                for (PersonBody pb : p.getPersonBodys()) {
                    pb.setPerson(p);
                    pb = (PersonBody)ScenerixxWizardPanel.this.db.getEntityService().save((AbstractEntity)pb);
                }
                ++ScenerixxWizardPanel.this.personCounter;
                this.publish("Added person '" + p.getName() + "' (due to " + this.mf.getFileName() + ")");
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("person thread finished");
            ScenerixxWizardPanel.this.personExecuting.set(false);
        }
    }

    public class QueueWorker
    extends SwingWorker<String, String> {
        private int updatingWindows = 0;
        private LocalDateTime starttime;

        @Override
        protected String doInBackground() throws Exception {
            this.publish("Let's do some wizardry things...");
            this.starttime = LocalDateTime.now();
            int sleepHashing = 500;
            int sleepMediaInformation = 500;
            int sleepPerson = 500;
            int sleepDuplicates = 500;
            int sleepStudios = 500;
            int sleepScreencap = 500;
            int sleepCreateSceneOrMovie = 500;
            boolean dupFinderStarted = false;
            new UpdateTutorialWorker().execute();
            LocalDateTime now = LocalDateTime.now();
            while (!ScenerixxWizardPanel.this.abort) {
                SwingWorker<String, String> poll;
                if (Duration.between(now, LocalDateTime.now()).getSeconds() >= 3L) {
                    this.publish(ScenerixxWizardPanel.this.updateStatistic);
                    now = LocalDateTime.now();
                }
                LOG.finer("******************************************");
                LOG.finer("WHILE");
                LOG.finer("******************************************");
                LOG.finer("hashing " + sleepHashing + " " + ScenerixxWizardPanel.this.hashingFailedAttemps + " " + ScenerixxWizardPanel.this.hashingExecuting.get());
                LOG.finer("person " + sleepPerson + " " + ScenerixxWizardPanel.this.personFailedAttemps + " " + ScenerixxWizardPanel.this.personExecuting.get());
                LOG.finer("screencap " + sleepScreencap + " " + ScenerixxWizardPanel.this.screencapFailedAttemps + " " + ScenerixxWizardPanel.this.screencapExecuting.get());
                LOG.finer("studios " + sleepStudios + " " + ScenerixxWizardPanel.this.studiosFailedAttemps + " " + ScenerixxWizardPanel.this.studiosExecuting.get());
                LOG.finer("duplicates " + sleepDuplicates + " " + ScenerixxWizardPanel.this.duplicatesFailedAttemps + " " + ScenerixxWizardPanel.this.duplicatesExecuting.get());
                LOG.finer("media " + sleepMediaInformation + " " + ScenerixxWizardPanel.this.mediaInformationFailedAttemps + " " + ScenerixxWizardPanel.this.mediaInformationExecuting.get());
                LOG.finer("create " + sleepCreateSceneOrMovie + " " + ScenerixxWizardPanel.this.createSceneOrMovieFailedAttemps + " " + ScenerixxWizardPanel.this.createSceneOrMovieExecuting.get());
                if (ScenerixxWizardPanel.this.lbqScreencap.size() == 0 && !ScenerixxWizardPanel.this.stillIndexing && (ScenerixxWizardPanel.this.personFailedAttemps > 250 && ScenerixxWizardPanel.this.hashingFailedAttemps > 250 && ScenerixxWizardPanel.this.mediaInformationFailedAttemps > 250 && ScenerixxWizardPanel.this.duplicatesFailedAttemps > 250 && ScenerixxWizardPanel.this.studiosFailedAttemps > 250 && ScenerixxWizardPanel.this.screencapFailedAttemps > 250 && ScenerixxWizardPanel.this.createSceneOrMovieFailedAttemps > 250 || ScenerixxWizardPanel.this.lesbianExisting && ScenerixxWizardPanel.this.studioExisting && ScenerixxWizardPanel.this.tagsExisting && ScenerixxWizardPanel.this.soloExisting && ScenerixxWizardPanel.this.allPersonsExisting && !ScenerixxWizardPanel.this.stillIndexing)) {
                    this.publish(Figlets.sFinished);
                    LOG.info("That's it.......");
                    this.publish("Looks like all threads have finished.");
                    ScenerixxWizardPanel.this.toggleAbort(true);
                    if (ScenerixxWizardPanel.this.optionsPanel.cbStartDuplicateFinder.isSelected()) {
                        this.publish("We are done with the indexing.");
                        this.publish("We will start now the duplicate finder.");
                        if (!ScenerixxWizardPanel.this.lbqScreencap.isEmpty()) {
                            this.publish("We need to wait till all screencaps are generated. There are still " + ScenerixxWizardPanel.this.lbqScreencap.size() + " screencaps to be generated.");
                            LOG.info("We need to wait till all screencaps are generated. There are still " + ScenerixxWizardPanel.this.lbqScreencap.size() + " screencaps to be generated.");
                            while (!ScenerixxWizardPanel.this.lbqScreencap.isEmpty()) {
                                Thread.sleep(5000L);
                                this.publish("Still waiting for " + ScenerixxWizardPanel.this.lbqScreencap.size() + " screencaps");
                                LOG.info("Still waiting for " + ScenerixxWizardPanel.this.lbqScreencap.size() + " screencaps");
                            }
                        }
                        dupFinderStarted = true;
                        LocalDateTime indexingStartedAt = this.starttime;
                        int diffInSeconds = 0;
                        double threshold = 18.0;
                        if (!ScenerixxWizardPanel.this.optionsPanel.tfDuplicateFinderDiffInSeconds.getText().isBlank()) {
                            try {
                                diffInSeconds = Integer.parseInt(ScenerixxWizardPanel.this.optionsPanel.tfDuplicateFinderDiffInSeconds.getText());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!ScenerixxWizardPanel.this.optionsPanel.tfDuplicateFinderThreshold.getText().isBlank()) {
                            try {
                                threshold = Double.parseDouble(ScenerixxWizardPanel.this.optionsPanel.tfDuplicateFinderThreshold.getText());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        LOG.info("Start duplicate finder");
                        double tmpThreshold = threshold;
                        int tmpDiffInSeconds = diffInSeconds;
                        String path = null;
                        if (ScenerixxWizardPanel.this.optionsPanel.cbSelectedFolderOnly.isSelected()) {
                            if (ScenerixxWizardPanel.this.optionsPanel.jFileChooser1.getSelectedFile() != null) {
                                path = ScenerixxWizardPanel.this.optionsPanel.jFileChooser1.getSelectedFile().getAbsolutePath();
                            } else {
                                LOG.info("No directory provided. Use null");
                            }
                        } else {
                            path = null;
                        }
                        String tmpPath = path;
                        LOG.info("path: " + path);
                        SwingUtilities.invokeLater(() -> ScenerixxWizardPanel.this.indexingTopComponent.startFindDuplicatesExternally(indexingStartedAt, tmpThreshold, tmpDiffInSeconds, tmpPath, ScenerixxWizardPanel.this.optionsPanel.cbShutdown.isSelected()));
                    } else {
                        LOG.info("ask to close wizard. Duplicate finder: " + ScenerixxWizardPanel.this.optionsPanel.cbStartDuplicateFinder.isSelected());
                        ScenerixxWizardPanel.this.askToClose();
                    }
                }
                if (!ScenerixxWizardPanel.this.hashingExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqHashing.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.hashingExecuting.set(true);
                        LOG.finer("execute hashing thread");
                        poll.execute();
                        sleepHashing = 500;
                    } else {
                        LOG.finer("hashing sleep: " + sleepHashing + " - failed attempts: " + ScenerixxWizardPanel.this.hashingFailedAttemps);
                        ++ScenerixxWizardPanel.this.hashingFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepHashing);
                    sleepHashing += 50;
                }
                if (!ScenerixxWizardPanel.this.mediaInformationExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqMediaInformation.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.mediaInformationExecuting.set(true);
                        LOG.finer("execute media information thread");
                        poll.execute();
                        sleepMediaInformation = 500;
                    } else {
                        LOG.finer("media information sleep: " + sleepMediaInformation + " - failed attempts: " + ScenerixxWizardPanel.this.mediaInformationFailedAttemps);
                        ++ScenerixxWizardPanel.this.mediaInformationFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepMediaInformation);
                    sleepMediaInformation += 50;
                }
                if (!ScenerixxWizardPanel.this.duplicatesExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqDuplicates.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.duplicatesExecuting.set(true);
                        LOG.finer("execute duplicates thread");
                        poll.execute();
                        sleepDuplicates = 500;
                    } else {
                        LOG.finer("duplicates sleep: " + sleepDuplicates + " - failed attempts: " + ScenerixxWizardPanel.this.duplicatesFailedAttemps);
                        ++ScenerixxWizardPanel.this.duplicatesFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepDuplicates);
                    sleepDuplicates += 50;
                }
                if (!ScenerixxWizardPanel.this.personExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqPersons.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.personExecuting.set(true);
                        LOG.finer("execute person thread");
                        poll.execute();
                        sleepPerson = 500;
                    } else {
                        LOG.finer("person sleep: " + sleepPerson + " - failed attempts: " + ScenerixxWizardPanel.this.personFailedAttemps);
                        ++ScenerixxWizardPanel.this.personFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepPerson);
                    sleepPerson += 50;
                }
                if (!ScenerixxWizardPanel.this.studiosExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqStudios.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.studiosExecuting.set(true);
                        LOG.finer("execute studios thread");
                        poll.execute();
                        sleepStudios = 500;
                    } else {
                        LOG.finer("studio sleep: " + sleepStudios + " - failed attempts: " + ScenerixxWizardPanel.this.studiosFailedAttemps);
                        ++ScenerixxWizardPanel.this.studiosFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepStudios);
                    sleepStudios += 50;
                }
                if (!ScenerixxWizardPanel.this.screencapExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqScreencap.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.screencapExecuting.set(true);
                        LOG.finer("execute screencap thread");
                        poll.execute();
                        sleepScreencap = 500;
                    } else {
                        LOG.finer("screencap sleep: " + sleepScreencap + " - failed attempts: " + ScenerixxWizardPanel.this.screencapFailedAttemps);
                        ++ScenerixxWizardPanel.this.screencapFailedAttemps;
                    }
                } else {
                    Thread.sleep(sleepScreencap);
                    sleepScreencap += 50;
                }
                if (!ScenerixxWizardPanel.this.createSceneOrMovieExecuting.get()) {
                    poll = ScenerixxWizardPanel.this.lbqCreateSceneOrMovie.poll();
                    if (poll != null) {
                        ScenerixxWizardPanel.this.createSceneOrMovieExecuting.set(true);
                        LOG.finer("execute CreateSceneOrMovie thread");
                        poll.execute();
                        sleepCreateSceneOrMovie = 500;
                        ++this.updatingWindows;
                        continue;
                    }
                    LOG.finer("CreateSceneOrMovie sleep: " + sleepCreateSceneOrMovie + " - failed attempts: " + ScenerixxWizardPanel.this.createSceneOrMovieFailedAttemps);
                    ++ScenerixxWizardPanel.this.createSceneOrMovieFailedAttemps;
                    continue;
                }
                Thread.sleep(sleepCreateSceneOrMovie);
                sleepCreateSceneOrMovie += 50;
            }
            this.publish(ScenerixxWizardPanel.this.updateStatistic);
            if (ScenerixxWizardPanel.this.failedFiles.size() > 0) {
                this.publish(Figlets.sErrors);
                this.publish(ScenerixxWizardPanel.this.failedFiles.size() + " files could not get imported. Probably because of some strange characters in the filename:");
                int i = 1;
                for (String failed : ScenerixxWizardPanel.this.failedFiles) {
                    this.publish(i++ + ". " + failed);
                }
            }
            LOG.info("stopped all threads");
            if (dupFinderStarted) {
                this.publish(Figlets.sFindDuplicates);
                this.publish("We are done with all the wizardry stuff. We continue in the other window (Indexing, Hashing, Purging) with the Duplicate Finder");
            } else {
                this.publish(Figlets.sFinished);
                this.publish("We are done here. We just wait a second to finish all threads. Have fun.");
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                if (s.equals(ScenerixxWizardPanel.this.updateStatistic)) {
                    Object status = "<html>What we've got so far:<br><br>";
                    if (ScenerixxWizardPanel.this.indexingCounter > 0) {
                        status = (String)status + "we indexed " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.indexingCounter, "file", true) + "<br>";
                    }
                    if (ScenerixxWizardPanel.this.movieFilesCounter > 0) {
                        status = (String)status + "from the indexed " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.movieFilesCounter, "file", false) + " " + ScenerixxWizardPanel.this.movieFilesCounter + " are movie files<br>";
                    }
                    if (ScenerixxWizardPanel.this.hashingCounter > 0) {
                        status = (String)status + "hashed " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.hashingCounter, "file", true) + "<br>";
                        LOG.fine("lbqHashing : " + ScenerixxWizardPanel.this.lbqHashing.size());
                    }
                    if (ScenerixxWizardPanel.this.mediaInformationCounter > 0) {
                        status = (String)status + "retrieved the runtime of " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.mediaInformationCounter, "movie", true) + "<br>";
                        LOG.fine("lbqMediaInformation : " + ScenerixxWizardPanel.this.lbqMediaInformation.size());
                    }
                    if (ScenerixxWizardPanel.this.screencapCounter > 0) {
                        status = (String)status + "generated " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.screencapCounter, "screencap", true) + " <br>";
                        LOG.fine("lbqScreencap : " + ScenerixxWizardPanel.this.lbqScreencap.size());
                    }
                    if (ScenerixxWizardPanel.this.createMovieCounter > 0) {
                        status = (String)status + "created " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.createMovieCounter, "movie", true) + "<br>";
                    }
                    if (ScenerixxWizardPanel.this.createSceneCounter > 0) {
                        status = (String)status + "added " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.createSceneCounter, "scene", true) + " to movies<br>";
                        LOG.fine("lbqCreateSceneOrMovie : " + ScenerixxWizardPanel.this.lbqCreateSceneOrMovie.size());
                    }
                    if (ScenerixxWizardPanel.this.duplicatesCounter > 0) {
                        status = (String)status + "detected " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.duplicatesCounter, "duplicate", true) + "<br>";
                    }
                    if (ScenerixxWizardPanel.this.personCounter > 0) {
                        status = (String)status + "imported the data of " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.personCounter, "person", true) + "<br>";
                        LOG.fine("lbqPersons : " + ScenerixxWizardPanel.this.lbqPersons.size());
                    }
                    if (ScenerixxWizardPanel.this.studiosCounter > 0) {
                        status = (String)status + "imported the data of " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.studiosCounter, "studio", true) + "<br>";
                        LOG.fine("lbqStudios : " + ScenerixxWizardPanel.this.lbqStudios.size());
                    }
                    if (ScenerixxWizardPanel.this.studioSetCounter > 0) {
                        status = (String)status + "assigned " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.studioSetCounter, "studio", true) + " to movies<br>";
                    }
                    if (ScenerixxWizardPanel.this.vrCounter > 0) {
                        status = (String)status + "marked " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.vrCounter, "scene", true) + " as a VR scene<br>";
                    }
                    if (ScenerixxWizardPanel.this.soloCounter > 0) {
                        status = (String)status + "assigned " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.soloCounter, "person", true) + " to a solo scene<br>";
                    }
                    if (ScenerixxWizardPanel.this.lesbianCounter > 0) {
                        status = (String)status + "assigned persons to " + ScenerixxWizardPanel.this.lesbianCounter + " lesbian " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.lesbianCounter, "scene", false) + "<br>";
                    }
                    if (ScenerixxWizardPanel.this.allPersonsCounter > 0) {
                        status = (String)status + "assigned " + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.allPersonsCounter, "person", true) + " to scenes<br>";
                    }
                    if (ScenerixxWizardPanel.this.multiFileCounter > 0) {
                        status = (String)status + ScenerixxCommon.singularPlural(ScenerixxWizardPanel.this.multiFileCounter, "multi file movie", true) + " detected<br>";
                    }
                    if (ScenerixxWizardPanel.this.onceDeletedCounter > 0) {
                        status = (String)status + "files detected that have been already deleted: " + ScenerixxWizardPanel.this.onceDeletedCounter + "<br>";
                    }
                    status = (String)status + "<br>Queues status:<br>";
                    status = (String)status + "Hashing queue: " + ScenerixxWizardPanel.this.lbqHashing.size() + "<br>";
                    status = (String)status + "Media information queue: " + ScenerixxWizardPanel.this.lbqMediaInformation.size() + "<br>";
                    status = (String)status + "Duplicates queue: " + ScenerixxWizardPanel.this.lbqDuplicates.size() + "<br>";
                    status = (String)status + "Studios queue: " + ScenerixxWizardPanel.this.lbqStudios.size() + "<br>";
                    status = (String)status + "Persons queue: " + ScenerixxWizardPanel.this.lbqPersons.size() + "<br>";
                    status = (String)status + "Screencaps queue: " + ScenerixxWizardPanel.this.lbqScreencap.size() + "<br>";
                    status = (String)status + "Create movies queue: " + ScenerixxWizardPanel.this.lbqCreateSceneOrMovie.size() + "<br>";
                    status = (String)status + "<br>Passed time: " + ScenerixxCommon.readableTimeDifference(this.starttime, LocalDateTime.now()) + "<br>";
                    if (ScenerixxWizardPanel.this.createMovieCounter > 0) {
                        long diffInMillis = Math.abs(Duration.between(this.starttime, LocalDateTime.now()).toMillis());
                        long diffSeconds = TimeUnit.SECONDS.convert(diffInMillis, TimeUnit.MILLISECONDS);
                        long diffSecondsPerMovie = diffSeconds / (1L * (long)ScenerixxWizardPanel.this.createMovieCounter);
                        long secondsLeft = (long)(ScenerixxWizardPanel.this.movieFilesCounter - ScenerixxWizardPanel.this.createMovieCounter) * diffSecondsPerMovie;
                        long diffSecondsPerScreencap = 1L;
                        if (ScenerixxWizardPanel.this.screencapCounter > 0) {
                            diffSecondsPerScreencap = diffSeconds / (1L * (long)ScenerixxWizardPanel.this.screencapCounter);
                        }
                        long secondsLeftScreencap = (long)(ScenerixxWizardPanel.this.movieFilesCounter - ScenerixxWizardPanel.this.screencapCounter) * diffSecondsPerScreencap;
                        LOG.fine("diffSecondsPerScreencap " + diffSecondsPerScreencap + " secondsLeftScreencap " + secondsLeftScreencap);
                        long remainingTime = Math.max(diffSecondsPerScreencap, secondsLeft);
                        LOG.fine(" avg. seconds per movie: " + diffSecondsPerMovie + " - Seconds left: " + secondsLeft + " - still indexing: " + ScenerixxWizardPanel.this.stillIndexing + " - createMovieCounter: " + ScenerixxWizardPanel.this.createMovieCounter);
                        status = (String)status + "Approx. time left: " + ScenerixxCommon.readableRuntime(remainingTime) + "<br>";
                        double percentage = (double)(ScenerixxWizardPanel.this.createMovieCounter + ScenerixxWizardPanel.this.duplicatesCounter + ScenerixxWizardPanel.this.onceDeletedCounter) / (double)ScenerixxWizardPanel.this.movieFilesCounter * 100.0;
                        status = (String)status + "Processed movie files: " + String.format("%,.2f", percentage) + "% (" + (ScenerixxWizardPanel.this.createMovieCounter + ScenerixxWizardPanel.this.duplicatesCounter + ScenerixxWizardPanel.this.onceDeletedCounter) + "/" + ScenerixxWizardPanel.this.movieFilesCounter + ")";
                        if (ScenerixxWizardPanel.this.alreadyProcessedFiles.size() > 0) {
                            status = (String)status + " (" + ScenerixxWizardPanel.this.alreadyProcessedFiles.size() + ")";
                        }
                        status = (String)status + "<br><br>";
                    }
                    status = (String)status + "</html>";
                    ScenerixxWizardPanel.this.lbStatus.setText((String)status);
                    continue;
                }
                ScenerixxWizardPanel.this.taLog.append("[" + ScenerixxWizardPanel.this.df.format(LocalDateTime.now()) + "] " + s + "\n");
            }
        }
    }

    public class CheckForLesbiansExistingDataWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            List movies = ScenerixxWizardPanel.this.db.getMovies(Scenerixx.unlocked);
            for (Movie movie : movies) {
                MediumFile mf;
                Medium medium;
                if (ScenerixxWizardPanel.this.abort) break;
                if (movie.getScenes().size() != 1 || !((Scene)movie.getScenes().get(0)).getPersons(Scenerixx.unlocked).isEmpty() || movie.getStartMedium() == null || !((medium = movie.getStartMedium()) instanceof MediumFile) || !(mf = (MediumFile)medium).getFileName().toLowerCase().contains("#lesbian")) continue;
                this.publish(mf.getFileName() + " seems to be a lesbian scene. Let's see if we can find the right persons.");
                List persons = DB.getInstance().getPersons(Gender.FEMALE, false, true);
                LOG.finer("Checking " + persons.size() + " persons");
                ArrayList<Person> tmpPerson = new ArrayList<Person>();
                for (Person p : persons) {
                    LOG.finer("Checking lesbian: " + p.getName());
                    if (p.getName().length() < 4) {
                        LOG.info("Ignoring " + p.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p.getName())) continue;
                    this.publish("Consider '" + p.getName() + "' for '" + movie.getTitle() + "'");
                    tmpPerson.add(p);
                }
                this.publish("Found " + tmpPerson.size() + " persons we could consider. We need at least 2.");
                if (tmpPerson.size() < 2) continue;
                for (Person p : tmpPerson) {
                    SceneDetails sd = new SceneDetails();
                    sd.setDateOfCreation(LocalDateTime.now());
                    sd.setScene((Scene)movie.getScenes().get(0));
                    sd.setPerson(p);
                    ((Scene)movie.getScenes().get(0)).getDetails().add(sd);
                }
                movie.setWizardGenerated(true);
                DB.getInstance().getEntityService().save((AbstractEntity)movie);
                this.publish("Added " + tmpPerson.size() + " persons to " + movie.getTitle());
                ++ScenerixxWizardPanel.this.lesbianCounter;
            }
            ScenerixxWizardPanel.this.lesbianExisting = true;
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class CheckForSoloExistingDataWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            List movies = ScenerixxWizardPanel.this.db.getMovies(Scenerixx.unlocked);
            block0: for (Movie movie : movies) {
                MediumFile mf;
                Medium medium;
                if (ScenerixxWizardPanel.this.abort) break;
                if (movie.getScenes().size() != 1 || !((Scene)movie.getScenes().get(0)).getPersons(Scenerixx.unlocked).isEmpty() || movie.getStartMedium() == null || !((medium = movie.getStartMedium()) instanceof MediumFile) || !(mf = (MediumFile)medium).getFileName().toLowerCase().contains("#solo")) continue;
                this.publish(mf.getFileName() + " seems to be a solo scene. Let's see if we can find the right person.");
                List persons = DB.getInstance().getPersons(true);
                LOG.finer("Checking " + persons.size() + " persons");
                for (Person p : persons) {
                    LOG.finer("Checking solo: " + p.getName());
                    if (p.getName().length() < 4) {
                        LOG.info("Ignoring " + p.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p.getName())) continue;
                    LOG.info(p.getName() + " fits for '" + movie.getTitle() + "'");
                    LOG.info("[check solo persons] 1. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                    Scene scene = (Scene)movie.getScenes().get(0);
                    SceneDetails sd = new SceneDetails();
                    sd.setDateOfCreation(LocalDateTime.now());
                    sd.setPerson(p);
                    sd.setScene((Scene)movie.getScenes().get(0));
                    ((Scene)movie.getScenes().get(0)).getDetails().add(sd);
                    movie.setWizardGenerated(true);
                    movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                    this.publish("Added '" + p.getName() + "' to '" + movie.getTitle() + "'");
                    ++ScenerixxWizardPanel.this.soloCounter;
                    LOG.info("2. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                    continue block0;
                }
            }
            ScenerixxWizardPanel.this.soloExisting = true;
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class CheckForAllPersonsExistingDataWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            List movies = ScenerixxWizardPanel.this.db.getMovies(Scenerixx.unlocked);
            List persons = DB.getInstance().getPersons(true);
            for (Movie movie : movies) {
                Object object;
                if (ScenerixxWizardPanel.this.abort) break;
                if (movie.getScenes().size() != 1 || movie.getStartMedium() == null || !((object = movie.getStartMedium()) instanceof MediumFile)) continue;
                MediumFile mf = (MediumFile)object;
                this.publish("Checking for persons for: " + mf.getFileName());
                LOG.finer("Checking " + persons.size() + " persons");
                object = persons.iterator();
                while (object.hasNext()) {
                    Person p = (Person)object.next();
                    LOG.finer("Checking: " + p.getName());
                    if (p.getName().length() < 4) {
                        LOG.finer("Ignoring " + p.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p.getName()) || ((Scene)movie.getScenes().get(0)).getPersons(Scenerixx.unlocked).contains(p)) continue;
                    LOG.info(p.getName() + " fits for '" + movie.getTitle() + "'");
                    LOG.info("[existing persons] 1. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                    SceneDetails sd = new SceneDetails();
                    sd.setDateOfCreation(LocalDateTime.now());
                    sd.setPerson(p);
                    sd.setScene((Scene)movie.getScenes().get(0));
                    ((Scene)movie.getScenes().get(0)).getDetails().add(sd);
                    movie.setWizardGenerated(true);
                    movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                    this.publish("Added '" + p.getName() + "' to '" + movie.getTitle() + "'");
                    LOG.info("Added '" + p.getName() + "' to '" + movie.getTitle() + "'");
                    ++ScenerixxWizardPanel.this.allPersonsCounter;
                    LOG.info("2. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                }
            }
            ScenerixxWizardPanel.this.allPersonsExisting = true;
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class CheckForStudioExistingDataWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            List movies = ScenerixxWizardPanel.this.db.getMovies(Scenerixx.unlocked);
            List studios = ScenerixxWizardPanel.this.db.getStudios();
            block0: for (Movie movie : movies) {
                if (ScenerixxWizardPanel.this.abort) break;
                if (movie.getStudio() != null || movie.getStartMedium() == null || !(movie.getStartMedium() instanceof MediumFile)) continue;
                MediumFile mf = (MediumFile)movie.getStartMedium();
                this.publish("Checking for studio for movie '" + movie.getNameOfPlayable() + "'. Search through " + studios.size() + " studios.");
                for (Studio studio : studios) {
                    if (ScenerixxWizardPanel.this.isBlacklistedStudio(studio) || !ScenerixxWizardPanel.this.checkForStudioNameAndAlternatives(studio.getName(), mf.getFileName())) continue;
                    this.publish("Found " + studio.getName() + " for movie '" + movie.getTitle() + "'.");
                    movie.setStudio(studio);
                    movie.setWizardGenerated(true);
                    movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                    ++ScenerixxWizardPanel.this.studioSetCounter;
                    continue block0;
                }
            }
            ScenerixxWizardPanel.this.studioExisting = true;
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class CheckForTagsExistingDataWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            List movies = ScenerixxWizardPanel.this.db.getMovies(Scenerixx.unlocked);
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTags.isSelected()) {
                for (Movie movie : movies) {
                    if (!ScenerixxWizardPanel.this.abort) {
                        if (movie.getStartMedium() == null || !(movie.getStartMedium() instanceof MediumFile)) continue;
                        MediumFile mf = (MediumFile)movie.getStartMedium();
                        Movie movie2 = ScenerixxWizardPanel.this.applyTags(movie, mf.getFileCompletePath(), true);
                        continue;
                    }
                    break;
                }
            } else {
                this.publish("Do not check for tags. If you want to check for tags select the checkbox");
            }
            ScenerixxWizardPanel.this.tagsExisting = true;
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class IndexingWorker
    extends SwingWorker<String, String> {
        private Long currentIndex = 0L;
        private Long totalSize = 0L;
        private Long indexedSize = 0L;
        private Long fileCounter = 0L;
        private int maxDepth = 1;
        private String finished_indexing = "Finished indexing.\n";
        private boolean queuesStarted = false;
        private File[] directories;

        public IndexingWorker(File[] directories) {
            this.directories = directories;
            ScenerixxWizardPanel.this.stillIndexing = true;
        }

        @Override
        protected String doInBackground() throws Exception {
            Stream<Path> paths;
            String rootFolder;
            ScenerixxWizardPanel.this.toggleAbort(false);
            block16: for (File directory : this.directories) {
                rootFolder = directory.getPath();
                this.publish("Start indexing. Root directory: " + rootFolder);
                this.publish("Calculating total size to index.");
                this.maxDepth = Integer.MAX_VALUE;
                try {
                    paths = Files.walk(Paths.get(rootFolder, new String[0]), this.maxDepth, new FileVisitOption[0]);
                    try {
                        for (Path filePath : paths.collect(Collectors.toList())) {
                            if (!ScenerixxWizardPanel.this.abort) {
                                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                                this.totalSize = this.totalSize + filePath.toFile().length();
                                Long l = this.fileCounter;
                                this.fileCounter = this.fileCounter + 1L;
                                continue;
                            }
                            this.publish("User requested to abort indexing.\n");
                            continue block16;
                        }
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            }
            this.publish("We are going to index " + this.fileCounter + " files. A total of " + ScenerixxCommon.readableFileSize(this.totalSize) + "\n");
            block18: for (File directory : this.directories) {
                rootFolder = directory.getPath();
                try {
                    paths = Files.walk(Paths.get(rootFolder, new String[0]), this.maxDepth, new FileVisitOption[0]);
                    try {
                        for (Path filePath : paths.sorted(Comparator.comparingLong(path -> path.toFile().length()).reversed()).collect(Collectors.toList())) {
                            if (!ScenerixxWizardPanel.this.abort) {
                                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                                String[] stringArray = new String[1];
                                this.currentIndex = this.currentIndex + 1L;
                                stringArray[0] = "[" + this.currentIndex + "/" + this.fileCounter + "] Indexing " + filePath.toString();
                                this.publish(stringArray);
                                long mfCount = -1L;
                                try {
                                    mfCount = ScenerixxWizardPanel.this.getDB().getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.fileCompletePath.eq((Object)filePath.toString())).count();
                                }
                                catch (Exception ex) {
                                    ScenerixxWizardPanel.this.failedFiles.add(filePath.toString());
                                    LOG.severe("Skipping file due to an error: " + String.valueOf(filePath));
                                    ex.printStackTrace();
                                    continue;
                                }
                                if (mfCount == 0L) {
                                    MediumFileService mfs = new MediumFileService();
                                    MediumFile mf = mfs.addNewMediumFileToIndex(filePath);
                                    ++ScenerixxWizardPanel.this.indexingCounter;
                                    if (MediumFileService.isMovie((MediumFile)mf)) {
                                        ++ScenerixxWizardPanel.this.movieFilesCounter;
                                    }
                                    LOG.finer("Add working threads");
                                    ScenerixxWizardPanel.this.lbqHashing.add(new HashingWorker(mf));
                                    ScenerixxWizardPanel.this.lbqMediaInformation.add(new UpdateMediaInformationWorker(mf));
                                    ScenerixxWizardPanel.this.lbqPersons.add(new CheckForPersonsToImportWorker(mf));
                                    if (!this.queuesStarted) {
                                        this.queuesStarted = true;
                                        new QueueWorker().execute();
                                    }
                                } else {
                                    this.publish("Skip indexing. " + String.valueOf(filePath.toFile()) + " is already known.");
                                }
                                this.indexedSize = this.indexedSize + filePath.toFile().length();
                                ScenerixxWizardPanel.this.hashingFailedAttemps = 0;
                                ScenerixxWizardPanel.this.mediaInformationFailedAttemps = 0;
                                ScenerixxWizardPanel.this.duplicatesFailedAttemps = 0;
                                ScenerixxWizardPanel.this.personFailedAttemps = 0;
                                ScenerixxWizardPanel.this.studiosFailedAttemps = 0;
                                ScenerixxWizardPanel.this.screencapFailedAttemps = 0;
                                ScenerixxWizardPanel.this.createSceneOrMovieFailedAttemps = 0;
                                continue;
                            }
                            this.publish("User requested to abort indexing.\n");
                            ScenerixxWizardPanel.this.stillIndexing = false;
                            continue block18;
                        }
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            }
            ScenerixxWizardPanel.this.stillIndexing = false;
            this.publish("We indexed " + this.currentIndex + " files (" + ScenerixxCommon.readableFileSize(this.indexedSize) + ")\n");
            this.publish(this.finished_indexing);
            if (!this.queuesStarted) {
                LOG.info("Queues are empty. Abort.");
                this.showFailedFiles();
                ScenerixxWizardPanel.this.toggleAbort(true);
                ScenerixxWizardPanel.this.askToClose();
            }
            return null;
        }

        private void showFailedFiles() {
            if (ScenerixxWizardPanel.this.failedFiles.size() > 0) {
                this.publish(Figlets.sErrors);
                this.publish(ScenerixxWizardPanel.this.failedFiles.size() + " files could not get imported. Probably because of some strange characters in the filename:");
                int i = 1;
                for (String failed : ScenerixxWizardPanel.this.failedFiles) {
                    this.publish(i++ + ". " + failed);
                }
            }
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }
    }

    public class UpdateTutorialWorker
    extends SwingWorker<String, String> {
        private List<String> tipps = new ArrayList<String>();
        private int index = 0;

        public UpdateTutorialWorker() {
            this.tipps.add("CTRL+Insert adds an entity to the <br>default playlist");
            this.tipps.add("ALT+A adds a person to the currently <br>selected scene");
            this.tipps.add("ALT+[0-9] opens directly a window");
            this.tipps.add("CTRL+1 opens the statistic window");
            this.tipps.add("With F6 you can put a playable on a <br>temporary playlist which gets discarded on shutdown.");
            this.tipps.add("ScenerixxHub lets you use your collection <br>on other devices");
            this.tipps.add("A right click on most nodes opens a context menu");
            this.tipps.add("prefixing a searchterm with two <br>dashes (--) excludes this term from the search");
            this.tipps.add("CTRL+Space opens an autocompleter on the <br>search text fields");
        }

        @Override
        protected String doInBackground() throws Exception {
            Collections.shuffle(this.tipps);
            while (!ScenerixxWizardPanel.this.abort) {
                this.publish(this.tipps.get(this.index));
                ++this.index;
                if (this.index >= this.tipps.size() - 1) {
                    this.index = 0;
                }
                Thread.sleep(20000L);
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                ScenerixxWizardPanel.this.lbTitle.setText("<html>" + s + "</html>");
            }
        }
    }

    public class CheckForDuplicatesWorker
    extends SwingWorker<String, String> {
        private MediumFile mf;

        public CheckForDuplicatesWorker(MediumFile mf) {
            this.mf = mf;
        }

        @Override
        protected String doInBackground() throws Exception {
            List mediumFiles = ScenerixxWizardPanel.this.getDB().getMediumFiles(true);
            HashMap x = new HashMap();
            for (MediumFile tmpmf : mediumFiles) {
                if (tmpmf.getHashValue() == null) continue;
                if (!x.containsKey(tmpmf.getHashValue())) {
                    x.put(tmpmf.getHashValue(), new ArrayList());
                }
                if (!MediumFileService.isMovie((MediumFile)tmpmf)) continue;
                ((List)x.get(tmpmf.getHashValue())).add(tmpmf);
            }
            ArrayList result = new ArrayList();
            for (Map.Entry next : x.entrySet()) {
                if (((List)next.getValue()).size() <= 1) continue;
                result.addAll((Collection)next.getValue());
            }
            boolean duplicate = false;
            for (MediumFile tmpMf : result) {
                if (!tmpMf.getId().equals(this.mf.getId())) continue;
                duplicate = true;
            }
            if (duplicate) {
                LOG.info("duplicate: " + this.mf.getFileName());
                this.publish("'" + this.mf.getFileName() + "' is a duplicate (" + this.mf.getHashValue() + "). We will not create a movie entity for it.");
                ++ScenerixxWizardPanel.this.duplicatesCounter;
            } else {
                this.publish(this.mf.getFileName() + " is not a duplicate, try to create movie entity.");
                if (ScenerixxWizardPanel.this.optionsPanel.cbCheckForMultifileMovies.isSelected()) {
                    Thread.sleep(1500L);
                }
                ScenerixxWizardPanel.this.lbqCreateSceneOrMovie.add(new CreateSceneOrMovieAndPersonsWorker(this.mf));
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("check for duplicates thread finished");
            ScenerixxWizardPanel.this.duplicatesExecuting.set(false);
        }
    }

    public class CreateSceneOrMovieAndPersonsWorker
    extends SwingWorker<String, String> {
        private MediumFile mf;
        private ScenerixxSettings settings;

        public CreateSceneOrMovieAndPersonsWorker(MediumFile mf) {
            this.settings = ScenerixxWizardPanel.this.getDB().getScenerixxSettings();
            this.mf = mf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String doInBackground() throws Exception {
            CreateSceneOrMovieAndPersonsWorker createSceneOrMovieAndPersonsWorker = this;
            synchronized (createSceneOrMovieAndPersonsWorker) {
                if (ScenerixxWizardPanel.this.optionsPanel.cbCheckForMultifileMovies.isSelected()) {
                    String rootPath = new File(this.mf.getFileCompletePath()).getParentFile().getAbsolutePath();
                    try (Stream<Path> paths = Files.walk(Paths.get(rootPath, new String[0]), 1, new FileVisitOption[0]);){
                        List allFilePaths = paths.collect(Collectors.toList());
                        this.log("Current root path: " + rootPath + " - Paths to check: " + allFilePaths.size());
                        Path filePath = Path.of(this.mf.getFileCompletePath(), new String[0]);
                        if (!ScenerixxWizardPanel.this.abort) {
                            if (!this.checkForMultiFileDirectory(Paths.get(rootPath, new String[0]))) {
                                this.checkForDiscOrCd(filePath);
                            }
                        } else {
                            this.publish(Figlets.sAborted);
                            this.publish("User requested to abort.\n");
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                    }
                } else {
                    this.publish(this.mf.getFileCompletePath() + " was not a multi file movie. Process normally.");
                    if (MediumFileService.isMovie((MediumFile)this.mf)) {
                        this.createMovieEntity(this.mf);
                    }
                }
                EventQueue.invokeLater(() -> {
                    if (ScenerixxWizardPanel.this.db.getMovies(true).size() < 75) {
                        AbstractTopComponent.reloadMovieList();
                    } else {
                        AbstractTopComponent.dirtyMovieList();
                    }
                    AbstractTopComponent.dirtyMediumFileList();
                });
            }
            return null;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private synchronized boolean checkForMultiFileDirectory(Path filePath) throws IOException {
            boolean wasMultiFile = false;
            long filesCount = Files.walk(Paths.get(filePath.toString(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).count();
            this.log("check how many files are in the directory '" + filePath.toString() + "' (max. allowed: " + ScenerixxWizardPanel.this.db.getScenerixxSettings().getWizardMultifileMaxFilesPerDir() + "): " + filesCount);
            if (filesCount > 1L && filesCount <= (long)ScenerixxWizardPanel.this.db.getScenerixxSettings().getWizardMultifileMaxFilesPerDir()) {
                wasMultiFile = true;
                ArrayList<MediumFile> mfs = new ArrayList<MediumFile>();
                try (Stream<Path> localpaths = Files.walk(Paths.get(filePath.toString(), new String[0]), 1, new FileVisitOption[0]);){
                    Iterator localAllFilePaths = localpaths.collect(Collectors.toList());
                    this.log("localallfilepaths: " + String.valueOf(filePath) + " " + localAllFilePaths.size());
                    localAllFilePaths.sort(Comparator.comparing(o -> new File(o.toString()).getName().toUpperCase()));
                    Iterator iterator = localAllFilePaths.iterator();
                    while (iterator.hasNext()) {
                        Path fp = (Path)iterator.next();
                        this.log("Processing! mf: " + String.valueOf(this.mf) + " - " + (!Files.isDirectory(fp, LinkOption.NOFOLLOW_LINKS) && MediumFileService.isMovie((MediumFile)this.mf)) + " ==> " + fp.toString());
                        if (ScenerixxWizardPanel.this.alreadyProcessedFiles.contains(fp.toString())) {
                            this.log(String.valueOf(fp) + " was already processed. Check next.");
                            continue;
                        }
                        this.log("medium file is movie: " + MediumFileService.isMovie((MediumFile)this.mf) + " - " + fp.toFile().getAbsolutePath() + " is movie: " + MediumFileService.isMovie((String)fp.toFile().getAbsolutePath()));
                        if (Files.isDirectory(fp, LinkOption.NOFOLLOW_LINKS)) continue;
                        File toFile = fp.toFile();
                        if (MediumFileService.isMovie((String)toFile.getAbsolutePath())) {
                            this.log("toFile.getName(): " + toFile.getName() + " - parent: " + toFile.getParentFile().getName() + " - diff: " + (toFile.getName().length() - toFile.getParentFile().getName().length()) + " - allowed diff: " + ScenerixxWizardPanel.this.db.getScenerixxSettings().getWizardMultifileCharDiff());
                            if (toFile.getName().toLowerCase().contains(toFile.getParentFile().getName().toLowerCase()) && toFile.getName().length() - toFile.getParentFile().getName().length() <= ScenerixxWizardPanel.this.db.getScenerixxSettings().getWizardMultifileCharDiff()) {
                                this.log("search for medium file of: " + fp.toFile().getName());
                                MediumFile find = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(fx -> fx.fileCompletePath.eq((Object)fp.toFile().getAbsolutePath())).findFirst();
                                int waitCounter = 0;
                                while (find.getHashValue() == null && !ScenerixxWizardPanel.this.abort) {
                                    this.log("[MULTIFILEDIR] '" + this.mf.getFileName() + "' waits for other file ('" + find.getFileCompletePath() + "') to hash - sleep (" + waitCounter + "): " + ScenerixxWizardPanel.this.currentHashingDirectory);
                                    ++waitCounter;
                                    find = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(fx -> fx.fileCompletePath.eq((Object)fp.toFile().getAbsolutePath())).findFirst();
                                    if (find.getHashValue() != null) break;
                                    if (waitCounter <= 100) continue;
                                    this.log("Re-queue " + String.valueOf(this.mf));
                                    ScenerixxWizardPanel.this.lbqHashing.addFirst(new HashingWorker(this.mf));
                                    boolean bl = wasMultiFile;
                                    return bl;
                                }
                                if (find.getHashValue() != null) {
                                    mfs.add(find);
                                    continue;
                                }
                                this.log("A hash value of a file could not be obtained in time. Abort creation of " + this.mf.getFileCompletePath());
                                continue;
                            }
                            this.log("was not a multi file");
                            wasMultiFile = false;
                            break;
                        }
                        this.log("We skip " + toFile.getAbsolutePath() + " because it's not a movie");
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
                if (wasMultiFile) {
                    this.log("seems to be a multi file");
                    if (!mfs.isEmpty()) {
                        Collections.sort(mfs, new MediumFileComparator(this));
                        boolean processed = true;
                        for (MediumFile mf : mfs) {
                            if (!MediumFileService.isMovie((MediumFile)mf) || ScenerixxWizardPanel.this.alreadyProcessedFiles.contains(mf.getFileCompletePath())) continue;
                            processed = false;
                            break;
                        }
                        if (processed) {
                            this.log("All files of the multi file movie were already processed. Skip. " + ((MediumFile)mfs.get(0)).getFileCompletePath());
                            return wasMultiFile;
                        }
                        if (mfs.size() > 1) {
                            this.log("Creating movie with " + mfs.size() + " medium files");
                            for (MediumFile mf : mfs) {
                                ScenerixxWizardPanel.this.alreadyProcessedFiles.add(mf.getFileCompletePath());
                            }
                            MediumFile first = (MediumFile)mfs.get(0);
                            this.createMovieEntity(first, mfs.subList(1, mfs.size()));
                            ++ScenerixxWizardPanel.this.multiFileCounter;
                        } else if (mfs.size() == 1 && MediumFileService.isMovie((MediumFile)this.mf)) {
                            this.log("Creating movie with 1 medium file");
                            ScenerixxWizardPanel.this.alreadyProcessedFiles.add(((MediumFile)mfs.get(0)).getFileCompletePath());
                            this.createMovieEntity((MediumFile)mfs.get(0));
                        }
                    } else {
                        this.log("medium files are either missing or already processed");
                    }
                }
            }
            return wasMultiFile;
        }

        private synchronized void checkForDiscOrCd(Path filePath) {
            String discOrCd = null;
            String discOrCdWithIndex = null;
            int lastIndexOfDiscOrCd = -1;
            if (filePath.toFile().getName().toLowerCase().contains("disc")) {
                lastIndexOfDiscOrCd = filePath.toAbsolutePath().toString().toLowerCase().lastIndexOf("disc");
                discOrCd = filePath.toAbsolutePath().toString().substring(lastIndexOfDiscOrCd, lastIndexOfDiscOrCd + "disc".length());
                discOrCdWithIndex = filePath.toAbsolutePath().toString().substring(lastIndexOfDiscOrCd, lastIndexOfDiscOrCd + "disc".length() + 1);
            } else if (filePath.toFile().getName().toLowerCase().contains("cd")) {
                lastIndexOfDiscOrCd = filePath.toAbsolutePath().toString().toLowerCase().lastIndexOf("cd");
                discOrCd = filePath.toAbsolutePath().toString().substring(lastIndexOfDiscOrCd, lastIndexOfDiscOrCd + "CD".length());
                discOrCdWithIndex = filePath.toAbsolutePath().toString().substring(lastIndexOfDiscOrCd, lastIndexOfDiscOrCd + "CD".length() + 1);
            }
            if (discOrCd != null) {
                String tmpStringWithIndexOne;
                String filename = filePath.toFile().getName();
                this.log("found '" + discOrCd + "' in: " + filename);
                ArrayList<String> multiFiles = new ArrayList<String>();
                int oldIndex = 1;
                int newIndex = 2;
                String tmpString = filePath.toAbsolutePath().toString();
                File f = new File(tmpString);
                if (!tmpString.toLowerCase().contains("cd1") && !tmpString.toLowerCase().contains("disc1") && (f = new File(tmpStringWithIndexOne = tmpString.replaceAll(discOrCdWithIndex, discOrCd + oldIndex))).exists()) {
                    tmpString = tmpStringWithIndexOne;
                }
                while (f.exists()) {
                    this.log("add: " + tmpString + " to " + filename);
                    if (multiFiles.contains(tmpString)) {
                        this.log("processed already: " + tmpString);
                        continue;
                    }
                    if (!tmpString.equalsIgnoreCase(tmpString.replaceAll(discOrCd + oldIndex, discOrCd + newIndex))) {
                        multiFiles.add(tmpString);
                        tmpString = tmpString.replaceAll(discOrCd + oldIndex, discOrCd + newIndex);
                        this.log("Check: old: " + oldIndex + " new: " + newIndex + " - " + tmpString);
                        f = new File(tmpString);
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    this.log("filename did not change. Index " + newIndex + " does not exist");
                    if (!multiFiles.isEmpty() || Files.isDirectory(Path.of(tmpString, new String[0]), LinkOption.NOFOLLOW_LINKS)) break;
                    multiFiles.add(tmpString);
                    break;
                }
                ArrayList<MediumFile> mfs = new ArrayList<MediumFile>();
                boolean create = true;
                LOG.info("iterate over " + multiFiles.size() + " possible files");
                for (String s : multiFiles) {
                    if (!MediumFileService.isMovie((String)s)) {
                        this.log(s + " is not a movie file. Skip it.");
                        continue;
                    }
                    this.log("multifile: " + s);
                    MediumFile find = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(fx -> fx.fileCompletePath.eq((Object)s)).findFirst();
                    this.log("corresponding medium file: " + String.valueOf(find));
                    int waitCounter = 0;
                    while (find != null && find.getHashValue() == null && !ScenerixxWizardPanel.this.abort) {
                        this.log("[DISC/CD] '" + filename + "' waits for other file ('" + find.getFileCompletePath() + "') to hash - sleep (" + waitCounter + "): " + ScenerixxWizardPanel.this.currentHashingDirectory);
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        ++waitCounter;
                        find = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(fx -> fx.fileCompletePath.eq((Object)s)).findFirst();
                        if (find.getHashValue() != null) {
                            ScenerixxWizardPanel.this.lbqHashing.addFirst(new HashingWorker(this.mf));
                            break;
                        }
                        if (waitCounter <= 100) continue;
                        this.log("Re-queue " + s);
                        MediumFile x = new MediumFile();
                        x.setFileCompletePath(filename);
                        MediumFile tmpMf = (MediumFile)ScenerixxWizardPanel.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(fx -> fx.fileCompletePath.eq((Object)s)).findFirst();
                        if (tmpMf != null) {
                            this.log("re-queue " + tmpMf.getFileCompletePath() + " for hashing");
                            ScenerixxWizardPanel.this.lbqHashing.addFirst(new HashingWorker(tmpMf));
                        }
                        return;
                    }
                    if (find.getHashValue() != null) {
                        this.log("Adding " + find.getFileCompletePath());
                        mfs.add(find);
                        continue;
                    }
                    this.log("A hash value of a file could not be obtained in time. Abort creation of " + this.mf.getFileCompletePath());
                    create = false;
                }
                if (create) {
                    if (mfs.size() > 1) {
                        LOG.info("Create movie with " + mfs.size() + " medium files (" + ((MediumFile)mfs.get(0)).getFileCompletePath() + ")");
                        this.createMovieEntity((MediumFile)mfs.get(0), mfs.subList(1, mfs.size()));
                        ++ScenerixxWizardPanel.this.multiFileCounter;
                    } else if (mfs.size() == 1) {
                        LOG.info("Create movie with only 1 medium file (" + ((MediumFile)mfs.get(0)).getFileCompletePath() + ")");
                        this.createMovieEntity((MediumFile)mfs.get(0));
                    } else {
                        this.log(this.mf.getFileCompletePath() + " was not a multifile. Process as single file");
                        if (MediumFileService.isMovie((MediumFile)this.mf)) {
                            ScenerixxWizardPanel.this.alreadyProcessedFiles.add(this.mf.getFileCompletePath());
                            this.createMovieEntity(this.mf);
                        } else {
                            ScenerixxWizardPanel.this.alreadyProcessedFiles.add(this.mf.getFileCompletePath());
                            this.log(this.mf.getFileCompletePath() + " was NOT a movie. Skip processing.");
                        }
                    }
                }
            } else {
                this.log("disc/cd not found");
                if (MediumFileService.isMovie((MediumFile)this.mf)) {
                    this.createMovieEntity(this.mf);
                }
            }
        }

        private void log(String s) {
            LOG.info(s);
            this.publish(s);
        }

        private void createMovieEntity(MediumFile mf) {
            this.createMovieEntity(mf, new ArrayList<MediumFile>());
        }

        /*
         * WARNING - void declaration
         */
        private void createMovieEntity(MediumFile mf, List<MediumFile> further) {
            SceneDetails sd;
            Movie movieByHash = null;
            if (ScenerixxWizardPanel.this.useMasterDb && further.size() == 0) {
                LOG.info("Try to find movie for hash " + mf.getHashValue() + " in the master database");
                DBInternal masterDB = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
                movieByHash = masterDB.getMovieByHash(mf.getHashValue());
                if (movieByHash != null) {
                    movieByHash = (Movie)ScenerixxWizardPanel.this.getDB().getEntityService().save((AbstractEntity)movieByHash);
                    LOG.info("Found movie: " + String.valueOf(movieByHash));
                }
            }
            this.log("Creating movie entity for '" + mf.getFileName() + "' - " + (further.size() + 1) + " medium files");
            Object title = mf.getFileName();
            if (ScenerixxWizardPanel.this.optionsPanel.cbPrefixWithDirectoryName.isSelected()) {
                String onlyPath = mf.getFileCompletePath().substring(0, mf.getFileCompletePath().length() - mf.getFileName().length() - 1);
                onlyPath = onlyPath.substring(onlyPath.lastIndexOf(File.separatorChar) + 1);
                title = onlyPath + " - " + (String)title;
            }
            Movie movie = new Movie();
            movie.setTitle((String)title);
            if (movieByHash != null) {
                LOG.info("use movie from master db");
                movie = movieByHash;
            }
            movie.setWizardGenerated(true);
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTags.isSelected()) {
                LOG.info("Try to apply tags");
                movie = ScenerixxWizardPanel.this.applyTags(movie, mf.getFileCompletePath(), false);
            } else {
                LOG.info("Skip applying tags");
            }
            movie = (Movie)ScenerixxWizardPanel.this.getDB().getEntityService().save((AbstractEntity)movie);
            ++ScenerixxWizardPanel.this.createMovieCounter;
            mf.setMovie(movie);
            mf = (MediumFile)ScenerixxWizardPanel.this.getDB().getEntityService().save((AbstractEntity)mf);
            int pos = 0;
            for (MediumFile mediumFile : further) {
                this.log("assigning '" + mediumFile.getFileCompletePath() + "' (hash: " + mediumFile.getHashValue() + ") to '" + movie.getNameOfPlayable() + "' (MFs so far: " + String.valueOf(ScenerixxWizardPanel.this.db.getMediumFiles(movie, false)) + ")");
                mediumFile.setMovie(movie);
                mediumFile.setPart(++pos);
                MediumFile mediumFile2 = (MediumFile)ScenerixxWizardPanel.this.getDB().getEntityService().save((AbstractEntity)mediumFile);
            }
            this.log("Loading movie with ID: " + movie.getId());
            movie = (Movie)ScenerixxWizardPanel.this.db.getEntityService().load(Movie.class, movie.getId().longValue());
            this.log("Passing to the screencap worker. MFs: " + String.valueOf(ScenerixxWizardPanel.this.db.getMediumFiles(movie, false)));
            ScenerixxWizardPanel.this.lbqScreencap.add(new CreateScreencapWorker(movie));
            this.publish("Checking for studio. Search through " + ScenerixxWizardPanel.this.studios.size() + " studios.");
            for (Studio studio : ScenerixxWizardPanel.this.studios) {
                void var8_18;
                if (ScenerixxWizardPanel.this.isBlacklistedStudio(studio) || !ScenerixxWizardPanel.this.checkForStudioNameAndAlternatives(studio.getName(), mf.getFileName())) continue;
                this.publish("Found " + studio.getName() + ". Check if we need to add this studio.");
                String studioName = studio.getName();
                if (DB.getInstance().getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.equalsIgnoreCase(studioName)).findFirst() == null) {
                    Studio studio2 = (Studio)DB.getInstance().getEntityService().save((AbstractEntity)studio);
                    ++ScenerixxWizardPanel.this.studiosCounter;
                    this.publish("Added studio '" + studio2.getName() + "' (due to " + mf.getFileName() + ")");
                }
                movie.setStudio((Studio)var8_18);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                ++ScenerixxWizardPanel.this.studioSetCounter;
                break;
            }
            if (!further.isEmpty()) {
                if (mf.getFileName().toLowerCase().contains("disc") || mf.getFileName().toLowerCase().contains("cd1")) {
                    this.log(mf.getFileName() + " seems to be a disc or cd");
                } else {
                    this.log(mf.getFileName() + " seems to be a multi file in a directory, create " + (further.size() + 1) + " scenes");
                    for (int i = 1; i <= further.size() + 1; ++i) {
                        Scene scene = new Scene();
                        scene.setMovie(movie);
                        scene.setPos(i);
                        movie.getScenes().add(scene);
                        ++ScenerixxWizardPanel.this.createSceneCounter;
                    }
                    movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                }
            } else if (mf.getDuration() != null && mf.getDuration() / 1000 > 0 && mf.getDuration() / 1000 < this.settings.getWizardMaxMinutesPerScene() * 60) {
                this.log("Adding scene to " + mf.getFileName() + " because it has a runtime which is less than " + this.settings.getWizardMaxMinutesPerScene() + " minutes.");
                Scene scene = new Scene();
                scene.setMovie(movie);
                scene.setPos(1);
                movie.getScenes().add(scene);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                ++ScenerixxWizardPanel.this.createSceneCounter;
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#vr") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("vr")) {
                movie.setVr(true);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                ++ScenerixxWizardPanel.this.vrCounter;
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#decensored") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("decensored") || mf.getFileName().toLowerCase().contains("[decensored]")) {
                movie.setDecensored(true);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#censored") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("censored")) {
                movie.setCensored(true);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#vertical") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("vertical")) {
                movie.setVertical(true);
                movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
            }
            if (movie.getScenes().size() == 1 && (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#solo") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("solo"))) {
                this.publish(mf.getFileName() + " seems to be a solo scene. Let's see if we can find the right person.");
                List persons = DB.getInstance().getPersons(true);
                LOG.info("Checking " + persons.size() + " persons");
                for (Person p : persons) {
                    LOG.info("Checking solo: " + p.getName());
                    if (p.getName().length() < 4) {
                        LOG.info("Ignoring " + p.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p.getName())) continue;
                    LOG.info(p.getName() + " fits");
                    Scene scene = (Scene)movie.getScenes().get(0);
                    sd = new SceneDetails();
                    sd.setDateOfCreation(LocalDateTime.now());
                    sd.setPerson(p);
                    sd.setScene((Scene)movie.getScenes().get(0));
                    ((Scene)movie.getScenes().get(0)).getDetails().add(sd);
                    DB.getInstance().getEntityService().save((AbstractEntity)((Scene)movie.getScenes().get(0)));
                    this.publish("Added '" + p.getName() + "' to '" + movie.getTitle() + "'");
                    ++ScenerixxWizardPanel.this.soloCounter;
                    break;
                }
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbAssociateAllPersons.isSelected()) {
                LOG.info("Check for all persons");
                for (Person person : ScenerixxWizardPanel.this.loadPersonFiles()) {
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), person.getName()) || DB.getInstance().getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.equalsIgnoreCase(person.getName())).findFirst() != null) continue;
                    DB.getInstance().getEntityService().save((AbstractEntity)person);
                    ++ScenerixxWizardPanel.this.personCounter;
                    this.publish("Added person '" + person.getName() + "' (due to " + mf.getFileName() + ")");
                }
                List persons = DB.getInstance().getPersons(true);
                LOG.finer("Checking " + persons.size() + " persons");
                Iterator iterator = persons.iterator();
                while (iterator.hasNext()) {
                    Person p3 = (Person)iterator.next();
                    LOG.finer("Checking: " + p3.getName());
                    if (p3.getName().length() < 4) {
                        LOG.finer("Ignoring " + p3.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p3.getName()) || ((Scene)movie.getScenes().get(0)).getPersons(Scenerixx.unlocked).contains(p3)) continue;
                    LOG.info(p3.getName() + " fits for '" + movie.getTitle() + "'");
                    LOG.info("[check for persons] 1. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                    SceneDetails sd2 = new SceneDetails();
                    sd2.setDateOfCreation(LocalDateTime.now());
                    sd2.setPerson(p3);
                    sd2.setScene((Scene)movie.getScenes().get(0));
                    ((Scene)movie.getScenes().get(0)).getDetails().add(sd2);
                    movie.setWizardGenerated(true);
                    movie = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movie);
                    this.publish("Added '" + p3.getName() + "' to '" + movie.getTitle() + "'");
                    LOG.info("2. " + ((Scene)movie.getScenes().get(0)).getDetails().size());
                    ++ScenerixxWizardPanel.this.allPersonsCounter;
                }
            }
            if (movie.getScenes().size() == 1 && (ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("#lesbian") || !ScenerixxWizardPanel.this.optionsPanel.cbApplyTagsWithHash.isSelected() && mf.getFileName().toLowerCase().contains("lesbian"))) {
                this.publish(mf.getFileName() + " seems to be a lesbian scene. Let's see if we can find the right persons.");
                List persons = DB.getInstance().getPersons(Gender.FEMALE, false, true);
                LOG.info("Checking " + persons.size() + " persons");
                ArrayList<Person> arrayList = new ArrayList<Person>();
                for (Person p : persons) {
                    LOG.info("Checking lesbian: " + p.getName());
                    if (p.getName().length() < 4) {
                        LOG.info("Ignoring " + p.getName() + " because the name is too short");
                        continue;
                    }
                    if (!ScenerixxWizardPanel.this.containsPersonName(mf.getFileName(), p.getName())) continue;
                    this.publish("Consider '" + p.getName() + "' for '" + movie.getTitle() + "'");
                    arrayList.add(p);
                }
                this.publish("Found " + arrayList.size() + " persons we could consider. We need at least 2.");
                if (arrayList.size() >= 2) {
                    for (Person p : arrayList) {
                        if (((Scene)movie.getScenes().get(0)).getPersons(Scenerixx.unlocked).contains(p)) continue;
                        sd = new SceneDetails();
                        sd.setDateOfCreation(LocalDateTime.now());
                        sd.setScene((Scene)movie.getScenes().get(0));
                        sd.setPerson(p);
                        ((Scene)movie.getScenes().get(0)).getDetails().add(sd);
                    }
                    DB.getInstance().getEntityService().save((AbstractEntity)((Scene)movie.getScenes().get(0)));
                    this.publish("Added " + arrayList.size() + " persons to " + movie.getTitle());
                    ++ScenerixxWizardPanel.this.lesbianCounter;
                }
            }
            if (ScenerixxWizardPanel.this.optionsPanel.cbCheckForMultifileMovies.isSelected()) {
                List moviesWithMissingMediumFile = ScenerixxWizardPanel.this.db.getMoviesWithMissingMediumFile("", DB.OrderBy.CREATED, false);
                for (Movie m : moviesWithMissingMediumFile) {
                    if (ScenerixxWizardPanel.this.starttime.isBefore(m.getDateOfCreation())) {
                        LOG.info("DELETE " + String.valueOf(m) + " - " + String.valueOf(ScenerixxWizardPanel.this.starttime) + " -> " + String.valueOf(m.getDateOfCreation()));
                        ScenerixxWizardPanel.this.db.deleteMovie(m);
                        continue;
                    }
                    LOG.info("do not DELETE " + String.valueOf(m) + " - " + String.valueOf(ScenerixxWizardPanel.this.starttime) + " -> " + String.valueOf(m.getDateOfCreation()));
                }
            }
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("CreateSceneOrMovie thread finished");
            ScenerixxWizardPanel.this.createSceneOrMovieExecuting.set(false);
        }

        public class MediumFileComparator
        implements Comparator<MediumFile> {
            public MediumFileComparator(CreateSceneOrMovieAndPersonsWorker this$1) {
            }

            @Override
            public int compare(MediumFile one, MediumFile other) {
                int compareTo = one.getFileName().compareTo(other.getFileName());
                if (compareTo == 0) {
                    return other.getFileName().compareTo(one.getFileName());
                }
                return compareTo;
            }
        }
    }

    public class CreateScreencapWorker
    extends SwingWorker<String, String> {
        private Movie m;

        public CreateScreencapWorker(Movie m) {
            this.m = m;
        }

        @Override
        protected String doInBackground() throws Exception {
            ScenerixxSettings settings = ScenerixxWizardPanel.this.getDB().getScenerixxSettings();
            File screencapDir = new File(Scenerixx.scenerixxScreencapDir);
            screencapDir.mkdirs();
            long usableSpace = screencapDir.getUsableSpace();
            if (usableSpace < 120000000L) {
                if (!ScenerixxWizardPanel.this.discIsFull) {
                    this.publish("YOUR DISK IS FULL (or not available)! System says " + usableSpace + " bytes left in '" + String.valueOf(screencapDir) + "'. Abort creating screencaps");
                    JOptionPane.showMessageDialog(null, "<html>Your disc is (nearly) full.<br>We cannot generate any screencaps.<br>We cannot find any duplicates for movies without screencaps.</html>", "Error", 0);
                    ScenerixxWizardPanel.this.discIsFull = true;
                }
                return null;
            }
            new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene").mkdirs();
            List mediumFiles = DB.getInstance().getMediumFiles(this.m, true);
            int i = 1;
            for (MediumFile mf : mediumFiles) {
                this.log("Create screencap for medium file: " + mf.getFileCompletePath() + " (Movie-ID: " + mf.getMovie().getId() + ") - " + ScenerixxCommon.readableFileSize(mf.getFileSize()) + " - " + ScenerixxCommon.readableDuration(mf.getDuration()));
                if (mf.getTotalRuntime() <= 0) {
                    errorMessage = "Cannot create screencap for " + this.m.getTitle() + " since the runtime is not known! Either update the media information or provide the runtime manually.";
                    this.log(errorMessage);
                } else if (!Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                    errorMessage = "Cannot create screencap for " + mf.getFileCompletePath() + " since the file is not available.";
                    this.log(errorMessage);
                } else {
                    ScreencapService.createMovieScreencap(this.m, i, settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow() / mediumFiles.size());
                    break;
                }
                ++i;
            }
            ++ScenerixxWizardPanel.this.screencapCounter;
            return null;
        }

        private void log(String s) {
            LOG.info(s);
            this.publish(s);
        }

        @Override
        protected void process(List<String> item) {
            ScenerixxWizardPanel.this.updateLog(item);
        }

        @Override
        protected void done() {
            LOG.info("screencap thread finished");
            ScenerixxWizardPanel.this.screencapExecuting.set(false);
        }
    }
}

