/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.indexing;

import com.google.gson.JsonSyntaxException;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.ScenerixxLib;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.DBInternal;
import xxx.scenerixx.scenerixxlib.exporter.ExportLevel;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QPersonBody;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.medium.Dvd;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QDvd;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.settings.NoDuplicate;
import xxx.scenerixx.scenerixxlib.model.settings.QNoDuplicate;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxlib.util.DuplicateFinder;
import xxx.scenerixx.scenerixxlib.util.Hashing;
import xxx.scenerixx.scenerixxlib.util.MediaInformation;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.ScreencapService;
import xxx.scenerixx.scenerixxmodule.util.gui.Figlets;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.FindDuplicatesPanel;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.SynchronizeWarning;
import xxx.scenerixx.scenerixxmodule.util.sync.WebServiceHelper;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.indexing.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.indexing.RenamePanel;
import xxx.scenerixx.scenerixxmodule.windows.indexing.ScenerixxWizardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonDiffPanel;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioDiffPanel;

@TopComponent.Description(preferredID="IndexingTopComponent", iconBase="icons/Database.png", persistenceType=0)
public final class IndexingTopComponent
extends AbstractTopComponent {
    private static boolean alreadyInit = false;
    private static NumberFormat formatter = new DecimalFormat("0000");
    public static final Logger LOG = Logger.getLogger(IndexingTopComponent.class.getName());
    public static int screencapStartOffset = 10;
    public static boolean abortIndexing = false;
    private boolean alreadyAborting = false;
    private boolean discIsFull = false;
    private String currentDvdPath = "";
    private SynchronizeWarning synchronizeWarningPanel = new SynchronizeWarning();
    private JButton btnAbort;
    private JButton btnAddSingleFileToIndex;
    private JButton btnFindDuplicates;
    private JButton btnGenerateScreenaps;
    private JButton btnHashing;
    private JButton btnImportImportfiles;
    private JButton btnIndexDvd;
    private JButton btnPurge;
    private JButton btnPurgeScreencaps;
    private JButton btnRename;
    private JButton btnStartIndexing;
    private JButton btnSynchronize;
    private JButton btnUpdateMediainformation;
    private JButton btnWizard;
    private JCheckBox cbIncludeSubDirs;
    private JFileChooser jFileChooser2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JProgressBar jProgressBarFiles;
    private JProgressBar jProgressBarSize;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel lbProgressFiles;
    private JLabel lbProgressSize;
    private JTextArea taLog;

    public IndexingTopComponent() {
        LOG.info("Initialize Index window");
        if (!alreadyInit) {
            alreadyInit = true;
            WindowManager.getDefault().invokeWhenUIReady(() -> {
                StatusDisplayer.getDefault().setStatusText("Initializing Index window");
                TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
                if (dashboard != null) {
                    ((DashboardTopComponent)dashboard).setStatus("Initializing Index window");
                }
            });
        }
        this.initComponents();
        this.setName(Bundle.CTL_IndexingTopComponent());
        this.setToolTipText(Bundle.HINT_IndexingTopComponent());
        this.setMinimumSize(new Dimension(0, 0));
        this.toggleIncludeSubDirIcon();
        Font font = new Font("Monospaced", 0, 13);
        this.taLog.setFont(font);
        this.btnIndexDvd.setVisible(this.db.getScenerixxSettings().isShowDvd());
        this.btnAddSingleFileToIndex.setVisible(this.db.getScenerixxSettings().isShowRare());
        this.btnImportImportfiles.setVisible(this.db.getScenerixxSettings().isShowImport());
        this.jProgressBarSize.setMaximum(100);
        this.jProgressBarSize.setMinimum(0);
        this.jProgressBarSize.setStringPainted(true);
        this.jProgressBarFiles.setMaximum(100);
        this.jProgressBarFiles.setMinimum(0);
        this.jProgressBarFiles.setStringPainted(true);
    }

    private void initComponents() {
        this.jFileChooser2 = new JFileChooser();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taLog = new JTextArea();
        this.btnAbort = new JButton();
        this.jProgressBarSize = new JProgressBar();
        this.jProgressBarFiles = new JProgressBar();
        this.lbProgressSize = new JLabel();
        this.lbProgressFiles = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnWizard = new JButton();
        this.jPanel3 = new JPanel();
        this.btnAddSingleFileToIndex = new JButton();
        this.btnGenerateScreenaps = new JButton();
        this.btnHashing = new JButton();
        this.btnIndexDvd = new JButton();
        this.btnUpdateMediainformation = new JButton();
        this.cbIncludeSubDirs = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.btnStartIndexing = new JButton();
        this.jPanel4 = new JPanel();
        this.btnPurgeScreencaps = new JButton();
        this.btnSynchronize = new JButton();
        this.btnFindDuplicates = new JButton();
        this.btnRename = new JButton();
        this.btnImportImportfiles = new JButton();
        this.btnPurge = new JButton();
        this.jLabel3 = new JLabel();
        this.setMinimumSize(new Dimension(660, 0));
        this.taLog.setColumns(20);
        this.taLog.setFont(new Font("Courier 10 Pitch", 0, 13));
        this.taLog.setRows(5);
        this.jScrollPane1.setViewportView(this.taLog);
        this.btnAbort.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAbort, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnAbort.text"));
        this.btnAbort.setToolTipText(NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnAbort.toolTipText"));
        this.btnAbort.setEnabled(false);
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnAbortActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbProgressSize, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.lbProgressSize.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbProgressFiles, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.lbProgressFiles.text"));
        this.jLabel1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/mysql_wizard.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jLabel1.text"));
        this.btnWizard.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/wand.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnWizard, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnWizard.text"));
        this.btnWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnWizardActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.btnWizard, -2, 378, -2)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnWizard).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jPanel2.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/mysql_wizard.png")), this.jPanel2);
        this.btnAddSingleFileToIndex.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/New document.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddSingleFileToIndex, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnAddSingleFileToIndex.text"));
        this.btnAddSingleFileToIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnAddSingleFileToIndexActionPerformed(evt);
            }
        });
        this.btnGenerateScreenaps.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/66camera.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnGenerateScreenaps, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnGenerateScreenaps.text"));
        this.btnGenerateScreenaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnGenerateScreenapsActionPerformed(evt);
            }
        });
        this.btnHashing.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/script_binary.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnHashing, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnHashing.text"));
        this.btnHashing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnHashingActionPerformed(evt);
            }
        });
        this.btnIndexDvd.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/dvd-icon.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnIndexDvd, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnIndexDvd.text"));
        this.btnIndexDvd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnIndexDvdActionPerformed(evt);
            }
        });
        this.btnUpdateMediainformation.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/51clock.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdateMediainformation, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnUpdateMediainformation.text"));
        this.btnUpdateMediainformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnUpdateMediainformationActionPerformed(evt);
            }
        });
        this.cbIncludeSubDirs.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbIncludeSubDirs, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.cbIncludeSubDirs.text"));
        this.cbIncludeSubDirs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.cbIncludeSubDirsActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/track_changes_edit.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jLabel2.text"));
        this.btnStartIndexing.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Folder.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnStartIndexing, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnStartIndexing.text"));
        this.btnStartIndexing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnStartIndexingActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.cbIncludeSubDirs).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnStartIndexing, -1, -1, Short.MAX_VALUE).addComponent(this.btnHashing, -1, -1, Short.MAX_VALUE).addComponent(this.btnUpdateMediainformation, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnAddSingleFileToIndex, -1, -1, Short.MAX_VALUE).addComponent(this.btnIndexDvd, -2, 185, -2).addComponent(this.btnGenerateScreenaps, -2, 185, -2)))).addContainerGap(238, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbIncludeSubDirs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnGenerateScreenaps, GroupLayout.Alignment.TRAILING).addComponent(this.btnStartIndexing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnHashing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUpdateMediainformation, -1, 27, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnAddSingleFileToIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnIndexDvd).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jPanel3.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/track_changes_edit.png")), this.jPanel3);
        this.btnPurgeScreencaps.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/camera_delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPurgeScreencaps, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnPurgeScreencaps.text"));
        this.btnPurgeScreencaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnPurgeScreencapsActionPerformed(evt);
            }
        });
        this.btnSynchronize.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/database_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSynchronize, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnSynchronize.text"));
        this.btnSynchronize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnSynchronizeActionPerformed(evt);
            }
        });
        this.btnFindDuplicates.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/pictures.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFindDuplicates, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnFindDuplicates.text"));
        this.btnFindDuplicates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnFindDuplicatesActionPerformed(evt);
            }
        });
        this.btnRename.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/arrow_join.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("xxx/scenerixx/scenerixxmodule/windows/indexing/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.btnRename, (String)bundle.getString("IndexingTopComponent.btnRename.text"));
        this.btnRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnRenameActionPerformed(evt);
            }
        });
        this.btnImportImportfiles.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/54downarrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportImportfiles, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnImportImportfiles.text"));
        this.btnImportImportfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnImportImportfilesActionPerformed(evt);
            }
        });
        this.btnPurge.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/31fire.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPurge, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnPurge.text"));
        this.btnPurge.setToolTipText(NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.btnPurge.toolTipText"));
        this.btnPurge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingTopComponent.this.btnPurgeActionPerformed(evt);
            }
        });
        this.jLabel3.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/setting_tools.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jLabel3.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRename, -1, -1, Short.MAX_VALUE).addComponent(this.btnSynchronize, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3).addComponent(this.btnFindDuplicates, -1, 179, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnImportImportfiles, -1, -1, Short.MAX_VALUE).addComponent(this.btnPurgeScreencaps, -1, 193, Short.MAX_VALUE)).addComponent(this.btnPurge, -2, 193, -2)).addContainerGap(252, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFindDuplicates).addComponent(this.btnPurge)).addGap(5, 5, 5).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRename).addComponent(this.btnPurgeScreencaps)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSynchronize).addComponent(this.btnImportImportfiles)).addContainerGap(34, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(IndexingTopComponent.class, (String)"IndexingTopComponent.jPanel4.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/setting_tools.png")), this.jPanel4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbProgressSize).addComponent(this.lbProgressFiles, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBarSize, -2, 0, Short.MAX_VALUE).addComponent(this.jProgressBarFiles, -2, 0, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jTabbedPane1, -2, 0, Short.MAX_VALUE)).addComponent(this.btnAbort, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 209, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAbort).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbProgressSize, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBarSize, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbProgressFiles, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBarFiles, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1, -2, -1, -2).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 660, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
    }

    private void btnStartIndexingActionPerformed(ActionEvent evt) {
        this.startIndexing();
    }

    private void startIndexing() throws HeadlessException {
        ScenerixxSettings scenerixxSettings = this.db.getScenerixxSettings();
        if (scenerixxSettings.getLastIndexDirectory() != null && Files.exists(Paths.get(scenerixxSettings.getLastIndexDirectory(), new String[0]), new LinkOption[0])) {
            LOG.info("Use last opened directory: " + scenerixxSettings.getLastIndexDirectory());
            this.jFileChooser2.setCurrentDirectory(new File(scenerixxSettings.getLastIndexDirectory()));
        }
        this.jFileChooser2.setFileSelectionMode(1);
        int ret = this.jFileChooser2.showOpenDialog((Component)((Object)this));
        if (ret == 0) {
            scenerixxSettings.setLastIndexDirectory(this.jFileChooser2.getSelectedFile().getAbsolutePath());
            this.db.getEntityService().save((AbstractEntity)scenerixxSettings);
            LOG.finest("Start indexing at root directory " + String.valueOf(this.jFileChooser2.getSelectedFile()));
            abortIndexing = false;
            this.setAbortButtonEnabled(true);
            new IndexingWorker().execute();
        } else {
            LOG.finest("User decided to cancel");
        }
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.abortIndexing();
    }

    public void abortIndexing() {
        abortIndexing = true;
        this.setAbortButtonEnabled(false);
        AbstractTopComponent.notifyInfo("Received abort signal. We will just finish the current process.");
    }

    private void btnHashingActionPerformed(ActionEvent evt) {
        this.startHashing();
    }

    public void startHashing() {
        int dialogResult = JOptionPane.showConfirmDialog(null, "It is really advised to purge your data before hashing.\nPurging first assures that no data is lost in case you renamed any files.\n\nDo you really want to hash now?", "Warning", 0);
        if (dialogResult == 0) {
            abortIndexing = false;
            this.setAbortButtonEnabled(true);
            new HashingWorker().execute();
        }
    }

    private void btnPurgeActionPerformed(ActionEvent evt) {
        this.purge();
    }

    private void btnAddSingleFileToIndexActionPerformed(ActionEvent evt) {
        this.addSingleFileToIndex();
    }

    private void btnIndexDvdActionPerformed(ActionEvent evt) {
        this.indexDvdAndCreate();
    }

    private void indexDvdAndCreate() {
        String indexDvdHash = this.indexDvd();
        LOG.info("DVD hash: " + indexDvdHash);
        if (indexDvdHash != null) {
            if (this.db.getEntityService().find((EntityPathBase)QDvd.dvd).filter(f -> f.hashValue.eq((Object)indexDvdHash)).count() == 0L) {
                int createNew = JOptionPane.showConfirmDialog(null, "DVD unknown. Create new movie for it?", "Create new?", 0);
                if (createNew == 0) {
                    String newMovieTitle = JOptionPane.showInputDialog(null, "DVD unknown. Create new movie for it?", "[New Movie Title]");
                    SwingUtilities.invokeLater(() -> {
                        Dvd dvd = new Dvd();
                        dvd.setHashValue(indexDvdHash);
                        dvd.setMovie(new Movie());
                        dvd.getMovie().setTitle(newMovieTitle);
                        this.db.getEntityService().save((AbstractEntity)dvd.getMovie());
                        this.db.getEntityService().save((AbstractEntity)dvd);
                        SwingUtilities.invokeLater(() -> {
                            AbstractTopComponent.notifyInfo("Created movie for DVD. Now read the meta data. Depending on the surface of the disc this can take a bit longer.");
                            SwingUtilities.invokeLater(() -> {
                                this.readDvdMedia(dvd);
                                AbstractTopComponent.dirtyMovieList();
                                AbstractTopComponent.notifyInfo("Finished reading DVD");
                                this.currentDvdPath = "";
                            });
                        });
                    });
                }
            } else {
                SwingUtilities.invokeLater(() -> {
                    Dvd dvd = (Dvd)this.db.getEntityService().find((EntityPathBase)QDvd.dvd).filter(f -> f.hashValue.eq((Object)indexDvdHash)).findFirst();
                    JOptionPane.showMessageDialog(null, "DVD already known: " + dvd.getMovie().getTitle());
                    this.currentDvdPath = "";
                });
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Dvd readDvdMedia(Dvd dvd) {
        LOG.info("read dvd media data");
        MediaInformation media = new MediaInformation();
        boolean save = false;
        if (!this.currentDvdPath.isEmpty()) {
            try {
                if (dvd.getHeight() == null) {
                    LOG.info("determine height");
                    String height = media.getMediaInfoValue("--Inform=Video;%Height%x", this.currentDvdPath);
                    if (!height.isEmpty()) {
                        dvd.setHeight(Integer.valueOf(Integer.parseInt(height.split("x")[0])));
                        save = true;
                        LOG.info("retrieved height");
                    }
                }
                if (dvd.getWidth() == null) {
                    LOG.info("determine width");
                    String width = media.getMediaInfoValue("--Inform=Video;%Width%x", this.currentDvdPath);
                    if (!width.isEmpty()) {
                        dvd.setWidth(Integer.valueOf(Integer.parseInt(width.split("x")[0])));
                        save = true;
                        LOG.info("retrieved width");
                    }
                }
            }
            catch (Exception ex) {
                AbstractTopComponent.notifyError("Could not retrieve media information: " + ex.getMessage());
            }
            if (dvd.getDuration() == null) {
                LOG.info("determine duration");
                try {
                    Integer dur;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(this.db.getScenerixxSettings().getPathToMediaInfo() + "mediainfo");
                    list.add("--Inform=Video;%Duration%x");
                    try (Stream<Path> paths = Files.walk(Paths.get(this.currentDvdPath, new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);){
                        for (Path filePath : paths.collect(Collectors.toList())) {
                            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS) || !filePath.toFile().getAbsolutePath().toLowerCase().endsWith(".vob")) continue;
                            list.add(filePath.toFile().getAbsolutePath());
                        }
                    }
                    ProcessBuilder ps = new ProcessBuilder(list);
                    LOG.finest("Command: " + String.valueOf(ps.command()));
                    ps.redirectErrorStream(true);
                    Process pr = ps.start();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));){
                        String line = "";
                        dur = 0;
                        while ((line = in.readLine()) != null) {
                            String[] sizes;
                            if (line.isEmpty()) continue;
                            if (line.toLowerCase().contains("file read error")) {
                                JOptionPane.showMessageDialog(null, "Could not read disc. Abort retrieving media data for this DVD.", "Error reading disc", 0);
                                Dvd dvd2 = null;
                                return dvd2;
                            }
                            LOG.fine("Result for duration: " + line);
                            for (String s : sizes = line.split("x")) {
                                if (s.contains(".")) {
                                    s = s.substring(0, s.indexOf("."));
                                }
                                if (s.isEmpty()) continue;
                                try {
                                    dur = dur + Integer.parseInt(s);
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                            LOG.finest(line);
                        }
                        pr.waitFor();
                    }
                    dvd.setDuration(dur);
                    save = true;
                    LOG.info("retrieved duration");
                }
                catch (IOException | InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            }
            if (save) {
                this.db.getEntityService().save((AbstractEntity)dvd);
                LOG.fine("Updated media information for DVD: " + dvd.getMovie().getTitle());
            }
        }
        LOG.info("finished with dvd media data");
        return dvd;
    }

    private void btnUpdateMediainformationActionPerformed(ActionEvent evt) {
        this.updateMediaInformation();
    }

    private void btnImportImportfilesActionPerformed(ActionEvent evt) {
        this.importImportfiles();
    }

    private void btnGenerateScreenapsActionPerformed(ActionEvent evt) {
        this.generateScreencaps();
    }

    private void btnRenameActionPerformed(ActionEvent evt) {
        this.bulkRenaming();
    }

    private void btnPurgeScreencapsActionPerformed(ActionEvent evt) {
        this.purgeScreencaps();
    }

    private void btnWizardActionPerformed(ActionEvent evt) {
        this.startWizard();
    }

    private void btnSynchronizeActionPerformed(ActionEvent evt) {
        this.synchronize();
    }

    private void btnFindDuplicatesActionPerformed(ActionEvent evt) {
        this.startFindDuplicates();
    }

    private void cbIncludeSubDirsActionPerformed(ActionEvent evt) {
        this.toggleIncludeSubDirIcon();
    }

    public void toggleIncludeSubDirIcon() {
        if (this.cbIncludeSubDirs.isSelected()) {
            this.cbIncludeSubDirs.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/folders_explorer.png")));
        } else {
            this.cbIncludeSubDirs.setIcon(null);
        }
    }

    private void startFindDuplicates() {
        FindDuplicatesPanel findDuplicatesPanel = new FindDuplicatesPanel();
        JOptionPane op = new JOptionPane(findDuplicatesPanel, 3, 2);
        JDialog dlg = op.createDialog("Let's make some space and find some duplicates... Ready?");
        dlg.setVisible(true);
        if (op.getValue() != null && op.getValue().equals(0)) {
            abortIndexing = false;
            this.setAbortButtonEnabled(true);
            this.jProgressBarFiles.setToolTipText("duplicate finder not started yet");
            this.jProgressBarFiles.setValue(0);
            this.lbProgressFiles.setText("duplicate finder not started yet");
            this.lbProgressSize.setVisible(false);
            this.jProgressBarFiles.setValue(0);
            this.jProgressBarSize.setVisible(false);
            new FindDuplicatesWorker(findDuplicatesPanel.getStartSecond(), findDuplicatesPanel.getEndSecond(), findDuplicatesPanel.getThresholdValue(), findDuplicatesPanel.getDiffSeconds(), findDuplicatesPanel.startWithLongestRuntime(), findDuplicatesPanel.getStartTime(), findDuplicatesPanel.getEndTime(), findDuplicatesPanel.getSelectedPath()).execute();
        }
    }

    public void startFindDuplicatesExternally(LocalDateTime startTime, double threshold, int diffInSeconds, String path, boolean shutdown) {
        LOG.info("start duplicate finder externally");
        abortIndexing = false;
        this.setAbortButtonEnabled(true);
        this.jProgressBarFiles.setToolTipText("duplicate finder not started yet");
        this.jProgressBarFiles.setValue(0);
        this.lbProgressFiles.setText("duplicate finder not started yet");
        this.lbProgressSize.setVisible(false);
        this.jProgressBarFiles.setValue(0);
        this.jProgressBarSize.setVisible(false);
        new FindDuplicatesWorker(60, 36000, threshold, diffInSeconds, false, startTime, LocalDateTime.now(), path, shutdown).execute();
    }

    private void synchronize() {
        if (Scenerixx.registered) {
            JOptionPane op = new JOptionPane(this.synchronizeWarningPanel, 3, 2);
            JDialog dlg = op.createDialog("Synchronize with server?");
            dlg.setVisible(true);
            if (op.getValue() != null && op.getValue().equals(0)) {
                this.synchronizeData();
            }
        } else {
            JOptionPane.showMessageDialog(null, "You are not registered yet. Do that under 'Help / Start Registration' first.", "Not registered yet", 2);
        }
    }

    private void startWizard() {
        LOG.info("Starting wizard");
        EventQueue.invokeLater(() -> {
            LOG.info("Show Wizard");
            this.setAbortButtonEnabled(true);
            TopComponent wizardTC = WindowManager.getDefault().findTopComponent("ScenerixxWizardTopComponent");
            if (wizardTC != null) {
                ((ScenerixxWizardTopComponent)wizardTC).open();
                ((ScenerixxWizardTopComponent)wizardTC).requestActive();
            }
            LOG.info("Show Wizard finish");
        });
    }

    public void purgeScreencaps() {
        int dialogResult = JOptionPane.showConfirmDialog(null, "Do you really want to purge screencaps now?", "Purge Screencaps?", 0);
        if (dialogResult == 0) {
            abortIndexing = false;
            this.setAbortButtonEnabled(true);
            new PurgeScreencapsWorker().execute();
        }
    }

    private void bulkRenaming() {
        this.setAbortButtonEnabled(true);
        JDialog frame = new JDialog((Frame)null, "Bulk Renaming", true);
        frame.getContentPane().add(new RenamePanel());
        frame.pack();
        frame.setLocationRelativeTo((Component)((Object)this));
        frame.setVisible(true);
        this.setAbortButtonEnabled(false);
    }

    private void importImportfiles() throws HeadlessException {
        this.jFileChooser2.setFileSelectionMode(2);
        this.jFileChooser2.setFileFilter(new FileNameExtensionFilter("ZIP-file containing import files", "zip"));
        int ret = this.jFileChooser2.showOpenDialog((Component)((Object)this));
        if (ret == 0) {
            if (this.jFileChooser2.getSelectedFile().isDirectory()) {
                JOptionPane.showMessageDialog(null, "You need to select an importfile, not a directory.", "Nothing to do here", 2);
            } else {
                new ImportImportFilesWorker().execute();
            }
        } else {
            LOG.finest("User decided to cancel");
        }
    }

    private void updateMediaInformation() {
        abortIndexing = false;
        this.setAbortButtonEnabled(true);
        new UpdateMediaInformationWorker().execute();
    }

    private void generateScreencaps() {
        abortIndexing = false;
        this.setAbortButtonEnabled(true);
        new GenerateScreencapsWorker().execute();
    }

    private void addSingleFileToIndex() {
        ScenerixxSettings scenerixxSettings = this.db.getScenerixxSettings();
        if (scenerixxSettings.getLastIndexDirectory() != null && Files.exists(Paths.get(scenerixxSettings.getLastIndexDirectory(), new String[0]), new LinkOption[0])) {
            LOG.info("Use last opened directory: " + scenerixxSettings.getLastIndexDirectory());
            this.jFileChooser2.setCurrentDirectory(new File(scenerixxSettings.getLastIndexDirectory()));
        }
        this.jFileChooser2.setFileSelectionMode(2);
        int ret = this.jFileChooser2.showOpenDialog((Component)((Object)this));
        if (ret == 0) {
            if (this.jFileChooser2.getSelectedFile().isDirectory()) {
                JOptionPane.showMessageDialog(null, "You need to select a single file, not a directory. There's an extra button to index a whole directory.", "Nothing to do here", 2);
            } else {
                LOG.finest("Add '" + String.valueOf(this.jFileChooser2.getSelectedFile()) + "' to index.");
                abortIndexing = false;
                this.setAbortButtonEnabled(true);
                MediumFileService mfs = new MediumFileService();
                mfs.addNewMediumFileToIndex(this.jFileChooser2.getSelectedFile().toPath());
                if (JOptionPane.showConfirmDialog(null, "Indexing finished. Should we now start hashing?", "Start hashing?", 0) == 0) {
                    new HashingWorker().execute();
                }
            }
        } else {
            LOG.finest("User decided to cancel");
        }
    }

    private void purge() {
        abortIndexing = false;
        this.setAbortButtonEnabled(true);
        new PurgeWorker().execute();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private String indexDvd() {
        this.jFileChooser2.setFileSelectionMode(1);
        int ret = this.jFileChooser2.showOpenDialog((Component)((Object)this));
        if (ret == 0) {
            this.currentDvdPath = this.jFileChooser2.getSelectedFile().getAbsolutePath();
            LOG.fine("Current path to DVD drive: " + this.currentDvdPath);
            try {
                if (!Files.list(Paths.get(this.currentDvdPath, new String[0])).anyMatch(f -> f.toString().endsWith("VOB"))) {
                    JOptionPane.showMessageDialog(null, "You need to select the directory containing the VOB-files!", "Error", 0);
                    return null;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            LOG.finest("Index DVD: '" + String.valueOf(this.jFileChooser2.getSelectedFile()) + "'");
            ArrayList<Long> sizes = new ArrayList<Long>();
            StringBuilder sb = new StringBuilder("");
            try (Stream<Path> paths = Files.walk(Paths.get(this.jFileChooser2.getSelectedFile().getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                for (Path filePath : paths.collect(Collectors.toList())) {
                    if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                    sizes.add(filePath.toFile().length());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            Collections.sort(sizes);
            Object stringToHash = "";
            for (Long s : sizes) {
                stringToHash = (String)stringToHash + s + "_";
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(((String)stringToHash).getBytes());
                byte[] mdbytes = md.digest();
                for (int i = 0; i < mdbytes.length; ++i) {
                    sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
                }
            }
            catch (NoSuchAlgorithmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            LOG.finest("Calculated hash: " + sb.toString());
            return sb.toString();
        }
        LOG.finest("User decided to cancel");
        return null;
    }

    private void synchronizeData() throws JsonSyntaxException {
        new SynchronizeDataWorker().execute();
    }

    private void resetProgressBars() {
        this.jProgressBarSize.setVisible(true);
        this.jProgressBarFiles.setVisible(true);
        this.lbProgressSize.setVisible(true);
        this.lbProgressFiles.setVisible(true);
        this.lbProgressSize.setText("Progress (size)");
        this.lbProgressFiles.setText("Progress (files)");
        this.jProgressBarFiles.setValue(0);
        this.jProgressBarSize.setValue(0);
        this.jProgressBarFiles.setString(null);
        this.jProgressBarSize.setString(null);
        this.jProgressBarFiles.setStringPainted(true);
        this.jProgressBarSize.setStringPainted(true);
    }

    private void setAbortButtonEnabled(boolean enabled) {
        this.btnAbort.setEnabled(enabled);
        this.btnPurge.setEnabled(!enabled);
        this.btnHashing.setEnabled(!enabled);
        this.btnUpdateMediainformation.setEnabled(!enabled);
        this.btnGenerateScreenaps.setEnabled(!enabled);
        this.btnImportImportfiles.setEnabled(!enabled);
        this.btnRename.setEnabled(!enabled);
        this.btnPurgeScreencaps.setEnabled(!enabled);
        this.btnFindDuplicates.setEnabled(!enabled);
        this.btnWizard.setEnabled(!enabled);
        this.btnSynchronize.setEnabled(!enabled);
        this.btnStartIndexing.setEnabled(!enabled);
        this.btnIndexDvd.setEnabled(!enabled);
        this.btnAddSingleFileToIndex.setEnabled(!enabled);
    }

    private void finishedThread() {
        LOG.info("finishiiiiiiing");
        this.jProgressBarSize.setValue(100);
        this.jProgressBarFiles.setValue(100);
        this.setAbortButtonEnabled(false);
    }

    static /* synthetic */ DB access$1100(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1200(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1300(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1400(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1500(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1600(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1700(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1800(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$1900(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$2000(IndexingTopComponent x0) {
        return x0.db;
    }

    static /* synthetic */ DB access$2100(IndexingTopComponent x0) {
        return x0.db;
    }

    public class IndexingWorker
    extends SwingWorker<String, String> {
        private Long currentIndex = 0L;
        private Long totalSize = 0L;
        private Long indexedSize = 0L;
        private Long fileCounter = 0L;
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private int maxDepth = 1;
        private final String finished_indexing = "Finished indexing.\n";

        @Override
        protected String doInBackground() throws Exception {
            Stream<Path> paths;
            IndexingTopComponent.this.resetProgressBars();
            String rootFolder = IndexingTopComponent.this.jFileChooser2.getSelectedFile().getPath();
            this.publish("Start indexing. Root directory: " + rootFolder + "\n");
            this.publish("Calculating total size to index.\n");
            if (IndexingTopComponent.this.cbIncludeSubDirs.isSelected()) {
                this.maxDepth = Integer.MAX_VALUE;
            }
            try {
                paths = Files.walk(Paths.get(rootFolder, new String[0]), this.maxDepth, new FileVisitOption[0]);
                try {
                    for (Path filePath : paths.collect(Collectors.toList())) {
                        if (!abortIndexing) {
                            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                            this.totalSize = this.totalSize + filePath.toFile().length();
                            Long l = this.fileCounter;
                            this.fileCounter = this.fileCounter + 1L;
                            if (this.fileCounter % 1000L != 0L) continue;
                            this.publish("We have " + this.fileCounter + " files with a total of " + ScenerixxCommon.readableFileSize(this.totalSize) + " and still searching.\n");
                            if (this.fileCounter == 1000L) {
                                this.publish("Nice collection\n");
                                continue;
                            }
                            if (this.fileCounter == 5000L) {
                                this.publish("Quite impressive\n");
                                continue;
                            }
                            if (this.fileCounter == 10000L) {
                                this.publish("Whoa!\n");
                                continue;
                            }
                            if (this.fileCounter == 50000L) {
                                this.publish("Okay, that will take a while!\n");
                                continue;
                            }
                            if (this.fileCounter == 100000L) {
                                this.publish("I get it. This is quite a serious hobby!\n");
                                continue;
                            }
                            if (this.fileCounter == 250000L) {
                                this.publish("Seriously, where do you find the time for all this?\n");
                                continue;
                            }
                            if (this.fileCounter == 500000L) {
                                this.publish("What the heck am I indexing? YouPorn?\n");
                                continue;
                            }
                            if (this.fileCounter != 1000000L) continue;
                            this.publish("I think I already left your harddisk and started somehow index the whole internet! Just kidding. But that's massive.\n");
                            continue;
                        }
                        this.publish("User requested to abort indexing.\n");
                        IndexingTopComponent.this.jProgressBarSize.setValue(100);
                        IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                        break;
                    }
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            this.publish("We are going to index " + this.fileCounter + " files. A total of " + ScenerixxCommon.readableFileSize(this.totalSize) + "\n");
            try {
                paths = Files.walk(Paths.get(rootFolder, new String[0]), this.maxDepth, new FileVisitOption[0]);
                try {
                    for (Path filePath : paths.collect(Collectors.toList())) {
                        if (!abortIndexing) {
                            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                            String[] stringArray = new String[1];
                            this.currentIndex = this.currentIndex + 1L;
                            stringArray[0] = "[" + this.currentIndex + "/" + this.fileCounter + "] Indexing " + filePath.toString() + "\n";
                            this.publish(stringArray);
                            if (IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.fileCompletePath.eq((Object)filePath.toString())).count() == 0L) {
                                MediumFileService mfs = new MediumFileService();
                                mfs.addNewMediumFileToIndex(filePath);
                            } else {
                                this.publish("Skip indexing. " + String.valueOf(filePath.toFile()) + " is already known.\n");
                            }
                            this.indexedSize = this.indexedSize + filePath.toFile().length();
                            Long completed = this.indexedSize * 100L / this.totalSize;
                            IndexingTopComponent.this.jProgressBarSize.setValue(completed.intValue());
                            Long completedFiles = this.currentIndex * 100L / this.fileCounter;
                            IndexingTopComponent.this.jProgressBarFiles.setValue(completedFiles.intValue());
                            continue;
                        }
                        this.publish("User requested to abort indexing.\n");
                        IndexingTopComponent.this.jProgressBarSize.setValue(100);
                        IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                        break;
                    }
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            this.publish("We indexed " + this.currentIndex + " files (" + ScenerixxCommon.readableFileSize(this.indexedSize) + ")\n");
            this.publish("Finished indexing.\n");
            IndexingTopComponent.this.setAbortButtonEnabled(false);
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished indexing.\n")) continue;
                AbstractTopComponent.reloadMediumFileList(Node.EMPTY);
            }
        }

        @Override
        protected void done() {
            super.done();
            if (JOptionPane.showConfirmDialog(null, "Indexing finished. Should we now start hashing?", "Start hashing?", 0) == 0) {
                abortIndexing = false;
                IndexingTopComponent.this.setAbortButtonEnabled(true);
                new HashingWorker().execute();
            }
        }
    }

    public class HashingWorker
    extends SwingWorker<String, String> {
        private Long currentIndex = 0L;
        private Long errorCounter = 0L;
        private Long totalSize = 0L;
        private Long hashedSize = 0L;
        private Long fileCounter = 0L;
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final Hashing hashing = new Hashing();
        private final String finished_hashing = "Finished hashing.\n";
        private boolean startImportWorker = true;

        @Override
        protected void done() {
            super.done();
            if (this.startImportWorker) {
                // empty if block
            }
        }

        @Override
        protected String doInBackground() throws Exception {
            IndexingTopComponent.this.resetProgressBars();
            this.publish("Find unhashed files.\n");
            List unhashedFiles = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.hashValue.isNull()).find();
            this.fileCounter = 0L + (long)unhashedFiles.size();
            this.publish("Found " + this.fileCounter + " files to hash.\n");
            this.publish("Calculating total size to hash.\n");
            for (MediumFile mf : unhashedFiles) {
                this.totalSize = this.totalSize + mf.getFileSize();
            }
            this.publish("Going to hash " + ScenerixxCommon.readableFileSize(this.totalSize) + ".\n");
            for (MediumFile mf : unhashedFiles) {
                if (!Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                    this.publish("Aborted hashing.\nFile '" + mf.getFileCompletePath() + "' was not found.\nMake sure that all necessary devices are connected!\nIf all devices are connected purge the database before you restart hashing.\n");
                    this.startImportWorker = false;
                    break;
                }
                if (!abortIndexing) {
                    String[] stringArray = new String[1];
                    this.currentIndex = this.currentIndex + 1L;
                    stringArray[0] = "[" + this.currentIndex + "/" + this.fileCounter + "] Hashing " + mf.getFileCompletePath() + " (" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + ")\n";
                    this.publish(stringArray);
                    MediumFile hashFile = this.hashing.hashFile(mf);
                    if (hashFile == null) {
                        this.publish("[ERROR] An error occured. Have a look at the log (under 'Tools / IDE Log').\n");
                        Long l = this.errorCounter;
                        this.errorCounter = this.errorCounter + 1L;
                    } else {
                        this.hashedSize = this.hashedSize + mf.getFileSize();
                    }
                    Long completed = this.hashedSize * 100L / this.totalSize;
                    IndexingTopComponent.this.jProgressBarSize.setValue(completed.intValue());
                    Long completedFiles = this.currentIndex * 100L / this.fileCounter;
                    IndexingTopComponent.this.jProgressBarFiles.setValue(completedFiles.intValue());
                    continue;
                }
                this.publish("User requested to abort hashing.\n");
                this.startImportWorker = false;
                IndexingTopComponent.this.jProgressBarSize.setValue(100);
                IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                break;
            }
            this.publish("We hashed " + (this.currentIndex - this.errorCounter) + " files (" + ScenerixxCommon.readableFileSize(this.hashedSize) + ")\n");
            if (this.errorCounter > 0L) {
                this.publish(this.errorCounter + " files could not be hashed due to an error.\n");
            }
            this.publish("Finished hashing.\n");
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished hashing.\n")) continue;
                AbstractTopComponent.dirtyMediumFileList();
                AbstractTopComponent.dirtyMovieList();
            }
        }
    }

    public class FindDuplicatesWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final String finishedFindingDuplicates = "Finished finding duplicates.\n";
        private final DuplicateFinder dupFinder = new DuplicateFinder();
        private Playlist dupPlaylist = null;
        private int startSecond = 60;
        private int endSecond = Integer.MAX_VALUE;
        private double thresholdValue = 10.0;
        private int secondsDiff = 0;
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private boolean startWithLongestRuntime = false;
        private final PlaylistService ps = new PlaylistService();
        private final DecimalFormat decformat = new DecimalFormat("0.000");
        private final NumberFormat nf = NumberFormat.getIntegerInstance();
        private boolean abortedByUser = false;
        private boolean abortedAfterNextRuntime = false;
        private String path = null;
        private boolean shutdownAfterFinish = false;

        public FindDuplicatesWorker(int startSecond, int endSecond, double thresholdValue, int secondsDiff, boolean startWithLongestRuntime, LocalDateTime startTime, LocalDateTime endTime, String path) {
            this(startSecond, endSecond, thresholdValue, secondsDiff, startWithLongestRuntime, startTime, endTime, path, false);
        }

        public FindDuplicatesWorker(int startSecond, int endSecond, double thresholdValue, int secondsDiff, boolean startWithLongestRuntime, LocalDateTime startTime, LocalDateTime endTime, String path, boolean shutdownAfterFinish) {
            this.startSecond = startSecond;
            this.endSecond = endSecond;
            this.thresholdValue = thresholdValue;
            this.secondsDiff = secondsDiff;
            this.startTime = startTime;
            this.endTime = endTime;
            this.startWithLongestRuntime = startWithLongestRuntime;
            this.path = path;
            this.shutdownAfterFinish = shutdownAfterFinish;
            LOG.info("Search for duplicates with a runtime of " + startSecond + " seconds and max. " + endSecond + " seconds");
            LOG.info("start-/end-date1: " + String.valueOf(startTime) + " - " + String.valueOf(endTime));
            if (startTime == null) {
                this.startTime = LocalDateTime.of(1959, Month.MARCH, 11, 0, 0);
            }
            if (endTime == null) {
                this.endTime = LocalDateTime.now();
            }
            LOG.info("start-/end-date2: " + String.valueOf(this.startTime) + " - " + String.valueOf(this.endTime));
            LOG.info("Path: " + path);
        }

        private void saveCurrentState(Integer currentSecond) {
            LOG.info("Saving current state: " + currentSecond);
            this.abortedByUser = true;
            ScenerixxSettings scenerixxSettings = IndexingTopComponent.this.db.getScenerixxSettings();
            scenerixxSettings.setDupFinderStart(Integer.valueOf(this.startSecond));
            scenerixxSettings.setDupFinderEnd(Integer.valueOf(this.endSecond));
            scenerixxSettings.setDupFinderThreshold(Double.valueOf(this.thresholdValue));
            scenerixxSettings.setDupFinderDiffSeconds(Integer.valueOf(this.secondsDiff));
            Date startDate = Date.from(this.startTime.atZone(ZoneId.systemDefault()).toInstant());
            Date endDate = Date.from(this.endTime.atZone(ZoneId.systemDefault()).toInstant());
            scenerixxSettings.setDupFinderDateStart(startDate);
            scenerixxSettings.setDupFinderDateEnd(endDate);
            scenerixxSettings.setDupFinderStartWithLongest(Boolean.valueOf(this.startWithLongestRuntime));
            scenerixxSettings.setDupFinderAbortDate(LocalDate.now());
            scenerixxSettings.setDupFinderCurrentSecond(currentSecond);
            scenerixxSettings = (ScenerixxSettings)IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)scenerixxSettings);
            IndexingTopComponent.this.db.setScenerixxSettings(scenerixxSettings);
            IndexingTopComponent.this.db.evictCache(ScenerixxSettings.class);
        }

        private void resetCurrentState() {
            LOG.info("Reset current state");
            ScenerixxSettings scenerixxSettings = IndexingTopComponent.this.db.getScenerixxSettings();
            scenerixxSettings.setDupFinderStart(null);
            scenerixxSettings.setDupFinderEnd(null);
            scenerixxSettings.setDupFinderThreshold(null);
            scenerixxSettings.setDupFinderDiffSeconds(null);
            scenerixxSettings.setDupFinderDateStart(null);
            scenerixxSettings.setDupFinderDateEnd(null);
            scenerixxSettings.setDupFinderStartWithLongest(null);
            scenerixxSettings.setDupFinderAbortDate(null);
            scenerixxSettings.setDupFinderCurrentSecond(null);
            scenerixxSettings = (ScenerixxSettings)IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)scenerixxSettings);
        }

        @Override
        protected String doInBackground() throws Exception {
            NavigableSet set;
            SortedMap map;
            LOG.info("Starting to find duplicates.");
            this.publish(Figlets.sFindDuplicates);
            this.publish("Starting to find duplicates.");
            this.publish("The gathering of the data might take a while.");
            IndexingTopComponent.this.alreadyAborting = false;
            IndexingTopComponent.this.discIsFull = false;
            this.resetCurrentState();
            IndexingTopComponent.this.resetProgressBars();
            IndexingTopComponent.this.jProgressBarFiles.setValue(0);
            IndexingTopComponent.this.jProgressBarSize.setVisible(false);
            IndexingTopComponent.this.lbProgressSize.setVisible(false);
            IndexingTopComponent.this.lbProgressFiles.setVisible(false);
            LOG.info("alreadyAborting: " + IndexingTopComponent.this.alreadyAborting + " - abortIndexing: " + abortIndexing + " - abortedAfterNextRuntime: " + this.abortedAfterNextRuntime);
            int cntDuplicates = 0;
            Long checkedDuplicates = 0L;
            Object screencapDirectory = Scenerixx.scenerixxScreencapDir;
            if (!((String)screencapDirectory).endsWith(File.separator)) {
                screencapDirectory = (String)screencapDirectory + File.separator;
            }
            LocalDateTime now = LocalDateTime.now();
            if (this.path == null) {
                LOG.info("no path set, consider all");
                map = IndexingTopComponent.this.db.getMoviesBetweenDatesForDuplicateFinder(this.startTime, this.endTime, Scenerixx.unlocked, this.startSecond, this.endSecond, this.secondsDiff, (String)screencapDirectory, 0L);
            } else {
                LOG.info("consider only: " + this.path);
                map = IndexingTopComponent.this.db.getMoviesBetweenDatesForDuplicateFinder(this.path, this.startTime, this.endTime, Scenerixx.unlocked, this.startSecond, this.endSecond, this.secondsDiff, (String)screencapDirectory, 0L);
            }
            LOG.info("map size: " + map.size());
            LOG.info("startWithLongestRuntime: " + this.startWithLongestRuntime);
            if (this.startWithLongestRuntime) {
                LOG.info("reverse order");
                set = ((TreeMap)map).descendingKeySet();
            } else {
                LOG.info("normal order");
                set = ((TreeMap)map).navigableKeySet();
            }
            this.publish(map.size() + " different runtimes to check");
            IndexingTopComponent.this.lbProgressSize.setText(map.size() + " different runtimes to check");
            int comparisonsToMake = 0;
            for (Object runtimeKey : set) {
                HashSet tmpScreencapIds = new HashSet();
                for (int i = ((Integer)runtimeKey).intValue(); i <= (Integer)runtimeKey + this.secondsDiff; ++i) {
                    if (map.get(i) == null || ((Set)map.get(i)).size() <= 1) continue;
                    LOG.finest("adding to screecapIds: " + i + " - " + ((Set)map.get(i)).size() + " - size before: " + tmpScreencapIds.size());
                    tmpScreencapIds.addAll((Collection)map.get(i));
                }
                LOG.info("tmpScreencapIds size " + tmpScreencapIds.size() + " - runtimekey: " + (Integer)runtimeKey);
                if (tmpScreencapIds.size() <= 1) continue;
                ArrayList tmpIds = new ArrayList(tmpScreencapIds);
                for (int i = 0; i < tmpScreencapIds.size(); ++i) {
                    for (int j = i; j < tmpScreencapIds.size(); ++j) {
                        Long id2;
                        Long id1 = (Long)tmpIds.get(i);
                        if (id1 != (id2 = (Long)tmpIds.get(j))) {
                            ++comparisonsToMake;
                        }
                        LOG.finest(" - i2 " + i + " - j: " + j + " - comp: " + comparisonsToMake);
                    }
                }
            }
            LOG.info("secondsDiff: " + this.secondsDiff);
            LOG.info("comparisons to make: " + comparisonsToMake);
            int currentIteration = 0;
            block8: for (Integer runtimeKey : set) {
                if (this.abortedAfterNextRuntime) {
                    this.userAbort(runtimeKey, true);
                    break;
                }
                if (abortIndexing && !IndexingTopComponent.this.alreadyAborting && !this.abortedAfterNextRuntime) {
                    this.userAbort(runtimeKey, false);
                    break;
                }
                if (abortIndexing && IndexingTopComponent.this.alreadyAborting && !this.abortedAfterNextRuntime) break;
                ++currentIteration;
                HashSet screencapIds = new HashSet();
                for (int i = runtimeKey.intValue(); i <= runtimeKey + this.secondsDiff; ++i) {
                    if (map.get(i) == null || ((Set)map.get(i)).size() <= 1) continue;
                    LOG.fine("adding to screecapIds: " + i);
                    screencapIds.addAll((Collection)map.get(i));
                }
                LOG.info("screencapIds size " + screencapIds.size());
                if (screencapIds.size() <= 1) {
                    LOG.info("current checked duplicates - only 1 - " + checkedDuplicates);
                    continue;
                }
                ArrayList ids = new ArrayList(screencapIds);
                this.publish(Figlets.sNextRuntime);
                this.publish("==== CHECKING CURRENT RUNTIME " + ScenerixxCommon.readableSecondsDurationInt(runtimeKey) + " (" + runtimeKey + " seconds), checking " + screencapIds.size() + " IDs -  currently " + cntDuplicates + " possible candidates ====");
                LOG.info("==== CHECKING CURRENT RUNTIME " + ScenerixxCommon.readableSecondsDurationInt(runtimeKey) + " (" + runtimeKey + " seconds), checking " + screencapIds.size() + " IDs -  currently " + cntDuplicates + " possible candidates ====");
                IndexingTopComponent.this.lbProgressSize.setText("Checking current runtime: " + ScenerixxCommon.readableSecondsDurationInt(runtimeKey) + " (" + runtimeKey + " seconds). Possible duplicates so far: " + cntDuplicates);
                for (int i = 0; !(i >= screencapIds.size() || abortIndexing && IndexingTopComponent.this.alreadyAborting && !this.abortedAfterNextRuntime); ++i) {
                    if (abortIndexing && !this.abortedAfterNextRuntime) {
                        this.userAbort(runtimeKey, false);
                        continue block8;
                    }
                    for (int j = i; j < screencapIds.size(); ++j) {
                        block41: {
                            LOG.info("current checked duplicates 2: " + checkedDuplicates);
                            if (abortIndexing && IndexingTopComponent.this.alreadyAborting && !this.abortedAfterNextRuntime) break;
                            if (abortIndexing && !this.abortedAfterNextRuntime) {
                                this.userAbort(runtimeKey, false);
                                break;
                            }
                            Long id1 = (Long)ids.get(i);
                            Long id2 = (Long)ids.get(j);
                            if (id1.longValue() != id2.longValue()) {
                                Long l = checkedDuplicates;
                                checkedDuplicates = checkedDuplicates + 1L;
                                LOG.info("current checked duplicates " + checkedDuplicates);
                                try {
                                    Object fileOne = "";
                                    if (new File((String)screencapDirectory + id1 + "_1.png").exists()) {
                                        fileOne = (String)screencapDirectory + id1 + "_1.png";
                                    } else {
                                        String doesFileWithIndexExist = ScenerixxCommonLib.doesFileWithIndexExist((String)((String)screencapDirectory + id1), (int)100);
                                        if (doesFileWithIndexExist != null) {
                                            fileOne = doesFileWithIndexExist;
                                        } else {
                                            LOG.info("Could not find screencap for ID " + id1);
                                            continue;
                                        }
                                    }
                                    Object fileTwo = "";
                                    if (new File((String)screencapDirectory + id2 + "_1.png").exists()) {
                                        fileTwo = (String)screencapDirectory + id2 + "_1.png";
                                    } else {
                                        String doesFileWithIndexExist = ScenerixxCommonLib.doesFileWithIndexExist((String)((String)screencapDirectory + id2), (int)100);
                                        if (doesFileWithIndexExist != null) {
                                            fileTwo = doesFileWithIndexExist;
                                        } else {
                                            LOG.info("Could not find screencap for ID " + id1);
                                            continue;
                                        }
                                    }
                                    double compareFilesDiff = this.dupFinder.compareFiles((String)fileOne, (String)fileTwo);
                                    this.publish("Compared " + id1 + " with " + id2 + " - Diff: " + this.decformat.format(compareFilesDiff));
                                    LOG.info("Compared " + id1 + " with " + id2 + " - Diff: " + this.decformat.format(compareFilesDiff));
                                    if (!(compareFilesDiff <= this.thresholdValue)) break block41;
                                    Movie movie1 = (Movie)IndexingTopComponent.this.db.getEntityService().load(Movie.class, id1.longValue());
                                    Movie movie2 = (Movie)IndexingTopComponent.this.db.getEntityService().load(Movie.class, id2.longValue());
                                    NoDuplicate findFirst = (NoDuplicate)IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)id1)).filter(f -> f.movieIdOther.eq((Object)id2)).findFirst();
                                    NoDuplicate findOther = (NoDuplicate)IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)id2)).filter(f -> f.movieIdOther.eq((Object)id1)).findFirst();
                                    if (findFirst != null || findOther != null) {
                                        this.publish(Figlets.sNoDuplicate);
                                        this.publish("'" + movie1.getTitle() + "' and '" + movie2.getTitle() + "' has been marked as no duplicate by you. Skip it.");
                                        break block41;
                                    }
                                    boolean added = false;
                                    if (this.dupPlaylist == null) {
                                        this.dupPlaylist = new Playlist();
                                        this.dupPlaylist.setName("Possible duplicates " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                                        this.dupPlaylist = (Playlist)IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)this.dupPlaylist);
                                    }
                                    this.dupPlaylist = (Playlist)IndexingTopComponent.this.db.getEntityService().load(Playlist.class, this.dupPlaylist.getId().longValue());
                                    if (!this.ps.contains((IPlayable)movie1, this.dupPlaylist, Scenerixx.unlocked)) {
                                        PlaylistEntry pe1 = new PlaylistEntry();
                                        pe1.setDateOfCreation(LocalDateTime.now());
                                        pe1.setMovie(movie1);
                                        this.dupPlaylist = this.ps.addPlaylistEntry(pe1, this.dupPlaylist, Scenerixx.unlocked);
                                        added = true;
                                    }
                                    if (!this.ps.contains((IPlayable)movie2, this.dupPlaylist, Scenerixx.unlocked)) {
                                        PlaylistEntry pe2 = new PlaylistEntry();
                                        pe2.setDateOfCreation(LocalDateTime.now());
                                        pe2.setMovie(movie2);
                                        this.dupPlaylist = this.ps.addPlaylistEntry(pe2, this.dupPlaylist, Scenerixx.unlocked);
                                        added = true;
                                    }
                                    if (added) {
                                        ++cntDuplicates;
                                    }
                                    this.publish(Figlets.sDuplicate);
                                    this.publish("Possible duplicate: '" + movie1.getTitle() + "' and '" + movie2.getTitle() + "'");
                                    LOG.info("POSSIBLE DUPLICATE: '" + movie1.getTitle() + "' and '" + movie2.getTitle() + "'");
                                    try {
                                        LOG.info("-> [1]" + ((MediumFile)movie1.getStartMedium()).getFileCompletePath());
                                        LOG.info("-> [2]" + ((MediumFile)movie2.getStartMedium()).getFileCompletePath());
                                    }
                                    catch (Exception e) {
                                        LOG.info("-> No further information");
                                    }
                                    this.publish("-> possible duplicates so far: " + ScenerixxCommon.singularPlural(cntDuplicates, "movie", true));
                                    LOG.info("-> map contains currently " + cntDuplicates + " movies");
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(DuplicateFinder.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                        Double completed = (double)checkedDuplicates.longValue() * 100.0 / (double)comparisonsToMake;
                        long timeAhead = -1L;
                        if (checkedDuplicates > 0L) {
                            timeAhead = Duration.between(now, LocalDateTime.now()).toSeconds() * 100L / checkedDuplicates * ((long)comparisonsToMake - checkedDuplicates) / 100L;
                        }
                        IndexingTopComponent.this.jProgressBarFiles.setString(this.nf.format(checkedDuplicates) + " / " + this.nf.format(comparisonsToMake) + " - " + this.decformat.format(completed) + "% - Possible duplicates so far: " + this.nf.format(cntDuplicates) + " - (ETA: ~" + ScenerixxCommon.readableRuntime(timeAhead) + ")");
                        IndexingTopComponent.this.jProgressBarFiles.setValue(completed.intValue());
                        LOG.finer("checkedDup: " + checkedDuplicates);
                        LOG.finer("comparisonsToMake: " + comparisonsToMake);
                        LOG.finer("completed: " + completed);
                    }
                    IndexingTopComponent.this.jProgressBarFiles.setToolTipText("==== Runtime: " + currentIteration + "/" + set.size() + " - Checking ID " + i + " from " + screencapIds.size() + " at " + ScenerixxCommon.readableSecondsDurationInt(runtimeKey) + " (" + runtimeKey + " seconds) -  currently " + cntDuplicates + " possible candidates ====");
                }
            }
            Object playlist = "";
            if (this.dupPlaylist != null) {
                playlist = "Check the playlist '" + this.dupPlaylist.getName() + "'";
            }
            IndexingTopComponent.this.jProgressBarFiles.setString("We are done. Found " + this.nf.format(cntDuplicates) + " possible " + ScenerixxCommon.singularPlural(cntDuplicates, "duplicate", "duplicates", false) + ". " + (String)playlist);
            this.publish(Figlets.sFinished);
            this.publish("We are done. Found " + cntDuplicates + " possible " + ScenerixxCommon.singularPlural(cntDuplicates, "duplicate", "duplicates", false) + ". " + (String)playlist);
            this.publish("Hint: the amount of possible duplicates do not neccessarily have to be exactly the half of the entries on the playlist. This happens e.g. if one movie exist thrice on the disk.");
            this.publish("Finished finding duplicates.\n");
            if (this.dupPlaylist != null) {
                this.publish("To sort out duplicate movies open the playlist '" + this.dupPlaylist.getName() + "' in the movies tab (show playlist).");
            }
            if (!this.abortedByUser) {
                this.resetCurrentState();
            }
            IndexingTopComponent.this.setAbortButtonEnabled(false);
            return null;
        }

        private void userAbort(Integer runtimeKey, boolean forceAbort) {
            LOG.info("user abort! forceAbout : " + forceAbort + " - abortIndexing: " + abortIndexing + " - abortedAfterNextRuntime: " + this.abortedAfterNextRuntime);
            abortIndexing = true;
            if (!(IndexingTopComponent.this.alreadyAborting || this.abortedAfterNextRuntime || forceAbort)) {
                int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Abort after the current runtime?<br><br>You can wait until the check of the current runtime has finished (press 'Yes' to resume later).<br><br>If you want to cancel right away press 'No'. If you want to continue: 'Cancel'</html>", "Wait for current runtime to finish?", 1, 1);
                if (showInternalConfirmDialog == 0) {
                    this.abortedAfterNextRuntime = true;
                    this.publish("We will abort after finishing with the current runtime.");
                } else if (showInternalConfirmDialog == 1) {
                    forceAbort = true;
                } else {
                    abortIndexing = false;
                    IndexingTopComponent.this.setAbortButtonEnabled(true);
                    return;
                }
            }
            if (!IndexingTopComponent.this.alreadyAborting && forceAbort) {
                this.publish(Figlets.sAborted);
                this.publish("User aborted. Current runtime : " + ScenerixxCommon.readableSecondsDurationInt(runtimeKey) + " (" + runtimeKey + " seconds)");
                if (this.dupPlaylist != null) {
                    this.publish("To sort out duplicate movies open the playlist '" + this.dupPlaylist.getName() + "' in the movies tab (show playlist).");
                }
                this.saveCurrentState(runtimeKey);
                IndexingTopComponent.this.alreadyAborting = true;
                IndexingTopComponent.this.discIsFull = false;
            }
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                if (IndexingTopComponent.this.taLog.getLineCount() > 10000) {
                    IndexingTopComponent.this.taLog.setText("");
                }
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s + "\n");
                if (!s.equals("Finished finding duplicates.\n")) continue;
                if (this.shutdownAfterFinish) {
                    LOG.info("We are done here. Shutdown now...");
                    try {
                        ScenerixxCommon.shutdown();
                    }
                    catch (IOException | RuntimeException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                LOG.info("We are done here. Just reloading the playlists.");
                if (this.dupPlaylist == null) continue;
                IndexingTopComponent.this.reloadPlaylist(this.dupPlaylist);
            }
        }
    }

    public class PurgeScreencapsWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final int maxDepth = 1;

        @Override
        protected String doInBackground() throws Exception {
            IndexingTopComponent.this.setAbortButtonEnabled(true);
            int deletedScreencaps = 0;
            int deletedScreencapsWitzZeroSize = 0;
            int indexMov = 0;
            int indexSc = 0;
            String screencapDirectory = Scenerixx.scenerixxScreencapDir;
            String screencapSceneDirectory = Scenerixx.scenerixxScreencapDir + File.separator + "scene";
            this.publish(Figlets.sPurgeScreencaps);
            this.publish("Reading in available movie screencaps from directory: " + screencapDirectory);
            HashSet<String> movieScreencapsFileNames = new HashSet<String>();
            try (Stream<Path> paths = Files.walk(Paths.get(screencapDirectory, new String[0]), 1, new FileVisitOption[0]);){
                for (Object filePath : paths.collect(Collectors.toList())) {
                    if (!abortIndexing) {
                        if (Files.isDirectory((Path)filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                        movieScreencapsFileNames.add(filePath.getFileName().toString());
                        continue;
                    }
                    this.publish("User requested to abort screencap purging.\n");
                    IndexingTopComponent.this.jProgressBarSize.setValue(100);
                    IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                    break;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
            }
            this.publish(movieScreencapsFileNames.size() + " movie screencaps found");
            this.publish("Reading now available scene screencaps from directory: " + screencapSceneDirectory);
            HashSet<String> sceneScreencapsFileNames = new HashSet<String>();
            try (Stream<Path> paths = Files.walk(Paths.get(screencapSceneDirectory, new String[0]), 1, new FileVisitOption[0]);){
                for (Object filePath : paths.collect(Collectors.toList())) {
                    if (!abortIndexing) {
                        if (Files.isDirectory((Path)filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                        sceneScreencapsFileNames.add(filePath.getFileName().toString());
                        continue;
                    }
                    this.publish("User requested to abort screencap purging.\n");
                    IndexingTopComponent.this.jProgressBarSize.setValue(100);
                    IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                    break;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            this.publish(sceneScreencapsFileNames.size() + " scene screencaps found");
            List movieIdsFromDb = IndexingTopComponent.this.db.getMovies(true).stream().map(f -> f.getId()).collect(Collectors.toList());
            HashSet movieIdFromDbSet = new HashSet();
            movieIdFromDbSet.addAll(movieIdsFromDb);
            for (String s : movieScreencapsFileNames) {
                ++indexMov;
                if (abortIndexing) {
                    this.publish("User requested to abort screencap purging.\n");
                    IndexingTopComponent.this.jProgressBarSize.setValue(100);
                    IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                    break;
                }
                String movScreencapFile = screencapDirectory + File.separator + s;
                File f2 = new File(movScreencapFile);
                if (f2.length() == 0L) {
                    this.publish("File size is zero. Delete " + movScreencapFile);
                    f2.delete();
                    ++deletedScreencapsWitzZeroSize;
                } else if (f2.getName().contains("_tmp_")) {
                    this.publish("File is a temporary file. Delete " + movScreencapFile);
                    f2.delete();
                } else if (s.contains("_")) {
                    try {
                        String movieIdFromFileString = s.substring(0, s.indexOf("_"));
                        Long movieIdFromFileLong = Long.parseLong(movieIdFromFileString);
                        if (!movieIdFromDbSet.contains(movieIdFromFileLong)) {
                            this.publish("Movie with ID " + movieIdFromFileLong + " does not exist anymore. Going to delete " + movScreencapFile);
                            f2.delete();
                            ++deletedScreencaps;
                        }
                    }
                    catch (Exception movieIdFromFileString) {}
                }
                if (indexMov % 100 != 0) continue;
                this.publish("Checked " + indexMov + " movie screencaps");
            }
            this.publish("Gathering scene screencaps. That could take a while.");
            List sceneIdsFromDb = IndexingTopComponent.this.db.getScenes(true).stream().map(f -> f.getId()).collect(Collectors.toList());
            HashSet sceneIdFromDbSet = new HashSet();
            sceneIdFromDbSet.addAll(sceneIdsFromDb);
            for (String s : sceneScreencapsFileNames) {
                ++indexSc;
                if (abortIndexing) {
                    this.publish("User requested to abort screencap purging.\n");
                    IndexingTopComponent.this.jProgressBarSize.setValue(100);
                    IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                    break;
                }
                String scScreencapFile = screencapSceneDirectory + File.separator + s;
                File f3 = new File(scScreencapFile);
                if (f3.length() == 0L) {
                    this.publish("File size is zero. Delete " + scScreencapFile);
                    f3.delete();
                    ++deletedScreencapsWitzZeroSize;
                } else if (f3.getName().contains("_tmp_")) {
                    this.publish("File is a temporary file. Delete " + scScreencapFile);
                    f3.delete();
                    ++deletedScreencaps;
                } else if (s.contains("_")) {
                    try {
                        String sceneIdFromFileString = s.substring(0, s.indexOf("_"));
                        Long sceneIdFromFileLong = Long.parseLong(sceneIdFromFileString);
                        if (!sceneIdFromDbSet.contains(sceneIdFromFileLong)) {
                            this.publish("Scene with ID " + sceneIdFromFileLong + " does not exist anymore. Going to delete " + scScreencapFile);
                            f3.delete();
                            ++deletedScreencaps;
                        }
                    }
                    catch (Exception exception) {}
                }
                if (indexSc % 100 != 0) continue;
                this.publish("Checked " + indexSc + " scene screencaps");
            }
            this.publish("=================");
            this.publish("Deleted " + deletedScreencaps + " screencaps due to missing movies or scenes or being a temporary file");
            if (deletedScreencapsWitzZeroSize > 0) {
                this.publish("Deleted " + deletedScreencapsWitzZeroSize + " screencaps because file size has been zero.");
            }
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s + "\n");
            }
        }
    }

    public class ImportImportFilesWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final String finished_import_importing_files = "Finished copying import files.\n";

        @Override
        protected void done() {
            super.done();
            new ImportingWorker().execute();
        }

        @Override
        protected String doInBackground() throws Exception {
            LOG.info("Going to import '" + String.valueOf(IndexingTopComponent.this.jFileChooser2.getSelectedFile()) + "'.");
            abortIndexing = false;
            IndexingTopComponent.this.setAbortButtonEnabled(true);
            try {
                FileSystem zipFs = FileSystems.newFileSystem(IndexingTopComponent.this.jFileChooser2.getSelectedFile().toPath(), (ClassLoader)null);
                for (Path root : zipFs.getRootDirectories()) {
                    Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Path targetPath = Paths.get(Scenerixx.scenerixxFilesDirBase + File.separator + String.valueOf(file.getParent()) + File.separator + String.valueOf(file.getFileName()), new String[0]);
                            if (Files.exists(targetPath, new LinkOption[0])) {
                                LOG.fine("File '" + String.valueOf(file.getFileName()) + "' already exists at '" + Scenerixx.scenerixxFilesDirBase + File.separator + String.valueOf(file.getFileName()) + "'");
                                ImportImportFilesWorker.this.publish(new String[]{"File '" + String.valueOf(file.getFileName()) + "' already exists at '" + Scenerixx.scenerixxFilesDirBase + File.separator + String.valueOf(file.getFileName()) + "'\n"});
                            } else {
                                LOG.fine("Copying file '" + String.valueOf(file.getFileName()) + "' to '" + Scenerixx.scenerixxFilesDirBase + File.separator + String.valueOf(file.getParent()) + File.separator + String.valueOf(file.getFileName()) + "'");
                                ImportImportFilesWorker.this.publish(new String[]{"Copying file '" + String.valueOf(file.getFileName()) + "' to '" + Scenerixx.scenerixxFilesDirBase + File.separator + String.valueOf(file.getParent()) + File.separator + String.valueOf(file.getFileName()) + "'\n"});
                                try {
                                    targetPath.toFile().mkdirs();
                                    Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                                }
                                catch (IOException ex) {
                                    ImportImportFilesWorker.this.publish(new String[]{"An error occurred copying the file " + String.valueOf(file.getFileName()) + " to " + String.valueOf(targetPath) + ". Skip this one. Exception message: " + ex.getMessage() + "\n"});
                                    ex.printStackTrace();
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return super.preVisitDirectory(dir, attrs);
                        }
                    });
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                LOG.severe("An error occured reading the importfile: " + ex.getMessage());
                this.publish("An error occured reading the importfile: \n" + ex.getMessage() + "\n");
                JOptionPane.showMessageDialog(null, "An error occured reading the importfile: \n" + ex.getMessage(), "Error", 0);
            }
            this.publish("Finished copying import files.\n");
            IndexingTopComponent.this.setAbortButtonEnabled(false);
            LOG.finest("Finished copying import files.");
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished copying import files.\n")) continue;
                AbstractTopComponent.dirtyMediumFileList();
                AbstractTopComponent.dirtyMovieList();
                AbstractTopComponent.dirtyPersonList();
            }
        }
    }

    public class UpdateMediaInformationWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final MediaInformation media = new MediaInformation();
        private final String finished_updating_media_information = "Finished updating media information.\n";
        private Long totalSize = 0L;
        private Long updatedSize = 0L;
        private Long fileCounter = 0L;
        private Long currentIndex = 0L;

        @Override
        protected String doInBackground() throws Exception {
            IndexingTopComponent.this.resetProgressBars();
            this.publish(Figlets.sUpdateMediainformation);
            this.publish("Gathering information. This can take a bit.");
            List mediumFiles = IndexingTopComponent.this.db.getMediumFiles("", true, false, Integer.MAX_VALUE, false, false, true, null, false);
            this.fileCounter = mediumFiles.size();
            for (MediumFile mf : mediumFiles) {
                this.totalSize = this.totalSize + mf.getFileSize();
            }
            for (MediumFile mf : mediumFiles) {
                Long l = this.currentIndex;
                this.currentIndex = this.currentIndex + 1L;
                this.updatedSize = this.updatedSize + mf.getFileSize();
                if (abortIndexing) {
                    this.publish("Aborted updating media information.\n");
                    return null;
                }
                boolean save = false;
                LOG.finer("Try to retrieve media information for file " + mf.getFileCompletePath());
                if (mf.getHeight() == null || mf.getWidth() == null || mf.getDuration() == null) {
                    this.publish("Try to retrieve media information for file " + mf.getFileCompletePath() + "\n");
                }
                try {
                    String duration;
                    String width;
                    String height;
                    if (mf.getHeight() == null && !(height = this.media.getMediaInfoValue("--Inform=Video;%Height%", mf.getFileCompletePath())).isEmpty()) {
                        mf.setHeight(Integer.valueOf(Integer.parseInt(height)));
                        save = true;
                    }
                    if (mf.getWidth() == null && !(width = this.media.getMediaInfoValue("--Inform=Video;%Width%", mf.getFileCompletePath())).isEmpty()) {
                        mf.setWidth(Integer.valueOf(Integer.parseInt(width)));
                        save = true;
                    }
                    if (mf.getDuration() == null && !(duration = this.media.getMediaInfoValue("--Inform=Video;%Duration%", mf.getFileCompletePath())).isEmpty()) {
                        if (duration.contains(".")) {
                            duration = duration.substring(0, duration.indexOf("."));
                        }
                        mf.setDuration(Integer.valueOf(Integer.parseInt(duration)));
                        save = true;
                    }
                }
                catch (Exception ex) {
                    AbstractTopComponent.notify("Could not retrieve media information: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
                if (save) {
                    IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)mf);
                    LOG.fine("Updated media information for file: " + mf.getFileCompletePath());
                    this.publish("Updated media information for file: " + mf.getFileCompletePath() + ": " + mf.getWidth() + "x" + mf.getHeight() + " - " + mf.getDuration() + "\n");
                }
                Long completed = this.updatedSize * 100L / this.totalSize;
                IndexingTopComponent.this.jProgressBarSize.setValue(completed.intValue());
                Long completedFiles = this.currentIndex * 100L / this.fileCounter;
                IndexingTopComponent.this.jProgressBarFiles.setValue(completedFiles.intValue());
            }
            this.publish("Finished updating media information.\n");
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished updating media information.\n")) continue;
                AbstractTopComponent.dirtyMediumFileList();
                AbstractTopComponent.dirtyMovieList();
            }
        }
    }

    public class GenerateScreencapsWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final String finished_generating_screencaps = "Finished generating screencaps.\n";
        private Long totalSize = 0L;
        private Long generatedSize = 0L;
        private Long movieCounter = 0L;
        private Long currentIndex = 0L;
        int screencapsLeft = 0;

        private boolean containsString(Set<String> set, String searchTerm) {
            for (String s : set) {
                if (!s.contains(searchTerm)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected String doInBackground() throws Exception {
            List mediumFiles;
            List<Movie> movies;
            block79: {
                int specificDirectory;
                block83: {
                    block82: {
                        IndexingTopComponent.this.resetProgressBars();
                        File screencapDir = new File(Scenerixx.scenerixxScreencapDir);
                        screencapDir.mkdirs();
                        long usableSpace = screencapDir.getUsableSpace();
                        if (usableSpace < 120000000L) {
                            if (IndexingTopComponent.this.discIsFull) return null;
                            this.publish("***** YOUR DISK IS FULL ***** (or not available)! System says " + usableSpace + " bytes left in '" + String.valueOf(screencapDir) + "'. Abort creating screencaps");
                            JOptionPane.showMessageDialog(null, "<html>Your disc is (nearly) full.<br>We cannot generate any screencaps.<br>We cannot find any duplicates for movies without screencaps.</html>", "Error", 0);
                            IndexingTopComponent.this.discIsFull = true;
                            return null;
                        }
                        this.publish(Figlets.sScreencapGenerateScreencaps);
                        this.publish("Preparing generation of screencaps.\n");
                        movies = new ArrayList();
                        specificDirectory = JOptionPane.showInternalConfirmDialog(null, "<html>Generate all screencaps?<br><br>Press YES if you want to generate all outstanding screencaps.<br><br>Press NO if you want to specify a directory where outstanding screencaps should be generated</html>", "Generate all screencaps?", 1, 3);
                        if (specificDirectory != 0) break block82;
                        LOG.info("Generate ALL screencaps");
                        movies = IndexingTopComponent.this.db.getMovies(Scenerixx.unlocked);
                        break block79;
                    }
                    if (specificDirectory != 1) break block83;
                    LOG.info("Generate only specific screencaps");
                    ScenerixxSettings scenerixxSettings = IndexingTopComponent.this.db.getScenerixxSettings();
                    if (scenerixxSettings.getLastScreencapDirectory() != null && Files.exists(Paths.get(scenerixxSettings.getLastScreencapDirectory(), new String[0]), new LinkOption[0])) {
                        LOG.info("Use last opened directory: " + scenerixxSettings.getLastScreencapDirectory());
                        IndexingTopComponent.this.jFileChooser2.setCurrentDirectory(new File(scenerixxSettings.getLastScreencapDirectory()));
                    }
                    IndexingTopComponent.this.jFileChooser2.setFileSelectionMode(1);
                    int ret = IndexingTopComponent.this.jFileChooser2.showOpenDialog((Component)((Object)IndexingTopComponent.this));
                    if (ret == 0) {
                        scenerixxSettings.setLastScreencapDirectory(IndexingTopComponent.this.jFileChooser2.getSelectedFile().getAbsolutePath());
                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)scenerixxSettings);
                        String absolutePath = IndexingTopComponent.this.jFileChooser2.getSelectedFile().getAbsolutePath();
                        LOG.info("User selected: " + (String)absolutePath);
                        try (Stream<Path> paths = Files.walk(Paths.get(IndexingTopComponent.this.jFileChooser2.getSelectedFile().getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                            for (Object filePath : paths.collect(Collectors.toList())) {
                                Movie movie;
                                if (Files.isDirectory((Path)filePath, LinkOption.NOFOLLOW_LINKS) || (movie = IndexingTopComponent.this.db.getMovie(filePath.toFile().getAbsolutePath())) == null) continue;
                                movies.add(movie);
                                LOG.info("Added movie without screencap: " + movie.getTitle());
                            }
                            break block79;
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                        }
                    }
                    break block79;
                }
                if (specificDirectory == 2) {
                    return null;
                }
            }
            new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene").mkdirs();
            ArrayList<Long> movieIdsWithScreencap = new ArrayList<Long>();
            try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), 1, new FileVisitOption[0]);){
                for (Object filePath : paths.collect(Collectors.toList())) {
                    if (Files.isDirectory((Path)filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                    try {
                        if (abortIndexing) {
                            this.publish("Aborted generating screencaps.\n");
                            Iterator iterator = null;
                            return iterator;
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                    }
                    {
                        if (!filePath.getFileName().toString().contains("_") || !filePath.getFileName().toString().endsWith(".png")) continue;
                        try {
                            Long parseLong = Long.parseLong(filePath.getFileName().toString().substring(0, filePath.getFileName().toString().indexOf("_")));
                            LOG.fine(filePath.getFileName().toString() + " matches with ID: " + parseLong + ".");
                            movieIdsWithScreencap.add(parseLong);
                        }
                        catch (Exception ex) {
                            LOG.info("Could not parse ID from " + String.valueOf(filePath.getFileName()));
                        }
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
            }
            if (movieIdsWithScreencap.isEmpty()) {
                movieIdsWithScreencap.add(-1L);
            }
            int errorCount = 0;
            ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
            this.screencapsLeft = movies.size();
            this.movieCounter = movies.size();
            for (Movie m : movies) {
                if (movieIdsWithScreencap.contains(m.getId())) {
                    --this.screencapsLeft;
                    continue;
                }
                for (MediumFile mediumFile : IndexingTopComponent.this.db.getMediumFiles(m, true)) {
                    this.totalSize = this.totalSize + mediumFile.getFileSize();
                }
            }
            this.publish("Generate " + this.screencapsLeft + " screencaps.\n");
            Set<String> screencapFileNames = Stream.of(new File(Scenerixx.scenerixxScreencapDir + File.separator).listFiles()).filter(file -> !file.isDirectory()).map(File::getName).collect(Collectors.toSet());
            ScenerixxSettings settings = IndexingTopComponent.this.db.getScenerixxSettings();
            for (Movie movie : movies) {
                Long l = this.currentIndex;
                this.currentIndex = this.currentIndex + 1L;
                if (abortIndexing) {
                    IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                    IndexingTopComponent.this.jProgressBarSize.setValue(100);
                    this.publish("Aborted generating screencaps.\n");
                    return null;
                }
                boolean startFfmpeg = true;
                if (movieIdsWithScreencap.contains(movie.getId())) {
                    LOG.finest("We have already a screencap for the movie with the ID " + movie.getId());
                    boolean allFilesHaveScreencaps = true;
                    int i = 0;
                    for (Object mf : IndexingTopComponent.this.db.getMediumFiles(movie, Scenerixx.unlocked)) {
                        ++i;
                        if (this.containsString(screencapFileNames, movie.getId() + "_")) continue;
                        allFilesHaveScreencaps = false;
                    }
                    if (allFilesHaveScreencaps) {
                        startFfmpeg = false;
                    }
                }
                if (startFfmpeg) {
                    Object mf2;
                    this.publish("Check if we need to create screencaps for movie  '" + movie.getTitle() + "' (ID: " + movie.getId() + ")");
                    LOG.finest("Create screencaps for movie '" + movie.getTitle());
                    int i = 0;
                    List tmpMediumFiles = IndexingTopComponent.this.db.getMediumFiles(movie, Scenerixx.unlocked);
                    mediumFiles = new ArrayList<MediumFile>();
                    for (Object mf2 : tmpMediumFiles) {
                        if (!MediumFileService.isMovie((MediumFile)mf2)) continue;
                        mediumFiles.add(mf2);
                    }
                    int totalImages = settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow();
                    mf2 = mediumFiles.iterator();
                    while (mf2.hasNext()) {
                        MediumFile mf3 = (MediumFile)mf2.next();
                        boolean notFound = false;
                        boolean notFound2 = false;
                        if (!this.containsString(screencapFileNames, movie.getId() + "_" + formatter.format(++i) + ".png")) {
                            notFound = true;
                        }
                        if (!this.containsString(screencapFileNames, movie.getId() + "_" + i + ".png")) {
                            notFound2 = true;
                        }
                        if (!notFound || !notFound2) continue;
                        this.publish("Create screencap for medium file: " + mf3.getFileCompletePath() + " (Movie-ID: " + mf3.getMovie().getId() + ") - " + ScenerixxCommon.readableFileSize(mf3.getFileSize()) + " - " + ScenerixxCommon.readableDuration(mf3.getDuration()));
                        if (mf3.getTotalRuntime() == 0) {
                            errorMessage = "Cannot create screencap for " + mf3.getFileCompletePath() + " since the runtime is not known! Either update the media information or provide the runtime manually.";
                            this.publish(errorMessage);
                            errorMessages.add((CallSite)((Object)errorMessage));
                            ++errorCount;
                        } else if (!Files.exists(Paths.get(mf3.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                            errorMessage = "Cannot create screencap for " + mf3.getFileCompletePath() + " since the file is not available.";
                            this.publish(errorMessage);
                            errorMessages.add((CallSite)((Object)errorMessage));
                            ++errorCount;
                        } else {
                            this.publish("Creating " + totalImages + " temporary files");
                            ScreencapService.createMovieScreencap(movie, i, totalImages);
                            break;
                        }
                        --this.screencapsLeft;
                        this.generatedSize = this.generatedSize + mf3.getFileSize();
                        Long completed = this.generatedSize * 100L / this.totalSize;
                        IndexingTopComponent.this.jProgressBarSize.setValue(completed.intValue());
                        Long completedFiles = this.currentIndex * 100L / this.movieCounter;
                        IndexingTopComponent.this.jProgressBarFiles.setValue(completedFiles.intValue());
                        if (abortIndexing || this.screencapsLeft == 0) continue;
                        this.publish("Generate " + this.screencapsLeft + " more screencaps.");
                    }
                }
                if (!settings.isScreencapGenerateScenes()) continue;
                if (movie.getScenes().size() > 1) {
                    this.publish("Generate screencaps for scenes for movie '" + movie.getTitle() + "' if needed");
                    for (Scene s : movie.getScenes()) {
                        ScreencapService.generateSceneScreencaps(s);
                    }
                    continue;
                }
                LOG.fine("Movie has only one scene. Skip screencap generation for scene.");
            }
            if (errorCount > 0) {
                this.publish("\n----");
                this.publish(errorCount + " screencaps could not be created.");
                this.publish("Collected error messages:");
                for (String string : errorMessages) {
                    this.publish(" * " + string);
                }
                this.publish("Check output for further details. Following movies are missing a screencap:");
                movieIdsWithScreencap = new ArrayList();
                try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), 1, new FileVisitOption[0]);){
                    for (Path filePath : paths.collect(Collectors.toList())) {
                        if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                        try {
                            if (abortIndexing) {
                                this.publish("Aborted generating screencaps.\n");
                                String i = null;
                                return i;
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                        }
                        {
                            if (!filePath.getFileName().toString().contains("_") || !filePath.getFileName().toString().endsWith(".png")) continue;
                            try {
                                Long parseLong = Long.parseLong(filePath.getFileName().toString().substring(0, filePath.getFileName().toString().indexOf("_")));
                                movieIdsWithScreencap.add(parseLong);
                            }
                            catch (Exception ex) {
                                LOG.info("Could not parse ID from " + String.valueOf(filePath.getFileName()));
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
                if (movieIdsWithScreencap.isEmpty()) {
                    movieIdsWithScreencap.add(-1L);
                }
                List movies2 = IndexingTopComponent.this.db.getMovies(Scenerixx.unlocked);
                this.screencapsLeft = movies2.size();
                ArrayList<Movie> arrayList = new ArrayList<Movie>();
                this.totalSize = 0L;
                for (Movie m : movies2) {
                    if (movieIdsWithScreencap.contains(m.getId())) {
                        --this.screencapsLeft;
                        continue;
                    }
                    arrayList.add(m);
                    for (MediumFile mf : IndexingTopComponent.this.db.getMediumFiles(m, true)) {
                        this.totalSize = this.totalSize + mf.getFileSize();
                    }
                }
                if (!arrayList.isEmpty()) {
                    this.publish("We couldn't create " + arrayList.size() + " screencaps (with a total size of " + ScenerixxCommon.readableFileSize(this.totalSize) + ") for the following movies: \n");
                    int i = 0;
                    for (Movie m : arrayList) {
                        this.publish(++i + ". " + m.getTitle());
                        mediumFiles = IndexingTopComponent.this.db.getMediumFiles(m, true);
                        if (mediumFiles.isEmpty()) {
                            Dvd dvd = IndexingTopComponent.this.db.getDvd(m, true);
                            if (dvd != null) {
                                this.publish("   -> DVD");
                                continue;
                            }
                            this.publish("   -> no medium file");
                            continue;
                        }
                        for (Object mf2 : mediumFiles) {
                            if (!Files.exists(Paths.get(mf2.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                                this.publish("   -> File does not exist: " + mf2.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(mf2.getFileSize()) + "]");
                                continue;
                            }
                            if (mf2.getTotalRuntime() <= 0) {
                                this.publish("   -> Missing runtime information: " + mf2.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(mf2.getFileSize()) + "] Execute 'Update Mediainformation' and then try again.");
                                continue;
                            }
                            this.publish("   -> " + mf2.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(mf2.getFileSize()) + "]");
                        }
                    }
                    this.publish("\n");
                    this.publish("Possible reasons for failure:");
                    this.publish("* File was not available");
                    this.publish("* Runtime information is missing");
                    this.publish("* Movie length is too short");
                    this.publish("* Unsupported format, e.g. *.ISO");
                    this.publish("* Broken stream (file can still be played sometimes)");
                    this.publish("* Broken or empty file (file cannot be played at all)");
                }
            }
            if (!settings.isScreencapGenerateScenes()) {
                this.publish("Screencaps for single scenes in a movie have NOT been generated. You can activate the generation of single scenes under Tools / Options / Screencaps");
            }
            IndexingTopComponent.this.jProgressBarFiles.setValue(100);
            IndexingTopComponent.this.jProgressBarSize.setValue(100);
            this.publish("Finished generating screencaps.\n");
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s + "\n");
            }
        }
    }

    public class PurgeWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final String finished_purging = "Finished purging.\n";

        private void deleteMediumFile(MediumFile mf) {
            this.publish("Trying to delete database entry for " + mf.getFileCompletePath() + "\n");
            if (!IndexingTopComponent.this.db.deleteMediumFileCascaded(mf) && IndexingTopComponent.this.db.getEntityService().getEntityManager().find(mf.getClass(), (Object)mf.getId()) != null) {
                AbstractTopComponent.notify("Error deleting", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "The file '" + mf.getFileCompletePath() + "' could not be deleted. There seems to be still an association.", null, NotificationDisplayer.Priority.HIGH);
                this.publish("The database entry for '" + mf.getFileCompletePath() + "' could not be deleted. There seems to be still an association.\n");
            }
        }

        @Override
        protected String doInBackground() throws Exception {
            IndexingTopComponent.this.resetProgressBars();
            this.publish(Figlets.sPurge);
            this.publish("Finding detached person body objects.\n");
            int deletedPb = 0;
            List persons = IndexingTopComponent.this.db.getPersons(Scenerixx.unlocked);
            this.publish("Checking: " + persons.size() + " persons.\n");
            for (Person p : persons) {
                Object pbToDelete;
                int pbSize;
                int iPb = 0;
                this.publish("Checking: " + p.getName() + "\n");
                int j = 1;
                boolean allEmpty = true;
                for (PersonBody pb : p.getPersonBodys()) {
                    if (p.getPersonBodys().size() <= 1) continue;
                    this.publish(++iPb + " - " + p.getPersonBodys().size() + " - " + p.getName() + " - " + pb.toString() + "\n");
                    if (pb.getAssSize() != null || pb.getTitsSize() != null || pb.getBodyType() != null || !pb.getAppearance().isEmpty() || pb.isFakeTits() != null) {
                        allEmpty = false;
                        this.publish(j + " is NOT empty\n");
                        break;
                    }
                    this.publish(j + " is empty\n");
                    ++j;
                }
                if (allEmpty) {
                    pbSize = p.getPersonBodys().size();
                    if (pbSize <= 0) continue;
                    for (int k = pbSize - 1; k >= 1; --k) {
                        this.publish("All are empty. Delete everything but the first.\n");
                        pbToDelete = (PersonBody)p.getPersonBodys().get(k);
                        this.publish(++iPb + " - " + p.getPersonBodys().size() + " - " + p.getName() + " - " + pbToDelete.toString() + "\n");
                        p.getPersonBodys().remove(pbToDelete);
                        IndexingTopComponent.this.db.getEntityService().delete((AbstractEntity)pbToDelete);
                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)p);
                        ++deletedPb;
                    }
                    continue;
                }
                this.publish("Delete all emtpy ones.\n");
                pbSize = p.getPersonBodys().size();
                if (pbSize <= 0) continue;
                for (int k = pbSize - 1; k >= 0; --k) {
                    pbToDelete = (PersonBody)p.getPersonBodys().get(k);
                    this.publish(++iPb + " - " + p.getPersonBodys().size() + " - " + p.getName() + " - " + pbToDelete.toString() + "\n");
                    if (pbToDelete.getAssSize() == null && pbToDelete.getTitsSize() == null && pbToDelete.getBodyType() == null && pbToDelete.getAppearance().isEmpty() && pbToDelete.isFakeTits() == null) {
                        p.getPersonBodys().remove(pbToDelete);
                        IndexingTopComponent.this.db.getEntityService().delete((AbstractEntity)pbToDelete);
                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)p);
                        ++deletedPb;
                        continue;
                    }
                    this.publish(j + " is NOT empty. Keep.\n");
                }
            }
            this.publish("Deleted " + deletedPb + " person body objects.\n");
            this.publish(Figlets.sNext);
            this.publish("Finding orphaned personbody objects.\n");
            long orphanedPersonBodysCnt = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QPersonBody.personBody).filter(f -> f.person.isNull()).count();
            this.publish("Found " + orphanedPersonBodysCnt + " orphaned personbody objects. This can take a bit the first time.\n");
            int updatedRows = 0;
            List orphanedPersonBodys = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QPersonBody.personBody).filter(f -> f.person.isNull()).find();
            for (PersonBody pb : orphanedPersonBodys) {
                IndexingTopComponent.this.db.getEntityService().delete((AbstractEntity)pb);
                this.publish(++updatedRows + ". deleted orphaned person body\n");
            }
            this.publish("Deleted " + updatedRows + " orphaned personbody objects.\n");
            this.publish(Figlets.sNext);
            this.publish("Finding orphaned scene details objects.\n");
            List orphanedSDs = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QSceneDetails.sceneDetails).filter(f -> f.scene.isNull()).find();
            for (SceneDetails sd : orphanedSDs) {
                if (sd.getPerson() != null) {
                    this.publish("Orphaned scene details object found for " + sd.getPerson().getName() + "\n");
                } else {
                    this.publish("Orphaned scene details object found for unknown person\n");
                }
                IndexingTopComponent.this.db.getEntityService().delete((AbstractEntity)sd);
            }
            this.publish("Found " + orphanedSDs.size() + " orphaned objects.\n");
            this.publish(Figlets.sNext);
            ArrayList<MediumFile> filesToPurge = new ArrayList<MediumFile>();
            ArrayList<MediumFile> filesToPurgeWithHashFile = new ArrayList<MediumFile>();
            this.publish("Finding files to purge. This takes a bit longer.\n");
            for (MediumFile mf : IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).find()) {
                File f2 = new File(mf.getFileCompletePath());
                if (f2.exists()) continue;
                filesToPurge.add(mf);
            }
            if (!filesToPurge.isEmpty()) {
                int dialogResult;
                this.publish("We found " + filesToPurge.size() + " files to purge\n");
                Object extraWarning = "";
                int msgType = 3;
                if (filesToPurge.size() >= 100) {
                    extraWarning = "\n\nWARNING: Are you REALLY sure all devices are online? " + filesToPurge.size() + " files to purge seem quite a lot.";
                    msgType = 2;
                }
                if ((dialogResult = JOptionPane.showConfirmDialog(null, "There a " + filesToPurge.size() + " files to purge! You are sure that any external devices which might store files are connected and we should purge now " + filesToPurge.size() + " files?" + (String)extraWarning, "Warning", 0, msgType)) == 0) {
                    int countHashed = 0;
                    for (MediumFile mediumFile : filesToPurge) {
                        if (mediumFile.getHashValue() == null || mediumFile.getHashValue().isEmpty()) continue;
                        ++countHashed;
                        filesToPurgeWithHashFile.add(mediumFile);
                    }
                    if (countHashed > 0) {
                        int dialogResultPurgeHashedFiles = JOptionPane.showConfirmDialog(null, "<html>From the " + filesToPurge.size() + " files to purge " + countHashed + " files have a hash value. Should we try to find a matching file?<br><br>If you select no, all files which we found for purging will be deleted (with and without hash)<br>If you select <b>YES</b>, only files without a hash will be deleted. For files that have a hashvalue and were just renamed we will try to find the matching file and you'll be asked how to proceed (<b>RECOMMENDED</b>)<br>Note: you need to add renamed files previously to the index so that we can identify those files. (If you forgot that, hit Cancel)</html>", "Warning", 1);
                        if (dialogResultPurgeHashedFiles == 2) {
                            this.publish("User canceled purging\n");
                        } else if (dialogResultPurgeHashedFiles == 1) {
                            this.publish("Purge files (with and without hash).\n");
                            for (MediumFile mf : filesToPurge) {
                                this.deleteMediumFile(mf);
                            }
                        } else {
                            this.publish("Purging only files without hashvalue.\n");
                            for (MediumFile mf : filesToPurge) {
                                if (mf.getHashValue() != null && (mf.getHashValue() == null || !mf.getHashValue().isEmpty())) continue;
                                this.publish("Purge: " + mf.getFileCompletePath() + "\n");
                                this.deleteMediumFile(mf);
                            }
                            ArrayList<MediumFile> arrayList = new ArrayList<MediumFile>();
                            this.publish("Trying to determine if files have been renamed.\n");
                            boolean askEverytime = false;
                            int dialogResultAskEverytime = JOptionPane.showConfirmDialog(null, "<html>Do you want to be asked for every file if they match?<br>If you click 'yes' you will be asked for all " + filesToPurgeWithHashFile.size() + " files what to do.<br>If you click '<b>NO</b>' Scenerixx will ask you only where more than one alternative file exists and it cannot decide on its own (<b>recommended</b>)</html>", "Question", 0);
                            if (dialogResultAskEverytime == 0) {
                                askEverytime = true;
                            }
                            block10: for (MediumFile mediumFile : filesToPurgeWithHashFile) {
                                if (IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.fileSize.eq((Object)mediumFile.getFileSize())).filter(f -> f.hashValue.isNull().or((Predicate)f.hashValue.isEmpty())).count() == 0L) {
                                    arrayList.add(mediumFile);
                                    continue;
                                }
                                List list = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.fileSize.eq((Object)mediumFile.getFileSize())).filter(f -> f.hashValue.isNull().or((Predicate)f.hashValue.isEmpty())).find();
                                int n = 1;
                                for (MediumFile alternative : list) {
                                    int dialogResultFoundAlternative;
                                    boolean reassign = false;
                                    if (!askEverytime && list.size() == 1) {
                                        reassign = true;
                                    }
                                    if ((askEverytime || list.size() > 1) && (dialogResultFoundAlternative = JOptionPane.showConfirmDialog(null, "We found " + list.size() + " alternative files which could match. \n" + n + ": is (the non-hashed) file '" + alternative.getFileCompletePath() + "' the same as (the now not found) file '" + mediumFile.getFileCompletePath() + "'?\nIf you select yes, we will copy the old values (hash, width, height, etc.) and delete the old entry.", "Warning", 0)) == 0) {
                                        reassign = true;
                                    }
                                    if (reassign) {
                                        this.publish("Reassign " + mediumFile.getFileCompletePath() + " to " + alternative.getFileCompletePath() + "\n");
                                        mediumFile.setFileCompletePath(alternative.getFileCompletePath());
                                        mediumFile.setFileExtension(alternative.getFileExtension());
                                        mediumFile.setFileName(alternative.getFileName());
                                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)mediumFile);
                                        this.deleteMediumFile(alternative);
                                        continue block10;
                                    }
                                    ++n;
                                }
                            }
                            if (!arrayList.isEmpty()) {
                                this.publish("\nFiles with no match found:\n");
                                int i = 0;
                                for (MediumFile mediumFile : arrayList) {
                                    this.publish(++i + ". " + mediumFile.getFileCompletePath() + "\n");
                                }
                                int n = JOptionPane.showConfirmDialog(null, "There are still  " + arrayList.size() + " files with a hash that we could not associate to another file. Should we delete those now?", "Warning", 0);
                                if (n == 0) {
                                    for (MediumFile mediumFile : arrayList) {
                                        this.deleteMediumFile(mediumFile);
                                    }
                                }
                            }
                        }
                    } else {
                        this.publish("Purging files. None of those files have a hash-value.\n");
                        for (MediumFile mediumFile : filesToPurge) {
                            this.publish("Purge: " + mediumFile.getFileCompletePath() + "\n");
                            this.deleteMediumFile(mediumFile);
                        }
                    }
                }
            } else {
                this.publish("No files found which could have been purged.\n");
            }
            this.publish("Finished purging.\n");
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished purging.\n")) continue;
                AbstractTopComponent.reloadMediumFileList(Node.EMPTY);
            }
        }
    }

    public class SynchronizeDataWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private final String finishedSynchronizing = "Finished synchronzing.\n";
        TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");

        @Override
        protected String doInBackground() throws Exception {
            IndexingTopComponent.this.resetProgressBars();
            this.publish(Figlets.sSynchronize);
            LOG.info("Start synchronizing");
            if (!(IndexingTopComponent.this.synchronizeWarningPanel.getCbUploadHashes().isSelected() || IndexingTopComponent.this.synchronizeWarningPanel.getCbSynchronizePersons().isSelected() || IndexingTopComponent.this.synchronizeWarningPanel.getCbSynchronizeStudios().isSelected())) {
                this.publish("Nothing was selected that could be synchronized.");
                this.publish("Maybe you should rethink your choices ;-)");
                this.publish("So we are finished here for now.");
                IndexingTopComponent.this.setAbortButtonEnabled(false);
                return null;
            }
            this.publish("Start synchronizing");
            abortIndexing = false;
            IndexingTopComponent.this.setAbortButtonEnabled(true);
            this.publish("Trying to download master database");
            boolean downloadMasterDB = ScenerixxCommon.downloadMasterDB(false);
            if (downloadMasterDB) {
                this.publish("Master database was downloaded");
            } else {
                this.publish("An error occured during download.");
            }
            if (!abortIndexing && IndexingTopComponent.this.synchronizeWarningPanel.getCbUploadHashes().isSelected()) {
                LOG.info("Start synchronizing hashes");
                this.synchronizeHashes();
            }
            if (!abortIndexing && IndexingTopComponent.this.synchronizeWarningPanel.getCbSynchronizePersons().isSelected()) {
                LOG.info("Start synchronizing persons");
                this.synchronizePersons();
            }
            if (!abortIndexing && IndexingTopComponent.this.synchronizeWarningPanel.getCbSynchronizeStudios().isSelected()) {
                LOG.info("Start synchronizing studios");
                this.synchronizeStudios();
            }
            LOG.info("Finished synchronizing ");
            this.publish("Finished synchronzing.\n");
            this.publish(Figlets.sFinished);
            IndexingTopComponent.this.finishedThread();
            return null;
        }

        void synchronizeHashes() throws JsonSyntaxException {
            List mfs = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.uploaded.isNull().or((Predicate)f.uploaded.isFalse())).filter(f -> f.secret.isFalse()).find();
            this.publish(Figlets.sHashes);
            this.publish("Synchronize " + mfs.size() + " hashes");
            int sublistSize = 150;
            int nextIndex = 0;
            if (mfs.size() < sublistSize) {
                sublistSize = mfs.size();
            }
            if (!mfs.isEmpty()) {
                for (int i = 0; i < mfs.size() - sublistSize; i += sublistSize) {
                    if (abortIndexing) continue;
                    LOG.info("uploading hashes " + i + " .. " + (i + sublistSize - 1));
                    this.publish("uploading hashes " + i + " .. " + (i + sublistSize - 1));
                    List<String> hashes = mfs.subList(i, i + sublistSize).stream().map(f -> f.getHashValue()).collect(Collectors.toList());
                    WebServiceHelper.uploadHashes(hashes);
                    for (int j = i; j < i + sublistSize; ++j) {
                        ((MediumFile)mfs.get(j)).setUploaded(true);
                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)((MediumFile)mfs.get(j)));
                    }
                    nextIndex = i + sublistSize;
                }
                if (!abortIndexing) {
                    LOG.info("uploading last hashes " + nextIndex + " .. " + (nextIndex + (mfs.size() - nextIndex)));
                    this.publish("uploading last hashes " + nextIndex + " .. " + (nextIndex + (mfs.size() - nextIndex)));
                    List<String> hashes2 = mfs.subList(nextIndex, nextIndex + (mfs.size() - nextIndex)).stream().map(f -> f.getHashValue()).collect(Collectors.toList());
                    WebServiceHelper.uploadHashes(hashes2);
                    for (int i = 0; i < hashes2.size(); ++i) {
                        ((MediumFile)mfs.get(i)).setUploaded(true);
                        IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)((MediumFile)mfs.get(i)));
                    }
                }
            }
        }

        void synchronizeStudios() throws JsonSyntaxException {
            List<Studio> searchStudioOnServer;
            this.publish(Figlets.sStudios);
            this.publish("Start synchronizing studios.\n");
            this.publish("Updating existing studios.\n");
            List studiosWithExternalId = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.externalId.isNotNull()).find();
            this.publish("Found " + studiosWithExternalId.size() + " studios with external ID");
            DBInternal dbInternal = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
            for (Studio s : studiosWithExternalId) {
                if (!abortIndexing) {
                    List studiosFromMasterDb = dbInternal.getStudios(s.getName());
                    if (!studiosFromMasterDb.isEmpty()) {
                        LOG.info("checking master db for " + s.getName());
                        this.diffStudioData(studiosFromMasterDb, s);
                        continue;
                    }
                    if (studiosFromMasterDb.isEmpty()) {
                        LOG.info("checking server for " + s.getName());
                        searchStudioOnServer = WebServiceHelper.searchStudioOnServer(s.getName());
                        this.diffStudioData(searchStudioOnServer, s);
                        continue;
                    }
                    LOG.info(s.getName() + " was neither found in master db nor on server");
                    continue;
                }
                this.publish("User requested to abort synchronizing.\n");
                IndexingTopComponent.this.jProgressBarSize.setValue(100);
                IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                break;
            }
            List studiosWithoutExternalId = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.externalId.isNull()).find();
            this.publish("Found " + studiosWithoutExternalId.size() + " studios without external ID");
            for (Studio s : studiosWithoutExternalId) {
                if (!abortIndexing) {
                    searchStudioOnServer = WebServiceHelper.searchStudioOnServer(s.getName());
                    if (searchStudioOnServer == null) {
                        LOG.info(s.getName() + " is unknown -> upload");
                        WebServiceHelper.uploadStudio(s);
                        this.publish("uploaded " + s.getName());
                        continue;
                    }
                    LOG.info("Found " + searchStudioOnServer.size() + " matches.");
                    this.publish(s.getName() + " has already " + searchStudioOnServer.size() + " matches on the server.");
                    if (this.details != null) {
                        StudioDiffPanel studioDiffPanel = new StudioDiffPanel(((DetailsTopComponent)this.details).getStudioDetailsPanel(), s, searchStudioOnServer);
                        if (studioDiffPanel.isDiff()) {
                            if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysAskStudio().isSelected()) {
                                LOG.info("user wants to decide");
                                this.publish("There's a difference. User needs to decide. Opening diff panel.");
                                JDialog frame = new JDialog((Frame)null, "Studio Diff Panel", true);
                                frame.getContentPane().add(studioDiffPanel);
                                frame.setDefaultCloseOperation(2);
                                frame.pack();
                                frame.setLocationRelativeTo(null);
                                frame.setVisible(true);
                                continue;
                            }
                            if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysUseServerStudio().isSelected()) {
                                LOG.info("user selected to always use server version");
                                studioDiffPanel.saveVersionFromServer();
                                continue;
                            }
                            if (!IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysIgnoreStudio().isSelected()) continue;
                            LOG.info("user selected to ignore differences");
                            continue;
                        }
                        LOG.info("no changes for " + s.getName());
                        continue;
                    }
                    this.publish("[ERROR] Could not open diff panel!");
                    continue;
                }
                this.publish("User requested to abort synchronizing.\n");
                IndexingTopComponent.this.jProgressBarSize.setValue(100);
                IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                break;
            }
        }

        private void diffStudioData(List<Studio> searchStudioOnServer, Studio s) throws JsonSyntaxException {
            if (searchStudioOnServer == null) {
                LOG.info(s.getName() + " is unknown, this should not happen -> upload");
                WebServiceHelper.uploadStudio(s);
                this.publish("uploaded " + s.getName());
            } else {
                LOG.info("Found " + searchStudioOnServer.size() + " matches.");
                this.publish(s.getName() + " has already " + searchStudioOnServer.size() + " matches on the server.");
                if (this.details != null) {
                    StudioDiffPanel studioDiffPanel = new StudioDiffPanel(((DetailsTopComponent)this.details).getStudioDetailsPanel(), s, searchStudioOnServer);
                    if (studioDiffPanel.isDiff()) {
                        if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysAskStudio().isSelected()) {
                            LOG.info("user wants to decide");
                            this.publish("There's a difference. User needs to decide. Opening diff panel.");
                            JDialog frame = new JDialog((Frame)null, "Studio Diff Panel", true);
                            frame.getContentPane().add(studioDiffPanel);
                            frame.setDefaultCloseOperation(2);
                            frame.pack();
                            frame.setLocationRelativeTo(null);
                            frame.setVisible(true);
                        } else if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysUseServerStudio().isSelected()) {
                            LOG.info("user selected to always use server version");
                            studioDiffPanel.saveVersionFromServer();
                        } else if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysIgnoreStudio().isSelected()) {
                            LOG.info("user selected to ignore differences");
                        }
                    } else {
                        LOG.info("no changes for " + s.getName());
                    }
                } else {
                    this.publish("[ERROR] Could not open diff panel!");
                }
            }
        }

        void synchronizePersons() throws JsonSyntaxException {
            this.publish(Figlets.sPersons);
            this.publish("Start synchronizing persons.\n");
            this.publish("Updating existing persons.\n");
            List personsWithExternalId = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.externalId.isNotNull()).find();
            this.publish("Found " + personsWithExternalId.size() + " persons with external ID");
            DBInternal dbInternal = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
            for (Person p : personsWithExternalId) {
                if (!abortIndexing) {
                    List personsFromMasterDb = dbInternal.getPersons(p.getName(), Scenerixx.unlocked);
                    if (!personsFromMasterDb.isEmpty()) {
                        LOG.info("checking master db for " + p.getName());
                        this.diffPersonData(personsFromMasterDb, p, "in master database");
                        continue;
                    }
                    if (personsFromMasterDb.isEmpty()) {
                        LOG.info("checking server for " + p.getName());
                        List<Person> searchPersonOnServer = WebServiceHelper.searchPersonOnServer(p.getName());
                        this.diffPersonData(searchPersonOnServer, p, "on server");
                        continue;
                    }
                    LOG.info(p.getName() + " was neither found in master db nor on server");
                    continue;
                }
                this.publish("User requested to abort synchronizing.\n");
                IndexingTopComponent.this.jProgressBarSize.setValue(100);
                IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                break;
            }
        }

        private boolean diffPersonData(List<Person> searchPersonOnServer, Person p, String fromWhere) throws JsonSyntaxException {
            boolean changes = false;
            if (searchPersonOnServer == null) {
                LOG.info(p.getName() + " is unknown, this should not happen -> upload");
                WebServiceHelper.uploadPerson(p);
                this.publish("uploaded " + p.getName());
            } else {
                LOG.info("Found " + searchPersonOnServer.size() + " matches.");
                this.publish(p.getName() + " has already " + searchPersonOnServer.size() + " matches " + fromWhere + ".");
                if (this.details != null) {
                    p.setRating(null);
                    p.setRatingDifferentiator(null);
                    p.setRatingAss(null);
                    p.setRatingAssDifferentiator(null);
                    p.setRatingCharacter(null);
                    p.setRatingCharacterDifferentiator(null);
                    p.setRatingEyes(null);
                    p.setRatingEyesDifferentiator(null);
                    p.setRatingFace(null);
                    p.setRatingFaceDifferentiator(null);
                    p.setRatingFeet(null);
                    p.setRatingFeetDifferentiator(null);
                    p.setRatingLaugh(null);
                    p.setRatingLaughDifferentiator(null);
                    p.setRatingPussy(null);
                    p.setRatingPussyDifferentiator(null);
                    p.setRatingSmile(null);
                    p.setRatingSmileDifferentiator(null);
                    p.setRatingSympathy(null);
                    p.setRatingSympathyDifferentiator(null);
                    p.setRatingTeeth(null);
                    p.setRatingTeethDifferentiator(null);
                    p.setRatingTits(null);
                    p.setRatingTitsDifferentiator(null);
                    p.setRatingVoice(null);
                    p.setRatingVoiceDifferentiator(null);
                    PersonDiffPanel personDiffPanel = new PersonDiffPanel(((DetailsTopComponent)this.details).getPersonDetailsPanel(), p, searchPersonOnServer, fromWhere, true);
                    if (personDiffPanel.isDiff()) {
                        if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysAskPerson().isSelected()) {
                            LOG.info("user wants to decide");
                            this.publish("There's a difference. User needs to decide. Opening diff panel.");
                            JDialog frame = new JDialog((Frame)null, "Person Diff Panel", true);
                            frame.getContentPane().add(personDiffPanel);
                            frame.setDefaultCloseOperation(2);
                            frame.pack();
                            frame.setLocationRelativeTo(null);
                            frame.setVisible(true);
                        } else if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysUseServerPerson().isSelected()) {
                            LOG.info("user selected to always use server version");
                            personDiffPanel.saveVersionFromServer();
                        } else if (IndexingTopComponent.this.synchronizeWarningPanel.getRbDefaultActionAlwaysIgnorePerson().isSelected()) {
                            LOG.info("user selected to ignore differences");
                        }
                    } else {
                        changes = false;
                        LOG.info("no changes for " + p.getName());
                    }
                } else {
                    this.publish("[ERROR] Could not open diff panel!");
                }
            }
            return changes;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s + "\n");
            }
        }
    }

    public class ImportingWorker
    extends SwingWorker<String, String> {
        private final DateFormat df = new SimpleDateFormat("HH:mm:ss");
        private final String finished_importing = "Finished importing.\n";
        private final Set<String> filesWithoutExportLevel = new HashSet<String>();
        private final Set<String> filesWithExportLevelAndNewerImportFile = new HashSet<String>();
        private final Set<String> filesImported = new HashSet<String>();
        private List<Path> filePaths = new ArrayList<Path>();

        private void importPersonsFromFile(Importer imp, String importFilename) throws Exception {
            this.publish("Try to import persons from file first\n");
            LOG.info("Try to import persons from file first");
            List personsToImport = imp.importPersonsFromMovieFile(importFilename);
            this.publish("Found " + personsToImport.size() + " persons\n");
            LOG.info("Found " + personsToImport.size() + " persons");
            for (Person p : personsToImport) {
                this.publish("Check if person '" + p.getName() + "' is already known.\n");
                LOG.info("Check if person '" + p.getName() + "' is already known.");
                List personsFromDb = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)p.getName())).find();
                if (personsFromDb.isEmpty()) {
                    this.publish("Not yet. Persist '" + p.getName() + "'\n");
                    LOG.info("Not yet. Persist '" + p.getName() + "'");
                    IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)p);
                    continue;
                }
                this.publish("There are already " + personsFromDb.size() + " persons(s) with the name " + p.getName() + "\n");
                LOG.info("There are already " + personsFromDb.size() + " persons(s) with the name " + p.getName());
                boolean alreadyKnown = false;
                for (Person knownPerson : personsFromDb) {
                    if (!knownPerson.getName().equals(p.getName())) continue;
                    this.publish("We know already a person with this name. Check other data.\n");
                    LOG.info("We know already a person with this name. Check other data.");
                    if (!Objects.equals(knownPerson.getBirthDay(), p.getBirthDay()) || !Objects.equals(knownPerson.getBirthMonth(), p.getBirthMonth()) || !Objects.equals(knownPerson.getBirthYear(), p.getBirthYear())) continue;
                    if (p.getBirthDay() != null || p.getBirthMonth() != null || p.getBirthYear() != null) {
                        this.publish("Birthdate is the same. So it's the same person.\n");
                        LOG.info("Birthdate is the same. So it's the same person.");
                        alreadyKnown = true;
                        break;
                    }
                    alreadyKnown = true;
                    this.publish("Birthdate is not set on both persons. We are not sure if it is the same person. For now we assume, it is.\n");
                    LOG.info("Birthdate is not set on both persons. We are not sure if it is the same person. For now we assume, it is.");
                    break;
                }
                if (alreadyKnown) continue;
                this.publish("We don't know the person yet. Persist '" + p.getName() + "'\n");
                LOG.info("We don't know the person yet. Persist '" + p.getName() + "'");
                IndexingTopComponent.this.db.getEntityService().save((AbstractEntity)p);
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void lookForHashFile(MediumFile mf) {
            minExportLevel = -1;
            exportLevelToUse = -1;
            if (mf.getMovie() != null) {
                this.publish(new String[]{"The file '" + mf.getFileName() + "' is already associated to a movie. Check for newer data.\n"});
                if (mf.getExportLevel() == null) {
                    this.publish(new String[]{"No export level known. Sorry, we don't support this sceneario yet. Delete the movie from the database and start hashing again to import the data from the import files\n"});
                    this.filesWithoutExportLevel.add(mf.getFileName());
                    return;
                }
                if (mf.getExportLevel() != null && mf.getExportLevel().intValue() == ExportLevel.Level_5.getLevel()) {
                    this.publish(new String[]{"The export level of the file '" + mf.getFileName() + "' is already set to level " + ExportLevel.Level_5.getLevel() + ".  \n"});
                    return;
                }
                minExportLevel = mf.getExportLevel() + 1;
                this.publish(new String[]{"Try to find data with an export level of at least " + minExportLevel + "\n"});
            }
            IndexingTopComponent.LOG.fine("Loading Scenerixx files");
            imp = new Importer();
            if (this.filePaths.isEmpty()) {
                try {
                    paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirMovies, new String[0]), new FileVisitOption[0]);
                    try {
                        this.filePaths = paths.collect(Collectors.toList());
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            }
            var5_5 = this.filePaths.iterator();
            block30: while (var5_5.hasNext() != false) {
                filePath = var5_5.next();
                if (Files.isDirectory(filePath, new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) continue;
                try {
                    block49: {
                        block52: {
                            block50: {
                                block51: {
                                    block48: {
                                        if (!filePath.toString().endsWith(mf.getHashValue())) continue;
                                        IndexingTopComponent.LOG.info("Found a file: " + filePath.toString());
                                        fis = new FileInputStream(filePath.toFile());
                                        isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                                        br = new BufferedReader(isr);
                                        while (true) {
                                            if ((line = br.readLine()) == null) continue block30;
                                            if (line.endsWith("_movie.scenerixx")) {
                                                if (mf.getMovie() != null) {
                                                    this.publish(new String[]{"The file '" + mf.getFileName() + "' is already associated to a movie. Check for newer data.\n"});
                                                    if (mf.getExportLevel() == null) {
                                                        this.publish(new String[]{"No export level known. Sorry, we don't support this sceneario yet. Delete the movie from the database and start hashing again to import the data from the import files\n"});
                                                        this.filesWithoutExportLevel.add(mf.getFileName());
                                                        return;
                                                    }
                                                    if (mf.getExportLevel() != null && mf.getExportLevel().intValue() == ExportLevel.Level_5.getLevel()) {
                                                        this.publish(new String[]{"The export level of the file '" + mf.getFileName() + "' is already set to level " + ExportLevel.Level_5.getLevel() + ".  \n"});
                                                        return;
                                                    }
                                                    minExportLevel = mf.getExportLevel() + 1;
                                                    this.publish(new String[]{"Try to find data with an export level of at least " + minExportLevel + "\n"});
                                                }
                                                foundFile = false;
                                                importFilename = Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirMovies;
                                                break block48;
                                            }
                                            this.publish(new String[]{"Not a movie file: " + line + "\n"});
                                            IndexingTopComponent.LOG.finest("Not a movie file: " + line);
                                            continue;
                                            break;
                                        }
                                        finally {
                                            br.close();
                                            continue;
                                        }
                                        finally {
                                            isr.close();
                                            continue;
                                        }
                                        finally {
                                            fis.close();
                                        }
                                    }
                                    for (i = 5; i > minExportLevel; --i) {
                                        importFilename = Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirMovies + File.separator + i + File.separator + line.toLowerCase().charAt(0) + File.separator + line;
                                        targetPath = Paths.get(importFilename, new String[0]);
                                        IndexingTopComponent.LOG.info("Check path: " + targetPath.toString());
                                        if (!Files.exists(targetPath, new LinkOption[0])) continue;
                                        foundFile = true;
                                        exportLevelToUse = i;
                                        break;
                                    }
                                    if (foundFile) {
                                        this.publish(new String[]{"We found a file with export level " + exportLevelToUse + "\n"});
                                    } else {
                                        this.publish(new String[]{"No file found for min. export level " + minExportLevel + "\n"});
                                    }
                                    if (!foundFile) break block49;
                                    tmpImportMovieFile = imp.importMovieFile(importFilename);
                                    title = tmpImportMovieFile.getTitle();
                                    if (IndexingTopComponent.access$1100(IndexingTopComponent.this).getEntityService().find((EntityPathBase)QMovie.movie).filter((Function<QMovie, Predicate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lookForHashFile$1(java.lang.String xxx.scenerixx.scenerixxlib.model.QMovie ), (Lxxx/scenerixx/scenerixxlib/model/QMovie;)Lcom/querydsl/core/types/Predicate;)((String)title)).findFirst() == null) break block50;
                                    tmpImportMovieFile = (Movie)IndexingTopComponent.access$1200(IndexingTopComponent.this).getEntityService().find((EntityPathBase)QMovie.movie).filter((Function<QMovie, Predicate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lookForHashFile$2(java.lang.String xxx.scenerixx.scenerixxlib.model.QMovie ), (Lxxx/scenerixx/scenerixxlib/model/QMovie;)Lcom/querydsl/core/types/Predicate;)((String)title)).findFirst();
                                    if (!IndexingTopComponent.access$1300(IndexingTopComponent.this).getMediumFiles(tmpImportMovieFile, true).contains(mf)) break block51;
                                    this.publish(new String[]{"Is already imported\n"});
                                    ** GOTO lbl-1000
                                }
                                this.publish(new String[]{"A part exists already, import a further part.\n"});
                                mf.setMovie(tmpImportMovieFile);
                                mf.setExportLevel(Integer.valueOf(exportLevelToUse));
                                IndexingTopComponent.access$1400(IndexingTopComponent.this).getEntityService().save((AbstractEntity)mf);
                                ** GOTO lbl-1000
                            }
                            if (minExportLevel == -1) break block52;
                            this.publish(new String[]{"We are updating the data. From export level " + minExportLevel + " to " + exportLevelToUse + "\n"});
                            IndexingTopComponent.LOG.info("We are updating the data. From export level " + minExportLevel + " to " + exportLevelToUse);
                            this.filesWithExportLevelAndNewerImportFile.add("Current export level: " + minExportLevel + " - Export level available: " + exportLevelToUse + " - " + mf.getFileName());
                            ** GOTO lbl-1000
                        }
                        this.importPersonsFromFile(imp, importFilename);
                        importMovieFile = imp.importMovieFile(importFilename);
                        importMovieFile = (Movie)IndexingTopComponent.access$1500(IndexingTopComponent.this).getEntityService().save((AbstractEntity)importMovieFile);
                        for (Scene s : importMovieFile.getScenes()) {
                            IndexingTopComponent.LOG.info("save scene " + String.valueOf(s));
                            IndexingTopComponent.access$1600(IndexingTopComponent.this).getEntityService().save((AbstractEntity)s);
                            for (Bookmark b : s.getBookmarks(true)) {
                                IndexingTopComponent.LOG.info("save scene bookmark " + String.valueOf(b));
                                IndexingTopComponent.access$1700(IndexingTopComponent.this).getEntityService().save((AbstractEntity)b);
                                if (!b.isCumshotType()) continue;
                                IndexingTopComponent.LOG.info("save cumshot");
                                IndexingTopComponent.access$1800(IndexingTopComponent.this).getEntityService().save((AbstractEntity)b.getCumshot());
                            }
                        }
                        for (Bookmark b : importMovieFile.getBookmarks(true)) {
                            IndexingTopComponent.LOG.info("save movie bookmark " + String.valueOf(b));
                            IndexingTopComponent.access$1900(IndexingTopComponent.this).getEntityService().save((AbstractEntity)b);
                            if (!b.isCumshotType()) continue;
                            IndexingTopComponent.LOG.info("save cumshot");
                            IndexingTopComponent.access$2000(IndexingTopComponent.this).getEntityService().save((AbstractEntity)b.getCumshot());
                        }
                        mf.setMovie(importMovieFile);
                        mf.setExportLevel(Integer.valueOf(exportLevelToUse));
                        IndexingTopComponent.access$2100(IndexingTopComponent.this).getEntityService().save((AbstractEntity)mf);
                        this.publish(new String[]{"Imported " + importMovieFile.getNameOfPlayable() + " - Level: " + exportLevelToUse + "\n"});
                        IndexingTopComponent.LOG.info("Imported " + importMovieFile.getNameOfPlayable() + " - Level: " + exportLevelToUse);
                        this.filesImported.add(importMovieFile.getNameOfPlayable() + " - Level: " + exportLevelToUse);
                        ** GOTO lbl-1000
                    }
                    this.publish(new String[]{"No file with a higher export level was found. Data is already up-to-date.\n"});
                    ** continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            }
        }

        @Override
        protected String doInBackground() throws Exception {
            this.publish("Check for import files.\n");
            Long currentIndex = 0L;
            abortIndexing = false;
            IndexingTopComponent.this.setAbortButtonEnabled(true);
            List filesWithHash = IndexingTopComponent.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.hashValue.isNotNull()).find();
            int totalFiles = filesWithHash.size();
            Long fileCounter = 0L + (long)filesWithHash.size();
            this.publish("Found " + fileCounter + " files with a hash in the database for which we try to find an import-file.\n");
            for (MediumFile mf : filesWithHash) {
                if (!abortIndexing) {
                    String[] stringArray = new String[1];
                    currentIndex = currentIndex + 1L;
                    stringArray[0] = "[" + currentIndex + "/" + fileCounter + "] Check for import-file for medium-file: " + mf.getFileCompletePath() + "\n";
                    this.publish(stringArray);
                    this.lookForHashFile(mf);
                    Long completed = currentIndex * 100L / (long)totalFiles;
                    IndexingTopComponent.this.jProgressBarSize.setValue(completed.intValue());
                    Long completedFiles = currentIndex * 100L / fileCounter;
                    IndexingTopComponent.this.jProgressBarFiles.setValue(completedFiles.intValue());
                    continue;
                }
                this.publish("User requested to abort importing.\n");
                IndexingTopComponent.this.jProgressBarSize.setValue(100);
                IndexingTopComponent.this.jProgressBarFiles.setValue(100);
                break;
            }
            this.publish("Checked " + currentIndex + " files for import.\n");
            if (!this.filesImported.isEmpty()) {
                this.publish("\n\nFollowing files were imported:\n");
                int i = 1;
                for (String s : this.filesImported) {
                    this.publish(i + ": " + s + "\n");
                    ++i;
                }
            }
            if (!this.filesWithoutExportLevel.isEmpty()) {
                this.publish("\n\nFollowing files were created by you and not an import and therefore don't have an export level set. We cannot update them (yet). Delete them manually and re-start hashing to import them.\n");
                int i = 1;
                for (String s : this.filesWithoutExportLevel) {
                    this.publish(i + ": " + s + "\n");
                    ++i;
                }
            }
            if (!this.filesWithExportLevelAndNewerImportFile.isEmpty()) {
                this.publish("\n\nFollowing files do have already an export level but a newer export level was found. We cannot update them (yet). Delete them manually and re-start hashing to import them.\n");
                int i = 1;
                for (String s : this.filesWithExportLevelAndNewerImportFile) {
                    this.publish(i + ": " + s + "\n");
                    ++i;
                }
            }
            this.publish("Finished importing.\n");
            IndexingTopComponent.this.setAbortButtonEnabled(false);
            this.filePaths.clear();
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                IndexingTopComponent.this.taLog.append("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                if (!s.equals("Finished importing.\n")) continue;
                AbstractTopComponent.dirtyMediumFileList();
                AbstractTopComponent.dirtyMovieList();
                AbstractTopComponent.dirtyPersonList();
                AbstractTopComponent.dirtyStudiolist();
            }
        }

        private static /* synthetic */ Predicate lambda$lookForHashFile$2(String title, QMovie f) {
            return f.title.eq((Object)title);
        }

        private static /* synthetic */ Predicate lambda$lookForHashFile$1(String title, QMovie f) {
            return f.title.eq((Object)title);
        }
    }
}

