/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.player;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstException;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.Version;
import org.freedesktop.gstreamer.elements.PlayBin;
import org.freedesktop.gstreamer.event.SeekFlags;
import org.freedesktop.gstreamer.swing.GstVideoComponent;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.player.Utils;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class SwingPlayer {
    private static final Logger LOG = Logger.getLogger(SwingPlayer.class.getName());
    private static PlayBin playbin;
    private static JFrame window;
    private static boolean initialized;
    private static JButton playButton;
    private static Bookmark startedBookmark;

    private static void init(String filename, Movie movie) throws GstException {
        Utils.configurePaths();
        try {
            Gst.init(Version.BASELINE);
        }
        catch (GstException gstException) {
            AbstractTopComponent.notifyError("GStreamer not found!");
            return;
        }
        EventQueue.invokeLater(() -> {
            GstVideoComponent vc = new GstVideoComponent();
            playbin = new PlayBin("playbin");
            playbin.setVideoSink(vc.getElement());
            window = new JFrame("Scenerixx Video Player");
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    playbin.stop();
                    initialized = false;
                }
            });
            window.setIconImage(ImageUtilities.loadImage((String)"icons2/favicon.png", (boolean)false));
            window.add(vc);
            vc.setPreferredSize(new Dimension(800, 600));
            JToolBar buttons = new JToolBar();
            playButton = new JButton("Pause");
            playButton.addActionListener(e -> SwingPlayer.togglePlayPause());
            JButton btnBookmark = new JButton("Add bookmark starttime");
            btnBookmark.addActionListener(e -> {
                LOG.info("add bookmark");
                if (btnBookmark.getText().startsWith("Add")) {
                    btnBookmark.setText("Set bookmark endtime");
                    int bookmarkStarTime = (int)((double)playbin.queryPosition(Format.TIME) / 1.0E9);
                    Bookmark bookmark = new Bookmark();
                    bookmark.setDateOfCreation(LocalDateTime.now());
                    bookmark.setStartTime(bookmarkStarTime);
                    LOG.info("Bookmark time : " + bookmarkStarTime + " - " + ScenerixxCommon.readableDuration(bookmarkStarTime));
                    LOG.info("Bookmark time : " + bookmarkStarTime + " - " + ScenerixxCommon.readableRuntime(Long.valueOf(bookmarkStarTime)));
                    boolean foundScene = false;
                    for (Scene sc : movie.getScenes()) {
                        LOG.info(" - sc.getStartTime(): " + sc.getStartTime() + " -  end: " + sc.getEndTime());
                        if (sc.getStartTime() < 0 || sc.getStartTime() > bookmarkStarTime || sc.getEndTime() <= 0 || sc.getEndTime() < bookmarkStarTime) continue;
                        LOG.fine("Found scene");
                        bookmark.setScene(sc);
                        foundScene = true;
                        break;
                    }
                    if (!foundScene) {
                        LOG.fine("No scene found. Create movie bookmark");
                        bookmark.setMovie(movie);
                    }
                    DB.getInstance().getEntityService().save((AbstractEntity)bookmark);
                    movie.getBookmarks(Scenerixx.unlocked).add(bookmark);
                    DB.getInstance().getEntityService().save((AbstractEntity)movie);
                    startedBookmark = bookmark;
                } else {
                    btnBookmark.setText("Add bookmark starttime");
                    if (startedBookmark != null) {
                        int bookmarkEndTime = (int)((double)playbin.queryPosition(Format.TIME) / 1.0E9);
                        startedBookmark.setEndTime(bookmarkEndTime);
                        DB.getInstance().getEntityService().save((AbstractEntity)startedBookmark);
                        startedBookmark = null;
                    } else {
                        AbstractTopComponent.notifyWarning("Couldn't find the right bookmark to set end time");
                    }
                }
            });
            JButton btnScene = new JButton("Add scene starttime ");
            btnScene.addActionListener(e -> {
                LOG.info("start scene");
                if (btnScene.getText().startsWith("Add scene starttime")) {
                    for (Scene sc : movie.getScenes()) {
                        LOG.info("starttime: " + sc.getStartTime());
                        if (sc.getStartTime() > 0) continue;
                        sc.setStartTime((int)((double)playbin.queryPosition(Format.TIME) / 1.0E9));
                        List<MediumFile> mediumFiles = SwingPlayer.getMediumFile(movie);
                        sc.setStartMedium((Medium)mediumFiles.get(0));
                        DB.getInstance().getEntityService().save((AbstractEntity)sc);
                        break;
                    }
                    btnScene.setText("Set scene endtime");
                } else {
                    btnScene.setText("Add scene starttime");
                    for (Scene sc : movie.getScenes()) {
                        if (sc.getEndTime() > 0) continue;
                        sc.setEndTime((int)((double)playbin.queryPosition(Format.TIME) / 1.0E9));
                        List<MediumFile> mediumFiles = SwingPlayer.getMediumFile(movie);
                        sc.setEndMedium((Medium)mediumFiles.get(0));
                        DB.getInstance().getEntityService().save((AbstractEntity)sc);
                        break;
                    }
                }
            });
            JButton timeButton = new JButton("Time");
            timeButton.addActionListener(e -> {
                LOG.info("time: " + playbin.queryPosition(Format.TIME));
                LOG.info("time in sec: " + (double)playbin.queryPosition(Format.TIME) / 1.0E9);
            });
            JButton btnLast3Seconds = new JButton("Last 3 seconds");
            btnLast3Seconds.addActionListener(e -> {
                long dur = playbin.queryDuration(Format.TIME);
                if (dur > 0L) {
                    LOG.info("duration     " + dur + " - " + ScenerixxCommon.readableDuration((int)Math.round((double)dur / 1000000.0)));
                    LOG.info("last seconds " + (dur - 0L) + " - " + ScenerixxCommon.readableDuration((int)Math.round((double)dur - 3.0E9)));
                    playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)((double)dur - 3.0E9));
                }
            });
            final JTextField tfGoto = new JTextField();
            tfGoto.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        if (tfGoto.getText().contains(":")) {
                            String[] split = tfGoto.getText().split(":");
                            if (split.length == 3) {
                                int parseIntHour = Integer.parseInt(split[0]);
                                int parseIntMinute = Integer.parseInt(split[1]);
                                int parseIntSecond = Integer.parseInt(split[2]);
                                double newPos = (double)(parseIntHour * 60 * 60 + parseIntMinute * 60 + parseIntSecond) * 1.0E9;
                                playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)newPos);
                            } else if (split.length == 2) {
                                int parseIntMinute = Integer.parseInt(split[0]);
                                int parseIntSecond = Integer.parseInt(split[1]);
                                double newPos = (double)(parseIntMinute * 60 + parseIntSecond) * 1.0E9;
                                playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)newPos);
                            }
                        } else {
                            int parseInt = Integer.parseInt(tfGoto.getText());
                            playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)((double)parseInt * 1.0E9));
                        }
                    }
                }
            });
            tfGoto.setToolTipText("<html>Enter a new position in seconds and press enter. <br>E.g. 126 jumps to 00:02:06h.<br>You can also use the format mm:ss or hh:mm:ss</html>");
            JToggleButton loopButton = new JToggleButton("Loop", true);
            JSlider position = new JSlider(0, 1000, 0);
            position.addChangeListener(e -> {
                long dur;
                if (position.getValueIsAdjusting() && (dur = playbin.queryDuration(Format.TIME)) > 0L) {
                    double relPos = (double)position.getValue() / 1000.0;
                    playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)(relPos * (double)dur));
                }
            });
            new Timer(50, e -> {
                if (!position.getValueIsAdjusting()) {
                    long dur = playbin.queryDuration(Format.TIME);
                    long pos = playbin.queryPosition(Format.TIME);
                    if (dur > 0L) {
                        double relPos = (double)pos / (double)dur;
                        position.setValue((int)(relPos * 1000.0));
                        timeButton.setText("Time : " + ScenerixxCommon.readableDuration((int)Math.round((double)pos / 1000000.0)) + " / " + ScenerixxCommon.readableDuration((int)Math.round((double)dur / 1000000.0)));
                    }
                }
            }).start();
            InputMap inputMap = playButton.getInputMap(2);
            ActionMap actionMap = playButton.getActionMap();
            AbstractAction actionForward3Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("forwrad");
                    double forwardTime = (double)playbin.queryPosition(Format.TIME) + 5.0E9;
                    playbin.seek((long)forwardTime);
                }
            };
            AbstractAction actionForward10Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("forwrad");
                    double forwardTime = (double)playbin.queryPosition(Format.TIME) + 1.0E10;
                    playbin.seek((long)forwardTime);
                }
            };
            AbstractAction actionForward60Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("forwrad");
                    double forwardTime = (double)playbin.queryPosition(Format.TIME) + 6.0E10;
                    playbin.seek((long)forwardTime);
                }
            };
            AbstractAction actionRewind3Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("rewind");
                    double rewindTime = (double)playbin.queryPosition(Format.TIME) - 3.0E9;
                    playbin.seek((long)rewindTime);
                }
            };
            AbstractAction actionRewind10Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("rewind");
                    double rewindTime = (double)playbin.queryPosition(Format.TIME) - 1.0E10;
                    playbin.seek((long)rewindTime);
                }
            };
            AbstractAction actionRewind60Seconds = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOG.info("rewind");
                    double rewindTime = (double)playbin.queryPosition(Format.TIME) - 6.0E10;
                    playbin.seek((long)rewindTime);
                }
            };
            AbstractAction actionTogglePause = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingPlayer.togglePlayPause();
                }
            };
            AbstractAction actionClose = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    playbin.stop();
                    initialized = false;
                    window.dispose();
                }
            };
            inputMap.put(KeyStroke.getKeyStroke(39, 64), "forward3seconds");
            actionMap.put("forward3seconds", actionForward3Seconds);
            inputMap.put(KeyStroke.getKeyStroke(39, 512), "forward10seconds");
            actionMap.put("forward10seconds", actionForward10Seconds);
            inputMap.put(KeyStroke.getKeyStroke(39, 128), "forward60seconds");
            actionMap.put("forward60seconds", actionForward60Seconds);
            inputMap.put(KeyStroke.getKeyStroke(37, 64), "rewind3seconds");
            actionMap.put("rewind3seconds", actionRewind3Seconds);
            inputMap.put(KeyStroke.getKeyStroke(37, 512), "rewind10seconds");
            actionMap.put("rewind10seconds", actionRewind10Seconds);
            inputMap.put(KeyStroke.getKeyStroke(37, 128), "rewind60seconds");
            actionMap.put("rewind60seconds", actionRewind60Seconds);
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "togglePause");
            actionMap.put("togglePause", actionTogglePause);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
            actionMap.put("close", actionClose);
            buttons.addSeparator();
            buttons.add(playButton);
            buttons.addSeparator();
            buttons.add(btnLast3Seconds);
            buttons.addSeparator();
            buttons.add(timeButton);
            buttons.addSeparator();
            buttons.add(position);
            buttons.add(tfGoto);
            buttons.add(loopButton);
            buttons.addSeparator();
            buttons.add(btnScene);
            buttons.addSeparator();
            buttons.add(btnBookmark);
            window.add((Component)buttons, "South");
            window.pack();
            window.setDefaultCloseOperation(2);
            playbin.getBus().connect(source -> EventQueue.invokeLater(() -> {
                if (loopButton.isSelected()) {
                    playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), 0L);
                } else {
                    playbin.stop();
                    position.setValue(0);
                }
            }));
            SwingPlayer.startFile(filename, movie);
            window.setVisible(true);
        });
    }

    private static void togglePlayPause() {
        if (playbin.isPlaying()) {
            playButton.setText("Play");
            playButton.setIcon(ImageUtilities.loadIcon((String)"icons2/favicon.png", (boolean)false));
            playbin.pause();
        } else {
            playButton.setText("Pause");
            playButton.setIcon(null);
            playbin.play();
        }
    }

    private static List<MediumFile> getMediumFile(Movie movie) {
        List mediumFiles = DB.getInstance().getMediumFiles(movie, Scenerixx.unlocked);
        if (mediumFiles.size() != 0) {
            LOG.warning("Works only with single-file movies. Found " + mediumFiles.size() + " files");
        }
        return mediumFiles;
    }

    public static void startFile(String filename, Movie movie) {
        if (!initialized) {
            SwingPlayer.init(filename, movie);
            initialized = true;
        } else {
            File file = new File(filename);
            if (file.exists()) {
                playbin.stop();
                playbin.setURI(file.toURI());
                playbin.play();
            }
        }
    }

    public static void startFile(String filename, Movie movie, long offsetInSeconds) {
        SwingPlayer.startFile(filename, movie);
        EventQueue.invokeLater(() -> {
            if (playbin != null) {
                LOG.info("Start at " + ScenerixxCommon.readableDuration((int)offsetInSeconds * 1000));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                State state = playbin.getState(1000000000L);
                LOG.info("State: " + String.valueOf(state));
                boolean seekSimple = playbin.seekSimple(Format.TIME, EnumSet.of(SeekFlags.FLUSH), (long)((double)offsetInSeconds * 1.0E9));
                LOG.info("Seeking was: " + seekSimple);
            } else {
                LOG.info("playbin is null");
            }
        });
    }

    static {
        initialized = false;
        startedBookmark = null;
    }
}

