/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.gui.renderer;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;

public class PersonComboRenderer
extends DefaultListCellRenderer {
    private boolean similarityScore = false;

    public PersonComboRenderer() {
    }

    public PersonComboRenderer(boolean similarityScore) {
        this.similarityScore = similarityScore;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof Person) {
            Person person = (Person)value;
            if (person.getName().toLowerCase().contains("similar persons")) {
                this.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/gnupg_keys.png", (boolean)false));
            } else if (person.getName().toLowerCase().contains("performed with")) {
                this.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/group_link.png", (boolean)false));
            } else if (person.getName().startsWith("Load a")) {
                this.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/search_accounts.png", (boolean)false));
            } else {
                this.setIcon(this.getIcon(person));
            }
            if (!this.similarityScore) {
                Object birthday = "";
                if (person.getBirthYear() != null) {
                    birthday = "(" + String.valueOf(person.getBirthDay() != null ? person.getBirthDay() : "??") + "." + String.valueOf(person.getBirthMonth() != null ? person.getBirthMonth() : "??") + "." + person.getBirthYear() + ")";
                }
                this.setText(person.getName() + " " + (String)birthday);
            } else if (person.getId() == null) {
                this.setText(person.getName());
            } else {
                this.setText(person.getName() + " (" + person.getSimilarityScore() + ")");
            }
        }
        return this;
    }

    protected ImageIcon getIcon(Person person) {
        if (Gender.FEMALE == person.getGender()) {
            return ImageUtilities.loadImageIcon((String)"icons/female.png", (boolean)false);
        }
        if (Gender.MALE == person.getGender()) {
            return ImageUtilities.loadImageIcon((String)"icons/male.png", (boolean)false);
        }
        if (Gender.TS == person.getGender()) {
            return ImageUtilities.loadImageIcon((String)"icons2/transgender.png", (boolean)false);
        }
        return null;
    }
}

