/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import com.github.lgooddatepicker.components.DatePickerSettings;
import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.RollbackException;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;
import org.openide.LifecycleManager;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.ScenerixxLib;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxlib.util.Downloader;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ImageResizer;
import xxx.scenerixx.scenerixxmodule.util.UnzipUtil;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class ScenerixxCommon {
    public static Set<Long> movieIdsOnDefaultPlaylist = new HashSet<Long>();
    public static Set<Long> movieIdsOnAnyPlaylist = new HashSet<Long>();
    public static Set<Long> sceneIdsOnDefaultPlaylist = new HashSet<Long>();
    public static Set<Long> sceneIdsOnAnyPlaylist = new HashSet<Long>();
    public static Set<Long> bookmarkIdsOnDefaultPlaylist = new HashSet<Long>();
    public static Set<Long> bookmarkIdsOnAnyPlaylist = new HashSet<Long>();
    public static final String SUM_SYMBOL = "\u2211";
    public static final String STAR = "\u263a";
    public static final String STAR_FILLED = "\u263b";
    public static final String HEART = "\u2661";
    public static final String HEART_FILLED = "\u2665";
    public static volatile String SUM_SYMBOL_CHAR = null;
    public static volatile String HEART_CHAR = null;
    public static volatile String HEART_CHAR_FILLED = null;
    public static volatile String STAR_CHAR = null;
    public static volatile String STAR_CHAR_FILLED = null;
    public static final String this_node_will_be_removed_with_the_next_reload = "this node will be removed with the next reload";
    public static final Logger LOG = Logger.getLogger(ScenerixxCommon.class.getName());
    private final PlaylistService ps = new PlaylistService();
    private DB db = DB.getInstance();
    private static OS os = null;

    public void initPlaylistCache() {
        LocalDateTime now = LocalDateTime.now();
        sceneIdsOnAnyPlaylist.clear();
        sceneIdsOnDefaultPlaylist.clear();
        bookmarkIdsOnDefaultPlaylist.addAll(this.db.getPlaylistBookmarkIds(true));
        sceneIdsOnDefaultPlaylist.addAll(this.db.getPlaylistSceneIds(true));
        movieIdsOnDefaultPlaylist.addAll(this.db.getPlaylistMovieIds(true));
        bookmarkIdsOnAnyPlaylist.addAll(this.db.getPlaylistBookmarkIds(false));
        sceneIdsOnAnyPlaylist.addAll(this.db.getPlaylistSceneIds(false));
        movieIdsOnAnyPlaylist.addAll(this.db.getPlaylistMovieIds(false));
        LOG.info("initialized playlist cache movies. Default " + movieIdsOnDefaultPlaylist.size() + " - All: " + movieIdsOnAnyPlaylist.size());
        LOG.info("initialized playlist cache scenes. Default " + sceneIdsOnDefaultPlaylist.size() + " - All: " + sceneIdsOnAnyPlaylist.size());
        LOG.info("initialized playlist cache bookmarks. Default " + bookmarkIdsOnDefaultPlaylist.size() + " - All: " + bookmarkIdsOnAnyPlaylist.size());
        LOG.info("Initialized playlist cache in: " + Duration.between(LocalDateTime.now(), now).toString());
    }

    public File findProfileFile(String personName, File startDirectory) {
        File findProfileFile = null;
        if (Scenerixx.unlocked) {
            if (this.db.getScenerixxSettings().isShowRandomProfilePicturesInLockedMode()) {
                LOG.fine("Try to find a random picture");
                findProfileFile = this.findRandomProfileFile(personName);
            }
            if (findProfileFile == null) {
                LOG.fine("Try to find a nsfw picture");
                findProfileFile = this.findProfileFile(personName, startDirectory, true);
            }
        }
        if (findProfileFile == null || !Scenerixx.unlocked) {
            LOG.finer("Try to find a normal profile picture for " + personName);
            findProfileFile = this.findProfileFile(personName, startDirectory, false);
        }
        return findProfileFile;
    }

    public File findProfileFile(String personName, File startDirectory, boolean findNsfw) {
        File[] list = startDirectory.listFiles();
        if (list != null && personName != null) {
            for (File imageFile : list) {
                if (imageFile.isDirectory()) {
                    File findFile = this.findProfileFile(personName, imageFile);
                    if (findFile == null) continue;
                    return findFile;
                }
                if (!imageFile.getName().toLowerCase().startsWith(personName.toLowerCase()) || !ImageResizer.isPicture(imageFile)) continue;
                if (imageFile.getName().toLowerCase().contains("nsfw") && findNsfw) {
                    return imageFile;
                }
                if (imageFile.getName().toLowerCase().contains("nsfw") || findNsfw) continue;
                return imageFile;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File findRandomProfileFile(String personName) {
        String profilePictureExtendedDirectory = this.db.getScenerixxSettings().getProfilePictureExtendedDirectory();
        if (profilePictureExtendedDirectory == null) return null;
        if (profilePictureExtendedDirectory.isBlank()) return null;
        String dirName = profilePictureExtendedDirectory + File.separator + personName;
        LOG.info("Check if " + dirName + " exists [random]");
        if (!Files.exists(Paths.get(dirName, new String[0]), LinkOption.NOFOLLOW_LINKS)) return null;
        try (Stream<Path> paths = Files.walk(Paths.get(dirName, new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);){
            File imageFile;
            ArrayList<File> files = new ArrayList<File>();
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                files.add(filePath.toFile());
            }
            Collections.shuffle(files);
            Iterator<Object> iterator = files.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((imageFile = (File)iterator.next()).isDirectory() || !ImageResizer.isPicture(imageFile));
            File file = imageFile;
            return file;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public List<File> findAllProfileFiles(String personName) {
        String profilePictureExtendedDirectory = this.db.getScenerixxSettings().getProfilePictureExtendedDirectory();
        if (profilePictureExtendedDirectory != null && !profilePictureExtendedDirectory.isBlank()) {
            File[] list;
            String dirName = profilePictureExtendedDirectory + File.separator + personName;
            LOG.info("Check if " + dirName + " exists [find all]");
            if (Files.exists(Paths.get(dirName, new String[0]), LinkOption.NOFOLLOW_LINKS) && (list = new File(dirName).listFiles()) != null) {
                return Arrays.asList(list);
            }
        } else {
            LOG.warning("Directory for profile pictures not set!");
        }
        return null;
    }

    public void removeFromPlaylist(Playlist playlist, IPlayable playable) {
        ArrayList<PlaylistEntry> toDelete = new ArrayList<PlaylistEntry>();
        for (PlaylistEntry pe : playlist.getEntries(Scenerixx.unlocked)) {
            if (pe.getMovie() != null && pe.getMovie().getId().longValue() == playable.getId().longValue()) {
                toDelete.add(pe);
            }
            if (pe.getScene() != null && pe.getScene().getId().longValue() == playable.getId().longValue()) {
                toDelete.add(pe);
            }
            if (pe.getBookmark() == null || pe.getBookmark().getId().longValue() != playable.getId().longValue()) continue;
            toDelete.add(pe);
        }
        this.ps.deletePlaylistEntries(toDelete, true, Scenerixx.unlocked);
    }

    public void addToPlaylist(Playlist playlist, Person person) {
        boolean add = true;
        if (this.ps.contains(person, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) && 1 == JOptionPane.showConfirmDialog(null, person.getName() + " is already on the playlist at position " + this.ps.getPositionInPlaylist(person, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this person another time?", 0)) {
            add = false;
        }
        if (add) {
            PlaylistEntry pe = new PlaylistEntry();
            pe.setDateOfCreation(LocalDateTime.now());
            pe.setPerson(person);
            this.ps.addPlaylistEntry(pe, Scenerixx.unlocked);
            AbstractTopComponent.notify("Added '" + person.getName() + "' to default playlist", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
            TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlistList != null) {
                ((PlaylistTopComponent)playlistList).reloadList();
            }
        }
    }

    public void addToPlaylist(Playlist playlist, Bookmark bookmark) {
        if (bookmark.getMovie() != null && this.db.getDvd(bookmark.getMovie(), Scenerixx.unlocked) != null || bookmark.getScene() != null && this.db.getDvd(bookmark.getScene().getMovie(), Scenerixx.unlocked) != null) {
            JOptionPane.showMessageDialog(null, "Sorry, bookmarks on DVD cannot be added to a playlist (yet)");
        } else if (bookmark.getMedium() == null) {
            JOptionPane.showMessageDialog(null, "Sorry, we cannot add this bookmark since a medium is missing. Please assign a medium first.");
        } else {
            boolean add = true;
            if (this.ps.contains((IPlayable)bookmark, playlist, Scenerixx.unlocked) && 1 == JOptionPane.showConfirmDialog(null, bookmark.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)bookmark, playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this bookmark another time?", 0)) {
                add = false;
            }
            if (add) {
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setBookmark(bookmark);
                this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                AbstractTopComponent.notify("Added '" + bookmark.getNameOfPlayable() + "' to playlist '" + playlist.getName() + "'", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                if (playlistList != null) {
                    ((PlaylistTopComponent)playlistList).reloadList();
                }
            }
        }
    }

    public void addToPlaylist(Playlist playlist, Scene scene) {
        if (this.db.getDvd(scene.getMovie(), Scenerixx.unlocked) != null) {
            JOptionPane.showMessageDialog(null, "Sorry, scenes on DVD cannot be added to a playlist (yet)");
        } else if (scene.getStartMedium() == null) {
            JOptionPane.showMessageDialog(null, "Sorry, we cannot add this scene since a medium is missing. Please assign a medium first to this scene.");
        } else {
            boolean add = true;
            if (this.ps.contains((IPlayable)scene, playlist, Scenerixx.unlocked) && 0 != JOptionPane.showConfirmDialog(null, scene.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)scene, playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this scene another time?", 0)) {
                add = false;
            }
            if (add) {
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setScene(scene);
                this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                AbstractTopComponent.notify("Added '" + scene.toString() + "' to playlist '" + playlist.getName() + "'", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                if (playlistList != null) {
                    ((PlaylistTopComponent)playlistList).reloadList(playlist.getName());
                }
            }
        }
    }

    public void addToPlaylist(Playlist playlist, Movie movie) {
        if (this.db.getDvd(movie, Scenerixx.unlocked) != null) {
            JOptionPane.showMessageDialog(null, "Sorry, movies on DVD cannot be added to a playlist (yet)");
        } else if (this.db.getMediumFiles(movie, Scenerixx.unlocked).isEmpty()) {
            JOptionPane.showMessageDialog(null, "Sorry, we cannot add this movie since a medium is missing. Please assign a medium first.");
        } else {
            boolean add = true;
            if (this.ps.contains((IPlayable)movie, playlist, Scenerixx.unlocked) && 0 != JOptionPane.showConfirmDialog(null, movie.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movie, playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this movie another time?", 0)) {
                add = false;
            }
            if (add) {
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setMovie(movie);
                this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                AbstractTopComponent.notify("Added '" + movie.getTitle() + "' to playlist '" + playlist.getName() + "'", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                SwingUtilities.invokeLater(() -> {
                    TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                    if (playlistList != null) {
                        ((PlaylistTopComponent)playlistList).reloadList(playlist.getName());
                    }
                });
            }
        }
    }

    public void addToPlaylist(Playlist playlist, Studio studio) {
        List movies = this.db.getMovies(studio, Scenerixx.unlocked);
        for (Movie movie : movies) {
            if (this.db.getDvd(movie, Scenerixx.unlocked) != null) {
                JOptionPane.showMessageDialog(null, "Sorry, movies on DVD cannot be added to a playlist (yet)");
                continue;
            }
            if (this.db.getMediumFiles(movie, Scenerixx.unlocked).isEmpty()) {
                JOptionPane.showMessageDialog(null, "Sorry, we cannot add this movie since a medium is missing. Please assign a medium first.");
                continue;
            }
            boolean add = true;
            if (this.ps.contains((IPlayable)movie, playlist, Scenerixx.unlocked) && 0 != JOptionPane.showConfirmDialog(null, movie.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movie, playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this movie another time?", 0)) {
                add = false;
            }
            if (!add) continue;
            PlaylistEntry pe = new PlaylistEntry();
            pe.setDateOfCreation(LocalDateTime.now());
            pe.setMovie(movie);
            this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
            AbstractTopComponent.notifyInfo("Added '" + movie.getTitle() + "' to playlist '" + playlist.getName() + "'");
        }
        AbstractTopComponent.reloadPlaylist(playlist.getName());
    }

    public void askHowManyScenesShouldBeCreated(Movie m) {
        this.askHowManyScenesShouldBeCreated(m, true);
    }

    public void askHowManyScenesShouldBeCreated(Movie m, boolean selextNextNode) {
        ArrayList<Movie> list = new ArrayList<Movie>();
        list.add(m);
        this.askHowManyScenesShouldBeCreated(list, selextNextNode);
    }

    public int askHowManyScenesShouldBeCreated(List<Movie> movies, boolean selextNextNode) {
        Image image = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/paginator.png"), (int)7, (int)7);
        ArrayList<CallSite> scenesModel = new ArrayList<CallSite>();
        scenesModel.add(0, null);
        for (int i = 0; i <= 100; ++i) {
            scenesModel.add((CallSite)((Object)("" + i)));
        }
        Object[] toArray = scenesModel.toArray(String[]::new);
        String showInputDialogScenes = (String)JOptionPane.showInputDialog(null, "Scenes to create", "How many scenes should be created?", 3, ImageUtilities.image2Icon((Image)image), toArray, toArray[0]);
        int n = 0;
        int sceneToSelect = -1;
        try {
            n = Integer.parseInt(showInputDialogScenes);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (Movie m : movies) {
            int newPos = 0;
            for (Scene sc : m.getScenes()) {
                if (newPos >= sc.getPos()) continue;
                newPos = sc.getPos();
            }
            if (sceneToSelect != -1) {
                sceneToSelect = newPos;
            }
            for (int i = 1; i <= n; ++i) {
                Scene newScene = new Scene();
                newScene.setDateOfCreation(LocalDateTime.now());
                newScene.setPos(++newPos);
                newScene.setMovie(m);
                newScene.setDateOfShootDay(m.getReleaseDay());
                newScene.setDateOfShootMonth(m.getReleaseMonth());
                newScene.setDateOfShootYear(m.getReleaseYear());
                m.getScenes().add(newScene);
            }
            m = (Movie)this.db.getEntityService().save((AbstractEntity)m);
            LOG.finest("Added " + n + " scenes to " + m.getTitle());
        }
        if (selextNextNode) {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null && movieList instanceof MovieListTopComponent) {
                MovieListTopComponent movieTc = (MovieListTopComponent)movieList;
                Node nextNode = movieTc.getNextNode();
                Movie nextMovie = null;
                if (nextNode != null) {
                    LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode) + " - " + nextNode.getDisplayName());
                    if (nextNode.getValue("movie") != null && nextNode.getValue("movie") instanceof Movie) {
                        nextMovie = (Movie)nextNode.getValue("movie");
                    }
                } else {
                    LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode));
                }
                movieTc.reloadList();
                if (!movies.isEmpty() && !movies.get(0).getScenes().isEmpty()) {
                    try {
                        boolean nodeWasSelected = movieTc.selectSceneNode((Scene)movies.get(0).getScenes().get(sceneToSelect));
                        if (!nodeWasSelected && nextMovie != null) {
                            LOG.fine("Could not select scene, try to select next movie as fallback: " + nextMovie.getTitle());
                            movieTc.selectMovieNode(nextMovie);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                AbstractTopComponent.reloadMovieList();
            }
        }
        return n;
    }

    public void addMediumFileToMovie(MediumFile mediumFile, Movie m) {
        this.addMediumFileToMovie(mediumFile, m, true);
    }

    public void addMediumFileToMovie(MediumFile mediumFile, Movie m, boolean activateDetailsWindow) {
        this.addMediumFileToMovie(mediumFile, m, true, true);
    }

    public void addMediumFileToMovie(MediumFile mediumFile, Movie m, boolean activateDetailsWindow, boolean reload) {
        if (mediumFile != null) {
            if (mediumFile.getHashValue() == null) {
                JOptionPane.showMessageDialog(null, "The file '" + mediumFile.getFileName() + "' is not hashed yet. Please hash the file before you associate it.", "Abort", 0);
            } else if (mediumFile.getMovie() != null) {
                JOptionPane.showMessageDialog(null, "The file '" + mediumFile.getFileName() + "' is already associated to '" + mediumFile.getMovie().getTitle() + "'", "Abort", 0);
            } else {
                LOG.info("mediumfile '" + String.valueOf(mediumFile) + "' pasted to movie " + m.getTitle());
                if (MediumFileService.isMovie((MediumFile)mediumFile)) {
                    LOG.fine("mediumfile is a movie");
                    mediumFile.setMovie(m);
                    List mediumFiles = this.db.getMediumFiles(m, Scenerixx.unlocked);
                    int highestPart = 0;
                    if (!mediumFiles.isEmpty()) {
                        highestPart = ((MediumFile)mediumFiles.get(mediumFiles.size() - 1)).getPart();
                    }
                    mediumFile.setPart(highestPart + 1);
                    this.db.getEntityService().save((AbstractEntity)mediumFile);
                    m.recalculateTotalRuntime();
                    this.db.getEntityService().save((AbstractEntity)m);
                }
                if (MediumFileService.isPicture((MediumFile)mediumFile)) {
                    LOG.fine("mediumfile is a picture");
                    m.addPicture(mediumFile);
                    try {
                        this.db.getEntityService().save((AbstractEntity)m);
                    }
                    catch (RollbackException ex) {
                        AbstractTopComponent.notify("Picture is already assigned", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "The picture is already assigned to this movie", null, NotificationDisplayer.Priority.LOW);
                    }
                }
                if (reload) {
                    TopComponent detailTopComponent;
                    TopComponent movieList;
                    TopComponent mediumFileList = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
                    if (mediumFileList != null) {
                        ((MediumFileListTopComponent)mediumFileList).reloadList(Node.EMPTY);
                    }
                    if ((movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null) {
                        ((MovieListTopComponent)movieList).reloadList();
                    }
                    if ((detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent")) != null) {
                        ((DetailsTopComponent)detailTopComponent).loadMovie(m);
                        ((DetailsTopComponent)detailTopComponent).focusNameTextField();
                        if (activateDetailsWindow) {
                            detailTopComponent.requestActive();
                        }
                    }
                }
            }
        }
    }

    public void addScene(Movie movie) {
        this.addScene(movie, true);
    }

    public void addScene(Movie movie, boolean reloadAndSelect) {
        TopComponent movieList;
        int newPos = 0;
        for (Scene sc : movie.getScenes()) {
            if (newPos >= sc.getPos()) continue;
            newPos = sc.getPos();
        }
        Scene newScene = new Scene();
        newScene.setDateOfCreation(LocalDateTime.now());
        newScene.setPos(newPos + 1);
        newScene.setMovie(movie);
        newScene.setDateOfShootDay(movie.getReleaseDay());
        newScene.setDateOfShootMonth(movie.getReleaseMonth());
        newScene.setDateOfShootYear(movie.getReleaseYear());
        movie.getScenes().add(newScene);
        movie = (Movie)this.db.getEntityService().save((AbstractEntity)movie);
        LOG.finest("Added scene to " + movie.getTitle());
        if (reloadAndSelect && (movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null) {
            movie = (Movie)this.db.getEntityService().getEntityManager().merge((Object)movie);
            Node nextNode = ((MovieListTopComponent)movieList).getNextNode();
            Movie nextMovie = null;
            if (nextNode != null) {
                LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode) + " - " + nextNode.getDisplayName());
                if (nextNode.getValue("movie") != null && nextNode.getValue("movie") instanceof Movie) {
                    nextMovie = (Movie)nextNode.getValue("movie");
                }
            } else {
                LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode));
            }
            ((MovieListTopComponent)movieList).reloadListAndRefocus();
            boolean nodeWasSelected = ((MovieListTopComponent)movieList).selectSceneNode((Scene)movie.getScenes().get(newPos));
            if (!nodeWasSelected && nextMovie != null) {
                LOG.fine("Could not select scene, try to select next movie as fallback: " + nextMovie.getTitle());
                ((MovieListTopComponent)movieList).selectMovieNode(nextMovie);
            }
        }
    }

    public void addBookmark(Scene scene) {
        this.addBookmark(scene, null);
    }

    public void addBookmark(Scene scene, BookmarkType type) {
        int newPos = -1;
        for (Bookmark b : scene.getBookmarks(true)) {
            if (newPos >= b.getPosition()) continue;
            newPos = b.getPosition();
        }
        Bookmark newBookmark = new Bookmark();
        newBookmark.setDateOfCreation(LocalDateTime.now());
        newBookmark.setPosition(newPos + 1);
        newBookmark.setScene(scene);
        scene.getBookmarks(true).add(newBookmark);
        if (type != null) {
            newBookmark.setType(type);
        }
        scene = (Scene)this.db.getEntityService().save((AbstractEntity)scene);
        AbstractTopComponent.notifyInfo("Added bookmark to " + scene.toString());
        Scene tmpLastScene = scene;
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).reloadListAndRefocus();
                ((MovieListTopComponent)movieList).selectBookmarkNode((Bookmark)tmpLastScene.getBookmarks(true).get(tmpLastScene.getBookmarks(true).size() - 1));
                LOG.info("finished selecting bookmark");
            }
        });
    }

    public void addSubBookmark(Bookmark bookmark) {
        Bookmark subBookmark = new Bookmark();
        subBookmark.setDateOfCreation(LocalDateTime.now());
        subBookmark.setParent(bookmark);
        subBookmark = (Bookmark)this.db.getEntityService().save((AbstractEntity)subBookmark);
        AbstractTopComponent.notifyInfo("Added sub-bookmark to " + bookmark.getNameOfPlayable());
        Bookmark tmpSubBookmark = subBookmark;
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).reloadListAndRefocus();
                ((MovieListTopComponent)movieList).selectBookmarkNode(tmpSubBookmark);
            }
        });
    }

    public int calculateAge(Person p) {
        return this.calculateBirthOrDeathAge(p.getBirthDay(), p.getBirthMonth(), p.getBirthYear());
    }

    public int calculateDeathAnniversary(Person p) {
        return this.calculateBirthOrDeathAge(p.getDeathDay(), p.getDeathMonth(), p.getDeathYear());
    }

    public int calculateDiedWithAge(Person p) {
        int calculateDeathAnniversary = this.calculateDeathAnniversary(p);
        int calculateAge = this.calculateAge(p);
        if (calculateDeathAnniversary < 0 || calculateAge < 0) {
            return -1;
        }
        return calculateAge - calculateDeathAnniversary;
    }

    private int calculateBirthOrDeathAge(Integer day, Integer month, Integer year) {
        if (year == null) {
            return -1;
        }
        int m = month != null ? month : 1;
        int d = day != null ? day : 1;
        LocalDate deathDate = LocalDate.of((int)year, m, d);
        LocalDate today = LocalDate.now();
        return Period.between(deathDate, today).getYears();
    }

    public static String calculateAge(Scene s, Person p) {
        Object result = "";
        if (s.getDateOfShootYear() != null && p.getBirthYear() != null) {
            boolean exact;
            int sDay = 31;
            int sMonth = 6;
            int sYear = s.getDateOfShootYear();
            int pDay = 31;
            int pMonth = 6;
            int pYear = p.getBirthYear();
            boolean bl = exact = p.getBirthMonth() != null && s.getDateOfShootMonth() != null;
            if (s.getDateOfShootMonth() != null) {
                sMonth = s.getDateOfShootMonth();
            }
            if (s.getDateOfShootDay() != null) {
                sDay = s.getDateOfShootDay();
            }
            if (p.getBirthMonth() != null) {
                pMonth = p.getBirthMonth();
            }
            if (p.getBirthDay() != null) {
                pDay = p.getBirthDay();
            }
            Date sceneDate = new Date(sYear + 1900, sMonth, sDay);
            Date personDate = new Date(pYear + 1900, pMonth, pDay);
            result = "(";
            if (!exact) {
                result = (String)result + "~";
            }
            result = (String)result + ScenerixxCommon.yearDifference(personDate, sceneDate) + ")";
        } else if (s.getDetails(p) != null) {
            if (s.getDetails(p).getMentionedAge() != null) {
                result = "(m: ";
                result = (String)result + s.getDetails(p).getMentionedAge() + ")";
            } else if (s.getDetails(p).getAgeRange() != null) {
                result = "(";
                result = (String)result + String.valueOf(s.getDetails(p).getAgeRange()) + ")";
            }
        }
        LOG.finer("calculated age for " + p.getName() + " in scene " + s.getNameOfPlayable() + ": " + (String)result);
        return result;
    }

    public static int yearDifference(Date first, Date second) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        int d1 = Integer.parseInt(formatter.format(first));
        int d2 = Integer.parseInt(formatter.format(second));
        int age = (d2 - d1) / 10000;
        return age;
    }

    public static String readableFileSize(BigDecimal size) {
        return ScenerixxCommon.readableFileSize(size.longValue());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0 bytes";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String readableTimeDifference(LocalDateTime first, LocalDateTime second) {
        Duration duration = Duration.between(first, second);
        long totalSeconds = Math.abs(duration.getSeconds());
        long hours = totalSeconds / 3600L % 24L;
        long minutes = totalSeconds / 60L % 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static LocalDate convertDateToLocalDate(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String readableDuration(Integer duration) {
        if (duration == null) {
            return "n/a";
        }
        return String.format("%02d", duration / 1000 / 3600 % 24) + ":" + String.format("%02d", duration / 1000 / 60 % 60) + ":" + String.format("%02d", duration / 1000 % 60);
    }

    public static String readableSecondsDurationInt(Integer duration) {
        return ScenerixxCommon.readableSecondsDuration((long)duration);
    }

    public static String readableSecondsDuration(Long duration) {
        if (duration == null) {
            return "n/a";
        }
        return String.format("%02d", duration / 3600L % 24L) + ":" + String.format("%02d", duration / 60L % 60L) + ":" + String.format("%02d", duration % 60L);
    }

    public static String readableRuntime(Long runtime) {
        if (runtime == null || runtime < 0L) {
            return "0d 00:00:00";
        }
        long SECONDS_IN_MINUTE = 60L;
        long SECONDS_IN_HOUR = 3600L;
        long SECONDS_IN_DAY = 86400L;
        long SECONDS_IN_YEAR = 31536000L;
        long years = runtime / 31536000L;
        long days = runtime % 31536000L / 86400L;
        long hours = runtime % 86400L / 3600L;
        long minutes = runtime % 3600L / 60L;
        long seconds = runtime % 60L;
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append("y ");
        }
        sb.append(days).append("d ");
        sb.append(String.format("%02d:%02d:%02d", hours, minutes, seconds));
        return sb.toString();
    }

    public static void openExternalBrowser(String url, String pathToBrowserBinary, boolean checkHttpPrefix) {
        if (checkHttpPrefix) {
            if (!url.startsWith("http")) {
                ScenerixxCommon.openExternalBrowser("https://" + url, pathToBrowserBinary);
            } else {
                ScenerixxCommon.openExternalBrowser(url, pathToBrowserBinary);
            }
        } else {
            ScenerixxCommon.openExternalBrowser(url, pathToBrowserBinary);
        }
    }

    public static void openExternalBrowser(String url, String pathToBrowserBinary) {
        LOG.info("Try to open '" + url + "' with " + pathToBrowserBinary);
        if (url == null || url.isBlank()) {
            LOG.info("URL was not set. Abort.");
            return;
        }
        if (pathToBrowserBinary == null || pathToBrowserBinary != null && !pathToBrowserBinary.isEmpty()) {
            ArrayList<String> paras = new ArrayList<String>();
            paras.add(pathToBrowserBinary);
            paras.add(url);
            String[] tmpParas = paras.toArray(new String[paras.size()]);
            try {
                Runtime.getRuntime().exec(tmpParas);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "User-specified browser could not be opened. Check settings. " + ex.getMessage(), "Could not open browser", 0);
            }
        } else {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    URI uri = new URI(url);
                    desktop.browse(uri);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not open external browser. An error occured: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static boolean containsUrlShortener(String url) {
        return (url = url.toLowerCase()).contains("bit.ly/") || url.contains("ow.ly/") || url.contains("buff.ly/") || url.contains("is.gd/") || url.contains("tinyurl.com/");
    }

    public static int parseWithDefault(String s, int defaultVal) {
        return s.matches("-?\\d+") ? Integer.parseInt(s) : defaultVal;
    }

    public StatisticInternal readStatisticInternalAndSaveCopy() {
        return this.readStatisticInternalAndSaveCopy(true);
    }

    public StatisticInternal readStatisticInternalAndSaveCopy(boolean save) {
        LocalDateTime now = LocalDateTime.now();
        StatisticInternal result = new StatisticInternal();
        List moviesWithSecrets = this.db.getMovies(true);
        List moviesWithoutSecrets = this.db.getMovies(false);
        StatisticInternal stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{g -> g.dateOfCreation.desc()}).findFirst();
        if (stats != null) {
            result.setSavedBytes(stats.getSavedBytes());
        }
        result.setStudios(this.db.getStudios().size());
        LOG.info("finished studios " + Duration.between(LocalDateTime.now(), now).toString());
        result.setBookmarksWithSecrets(this.db.getBookmarks(true));
        result.setBookmarksWithoutSecrets(this.db.getBookmarks(false));
        LOG.info("finished bookmarks " + Duration.between(LocalDateTime.now(), now).toString());
        List mediumFilesWithoutSecrets = this.db.getMediumFiles(false);
        long fileSizeWithoutSecrets = 0L;
        for (MediumFile mf : mediumFilesWithoutSecrets) {
            fileSizeWithoutSecrets += mf.getFileSize().longValue();
        }
        result.setMediumfilesWithoutSecretsSize(fileSizeWithoutSecrets);
        List mediumFilesWithSecrets = this.db.getMediumFiles(true);
        long fileSizeWithSecrets = 0L;
        for (MediumFile mf : mediumFilesWithSecrets) {
            fileSizeWithSecrets += mf.getFileSize().longValue();
        }
        result.setMediumfilesWithSecretsSize(fileSizeWithSecrets);
        result.setMediumfilesWithoutSecrets(this.db.getMediumFilesCount(false));
        result.setMediumfilesWithSecrets(this.db.getMediumFilesCount(true));
        LOG.info("finished medium files " + Duration.between(LocalDateTime.now(), now).toString());
        result.setTotalRuntimeWithSecrets(ScenerixxCommon.calculateRuntime(moviesWithSecrets).longValue());
        result.setTotalRuntimeWithoutSecrets(ScenerixxCommon.calculateRuntime(moviesWithoutSecrets).longValue());
        LOG.info("finished runtime " + Duration.between(LocalDateTime.now(), now).toString());
        result.setPersonsWithSecrets(this.db.getPersonsCount(true));
        result.setPersonsWithoutSecrets(this.db.getPersonsCount(false));
        result.setFemalesWithSecrets(this.db.getPersonCount(Gender.FEMALE, true));
        result.setFemalesWithoutSecrets(this.db.getPersonCount(Gender.FEMALE, false));
        result.setMalesWithSecrets(this.db.getPersonCount(Gender.MALE, false));
        result.setMalesWithoutSecrets(this.db.getPersonCount(Gender.MALE, false));
        result.setTsWithSecrets(this.db.getPersonCount(Gender.TS, true));
        result.setTsWithoutSecrets(this.db.getPersonCount(Gender.TS, false));
        LOG.info("finished persons " + Duration.between(LocalDateTime.now(), now).toString());
        result.setMoviesWithSecrets(moviesWithSecrets.size());
        result.setMoviesWithoutSecrets(moviesWithoutSecrets.size());
        result.setThreeDmoviesWithSecrets(this.db.get3DCount(true));
        result.setThreeDmoviesWithoutSecrets(this.db.get3DCount(false));
        result.setInteractiveMoviesWithSecrets(this.db.getInteractiveCount(true));
        result.setInteractiveMoviesWithoutSecrets(this.db.getInteractiveCount(false));
        result.setVrMoviesWithSecrets(this.db.getVRCount(true));
        result.setVrMoviesWithoutSecrets(this.db.getVRCount(false));
        LOG.info("finished special movies " + Duration.between(LocalDateTime.now(), now).toString());
        result.setScenesWithSecrets(this.db.getSceneCount(true));
        result.setScenesWithoutSecrets(this.db.getSceneCount(false));
        LOG.info("finished scenes " + Duration.between(LocalDateTime.now(), now).toString());
        result.setHashedFileCompletedWithSecrets(this.db.getMediumFilesCount(true, false, false, true));
        result.setHashedFileCompletedWithoutSecrets(this.db.getMediumFilesCount(true, false, false, false));
        result.setHashedFileMissingWithSecrets(this.db.getMediumFilesCount(true, false, true, true));
        result.setHashedFileMissingWithoutSecrets(this.db.getMediumFilesCount(true, false, true, false));
        LOG.info("finished hashed files " + Duration.between(LocalDateTime.now(), now).toString());
        result.setAssociatedMovieFilesCompletedWithSecrets(this.db.getMediumFilesCount(false, false, false, true));
        result.setAssociatedMovieFilesCompletedWithoutSecrets(this.db.getMediumFilesCount(false, false, false, false));
        result.setAssociatedMovieFilesMissingWithSecrets(this.db.getMediumFilesCount(false, true, false, true));
        result.setAssociatedMovieFilesMissingWithoutSecrets(this.db.getMediumFilesCount(false, true, false, false));
        LOG.info("finished associated files " + Duration.between(LocalDateTime.now(), now).toString());
        int scenes = 0;
        int scenesMissing = 0;
        int dateOfShoot = 0;
        int dateOfShootMissing = 0;
        int studios = 0;
        int studiosMissing = 0;
        long person = this.db.countPersons(true, false);
        long personMissing = this.db.countPersons(true, true);
        int lengthSet = 0;
        int lengthMissing = 0;
        int scenesWithoutSecrets = 0;
        int scenesMissingWithoutSecrets = 0;
        int dateOfShootWithoutSecrets = 0;
        int dateOfShootMissingWithoutSecrets = 0;
        int studiosWithoutSecrets = 0;
        int studiosMissingWithoutSecrets = 0;
        int lengthSetWithoutSecrets = 0;
        int lengthMissingWithoutSecrets = 0;
        long personWithoutSecrets = this.db.countPersons(false, false);
        long personMissingWithoutSecrets = this.db.countPersons(false, true);
        LOG.info("finished set/missing (persons)" + Duration.between(LocalDateTime.now(), now).toString());
        lengthMissing = this.db.countScenesLength(true, true);
        lengthMissingWithoutSecrets = this.db.countScenesLength(false, true);
        lengthSet = this.db.countScenesLength(true, false);
        lengthSetWithoutSecrets = this.db.countScenesLength(false, false);
        LOG.info("finished set/missing (length)" + Duration.between(LocalDateTime.now(), now).toString());
        studios = this.db.countAssociatedStudios(true, false);
        studiosMissing = this.db.countAssociatedStudios(true, true);
        studiosMissingWithoutSecrets = this.db.countAssociatedStudios(false, true);
        studiosWithoutSecrets = this.db.countAssociatedStudios(false, false);
        LOG.info("finished set/missing (studios)" + Duration.between(LocalDateTime.now(), now).toString());
        dateOfShoot = this.db.countDateOfShoot(true, false);
        dateOfShootMissing = this.db.countDateOfShoot(true, true);
        dateOfShootMissingWithoutSecrets = this.db.countDateOfShoot(false, true);
        dateOfShootWithoutSecrets = this.db.countDateOfShoot(false, false);
        LOG.info("finished set/missing (date of shoot)" + Duration.between(LocalDateTime.now(), now).toString());
        scenes = this.db.countAssociatedScenes(true, false);
        scenesMissing = this.db.countAssociatedScenes(true, true);
        scenesMissingWithoutSecrets = this.db.countAssociatedScenes(false, true);
        scenesWithoutSecrets = this.db.countAssociatedScenes(false, false);
        LOG.info("finished set/missing (associated scenes)" + Duration.between(LocalDateTime.now(), now).toString());
        result.setMoviesWithAssociatedScenesCompletedWithSecrects(scenes);
        result.setMoviesWithAssociatedScenesMissingWithSecrects(scenesMissing);
        result.setStudioCompletedWithSecrects(studios);
        result.setStudioMissingWithSecrects(studiosMissing);
        result.setPersonsAssociatedCompletedWithSecrects((int)person);
        result.setPersonsAssociatedMissingWithSecrects((int)personMissing);
        result.setSceneLengthSetCompletedWithSecrects(lengthSet);
        result.setSceneLengthSetMissingWithSecrects(lengthMissing);
        result.setMoviesWithAssociatedScenesCompletedWithoutSecrects(scenesWithoutSecrets);
        result.setMoviesWithAssociatedScenesMissingWithoutSecrects(scenesMissingWithoutSecrets);
        result.setPersonsAssociatedCompletedWithoutSecrects((int)personWithoutSecrets);
        result.setPersonsAssociatedMissingWithoutSecrects((int)personMissingWithoutSecrets);
        result.setDateOfShootSetCompletedWithSecrects(dateOfShoot);
        result.setDateOfShootSetMissingWithSecrects(dateOfShootMissing);
        result.setDateOfShootSetCompletedWithoutSecrects(dateOfShootWithoutSecrets);
        result.setDateOfShootSetMissingWithoutSecrects(dateOfShootMissingWithoutSecrets);
        result.setStudioCompletedWithoutSecrects(studiosWithoutSecrets);
        result.setStudioMissingWithoutSecrects(studiosMissingWithoutSecrets);
        result.setSceneLengthSetCompletedWithoutSecrects(lengthSetWithoutSecrets);
        result.setSceneLengthSetMissingWithoutSecrects(lengthMissingWithoutSecrets);
        LOG.info("finished set/missing " + Duration.between(LocalDateTime.now(), now).toString());
        result.setScreencapsMissingWithSecrects(this.countMissingScreencaps(true));
        result.setScreencapsMissingWithoutSecrects(this.countMissingScreencaps(false));
        if (result.getScreencapsMissingWithSecrects() == -1) {
            result.setScreencapsCompletedWithSecrects(-1);
        } else {
            result.setScreencapsCompletedWithSecrects(moviesWithSecrets.size() - result.getScreencapsMissingWithSecrects());
        }
        if (result.getScreencapsCompletedWithoutSecrects() == -1) {
            result.setScreencapsCompletedWithoutSecrects(-1);
        } else {
            result.setScreencapsCompletedWithoutSecrects(moviesWithoutSecrets.size() - result.getScreencapsMissingWithoutSecrects());
        }
        LOG.info("finished screencaps " + Duration.between(LocalDateTime.now(), now).toString());
        result.setMediaInformationCompletedWithSecrects((int)this.db.countMediaInfosSet(true));
        result.setMediaInformationMissingWithSecrects((int)this.db.countMediaInfosMissing(true));
        result.setMediaInformationCompletedWithoutSecrects((int)this.db.countMediaInfosSet(false));
        result.setMediaInformationMissingWithoutSecrects((int)this.db.countMediaInfosMissing(false));
        LOG.info("finished media information " + Duration.between(LocalDateTime.now(), now).toString());
        result.setWizardDataConfirmedWithSecrects((int)this.db.countWizardGeneratedDataConfirmed(true));
        result.setWizardDataNotConfirmedWithSecrects((int)this.db.countWizardGeneratedDataNotConfirmed(true));
        result.setWizardDataConfirmedWithoutSecrects((int)this.db.countWizardGeneratedDataConfirmed(false));
        result.setWizardDataNotConfirmedWithoutSecrects((int)this.db.countWizardGeneratedDataNotConfirmed(false));
        LOG.info("finished data confirmed" + Duration.between(LocalDateTime.now(), now).toString());
        if (save) {
            this.db.getEntityService().save((AbstractEntity)result);
        }
        LOG.info("finished statistic " + Duration.between(LocalDateTime.now(), now).toString());
        return result;
    }

    private int countMissingScreencaps(boolean showSecrets) {
        if (Scenerixx.scenerixxScreencapDir == null || !new File(Scenerixx.scenerixxScreencapDir).exists()) {
            LOG.info("the screencap directory seem not to exist. Maybe it's on a removable drive? Return -1");
            return -1;
        }
        ArrayList<Long> movieIdsWithScreencap = new ArrayList<Long>();
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), 1, new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    if (!filePath.getFileName().toString().contains("_") || !filePath.getFileName().toString().endsWith(".png")) continue;
                    try {
                        Long parseLong = Long.valueOf(filePath.getFileName().toString().substring(0, filePath.getFileName().toString().indexOf("_")));
                        movieIdsWithScreencap.add(parseLong);
                    }
                    catch (NumberFormatException ex) {
                        LOG.info("Could not parse ID from " + String.valueOf(filePath.getFileName()));
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
        }
        if (movieIdsWithScreencap.isEmpty()) {
            movieIdsWithScreencap.add(-1L);
        }
        int screencapsLeft = 0;
        List movies = this.db.getMovies(showSecrets);
        screencapsLeft = movies.size();
        for (Movie m : movies) {
            if (!movieIdsWithScreencap.contains(m.getId())) continue;
            --screencapsLeft;
        }
        return screencapsLeft;
    }

    public static Long calculateRuntime(List<Movie> movies) {
        Long runtime = 0L;
        for (Movie movie : movies) {
            if (movie.getTotalRuntime() <= 0) continue;
            runtime = runtime + (long)movie.getTotalRuntime();
        }
        return runtime;
    }

    public String calculateTotalRuntime(Person p) {
        List scenes = this.db.getScenes(p, Scenerixx.unlocked);
        Long runtime = 0L;
        for (Scene s : scenes) {
            if (s.getTotalRuntime() <= 0) continue;
            runtime = runtime + (long)s.getTotalRuntime();
        }
        Object sRuntime = "";
        if (runtime / 86400L > 0L) {
            sRuntime = String.format("%02d", runtime / 86400L) + "d:";
        }
        sRuntime = (String)sRuntime + String.format("%02d", runtime / 3600L % 24L) + ":" + String.format("%02d", runtime / 60L % 60L) + ":" + String.format("%02d", runtime % 60L);
        return sRuntime;
    }

    public static int parseInt(String s) {
        int result = 0;
        try {
            result = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            LOG.warning("Could not parse as integer: " + s);
        }
        return result;
    }

    public static OS getOS() {
        if (os == null) {
            String operSys = System.getProperty("os.name").toLowerCase();
            if (operSys.contains("win")) {
                os = OS.WINDOWS;
            } else if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
                os = OS.LINUX;
            } else if (operSys.contains("mac")) {
                os = OS.MAC;
            } else if (operSys.contains("sunos")) {
                os = OS.SOLARIS;
            }
        }
        return os;
    }

    public static void shutdown() throws RuntimeException, IOException {
        String shutdownCommand;
        if (ScenerixxCommon.getOS() == OS.LINUX || ScenerixxCommon.getOS() == OS.MAC) {
            shutdownCommand = "shutdown -h 0";
        } else if (ScenerixxCommon.getOS() == OS.WINDOWS) {
            shutdownCommand = "shutdown.exe -s -t 0";
        } else {
            throw new RuntimeException("Unsupported operating system.");
        }
        LOG.info("shutdown: " + shutdownCommand);
        AbstractTopComponent.notifyWarning("We are going to shutdown now!!! See you next time...");
        Runtime.getRuntime().exec(shutdownCommand);
        LifecycleManager.getDefault().exit();
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static void setWindowPosition(JDialog window, int screen) {
        int screenY;
        int screenX;
        int topLeftY;
        int topLeftX;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allDevices = env.getScreenDevices();
        if (screen < allDevices.length && screen > -1) {
            topLeftX = allDevices[screen].getDefaultConfiguration().getBounds().x;
            topLeftY = allDevices[screen].getDefaultConfiguration().getBounds().y;
            screenX = allDevices[screen].getDefaultConfiguration().getBounds().width;
            screenY = allDevices[screen].getDefaultConfiguration().getBounds().height;
        } else {
            topLeftX = allDevices[0].getDefaultConfiguration().getBounds().x;
            topLeftY = allDevices[0].getDefaultConfiguration().getBounds().y;
            screenX = allDevices[0].getDefaultConfiguration().getBounds().width;
            screenY = allDevices[0].getDefaultConfiguration().getBounds().height;
        }
        int windowPosX = (screenX - window.getWidth()) / 2 + topLeftX;
        int windowPosY = (screenY - window.getHeight()) / 2 + topLeftY;
        window.setLocation(windowPosX, windowPosY);
    }

    public static String highlighting(String displayName, String searchTerms) {
        if (searchTerms != null && !searchTerms.isBlank()) {
            LOG.finer("search term to be highlighted: " + searchTerms);
            searchTerms = searchTerms.replaceAll("  ", " ");
            searchTerms = searchTerms.replaceAll("\"\"", "");
            String[] terms = searchTerms.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            ArrayList<String> list = new ArrayList<String>();
            for (String s : terms) {
                if (s.startsWith("\"") && s.endsWith("\"")) {
                    list.add(s.substring(1, s.length() - 1));
                    continue;
                }
                list.add(s);
            }
            String[] myArray = new String[list.size()];
            list.toArray(myArray);
            displayName = ScenerixxCommon.highlight(displayName, myArray);
        }
        return displayName;
    }

    public static String highlight(String inputString, String[] terms) {
        int searchHighlightColor = DB.getInstance().getScenerixxSettings().getSearchHighlightColor();
        String toHexString = Integer.toHexString(searchHighlightColor);
        Object highlightColor = "";
        if (toHexString.length() < 2) {
            LOG.finest("Default to 0xFFC40C");
            highlightColor = "FFC40C";
        } else {
            highlightColor = "#" + toHexString.substring(2);
        }
        String startTag = "<b><font color=\"" + (String)highlightColor + "\">";
        String endTag = "</font></b>";
        Trie trie = Trie.builder().ignoreCase().addKeywords(terms).build();
        Collection emits = trie.parseText((CharSequence)inputString);
        ArrayList list = new ArrayList();
        list.addAll(emits);
        Object tmp = "";
        int startIndex = 0;
        for (Emit e : list) {
            try {
                int lastIndex = e.getStart();
                tmp = (String)tmp + inputString.substring(startIndex, lastIndex) + startTag + e.getKeyword() + endTag;
                startIndex = e.getEnd() + 1;
            }
            catch (StringIndexOutOfBoundsException ex) {
                LOG.info("Error during highlighting. Input string: " + inputString + " - keyword: " + e.getKeyword() + " - error: " + ex.getMessage());
            }
        }
        tmp = (String)tmp + inputString.substring(startIndex, inputString.length());
        return "<html>" + (String)tmp + "</html>";
    }

    public static String getSumSymbol(int count) {
        if (count > 0) {
            return "<font color=\"#7B68EE\">" + count + "</font> " + ScenerixxCommon.getSumSymbolChar();
        }
        return count + " " + ScenerixxCommon.getSumSymbolChar();
    }

    public static String getColoredHeart(int count) {
        if (count > 0) {
            return "<font color=\"#F660AB\">" + count + "</font> " + ScenerixxCommon.getHeartChar(true);
        }
        return count + " " + ScenerixxCommon.getHeartChar(false);
    }

    public static String getColoredStar(int count) {
        if (count > 0) {
            return "<font color=\"#3EA055\">" + count + "</font> " + ScenerixxCommon.getStarChar(true);
        }
        return "?? " + ScenerixxCommon.getStarChar(false);
    }

    public static String getColoredStar(int count, Differentiator diff) {
        if (count > 0) {
            String rating = "" + count;
            if (count <= 9) {
                rating = "&nbsp;" + rating;
            }
            rating = diff != null && diff != Differentiator.SAME ? rating + diff.getTitle() : rating + "&nbsp;&nbsp;";
            return "<font color=\"#3EA055\">" + rating + "</font> " + ScenerixxCommon.getStarChar(true);
        }
        return "??&nbsp;&nbsp;" + ScenerixxCommon.getStarChar(false);
    }

    public static String getSumSymbolChar() {
        String result = "";
        if (SUM_SYMBOL_CHAR != null) {
            result = SUM_SYMBOL_CHAR;
        } else {
            try {
                LOG.info("initialize sum symbol char");
                UIDefaults defaults = UIManager.getDefaults();
                int i = 0;
                Enumeration e = defaults.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = defaults.get(key);
                    if (value instanceof Font) {
                        Font font = (Font)value;
                        LOG.finer("---> font: " + font.getName() + " - " + font.canDisplay(SUM_SYMBOL.charAt(0)));
                        if (font.canDisplay(SUM_SYMBOL.charAt(0))) {
                            SUM_SYMBOL_CHAR = result = SUM_SYMBOL;
                            break;
                        }
                        SUM_SYMBOL_CHAR = result = "x";
                        LOG.finer("Sum: " + result + SUM_SYMBOL_CHAR);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            LOG.info("finished: " + SUM_SYMBOL_CHAR);
        }
        return result;
    }

    private static String getHeartChar(boolean filled) {
        String result = "";
        if (!filled && HEART_CHAR != null) {
            result = HEART_CHAR;
        } else if (filled && HEART_CHAR_FILLED != null) {
            result = HEART_CHAR_FILLED;
        } else {
            try {
                LOG.info("initialize heart char");
                UIDefaults defaults = UIManager.getDefaults();
                int i = 0;
                Enumeration e = defaults.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = defaults.get(key);
                    if (value instanceof Font) {
                        Font font = (Font)value;
                        LOG.finer(String.valueOf(key) + "---> font: " + font.getName() + " - " + font.canDisplay(HEART.charAt(0)));
                        if (!filled && font.canDisplay(HEART.charAt(0))) {
                            HEART_CHAR = result = HEART;
                            break;
                        }
                        if (filled && font.canDisplay(HEART_FILLED.charAt(0))) {
                            HEART_CHAR_FILLED = result = HEART_FILLED;
                            break;
                        }
                        if (font.canDisplay(HEART_FILLED.charAt(0))) {
                            HEART_CHAR = result = HEART_FILLED;
                            HEART_CHAR_FILLED = result;
                        } else {
                            HEART_CHAR = result = ":-)";
                            HEART_CHAR_FILLED = result;
                        }
                        LOG.finer("Heart: " + result + " " + HEART_CHAR + " " + HEART_CHAR_FILLED);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            LOG.info("finished: " + HEART_CHAR + " - " + HEART_CHAR_FILLED);
        }
        return result;
    }

    private static String getStarChar(boolean filled) {
        String result = "";
        if (!filled && STAR_CHAR != null) {
            result = STAR_CHAR;
        } else if (filled && STAR_CHAR_FILLED != null) {
            result = STAR_CHAR_FILLED;
        } else {
            try {
                LOG.info("initialize star char");
                UIDefaults defaults = UIManager.getDefaults();
                int i = 0;
                Enumeration e = defaults.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = defaults.get(key);
                    if (value instanceof Font) {
                        Font font = (Font)value;
                        LOG.finer("---> font: " + font.getName() + " - " + font.canDisplay(STAR.charAt(0)));
                        if (!filled && font.canDisplay(STAR.charAt(0))) {
                            STAR_CHAR = result = STAR;
                            break;
                        }
                        if (filled && font.canDisplay(STAR_FILLED.charAt(0))) {
                            STAR_CHAR_FILLED = result = STAR_FILLED;
                            break;
                        }
                        STAR_CHAR = result = "#";
                        STAR_CHAR_FILLED = result;
                        LOG.finer("Star: " + result + " " + STAR_CHAR_FILLED + " " + STAR_CHAR);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            LOG.info("finished: " + STAR_CHAR + " - " + STAR_CHAR_FILLED);
        }
        return result;
    }

    public static String formatRuntimeBookmarkWithoutEndtime(int runtime) {
        DecimalFormat formatter = new DecimalFormat("00");
        String sRuntime = formatter.format(runtime / 3600 % 24) + ":" + formatter.format(runtime / 60 % 60) + ":" + formatter.format(runtime % 60);
        sRuntime = "Starts at " + sRuntime.replaceAll("-", "");
        return sRuntime;
    }

    public static String formatRuntime(int runtime) {
        DecimalFormat formatter = new DecimalFormat("00");
        String sRuntime = formatter.format(runtime / 3600 % 24) + ":" + formatter.format(runtime / 60 % 60) + ":" + formatter.format(runtime % 60);
        LOG.finest("sRuntime: " + sRuntime + " - runtime: " + runtime);
        if (sRuntime.contains("-") && !sRuntime.equalsIgnoreCase("00:00:-01")) {
            sRuntime = "Starts at " + sRuntime.replaceAll("-", "");
        }
        LOG.finest("return: " + sRuntime);
        return sRuntime;
    }

    public static Movie readInNextNode(TopComponent movieList) {
        Movie nextMovie = null;
        if (movieList != null) {
            Object object;
            Node nextNode = Node.EMPTY;
            nextNode = ((MovieListTopComponent)movieList).getNextNode();
            if (nextNode != null && nextNode.getValue("movie") != null && (object = nextNode.getValue("movie")) instanceof Movie) {
                Movie movie = (Movie)object;
                nextMovie = movie;
                if (nextMovie.getTitle().contains(this_node_will_be_removed_with_the_next_reload)) {
                    LOG.info(nextMovie.getTitle() + " is already marked for deletion.");
                    nextMovie = null;
                } else {
                    LOG.info("not marked for deletion: " + nextMovie.getTitle() + " / " + nextNode.getHtmlDisplayName() + " / " + nextNode.getName());
                }
            }
        }
        return nextMovie;
    }

    public static String singularPlural(int count, String singular, String plural, boolean prefix) {
        return ScenerixxCommon.singularPlural((long)count, singular, plural, prefix);
    }

    public static String singularPlural(long count, String singular, String plural, boolean prefix) {
        if (count != 1L) {
            if (prefix) {
                return count + " " + plural;
            }
            return plural;
        }
        if (prefix) {
            return count + " " + singular;
        }
        return singular;
    }

    public static String singularPlural(int count, String singular, boolean prefix) {
        return ScenerixxCommon.singularPlural((long)count, singular, prefix);
    }

    public static String singularPlural(int count, String singular) {
        return ScenerixxCommon.singularPlural((long)count, singular, true);
    }

    public static String singularPlural(long count, String singular, boolean prefix) {
        if (count != 1L) {
            if (prefix) {
                return count + " " + singular + "s";
            }
            return singular + "s";
        }
        if (prefix) {
            return count + " " + singular;
        }
        return singular;
    }

    public Playlist renamePlaylist(Playlist playlist) {
        String newValue = JOptionPane.showInputDialog(null, "Rename", playlist.getName());
        if (newValue == null || newValue != null && newValue.isEmpty()) {
            JOptionPane.showMessageDialog(null, "A name for a playlist can't be empty.");
            return null;
        }
        if (playlist.getId() == null) {
            playlist = (Playlist)this.db.getEntityService().save((AbstractEntity)playlist);
            AbstractTopComponent.clearClipboard();
        }
        playlist.setName(newValue);
        playlist = (Playlist)this.db.getEntityService().save((AbstractEntity)playlist);
        LOG.info("from rename childfactory: " + String.valueOf(playlist.getEntries(Scenerixx.unlocked)));
        return playlist;
    }

    public void checkEmptyDirectoryAndDeleteIfWanted(MediumFile mf) {
        String pathString = new File(mf.getFileCompletePath()).getParent();
        LOG.info("Check if directory is empty: " + pathString);
        File path = new File(pathString);
        File[] listFiles = path.listFiles();
        if (listFiles != null && listFiles.length == 0) {
            if (Scenerixx.deleteEmptyDirectories) {
                LOG.info("Delete empty directory because of remembered decision: " + pathString);
                path.delete();
            } else {
                int showConfirmDialog = JOptionPane.showConfirmDialog(null, "The directory " + pathString + " is now empty. Should we also delete it and remember this decision?\n\nClick YES, if you want to delete the empty directory and remember the decision for the next empty directories.\nPress NO to delete the current empty directory but get asked how to proceed with the next empty directory.\nPress CANCEL if you don't want to delete the empty directory", "Delete also empty directory?", 1);
                if (0 == showConfirmDialog) {
                    LOG.info("Deleting also empty directory and remember decision: " + pathString);
                    path.delete();
                    Scenerixx.deleteEmptyDirectories = true;
                } else if (1 == showConfirmDialog) {
                    LOG.info("Deleting also empty directory but don't remember decision: " + pathString);
                    path.delete();
                } else if (2 == showConfirmDialog) {
                    LOG.info("Empty directory should not get deleted: " + pathString);
                }
            }
        }
    }

    public boolean deleteStudio(Studio obj) {
        boolean reload = false;
        List moviesAssignedToStudio = this.db.getMovies(obj, Scenerixx.unlocked);
        List studiosAssignedToPlaylistEntries = this.db.getPlaylistEntries(obj);
        List studiosWithParents = this.db.getStudios(obj);
        boolean rolledback = false;
        try {
            this.db.getEntityService().delete((AbstractEntity)obj);
            reload = true;
            AbstractTopComponent.notifyInfo("Deleted studio '" + obj.getName() + "'");
        }
        catch (RollbackException ex) {
            rolledback = true;
        }
        if (rolledback) {
            if (!moviesAssignedToStudio.isEmpty() || !studiosAssignedToPlaylistEntries.isEmpty()) {
                int resetAssignnments = JOptionPane.showConfirmDialog(null, "Could not delete " + obj.getName() + ". There are still " + moviesAssignedToStudio.size() + " movies assigned to this studio and " + studiosAssignedToPlaylistEntries.size() + " playlist entries.\nShould we try to reset all assignments and try again?", "Reset studio assignments?", 0, 2);
                if (resetAssignnments == 0) {
                    for (Movie m : moviesAssignedToStudio) {
                        m.setStudio(null);
                        this.db.getEntityService().save((AbstractEntity)m);
                    }
                    for (PlaylistEntry pe : studiosAssignedToPlaylistEntries) {
                        pe.setStudio(null);
                        this.db.getEntityService().save((AbstractEntity)pe);
                    }
                    try {
                        this.db.getEntityService().delete((AbstractEntity)obj);
                        reload = true;
                        AbstractTopComponent.notifyInfo("Deleted studio '" + obj.getName() + "'");
                    }
                    catch (RollbackException ex) {
                        JOptionPane.showMessageDialog(null, "Sorry, still no sucess. Seems like some manual labor needs to be done :-/", "Error", 0);
                    }
                }
            } else if (!studiosWithParents.isEmpty()) {
                int resetAssignnments = JOptionPane.showConfirmDialog(null, "Could not delete " + obj.getName() + ". There are still " + studiosWithParents.size() + " studios which use the studio as a parent studio.\nShould we try to reset all assignments and try again?", "Reset studio assignments?", 0, 2);
                if (resetAssignnments == 0) {
                    for (Studio s : studiosWithParents) {
                        s.setParent(null);
                        this.db.getEntityService().save((AbstractEntity)s);
                    }
                    try {
                        this.db.getEntityService().delete((AbstractEntity)obj);
                        reload = true;
                        AbstractTopComponent.notifyInfo("Deleted studio '" + obj.getName() + "'");
                    }
                    catch (RollbackException ex) {
                        JOptionPane.showMessageDialog(null, "Sorry, still no sucess. Seems like some manual labor needs to be done :-/", "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Sorry, neither a movie uses this studio nor is it used as a parent studio. No clue, why this studio could not be deleted :-/", "Error", 0);
            }
        }
        return reload;
    }

    /*
     * Could not resolve type clashes
     */
    public void addToDefaultPlaylist(Node[] nodes) {
        int cntPerson = 0;
        int cntStudioMovie = 0;
        int cntStudio = 0;
        int cntMovie = 0;
        int cntScene = 0;
        int cntBookmark = 0;
        int cntMediumFile = 0;
        int cntStudioNotMovie = 0;
        int cntNotStudio = 0;
        int cntNotPerson = 0;
        int cntNotMovie = 0;
        int cntNotScene = 0;
        int cntNotBookmark = 0;
        int cntNotMediumFile = 0;
        PlaylistEntry entry = new PlaylistEntry();
        entry.setDateOfCreation(LocalDateTime.now());
        Object msg = "";
        for (Node n : nodes) {
            MediumFile mediumFile;
            Bookmark bookmark;
            Scene scene;
            Object pe4;
            Movie movie;
            Person person;
            Studio studio = (Studio)n.getValue("studio");
            if (studio != null) {
                boolean add = true;
                if (this.ps.contains(studio, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                    Object[] options = new Object[]{"Yes, add another time", "No way!", "Replace existing entries with new one", "Cancel"};
                    int showConfirmDialog = JOptionPane.showOptionDialog(null, studio.getName() + " is already on the playlist at position " + this.ps.getPositionInPlaylist(studio, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this studio another time?", -1, 3, null, options, options[0]);
                    if (1 == showConfirmDialog) {
                        add = false;
                        ++cntNotStudio;
                    } else if (2 == showConfirmDialog) {
                        List entries = this.ps.getDefaultPlaylist(Scenerixx.unlocked).getEntries(Scenerixx.unlocked);
                        ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
                        for (PlaylistEntry pe2 : entries) {
                            if (!pe2.getNameOfPlayable().equals(studio.getName())) continue;
                            LOG.info("delete " + studio.getName());
                            tmpList.add(pe2);
                        }
                        for (PlaylistEntry pe2 : tmpList) {
                            this.ps.deletePlaylistEntry(pe2, true);
                        }
                        add = true;
                    } else if (3 == showConfirmDialog || -1 == showConfirmDialog) {
                        return;
                    }
                }
                if (add) {
                    entry.setStudio(studio);
                    this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                    ++cntStudio;
                }
            }
            if ((person = (Person)n.getValue("person")) != null) {
                boolean add = true;
                if (this.ps.contains(person, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                    Object[] options = new Object[]{"Yes, add another time", "No way!", "Replace existing entries with new one", "Cancel"};
                    int showConfirmDialog = JOptionPane.showOptionDialog(null, person.getName() + " is already on the playlist at position " + this.ps.getPositionInPlaylist(person, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this person another time?", -1, 3, null, options, options[0]);
                    if (1 == showConfirmDialog) {
                        add = false;
                        ++cntNotPerson;
                    } else if (2 == showConfirmDialog) {
                        List entries = this.ps.getDefaultPlaylist(Scenerixx.unlocked).getEntries(Scenerixx.unlocked);
                        ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
                        for (Object pe3 : entries) {
                            if (!pe3.getNameOfPlayable().equals(person.getName())) continue;
                            LOG.info("delete " + person.getName());
                            tmpList.add((PlaylistEntry)pe3);
                        }
                        for (Object pe3 : tmpList) {
                            this.ps.deletePlaylistEntry((PlaylistEntry)pe3, true);
                        }
                        add = true;
                    } else if (3 == showConfirmDialog || -1 == showConfirmDialog) {
                        return;
                    }
                }
                if (add) {
                    entry.setPerson(person);
                    this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                    ++cntPerson;
                }
            }
            if ((movie = (Movie)n.getValue("movie")) != null) {
                if (this.db.getDvd(movie, Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, movies on DVD cannot be added to a playlist (yet)");
                } else if (this.db.getMediumFiles(movie, Scenerixx.unlocked).isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this movie since a medium is missing. Please assign a medium first.");
                } else {
                    boolean add = true;
                    if (this.ps.contains((IPlayable)movie, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                        Object[] options = new Object[]{"Yes, add another time", "No way!", "Replace existing entries with new one", "Cancel"};
                        int showConfirmDialog = JOptionPane.showOptionDialog(null, movie.getTitle() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movie, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this movie another time?", -1, 3, null, options, options[0]);
                        if (1 == showConfirmDialog) {
                            add = false;
                            ++cntNotMovie;
                        } else if (2 == showConfirmDialog) {
                            Object pe3;
                            List entries = this.ps.getDefaultPlaylist(Scenerixx.unlocked).getEntries(Scenerixx.unlocked);
                            ArrayList<Object> tmpList = new ArrayList<Object>();
                            for (Object pe4 : entries) {
                                if (!pe4.getNameOfPlayable().equals(movie.getTitle())) continue;
                                LOG.info("delete " + movie.getTitle());
                                tmpList.add(pe4);
                            }
                            pe3 = tmpList.iterator();
                            while (pe3.hasNext()) {
                                pe4 = (PlaylistEntry)pe3.next();
                                this.ps.deletePlaylistEntry((PlaylistEntry)pe4, true);
                            }
                            add = true;
                        } else if (3 == showConfirmDialog || -1 == showConfirmDialog) {
                            return;
                        }
                    }
                    if (add) {
                        entry.setMovie(movie);
                        this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                        ++cntMovie;
                    }
                }
            }
            if ((scene = (Scene)n.getValue("scene")) != null) {
                if (this.db.getDvd(scene.getMovie(), Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, scenes on DVD cannot be added to a playlist (yet)");
                } else if (scene.getStartMedium() == null) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this scene since a medium is missing. Please assign a medium first to this scene.");
                } else {
                    boolean add = true;
                    if (this.ps.contains((IPlayable)scene, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                        int showConfirmDialog = JOptionPane.showConfirmDialog(null, scene.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)scene, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this scene another time?", 1);
                        if (1 == showConfirmDialog) {
                            add = false;
                            ++cntNotScene;
                        } else if (2 == showConfirmDialog) {
                            return;
                        }
                    }
                    if (this.ps.contains((IPlayable)scene, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                        Object[] options = new Object[]{"Yes, add another time", "No way!", "Replace existing entries with new one", "Cancel"};
                        int showConfirmDialog = JOptionPane.showOptionDialog(null, scene.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)scene, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this scene another time?", -1, 3, null, options, options[0]);
                        if (1 == showConfirmDialog) {
                            add = false;
                            ++cntNotScene;
                        } else if (2 == showConfirmDialog) {
                            List entries = this.ps.getDefaultPlaylist(Scenerixx.unlocked).getEntries(Scenerixx.unlocked);
                            ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
                            for (PlaylistEntry pe5 : entries) {
                                if (!pe5.getNameOfPlayable().equals(scene.getNameOfPlayable())) continue;
                                LOG.info("delete " + scene.getNameOfPlayable());
                                tmpList.add(pe5);
                            }
                            pe4 = tmpList.iterator();
                            while (pe4.hasNext()) {
                                PlaylistEntry pe5;
                                pe5 = (PlaylistEntry)pe4.next();
                                this.ps.deletePlaylistEntry(pe5, true);
                            }
                            add = true;
                        } else if (3 == showConfirmDialog || -1 == showConfirmDialog) {
                            return;
                        }
                    }
                    if (add) {
                        entry.setScene(scene);
                        this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                        ++cntScene;
                    }
                }
            }
            if ((bookmark = (Bookmark)n.getValue("bookmark")) != null) {
                if (bookmark.getMovie() != null && this.db.getDvd(bookmark.getMovie(), Scenerixx.unlocked) != null || bookmark.getScene() != null && this.db.getDvd(bookmark.getScene().getMovie(), Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, bookmarks on DVD cannot be added to a playlist (yet)");
                } else if (bookmark.getMedium() == null) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this bookmark since a medium is missing. Please assign a medium first.");
                } else {
                    boolean add = true;
                    if (this.ps.contains((IPlayable)bookmark, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                        Object[] options = new Object[]{"Yes, add another time", "No way!", "Replace existing entries with new one", "Cancel"};
                        int showConfirmDialog = JOptionPane.showOptionDialog(null, bookmark.getTitle() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)bookmark, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this bookmark another time?", -1, 3, null, options, options[0]);
                        if (1 == showConfirmDialog) {
                            add = false;
                            ++cntNotBookmark;
                        } else if (2 == showConfirmDialog) {
                            List entries = this.ps.getDefaultPlaylist(Scenerixx.unlocked).getEntries(Scenerixx.unlocked);
                            ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
                            for (PlaylistEntry pe6 : entries) {
                                if (!pe6.getNameOfPlayable().equals(bookmark.getNameOfPlayable())) continue;
                                LOG.info("delete " + bookmark.getNameOfPlayable());
                                tmpList.add(pe6);
                            }
                            for (PlaylistEntry pe6 : tmpList) {
                                this.ps.deletePlaylistEntry(pe6, true);
                            }
                            add = true;
                        } else if (3 == showConfirmDialog || -1 == showConfirmDialog) {
                            return;
                        }
                    }
                    if (add) {
                        entry.setBookmark(bookmark);
                        this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                        ++cntBookmark;
                    }
                }
            }
            if ((mediumFile = (MediumFile)n.getValue("mediumFile")) != null) {
                int positionInPlaylist;
                boolean add = true;
                Movie movieToCheck = mediumFile.getMovie();
                if (movieToCheck == null) {
                    movieToCheck = new Movie();
                }
                if ((positionInPlaylist = this.ps.getPositionInPlaylist((IPlayablePlaylistItems)mediumFile, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) == -1) {
                    positionInPlaylist = this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movieToCheck, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked);
                }
                if (this.ps.contains((IPlayable)mediumFile, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked) || this.ps.contains((IPlayable)movieToCheck, this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                    int showConfirmDialog = JOptionPane.showConfirmDialog(null, mediumFile.getNameOfPlayable() + " is already on the playlist at position " + positionInPlaylist + ". Add anyway?", "Do you really want to add this medium file another time?", 1);
                    if (1 == showConfirmDialog) {
                        add = false;
                        ++cntNotMediumFile;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (add) {
                    if (mediumFile.getMovie() != null) {
                        LOG.info("Added movie from medium file: " + String.valueOf(mediumFile.getMovie()));
                        entry.setMovie(mediumFile.getMovie());
                    } else {
                        entry.setMediumFile(mediumFile);
                        LOG.info("Added medium file: " + mediumFile.getFileName());
                    }
                    this.ps.addPlaylistEntry(entry, Scenerixx.unlocked);
                    ++cntMediumFile;
                }
            }
            msg = "";
            if (cntPerson + cntStudio + cntStudioMovie + cntMovie + cntScene + cntBookmark + cntBookmark + cntMediumFile > 0) {
                if (cntPerson > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntPerson, " person") + " - ";
                }
                if (cntMovie > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntMovie, " movie") + " - ";
                }
                if (cntStudio > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntStudio, " studio") + " - ";
                }
                if (cntStudioMovie > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntStudioMovie, " movie") + " (from studios) - ";
                }
                if (cntScene > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntScene, " scene") + " - ";
                }
                if (cntBookmark > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntBookmark, " bookmark") + " - ";
                }
                if (cntMediumFile > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntMediumFile, " mediumfile") + " - ";
                }
            }
            if (cntStudioNotMovie + cntNotStudio + cntNotMovie + cntNotScene + cntNotBookmark + cntNotBookmark + cntNotMediumFile <= 0) continue;
            msg = (String)msg + "Not added because they are already on the playlist: ";
            if (cntNotPerson > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntNotMovie, " person") + " - ";
            }
            if (cntNotMovie > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntNotMovie, " movie") + " - ";
            }
            if (cntNotStudio > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntNotStudio, " studio") + " - ";
            }
            if (cntStudioNotMovie > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntStudioNotMovie, " movie") + " (from studios) - ";
            }
            if (cntNotScene > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntNotScene, " scene") + " - ";
            }
            if (cntNotBookmark > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntNotBookmark, " bookmark") + " - ";
            }
            if (cntNotMediumFile <= 0) continue;
            msg = (String)msg + ScenerixxCommon.singularPlural(cntNotMediumFile, " mediumfile") + " - ";
        }
        if (((String)msg).length() > 3) {
            if (((String)(msg = ((String)msg).substring(0, ((String)msg).length() - " - ".length()))).toLowerCase().startsWith("not added")) {
                AbstractTopComponent.notifyInfo((String)msg);
            } else {
                AbstractTopComponent.notifyInfo("Added '" + (String)msg + "' to the default playlist");
            }
        }
    }

    public static <K, V> SortedMap<K, V> getTreeMapFirstEntries(SortedMap<K, V> sortedMap, int elementsToReturn) {
        return sortedMap.entrySet().stream().limit(elementsToReturn).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, TreeMap::new));
    }

    public static <K, V> SortedMap<K, V> getTreeMapLastEntries(TreeMap<K, V> sortedMap, int elementsToReturn) {
        return sortedMap.descendingMap().entrySet().stream().limit(elementsToReturn).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, TreeMap::new));
    }

    public Playlist correctPositions(Playlist playlist) {
        int i;
        if (playlist.isHistoryPlaylist()) {
            LOG.info("passed playlist was the history playlist. Do NOT correct the positions.");
            return playlist;
        }
        int startIndex = -1;
        boolean save = false;
        if (playlist.getId() != null) {
            playlist = (Playlist)this.db.getEntityService().load(Playlist.class, playlist.getId().longValue());
            save = true;
        }
        LOG.info("Correct positions in playlist " + playlist.getName() + " - " + playlist.getEntries(Scenerixx.unlocked).size() + " entries");
        for (i = 0; i < playlist.getEntries(Scenerixx.unlocked).size() - 1; ++i) {
            if (((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i + 1)).getPositionInList() - ((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i)).getPositionInList() == 1) continue;
            LOG.info("correction needed for " + ((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i + 1)).getPositionInList() + " - " + ((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i)).getPositionInList());
            startIndex = i;
            break;
        }
        if (startIndex != -1) {
            LOG.info("Start correction at index " + startIndex);
            for (i = startIndex; i < playlist.getEntries(Scenerixx.unlocked).size(); ++i) {
                ((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i)).setPos(i);
                if (save) {
                    this.db.getEntityService().save((AbstractEntity)((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i)));
                }
                LOG.info(i + " - " + playlist.getName() + "- " + ((PlaylistEntry)playlist.getEntries(Scenerixx.unlocked).get(i)).getPos());
            }
            if (save) {
                playlist = (Playlist)this.db.getEntityService().save((AbstractEntity)playlist);
            }
        }
        return playlist;
    }

    public void fillPlaylistEntry(IPlayablePlaylistItems p, Playlist playlist) {
        PlaylistEntry playlistEntry = new PlaylistEntry();
        if (p instanceof Medium) {
            playlistEntry.setMediumFile((MediumFile)p);
        }
        if (p instanceof Movie) {
            Movie movie = (Movie)p;
            playlistEntry.setMovie(movie);
        }
        if (p instanceof Scene) {
            Scene scene = (Scene)p;
            playlistEntry.setScene(scene);
        }
        if (p instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)p;
            playlistEntry.setBookmark(bookmark);
        }
        if (p instanceof Studio) {
            Studio studio = (Studio)p;
            LOG.info("It's a studio");
            for (Movie m : studio.getMovies(Scenerixx.unlocked)) {
                PlaylistEntry studioPlaylistEntry = new PlaylistEntry();
                studioPlaylistEntry.setMovie(m);
                playlist.getEntries(Scenerixx.unlocked).add(playlistEntry);
            }
        }
        if (p instanceof Person) {
            Person person = (Person)p;
            LOG.finer("It's a person");
            for (Scene s : person.getScenes(Scenerixx.unlocked)) {
                PlaylistEntry personPlaylistEntry = new PlaylistEntry();
                personPlaylistEntry.setScene(s);
                playlist.getEntries(Scenerixx.unlocked).add(playlistEntry);
            }
        } else {
            LOG.finer("It's something else");
            playlist.getEntries(Scenerixx.unlocked).add(playlistEntry);
        }
    }

    public void askToAddDuplicatePerson(Person p, Scene s) {
        int addDuplicate = JOptionPane.showInternalConfirmDialog(null, "<html>" + p.getName() + " is already added. Add again?<br><br>Usually you don't want to add a person twice. But in some cases this might make sense.<br>E.g. if you have two unknown persons or if person acts in two different roles.<br><br>Add anyway?</html>", "Add as a dulicate??", 0, 1);
        if (addDuplicate == 0) {
            this.db.addPersonToScene(p, s, true);
        }
    }

    public static DatePickerSettings getDatePickerSettings() {
        DatePickerSettings settings = new DatePickerSettings();
        settings.setColor(DatePickerSettings.DateArea.TextClearLabel, Color.red);
        settings.setColor(DatePickerSettings.DateArea.TextTodayLabel, Color.blue);
        settings.setColor(DatePickerSettings.DateArea.TextMonthAndYearMenuLabels, Color.blue);
        settings.setColor(DatePickerSettings.DateArea.BackgroundCalendarPanelLabelsOnHover, Color.white);
        settings.setColor(DatePickerSettings.DateArea.TextCalendarPanelLabelsOnHover, Color.black);
        return settings;
    }

    public static void websiteAvailable(JTextField tf, JButton button) {
        if (tf.getText().trim().toLowerCase().startsWith("www") || tf.getText().trim().toLowerCase().startsWith("http")) {
            button.setEnabled(true);
        } else {
            button.setEnabled(false);
        }
    }

    public static boolean downloadMasterDB(boolean skipCheck) {
        if (skipCheck) {
            return ScenerixxCommon.downloadMasterDB();
        }
        LOG.info("path: " + ScenerixxLib.MASTER_DB_DOWNLOAD_PATH + File.separator + "datadb.zip");
        long lastModified = new File(ScenerixxLib.MASTER_DB_DOWNLOAD_PATH + File.separator + "datadb.zip").lastModified();
        Date currentDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(10, -24);
        Date alertDate = cal.getTime();
        LOG.info("lastModified long: " + lastModified);
        Date lastModifiedDate = new Date(lastModified);
        LOG.info("lastModified: " + String.valueOf(lastModifiedDate) + " - " + String.valueOf(alertDate));
        if (lastModifiedDate.after(alertDate)) {
            LOG.info("Master database is not even 24 hours old. Skip download.");
            return true;
        }
        LOG.info("Master database is older than 24 hours. Try to download master database.");
        return ScenerixxCommon.downloadMasterDB();
    }

    private static boolean downloadMasterDB() {
        LOG.info("Try to download master db");
        boolean result = false;
        String downloadDestDir = ScenerixxLib.MASTER_DB_DOWNLOAD_PATH;
        if (!new File(downloadDestDir).exists()) {
            new File(downloadDestDir).mkdirs();
            LOG.info("download directory created");
        }
        LOG.info("path to save download: " + downloadDestDir);
        try {
            String masterDbZipFile = "datadb.zip";
            File destFile = new File(downloadDestDir + File.separator + masterDbZipFile);
            if (destFile.exists()) {
                LOG.severe("File already exists: " + downloadDestDir + File.separator + masterDbZipFile + " - Delete file.");
                destFile.delete();
            }
            if (Downloader.downloadWithUserAgent((String)ScenerixxLib.DATA_DB_DOWNLOAD_URL, (String)(downloadDestDir + File.separator + masterDbZipFile))) {
                LOG.info("Download was successful. Unzip now.");
                UnzipUtil unzip = new UnzipUtil();
                unzip.unzip(downloadDestDir + File.separator + masterDbZipFile, downloadDestDir);
                LOG.info("Unzipped to '" + downloadDestDir + "'");
                result = true;
            } else {
                LOG.severe("Download of master DB failed");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public void markAsFavorite(Node[] activatedNodes, boolean favorite) {
        int cntMovie = 0;
        int cntScene = 0;
        int cntBookmark = 0;
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") != null && (object = n.getValue("movie")) instanceof Movie) {
                Movie mov = (Movie)object;
                this.db.getEntityService().load(Movie.class, mov.getId().longValue());
                mov.setFavorite(favorite);
                this.db.getEntityService().save((AbstractEntity)mov);
                ++cntMovie;
            }
            if (n.getValue("scene") != null && (object = n.getValue("scene")) instanceof Scene) {
                Scene scene = (Scene)object;
                this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                scene.setFavorite(favorite);
                this.db.getEntityService().save((AbstractEntity)scene);
                ++cntScene;
            }
            if (n.getValue("bookmark") == null || !((object = n.getValue("bookmark")) instanceof Bookmark)) continue;
            Bookmark bookmark = (Bookmark)object;
            this.db.getEntityService().load(Bookmark.class, bookmark.getId().longValue());
            bookmark.setFavorite(favorite);
            this.db.getEntityService().save((AbstractEntity)bookmark);
            ++cntBookmark;
        }
        if (cntScene + cntBookmark + cntMovie > 0) {
            if (favorite) {
                AbstractTopComponent.notifyInfo("We marked the selected nodes as favorites");
            } else {
                AbstractTopComponent.notifyInfo("We unmarked the selected nodes as favorites");
            }
            AbstractTopComponent.dirtyMovieList();
            SwingUtilities.invokeLater(() -> {
                TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (details != null) {
                    ((DetailsTopComponent)details).reload();
                }
            });
        }
    }

    public static int imageDownload(String performerName, String basePath) {
        File path;
        int i = 0;
        int deleted = 0;
        int skipped = 0;
        if (!((String)basePath).endsWith(File.separator)) {
            basePath = (String)basePath + File.separator;
        }
        if (!(path = new File((String)(basePath = (String)basePath + performerName + File.separator))).exists()) {
            path.mkdirs();
        }
        performerName = performerName.replaceAll(" ", "+");
        try {
            String url = "https://search.brave.com/images?q=" + performerName + "+nude&source=web";
            LOG.info("url: " + url);
            URL brave = new URL(url);
            URLConnection yc = brave.openConnection();
            yc.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
            try (BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));){
                String inputLine;
                Object json = "";
                LOG.info("start reading");
                while ((inputLine = in.readLine()) != null) {
                    LOG.finer(inputLine);
                    json = (String)json + inputLine;
                }
                LOG.finer("XXX----------------------");
                String thumbnailsrc = "thumbnail:{src:\"https";
                Object imgUrl = "";
                while (((String)json).contains("thumbnail:{src:\"https")) {
                    LOG.finer("json size: " + ((String)json).length());
                    LOG.finer("thumbn " + ((String)json).indexOf("thumbnail:{src:\"https"));
                    LOG.finer("\": " + ((String)json).indexOf("\""));
                    json = ((String)json).substring(((String)json).indexOf("thumbnail:{src:\"https") + "thumbnail:{src:\"https".length());
                    imgUrl = "https" + ((String)json).substring(0, ((String)json).indexOf("\""));
                    LOG.finer("imgUrl: " + (String)imgUrl);
                    json = ((String)json).substring(((String)json).indexOf("\"") + 1, ((String)json).length());
                    try (InputStream in2 = new URL((String)imgUrl).openStream();){
                        if (Paths.get((String)basePath + i + ".jpg", new String[0]).toFile().exists()) {
                            LOG.fine((String)basePath + i + ".jpg already exists. Skip.");
                            ++skipped;
                        } else {
                            Files.copy(in2, Paths.get((String)basePath + i + ".jpg", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            File file = new File((String)basePath + i + ".jpg");
                            if (file.length() < 10000L) {
                                file.delete();
                                ++deleted;
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return i - deleted - skipped;
    }

    public static void setSelectedNodesInTitle(int selectedNodesLength) {
        ScenerixxCommon.setSelectedNodesInTitle(selectedNodesLength, "");
    }

    public static void setSelectedNodesInTitle(int selectedNodesLength, String type) {
        LOG.info("selected nodes: " + selectedNodesLength);
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            JFrame mainFrame = (JFrame)WindowManager.getDefault().getMainWindow();
            String title = "Scenerixx ~ " + Scenerixx.VERSION + " ~ " + Scenerixx.CODENAME;
            title = Scenerixx.unlocked ? title + " - Session is unlocked " : title + " - Session is locked ";
            LOG.info("title: " + title);
            if (selectedNodesLength > 1) {
                title = title + " | " + selectedNodesLength + " selected " + type + " nodes";
            }
            mainFrame.setTitle(title);
        });
    }

    public void openVlc(Node[] activatedNodes) {
        Playlist tmpPlaylist = new Playlist();
        for (Node n : activatedNodes) {
            Bookmark bookmark = (Bookmark)n.getValue("bookmark");
            Scene scene = (Scene)n.getValue("scene");
            Movie movie = (Movie)n.getValue("movie");
            PlaylistEntry pe = new PlaylistEntry();
            if (bookmark != null) {
                pe.setBookmark(bookmark);
                tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                continue;
            }
            if (movie != null) {
                pe.setMovie(movie);
                tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                continue;
            }
            if (scene == null) continue;
            pe.setScene(scene);
            tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
        }
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).openVlc(tmpPlaylist, true, false);
            }
        });
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        SOLARIS;

    }
}

