/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.studio.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ImportStudioAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ImportStudioAction.class.getName());
    private final DB db = DB.getInstance();

    public ImportStudioAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Download.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int imported = 0;
        Object importedStudios = "";
        boolean reload = false;
        for (Node n : activatedNodes) {
            Studio s;
            if (n.getValue("studio") == null || !(n.getValue("studio") instanceof Studio) || (s = (Studio)n.getValue("studio")) == null) continue;
            try {
                String studioName = s.getName();
                if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)studioName)).count() > 0L) {
                    AbstractTopComponent.notifyError("There is already a studio with the name " + studioName + ". I cannot handle this. Either delete the studio person or rename the studio to import.");
                    continue;
                }
                if (s.getParent() != null) {
                    String parentName = s.getParent().getName();
                    LOG.info("parent: " + parentName);
                    if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)parentName)).count() > 0L) {
                        LOG.info("Set existing parent");
                        s.setParent((Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)parentName)).findFirst());
                    } else {
                        LOG.info("persist parent first");
                        s.setParent((Studio)this.db.getEntityService().save((AbstractEntity)s.getParent()));
                        importedStudios = (String)importedStudios + parentName + ",  ";
                        ++imported;
                    }
                }
                LOG.info("persist studio " + s.getName());
                s = (Studio)this.db.getEntityService().save((AbstractEntity)s);
                ++imported;
                reload = true;
                importedStudios = (String)importedStudios + studioName + ",  ";
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
        if (reload) {
            AbstractTopComponent.reloadStudioList();
            importedStudios = ((String)importedStudios).substring(0, ((String)importedStudios).lastIndexOf(","));
            AbstractTopComponent.notifyInfo(ScenerixxCommon.singularPlural(imported, "studio", true) + " have been imported: " + (String)importedStudios);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Import studio(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

