/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.comparator.MovieComparator;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Resolution;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.CallableMovieChildFactory;

public class ResolutionWidthChildFactory
extends ChildFactory<Resolution> {
    public static final Logger LOG = Logger.getLogger(ResolutionWidthChildFactory.class.getName());
    private List<Resolution> resolutionList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;
    private Map<Resolution, List<Movie>> moviesByResolution;
    private long totalPeople = 0L;

    public ResolutionWidthChildFactory(List<Resolution> resolutionList, String searchTerm) {
        this.resolutionList = resolutionList;
        this.gender = this.gender;
        this.showCounter = this.showCounter;
        this.showBirthyear = this.showBirthyear;
        this.showRating = this.showRating;
        this.showLikeCounter = this.showLikeCounter;
        this.showRuntime = this.showRuntime;
        this.showSecret = this.showSecret;
        this.showPosition = this.showPosition;
        this.moviesByResolution = this.db.getMoviesByResolution(searchTerm);
        LOG.info("resolutions: " + this.moviesByResolution.keySet().size());
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in ResolutionWidthChildFactory");
    }

    protected boolean createKeys(List<Resolution> list) {
        list.addAll(this.resolutionList);
        return true;
    }

    protected Node createNodeForKey(Resolution resolution) {
        LOG.info("create new node for resolution width: " + resolution.toString());
        List<Movie> movieList = null;
        for (Resolution r : this.moviesByResolution.keySet()) {
            if (r.getWidth().intValue() != resolution.getWidth().intValue()) continue;
            LOG.info("current width: " + r.getWidth());
            if (movieList == null) {
                movieList = this.moviesByResolution.get(r);
                continue;
            }
            movieList.addAll((Collection<Movie>)this.moviesByResolution.get(r));
        }
        if (movieList == null) {
            LOG.info("no movies for resolution " + String.valueOf(resolution));
            return null;
        }
        LOG.info("get: " + movieList.size());
        Collections.sort(movieList, new MovieComparator());
        Children createLazy = Children.createLazy((Callable)new CallableMovieChildFactory(movieList, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition, false));
        AbstractNode result = new AbstractNode(this, createLazy){

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons.silk/arrow_right.png", (boolean)false);
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        result.setDisplayName(resolution.getWidth() + "... x " + resolution.getHeight() + " [" + movieList.size() + "]");
        result.setValue("resolution", (Object)resolution);
        result.setName(resolution.toString());
        return result;
    }
}

