/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.SceneChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class RemindsMeOfChildFactory
extends ChildFactory<Person> {
    public static final Logger LOG = Logger.getLogger(RemindsMeOfChildFactory.class.getName());
    private final List<Person> persons;
    private final DB db = DB.getInstance();
    private final boolean showNoOfApperance = true;
    private boolean showCounter = false;
    private boolean showLikeCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showRuntime = false;
    private boolean showSceneRating = false;
    final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();

    public RemindsMeOfChildFactory(List<Person> persons, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSceneRating) {
        this.persons = persons;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSceneRating = showSceneRating;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in RemindMeOfChildFactory");
    }

    protected boolean createKeys(List<Person> list) {
        list.addAll(this.persons);
        return true;
    }

    protected Node createNodeForKey(Person remindsMeOf) {
        LOG.finest("create new node for key. Person: " + String.valueOf(remindsMeOf));
        ArrayList tmpScenes = new ArrayList();
        tmpScenes.addAll(this.db.getScenesForRemindsMeOf(remindsMeOf, Scenerixx.unlocked));
        ArrayList<INode> scenesAsINode = new ArrayList<INode>();
        for (Scene s : tmpScenes) {
            scenesAsINode.add((INode)s);
        }
        final Person p = remindsMeOf;
        AbstractNode result = new AbstractNode(Children.create((ChildFactory)new SceneChildFactory(scenesAsINode, false, true, true, false, this.showCounter, this.showLikeCounter, this.showRuntime, this.showSceneRating, false), (boolean)true), Lookups.singleton((Object)remindsMeOf)){

            public Image getOpenedIcon(int type) {
                if (Gender.FEMALE.equals((Object)p.getGender())) {
                    if (p.isAlias()) {
                        return ImageUtilities.loadImage((String)"icons/femaleperson.png");
                    }
                    return ImageUtilities.loadImage((String)"icons/female.png");
                }
                if (Gender.MALE.equals((Object)p.getGender())) {
                    if (p.isAlias()) {
                        return ImageUtilities.loadImage((String)"icons/maleperson.png");
                    }
                    return ImageUtilities.loadImage((String)"icons/male.png");
                }
                return super.getOpenedIcon(type);
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }

            public Action[] getActions(boolean context) {
                return new Action[]{new CreatePlaylistAction()};
            }

            class CreatePlaylistAction
            extends AbstractAction {
                public CreatePlaylistAction() {
                    this.putValue("Name", "Create Playlist");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Person obj = (Person)this.getLookup().lookup(Person.class);
                    obj = (Person)RemindsMeOfChildFactory.this.db.getEntityService().load(Person.class, obj.getId().longValue());
                    PlaylistService ps = new PlaylistService();
                    Playlist playlist = new Playlist();
                    playlist.setName(obj.getName());
                    int dvds = 0;
                    for (Scene s : RemindsMeOfChildFactory.this.db.getScenes(obj, Scenerixx.unlocked)) {
                        if (RemindsMeOfChildFactory.this.db.getDvd(s.getMovie(), Scenerixx.unlocked) == null) {
                            PlaylistEntry pe = new PlaylistEntry();
                            pe.setDateOfCreation(LocalDateTime.now());
                            pe.setScene(s);
                            ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                            continue;
                        }
                        ++dvds;
                    }
                    TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                    if (playlistList != null) {
                        ((PlaylistTopComponent)playlistList).reloadList();
                    }
                    String message = "Created new playlist '" + playlist.getName() + "'";
                    if (dvds > 0) {
                        message = message + " (" + dvds + " DVDs have not been added)";
                    }
                    AbstractTopComponent.notifyInfo(message);
                }
            }
        };
        Object app = "";
        if (this.showBirthyear) {
            app = (String)app + " [";
            app = p.getBirthYear() != null ? (String)app + p.getBirthYear() : (String)app + "??";
            app = (String)app + "]";
        }
        if (this.showRating) {
            app = (String)app + " [";
            app = p.getRating() != null ? (String)app + p.getRating() : (String)app + "??";
            app = (String)app + "]";
        }
        app = (String)app + " [" + scenesAsINode.size() + "]";
        if (this.showRuntime) {
            app = (String)app + " [" + this.scenerixxCommon.calculateTotalRuntime(p) + "]";
        }
        result.setDisplayName(remindsMeOf.getName() + (String)app);
        result.setValue("person", (Object)p);
        result.setName(p.getName());
        return result;
    }
}

