/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.RendererUtil;

public class NationalityChildFactory
extends ChildFactory<Nationality> {
    public static final Logger LOG = Logger.getLogger(NationalityChildFactory.class.getName());
    private List<Nationality> nationalityList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;
    private long totalPeople = 0L;

    public NationalityChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition) {
        this.nationalityList = new ArrayList<Nationality>(Arrays.asList(Nationality.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in NationalityChildFactory");
    }

    protected boolean createKeys(List<Nationality> list) {
        for (Nationality nationality : this.nationalityList) {
            list.add(nationality);
        }
        return true;
    }

    protected Node createNodeForKey(final Nationality nationality) {
        LOG.info("create new node for Nationality: " + nationality.toString());
        List personsByNationality = null;
        personsByNationality = Nationality.NotSet.equals((Object)nationality) ? this.db.getPersonsWithoutNationality(this.gender, this.showSecret) : this.db.getPersonsByNationality(this.gender, nationality, this.showSecret);
        AbstractNode result = new AbstractNode(this, Children.create((ChildFactory)new PersonChildFactory(personsByNationality, this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                return RendererUtil.getFlagImage(nationality);
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        Long personsByNationalityCount = this.db.getPersonsByNationalityCount(this.gender, nationality, this.showSecret);
        String app = " [" + personsByNationalityCount + "]";
        result.setDisplayName(nationality.getTitle() + app);
        result.setValue("nationality", (Object)nationality);
        result.setName(nationality.getTitle());
        this.totalPeople += personsByNationalityCount.longValue();
        LOG.info("count persons by nationality: " + personsByNationalityCount);
        if (personsByNationalityCount > 0L) {
            return result;
        }
        return null;
    }

    public long getTotalPeople() {
        return this.totalPeople;
    }
}

