/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;

public class AppearanceChildFactory
extends ChildFactory<Appearance> {
    public static final Logger LOG = Logger.getLogger(AppearanceChildFactory.class.getName());
    private List<Appearance> appearanceList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;

    public AppearanceChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition) {
        this.appearanceList = new ArrayList<Appearance>(Arrays.asList(Appearance.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in BodyTypeChildFactory");
    }

    protected boolean createKeys(List<Appearance> list) {
        for (Appearance appearance : this.appearanceList) {
            list.add(appearance);
        }
        return true;
    }

    protected Node createNodeForKey(final Appearance appearance) {
        LOG.finest("create new node for Appearance: " + appearance.toString());
        List personsByAppearance = null;
        personsByAppearance = this.db.getPersonsByAppearance(this.gender, appearance, this.showSecret);
        AbstractNode result = new AbstractNode(this, Children.create((ChildFactory)new PersonChildFactory(personsByAppearance, this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                switch (appearance) {
                    case Amateur: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_patrick.png");
                    }
                    case Normal: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_squidward.png");
                    }
                    case GirlNextDoor: {
                        return ImageUtilities.loadImage((String)"icons.fugue/door-open.png");
                    }
                    case Authentic: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_sponge_bob.png");
                    }
                    case Arrogant: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_doubt.png");
                    }
                    case Sympathic: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_hand_flower.png");
                    }
                    case Cheeky: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_tongue.png");
                    }
                    case Fun: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_party.png");
                    }
                    case Natural: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/grass.png");
                    }
                    case Innocent: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_imprisoned_female.png");
                    }
                    case Sweet: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/lollipop.png");
                    }
                    case Shy: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_hidden.png");
                    }
                    case Sporty: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/sport.png");
                    }
                    case Model: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_girl.png");
                    }
                    case Classy: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_banker.png");
                    }
                    case Highclass: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_queen.png");
                    }
                    case Hot: {
                        return ImageUtilities.loadImage((String)"icons.fugue/fire-small.png");
                    }
                    case Exotic: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_nude_female_black.png");
                    }
                    case Slutty: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_blondy.png");
                    }
                    case Vamp: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_vampire.png");
                    }
                    case Bimbo: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_devil.png");
                    }
                    case RealBimbo: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_kiss.png");
                    }
                    case Trashy: {
                        return ImageUtilities.loadImage((String)"icons/Trash.png");
                    }
                    case Alternative: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_terminator.png");
                    }
                    case Goth: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_goth.png");
                    }
                    case Punk: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/emotion_punk.png");
                    }
                    case Unapproachable: {
                        return ImageUtilities.loadImage((String)"icons.fatcow/user_robocop.png");
                    }
                }
                return ImageUtilities.loadImage((String)"icons/Folder.png");
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        String app = " [" + this.db.getPersonsByAppearanceCount(this.gender, appearance, this.showSecret) + "]";
        result.setDisplayName(appearance.getTitle() + app);
        result.setValue("appearance", (Object)appearance);
        result.setName(appearance.getTitle());
        return result;
    }
}

