/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action;

import java.awt.Image;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class RemoveItemFromPlaylistAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(RemoveItemFromPlaylistAction.class.getName());
    private PlaylistService ps = new PlaylistService();

    public RemoveItemFromPlaylistAction() {
        Image image = ImageUtilities.loadImage((String)"icons/yellowbookmark.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        HashSet<Playlist> playlists = new HashSet<Playlist>();
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("entry") == null || !((object = n.getValue("entry")) instanceof PlaylistEntry)) continue;
            PlaylistEntry pe = (PlaylistEntry)object;
            this.ps.deletePlaylistEntry(pe, false, Scenerixx.unlocked);
            playlists.add(pe.getPlaylist());
        }
        LOG.info("correct now the position of " + playlists.size() + " playlists.");
        playlists.stream().forEach(playlist -> this.ps.correctAllPositions(playlist, Scenerixx.unlocked));
        LOG.info("Finished correcting positions.");
        AbstractTopComponent.reloadPlaylist();
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.info("activated nodes (Remove from playlist action) " + activatedNodes.length);
        return true;
    }

    public String getName() {
        return "Remove from playlist";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

