/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlist;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.PlaylistEntryChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.ArchiveAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.CopyPlaylistItemsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.DeletePlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.ExportToXspfAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.OpenInMoviesWindowAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.PlayPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.PlayPlaylistReverseAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.PlayRandomizedAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.ReloadAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.RenameAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.SecretAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.action.SetAsDefaultAction;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class PlaylistChildFactory
extends ChildFactory<Playlist> {
    public static final Logger LOG = Logger.getLogger(PlaylistChildFactory.class.getName());
    private final List<Playlist> resultList;
    private final DB db = DB.getInstance();
    private final PlaylistService ps = new PlaylistService();
    private boolean showPosition = false;
    private boolean showTimeAndEntries = false;
    private final DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public PlaylistChildFactory(List<Playlist> resultList, boolean showPosition) {
        this(resultList, showPosition, false);
    }

    public PlaylistChildFactory(List<Playlist> resultList, boolean showPosition, boolean showTimeAndEntries) {
        this.resultList = resultList;
        this.showPosition = showPosition;
        this.showTimeAndEntries = showTimeAndEntries;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in PlaylistChildFactory: " + String.valueOf(node));
    }

    protected boolean createKeys(List<Playlist> list) {
        int i = 1;
        for (Playlist p : this.resultList) {
            p.setPositionInList(i++);
            list.add(p);
            LOG.finest("Create keys. Playlist: " + p.getName());
        }
        return true;
    }

    protected Node createNodeForKey(Playlist p) {
        long start = System.currentTimeMillis();
        LOG.finest("create new node for key. Playlist: " + p.getName());
        PlaylistNode result = null;
        try {
            result = new PlaylistNode(p);
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not create playlist node. An error occured: " + ex.getMessage());
            return null;
        }
        Long runtime = 0L;
        if (this.showTimeAndEntries) {
            for (IPlayablePlaylistItems pl : p.getPlayables(Scenerixx.unlocked)) {
                IPlayable iPlayable;
                if (!(pl instanceof IPlayable) || (iPlayable = (IPlayable)pl).getTotalRuntime() <= 0) continue;
                runtime = runtime + (long)iPlayable.getTotalRuntime();
            }
        }
        String sRuntime = ScenerixxCommon.readableRuntime(runtime);
        Object displayName = "";
        if (p.isSecret()) {
            displayName = "[Secret] ";
        }
        displayName = (String)displayName + p.getName();
        if (this.showTimeAndEntries) {
            displayName = (String)displayName + " [Runtime: " + sRuntime + " | " + p.getEntries(Scenerixx.unlocked).size() + " entries]";
        }
        if (p.isDefaultPlaylist()) {
            displayName = (String)displayName + " [Default]";
        }
        if (this.showPosition) {
            displayName = p.getPositionInList() + ". " + (String)displayName;
        }
        result.setDisplayName((String)displayName);
        result.setValue("playlist", p);
        String dateOfCreation = "???";
        if (p.getDateOfCreation() != null) {
            dateOfCreation = this.df.format(p.getDateOfCreation());
        }
        String tooltip = p.getName() + " was created on " + dateOfCreation + " and currently contains " + p.getPlayables(Scenerixx.unlocked).size() + " entries";
        result.setShortDescription("<html>" + tooltip + "</html>");
        LOG.info("Node created for playlist " + p.getName() + " in " + (System.currentTimeMillis() - start) + " ms");
        return result;
    }

    public class PlaylistNode
    extends BeanNode {
        private Playlist playlist;

        public PlaylistNode(Playlist playlist) throws IntrospectionException {
            super((Object)playlist, playlist.getEntries(Scenerixx.unlocked).isEmpty() ? Children.LEAF : Children.create((ChildFactory)new PlaylistEntryChildFactory(playlist.getEntries(Scenerixx.unlocked), PlaylistChildFactory.this.showPosition){

                @Override
                public void reloadList(Node node) {
                    super.reloadList(node);
                    LOG.fine("Reload playlist from PlayableChildFactory");
                    PlaylistChildFactory.this.reloadList(node);
                }
            }, (boolean)false), Lookups.singleton((Object)playlist));
            this.playlist = playlist;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Image getIcon(int type) {
            if (this.playlist.isDefaultPlaylist()) {
                return ImageUtilities.loadImage((String)"icons/favourites.png");
            }
            if (this.playlist.isHistoryPlaylist()) {
                return ImageUtilities.loadImage((String)"icons/History.png");
            }
            if (this.playlist.isSecretHistoryPlaylist()) {
                return ImageUtilities.loadImage((String)"icons/Alarm.png");
            }
            if (this.playlist.isSecret()) {
                return ImageUtilities.loadImage((String)"icons/Lock.png");
            }
            if (this.playlist.isTemporaryPlaylist()) {
                return ImageUtilities.loadImage((String)"icons.fatcow/recycle.png");
            }
            if (this.playlist.isArchived()) {
                return ImageUtilities.loadImage((String)"icons.fatcow/bookshelf.png");
            }
            return ImageUtilities.loadImage((String)"icons/notes.png");
        }

        public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    Node[] nodes;
                    for (Node node : nodes = NodeTransfer.nodes((Transferable)t, (int)action)) {
                        PlaylistEntry pe;
                        Object target;
                        Object source;
                        if (node instanceof PlaylistNode) {
                            LOG.info("A playlist node was pasted");
                            source = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, ((Playlist)node.getValue("playlist")).getId().longValue());
                            Playlist target2 = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, ((Playlist)PlaylistNode.this.getValue("playlist")).getId().longValue());
                            LOG.info("playlist '" + source.getName() + "' pasted to playlist '" + target2.getName() + "'");
                            if (action == 1) {
                                if (JOptionPane.showConfirmDialog(null, "Should we copy the playlist '" + source.getName() + "' into '" + target2.getName() + "'?", "Copy?", 0) == 0) {
                                    PlaylistChildFactory.this.ps.copyPlaylist((Playlist)source, target2, Scenerixx.unlocked);
                                }
                                PlaylistChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                                continue;
                            }
                            if (JOptionPane.showConfirmDialog(null, "Should we merge the playlist '" + source.getName() + "' into '" + target2.getName() + "'?", "Merge?", 0) != 0) continue;
                            PlaylistChildFactory.this.ps.mergePlaylist((Playlist)source, target2, Scenerixx.unlocked);
                            LOG.info("playlistnode: " + String.valueOf((Object)PlaylistNode.this));
                            PlaylistChildFactory.this.reloadList((Node)PlaylistNode.this);
                            continue;
                        }
                        if (node.getValue("movie") != null && (source = node.getValue("movie")) instanceof Movie) {
                            Movie m = (Movie)source;
                            LOG.info("A movie node was pasted");
                            target = (Playlist)PlaylistNode.this.getValue("playlist");
                            target = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, target.getId().longValue());
                            pe = new PlaylistEntry();
                            pe.setMovie(m);
                            pe.setPlaylist((Playlist)target);
                            target = PlaylistChildFactory.this.ps.addPlaylistEntry(pe, (Playlist)target, Scenerixx.unlocked);
                            PlaylistChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            continue;
                        }
                        if (node.getValue("scene") != null && (target = node.getValue("scene")) instanceof Scene) {
                            Scene s = (Scene)target;
                            LOG.info("A scene node was pasted");
                            target = (Playlist)PlaylistNode.this.getValue("playlist");
                            target = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, target.getId().longValue());
                            pe = new PlaylistEntry();
                            pe.setScene(s);
                            pe.setPlaylist((Playlist)target);
                            target = PlaylistChildFactory.this.ps.addPlaylistEntry(pe, (Playlist)target, Scenerixx.unlocked);
                            PlaylistChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            continue;
                        }
                        if (node.getValue("bookmark") != null && (target = node.getValue("bookmark")) instanceof Bookmark) {
                            Bookmark b = (Bookmark)target;
                            LOG.info("A bookmark node was pasted");
                            target = (Playlist)PlaylistNode.this.getValue("playlist");
                            target = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, target.getId().longValue());
                            pe = new PlaylistEntry();
                            pe.setBookmark(b);
                            pe.setPlaylist((Playlist)target);
                            target = PlaylistChildFactory.this.ps.addPlaylistEntry(pe, (Playlist)target, Scenerixx.unlocked);
                            PlaylistChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            continue;
                        }
                        if (node.getValue("entry") != null && (target = node.getValue("entry")) instanceof PlaylistEntry) {
                            PlaylistEntry pe2 = (PlaylistEntry)target;
                            LOG.info("A playlist entry node was pasted");
                            target = (Playlist)PlaylistNode.this.getValue("playlist");
                            target = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, target.getId().longValue());
                            if (action == 1) {
                                LOG.info("Copy playlist entry");
                                PlaylistChildFactory.this.ps.copyPlaylistEntry(pe2, (Playlist)target, Scenerixx.unlocked);
                            } else {
                                LOG.info("Move playlist entry... target size: " + target.getEntries(Scenerixx.unlocked).size());
                                Long sourcePlaylistId = pe2.getPlaylist().getId();
                                PlaylistChildFactory.this.ps.movePlaylistEntry(pe2, (Playlist)target, Scenerixx.unlocked);
                                PlaylistChildFactory.this.db.evictCache();
                                if (sourcePlaylistId == null) {
                                    LOG.info("entry comes from a temp. playlist. Do not correct positions, rather remove manually");
                                    AbstractTopComponent.removeFromClipboard((IPlayablePlaylistItems)pe2);
                                } else {
                                    new PlaylistService().correctAllPositions((Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, sourcePlaylistId.longValue()), Scenerixx.unlocked);
                                }
                                target = (Playlist)PlaylistChildFactory.this.db.getEntityService().load(Playlist.class, target.getId().longValue());
                                PlaylistNode.this.setValue("playlist", target);
                            }
                            PlaylistChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            continue;
                        }
                        LOG.fine("Something pasted to a playlist but not a playlist: " + node.getDisplayName());
                    }
                    PlaylistChildFactory.this.refresh(true);
                    return null;
                }
            };
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return this.createPasteType(t, action, (AbstractNode)this);
        }

        public Action[] getActions(boolean context) {
            ArrayList<SystemAction> list = new ArrayList<SystemAction>();
            list.add(SystemAction.get(PlayPlaylistAction.class));
            list.add(SystemAction.get(PlayPlaylistReverseAction.class));
            list.add(SystemAction.get(PlayRandomizedAction.class));
            list.add(null);
            Playlist playlist = (Playlist)this.getLookup().lookup(Playlist.class);
            list.add(SystemAction.get(SetAsDefaultAction.class));
            list.add(SystemAction.get(SecretAction.class));
            list.add(SystemAction.get(ArchiveAction.class));
            list.add(SystemAction.get(RenameAction.class));
            list.add(SystemAction.get(CopyPlaylistItemsAction.class));
            list.add(SystemAction.get(ExportToXspfAction.class));
            list.add(null);
            list.add(SystemAction.get(OpenInMoviesWindowAction.class));
            list.add(SystemAction.get(ReloadAction.class));
            list.add(null);
            list.add(SystemAction.get(DeletePlaylistAction.class));
            Action[] actions = new Action[list.size()];
            actions = list.toArray(actions);
            return actions;
        }

        public Action getPreferredAction() {
            LOG.fine("expand playlist node");
            return null;
        }
    }
}

