/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person.action;

import java.awt.Image;
import java.time.LocalDateTime;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class CreatePlaylistAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public CreatePlaylistAction() {
        Image image = ImageUtilities.loadImage((String)"icons/notes.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0].getValue("person") != null && activatedNodes[0].getValue("person") instanceof Person) {
            Person person = (Person)activatedNodes[0].getValue("person");
            person = (Person)this.db.getEntityService().load(Person.class, person.getId().longValue());
            PlaylistService ps = new PlaylistService();
            Playlist playlist = new Playlist();
            playlist.setName(person.getName());
            playlist = (Playlist)this.db.getEntityService().save((AbstractEntity)playlist);
            int dvds = 0;
            for (Scene s : this.db.getScenes(person, Scenerixx.unlocked)) {
                if (this.db.getDvd(s.getMovie(), Scenerixx.unlocked) == null) {
                    PlaylistEntry pe = new PlaylistEntry();
                    pe.setDateOfCreation(LocalDateTime.now());
                    pe.setScene(s);
                    playlist = ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                    continue;
                }
                ++dvds;
            }
            TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlistList != null) {
                ((PlaylistTopComponent)playlistList).reloadList(playlist.getName());
            }
            String message = "Created new playlist '" + playlist.getName() + "'";
            if (dvds > 0) {
                message = message + " (" + dvds + " DVDs have not been added)";
            }
            AbstractTopComponent.notifyInfo(message);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Create playlist";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

