/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.StudioSelectionPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class SetStudioAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(SetStudioAction.class.getName());
    private DB db = DB.getInstance();

    public SetStudioAction() {
        Image image = ImageUtilities.loadImage((String)"icons/home.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        final StudioSelectionPanel panel = new StudioSelectionPanel();
        JOptionPane op = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                panel.getComboStudio();
            }
        };
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
            ++selectedMovies;
        }
        JDialog dlg = op.createDialog("Set studio for " + selectedMovies + " movies");
        dlg.setVisible(true);
        dlg.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                panel.gainedFocus();
            }
        });
        if (op.getValue() != null && op.getValue().equals(0)) {
            int cntMovies = 0;
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
                Movie m = (Movie)n.getValue("movie");
                LOG.fine(m.getTitle() + " - Current studio: " + String.valueOf(m.getStudio()) + " - Will be set to " + panel.getStudio().getName());
                if (panel.getStudio().getName().equalsIgnoreCase("??")) {
                    m.setStudio(null);
                } else {
                    m.setStudio(panel.getStudio());
                }
                this.db.getEntityService().save((AbstractEntity)m);
                ++cntMovies;
            }
            AbstractTopComponent.notifyInfo("Set the studio of " + cntMovies + " movies to '" + panel.getStudio().getName() + "'");
            AbstractTopComponent.dirtyStudiolist();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Set Studio";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

