/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class PrefixTitleAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(PrefixTitleAction.class.getName());
    private DB db = DB.getInstance();

    public PrefixTitleAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/style_go.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
            ++selectedMovies;
        }
        String prefix = JOptionPane.showInputDialog(null, "Remember to use some space at the end (if wanted)", "Prefix movie title for " + selectedMovies + " movies", 3);
        if (prefix != null) {
            int cntMovies = 0;
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
                Movie m = (Movie)n.getValue("movie");
                LOG.fine("Current title: " + m.getTitle() + " - Will be set to " + prefix + m.getTitle());
                m.setTitle(prefix + m.getTitle());
                this.db.getEntityService().save((AbstractEntity)m);
                ++cntMovies;
            }
            AbstractTopComponent.notifyInfo("Prefixed " + cntMovies + " movies with '" + prefix + "'");
            AbstractTopComponent.reloadMovieList(true);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Prefix movie title";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

