/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.settings.NoDuplicate;
import xxx.scenerixx.scenerixxlib.model.settings.QNoDuplicate;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class MarkAsNoDuplicateAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(MarkAsNoDuplicateAction.class.getName());
    private static boolean hintShown = false;

    public MarkAsNoDuplicateAction() {
        Image image = ImageUtilities.loadImage((String)"icons.silk/pictures.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        DB db = DB.getInstance();
        int showInternalConfirmDialog = 1;
        if (!hintShown) {
            showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Should we mark those two movies as 'no duplicate'?<br><br>If two movies are marked as duplicates the 'Find Duplicates' functionality will never consider those two movies as duplicates.<br>This can be useful if you want to keep both versions, e.g. because they have a different audio track or subtitles.<br>HINT: no check is performed if this could be really a duplicate or not. Therefore you could also mark a 20 second clip and a 5 hour movie as duplicate.<br>HINT 2: This message won't be shown again in this session</html>", "No duplicate?", 0, 1);
        }
        if (showInternalConfirmDialog == 0 || hintShown) {
            hintShown = true;
            int permutationCnt = 0;
            for (int i = 0; i < activatedNodes.length - 1; ++i) {
                Long outerId = ((Movie)activatedNodes[i].getValue("movie")).getId();
                LOG.info("i: " + i + " - " + outerId);
                for (int j = i + 1; j < activatedNodes.length; ++j) {
                    Long innerId = ((Movie)activatedNodes[j].getValue("movie")).getId();
                    LOG.info("j: " + j + " - " + innerId + " : " + outerId);
                    NoDuplicate findFirst = (NoDuplicate)db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)outerId)).filter(f -> f.movieIdOther.eq((Object)innerId)).findFirst();
                    NoDuplicate findOther = (NoDuplicate)db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)innerId)).filter(f -> f.movieIdOther.eq((Object)outerId)).findFirst();
                    if (findFirst != null || findOther != null) {
                        LOG.info("Movies (" + outerId + ":" + innerId + ") were already marked as 'no duplicate'.");
                    }
                    NoDuplicate noDuplicate = new NoDuplicate(outerId, innerId);
                    db.getEntityService().save((AbstractEntity)noDuplicate);
                    ++permutationCnt;
                }
                LOG.info("---");
            }
            AbstractTopComponent.notifyInfo("Added " + permutationCnt + " 'no duplicate' pairs.");
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("Check if MarkAsNoDuplicateAction is enabled");
        boolean enable = false;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) {
                LOG.fine("Only movie nodes are allowed.");
                enable = false;
                break;
            }
            LOG.finer("it's a movie");
            enable = true;
            if (activatedNodes.length != 1) continue;
            enable = false;
        }
        return enable;
    }

    public String getName() {
        return "Mark as 'No Duplicate'";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

