/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.AskLevelPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ExportMovieToPublicFileAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public ExportMovieToPublicFileAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/xml_exports.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        Exporter exp = new Exporter();
        if (activatedNodes[0].getValue("movie") != null && activatedNodes[0].getValue("movie") instanceof Movie) {
            Movie movie = (Movie)activatedNodes[0].getValue("movie");
            movie = (Movie)this.db.getEntityService().load(Movie.class, movie.getId().longValue());
            boolean hashValuesSet = true;
            for (MediumFile mf : this.db.getMediumFiles(movie, true)) {
                if (mf.getHashValue() != null) continue;
                hashValuesSet = false;
            }
            if (hashValuesSet) {
                final AskLevelPanel pAlp = new AskLevelPanel();
                JOptionPane op = new JOptionPane(pAlp, 3, 2);
                JDialog dlg = op.createDialog("Please provide the information how detailed the data is that you'll export");
                dlg.setVisible(true);
                dlg.addWindowFocusListener(new WindowAdapter(this){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        pAlp.gainedFocus();
                    }
                });
                if (op.getValue() != null && op.getValue().equals(0)) {
                    int overwrite;
                    String exportMovieToFile = "";
                    String destinationFileName = Scenerixx.getPathToMovieExport(movie, pAlp.getLevel()) + "/" + exp.getDestinationFileName(movie);
                    if (new File(destinationFileName).exists() && (overwrite = JOptionPane.showConfirmDialog(null, "A file with the name '" + destinationFileName + "' already exists. Do you want to overwrite it?\n'Yes' overwrites the file, 'No' does not do anything", "File exists already", 0, 2)) != 0 && overwrite == 1) {
                        AbstractTopComponent.notifyInfo("Aborted export. Existing file was not changed.");
                        return;
                    }
                    try {
                        exportMovieToFile = exp.exportMovieToFile(movie, Scenerixx.getPathToMovieExport(movie, pAlp.getLevel()), pAlp.getLevel());
                        for (Medium medium : this.db.getMediums(movie, true)) {
                            medium.setExportLevel(Integer.valueOf(pAlp.getLevel().getLevel()));
                            this.db.getEntityService().save((AbstractEntity)medium);
                        }
                        JOptionPane.showMessageDialog(null, "Exported movie '" + movie.getTitle() + "' to " + exportMovieToFile);
                    }
                    catch (TransformerException ex) {
                        JOptionPane.showMessageDialog(null, "An error occured while exporting '" + movie.getTitle() + "' to " + exportMovieToFile + ". Does the destination exists?\nThe error message we received: " + ex.getMessageAndLocation());
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "There are some unhashed files associated to this movie. You need to hash them first before exporting the movie.", "Found some unhashed files", 0);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Export Movie to public file";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

