/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.DeletedMedium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.settings.NoDuplicate;
import xxx.scenerixx.scenerixxlib.model.settings.QNoDuplicate;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class CompareMoviesPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(CompareMoviesPanel.class.getName());
    private PlaylistService ps = new PlaylistService();
    private DB db = DB.getInstance();
    private Movie first;
    private Movie second;
    private Node firstNode;
    private Node secondNode;
    private DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private JButton btnDeleteFirstMovie;
    private JButton btnDeleteSecondMovie;
    private JButton btnNoDuplicate;
    private JButton btnOpenBothSameInstance;
    private JButton btnOpenBothSeparateInstance;
    private JButton btnOpenFirst;
    private JButton btnOpenSecond;
    private JLabel lbCompareTable;

    public CompareMoviesPanel(Node firstNode, Node secondNode) {
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.first = (Movie)firstNode.getValue("movie");
        this.second = (Movie)secondNode.getValue("movie");
        this.initComponents();
        KeyStroke keyDelete = KeyStroke.getKeyStroke(27, 0);
        AbstractAction performCloseWindow = new AbstractAction("closeWindow"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareMoviesPanel.this.closePanel();
            }
        };
        this.getActionMap().put("closeWindow", performCloseWindow);
        this.getInputMap(1).put(keyDelete, "closeWindow");
        Image noDupIcon = ImageUtilities.loadImage((String)"icons.silk/pictures.png");
        noDupIcon = ImageUtilities.mergeImages((Image)noDupIcon, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.btnNoDuplicate.setIcon(ImageUtilities.image2Icon((Image)noDupIcon));
        MediumFile firstMf = null;
        MediumFile secondMf = null;
        List firstMediumFiles = this.db.getMediumFiles(this.first, Scenerixx.unlocked);
        List secondMediumFiles = this.db.getMediumFiles(this.second, Scenerixx.unlocked);
        if (!firstMediumFiles.isEmpty()) {
            firstMf = (MediumFile)firstMediumFiles.get(0);
        }
        if (!secondMediumFiles.isEmpty()) {
            secondMf = (MediumFile)secondMediumFiles.get(0);
        }
        if (firstMf == null || secondMf == null) {
            this.disableElementsAndWarn("Cannot compare movies. Medium file not found");
            return;
        }
        if (firstMf.getFileCompletePath().equalsIgnoreCase(secondMf.getFileCompletePath())) {
            this.disableElementsAndWarn("No comparison possible. You are comparing a movie to itself. It's the same file.");
            return;
        }
        int firstPersonCount = 0;
        for (Object s : this.first.getScenes()) {
            if (s.getPersons(Scenerixx.unlocked).isEmpty()) continue;
            ++firstPersonCount;
        }
        int secondPersonCount = 0;
        for (Object s : this.second.getScenes()) {
            if (s.getPersons(Scenerixx.unlocked).isEmpty()) continue;
            ++secondPersonCount;
        }
        int firstICameCounter = 0;
        for (Object s : this.first.getScenes()) {
            Statistic statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(arg_0 -> CompareMoviesPanel.lambda$new$0((Scene)s, arg_0)).findFirst();
            if (statistic == null) continue;
            firstICameCounter += statistic.getLikes().size();
        }
        int secondICameCounter = 0;
        for (Scene s : this.second.getScenes()) {
            Statistic statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(stat -> stat.scene.eq((Object)s)).findFirst();
            if (statistic == null) continue;
            secondICameCounter += statistic.getLikes().size();
        }
        LOG.info("rating 1: " + this.first.getRating());
        LOG.info("rating 2: " + this.second.getRating());
        String totalRuntimeColor = "red";
        if (firstMf.getTotalRuntime() != 0 && secondMf.getTotalRuntime() != 0 && firstMf.getTotalRuntime() == secondMf.getTotalRuntime()) {
            totalRuntimeColor = "green";
        }
        String fileSizeColor = "red";
        if (firstMf.getFileSize() != null && secondMf.getFileSize() != null && firstMf.getFileSize().longValue() == secondMf.getFileSize().longValue()) {
            fileSizeColor = "green";
        }
        String widthColor = "red";
        if (firstMf.getWidth() != null && secondMf.getWidth() != null && firstMf.getWidth().intValue() == secondMf.getWidth().intValue()) {
            widthColor = "green";
        }
        String heightColor = "red";
        if (firstMf.getHeight() != null && secondMf.getHeight() != null && firstMf.getHeight().intValue() == secondMf.getHeight().intValue()) {
            heightColor = "green";
        }
        String scenesColor = "red";
        if (this.first.getScenes().size() == this.second.getScenes().size()) {
            scenesColor = "green";
        }
        String personsColor = "red";
        if (firstPersonCount == secondPersonCount) {
            personsColor = "green";
        }
        String icameColor = "red";
        if (firstICameCounter == secondICameCounter) {
            icameColor = "green";
        }
        String ratingColor = "red";
        if (this.first.getRating() == null && this.second.getRating() == null || this.first.getRating() != null && this.second.getRating() != null && this.first.getRating().intValue() == this.second.getRating().intValue()) {
            ratingColor = "green";
        }
        String releaseYearColor = "red";
        if (this.first.getReleaseYear() == null && this.second.getReleaseYear() == null || this.first.getReleaseYear() != null && this.second.getReleaseYear() != null && this.first.getReleaseYear().intValue() == this.second.getReleaseYear().intValue()) {
            releaseYearColor = "green";
        }
        String studioColor = "red";
        if (this.first.getStudio() == null && this.second.getStudio() == null || this.first.getStudio() != null && this.second.getStudio() != null && this.first.getStudio().getName().equals(this.second.getStudio().getName())) {
            studioColor = "green";
        }
        String cmp = "<html><table><tr><td>Title</td><td>" + this.shortenTitle(this.first.getTitle()) + "</td><td>" + this.shortenTitle(this.second.getTitle()) + "</td></tr><tr><td>Date of creation</td><td>" + this.df.format(this.first.getDateOfCreation()) + " - (" + ChronoUnit.DAYS.between(this.first.getDateOfCreation(), LocalDateTime.now()) + " days ago)</td><td>" + this.df.format(this.second.getDateOfCreation()) + " - (" + ChronoUnit.DAYS.between(this.second.getDateOfCreation(), LocalDateTime.now()) + " days ago)</td></tr><tr><td>Date of last modification</td><td>" + this.df.format(this.first.getDateOfLastModification()) + " - (" + ChronoUnit.DAYS.between(this.first.getDateOfLastModification(), LocalDateTime.now()) + " days ago)</td><td>" + this.df.format(this.second.getDateOfLastModification()) + " - (" + ChronoUnit.DAYS.between(this.second.getDateOfLastModification(), LocalDateTime.now()) + " days ago)</td></tr><tr><td>Total runtime</td><td><font color=\"" + totalRuntimeColor + "\">" + ScenerixxCommon.readableRuntime(Long.valueOf(this.first.getTotalRuntime())) + "</font></td><td><font color=\"" + totalRuntimeColor + "\">" + ScenerixxCommon.readableRuntime(Long.valueOf(this.second.getTotalRuntime())) + "</font></td></tr><tr><td>File size (only first medium)</td><td><font color=\"" + fileSizeColor + "\">" + ScenerixxCommon.readableFileSize(firstMf.getFileSize()) + "</font></td><td><font color=\"" + fileSizeColor + "\">" + ScenerixxCommon.readableFileSize(secondMf.getFileSize()) + "</font></td></tr><tr><td>Resolution</td><td><font color=\"" + widthColor + "\">" + firstMf.getWidth() + "</font>x<font color=\"" + heightColor + "\">" + firstMf.getHeight() + "</font></td><td><font color=\"" + widthColor + "\">" + secondMf.getWidth() + "</font>x<font color=\"" + heightColor + "\">" + secondMf.getHeight() + "</font></td></tr><tr><td>Scenes</td><td><font color=\"" + scenesColor + "\">" + this.first.getScenes().size() + "</font></td><td><font color=\"" + scenesColor + "\">" + this.second.getScenes().size() + "</font></td></tr><tr><td>Scenes with associated persons</td><td><font color=\"" + personsColor + "\">" + firstPersonCount + "</font></td><td><font color=\"" + personsColor + "\">" + secondPersonCount + "</font></td></tr><tr><td>I came</td><td><font color=\"" + icameColor + "\">" + firstICameCounter + "</font></td><td><font color=\"" + icameColor + "\">" + secondICameCounter + "</font></td></tr><tr><td>Rating</td><td><font color=\"" + ratingColor + "\">" + (this.first.getRating() != null ? this.first.getRating().toString() : "n/a") + "</font></td><td><font color=\"" + ratingColor + "\">" + (this.second.getRating() != null ? this.second.getRating().toString() : "n/a") + "</font></td></tr><tr><td>Year of release</td><td><font color=\"" + releaseYearColor + "\">" + (this.first.getReleaseYear() != null ? this.first.getReleaseYear().toString() : "n/a") + "</font></td><td><font color=\"" + releaseYearColor + "\">" + (this.second.getReleaseYear() != null ? this.second.getReleaseYear().toString() : "n/a") + "</font></td></tr><tr><td>Studio</td><td><font color=\"" + studioColor + "\">" + (this.first.getStudio() != null ? this.first.getStudio().getName() : "n/a") + "</font></td><td><font color=\"" + studioColor + "\">" + (this.second.getStudio() != null ? this.second.getStudio().getName() : "n/a") + "</font></td></tr><tr><td>Playlists</td><td>" + this.getPlaylistLabel(this.first) + "</td><td>" + this.getPlaylistLabel(this.second) + "</td></tr><tr><td>Screencap</td><td><img src='" + this.loadScreencaps(this.first.getId(), Scenerixx.scenerixxScreencapDir) + "' width='300' height='300'></td><td><img src='" + this.loadScreencaps(this.second.getId(), Scenerixx.scenerixxScreencapDir) + "' width='300' height='300'></td></tr></table></html>";
        this.lbCompareTable.setText(cmp);
        this.btnDeleteFirstMovie.setText("Delete " + this.first.getTitle());
        this.btnDeleteSecondMovie.setText("Delete " + this.second.getTitle());
        Image image = ImageUtilities.loadImage((String)"icons.silk/pictures.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.btnNoDuplicate.setIcon(ImageUtilities.image2Icon((Image)image));
    }

    public void disableElementsAndWarn(String warning) {
        AbstractTopComponent.notifyError(warning);
        this.lbCompareTable.setText(warning);
        this.btnDeleteFirstMovie.setEnabled(false);
        this.btnDeleteSecondMovie.setEnabled(false);
        this.btnNoDuplicate.setEnabled(false);
        this.btnOpenFirst.setEnabled(false);
        this.btnOpenSecond.setEnabled(false);
        this.btnOpenBothSameInstance.setEnabled(false);
        this.btnOpenBothSeparateInstance.setEnabled(false);
    }

    private void initComponents() {
        this.lbCompareTable = new JLabel();
        this.btnDeleteFirstMovie = new JButton();
        this.btnDeleteSecondMovie = new JButton();
        this.btnNoDuplicate = new JButton();
        this.btnOpenFirst = new JButton();
        this.btnOpenSecond = new JButton();
        this.btnOpenBothSameInstance = new JButton();
        this.btnOpenBothSeparateInstance = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lbCompareTable, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.lbCompareTable.text"));
        this.btnDeleteFirstMovie.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteFirstMovie, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnDeleteFirstMovie.text"));
        this.btnDeleteFirstMovie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnDeleteFirstMovieActionPerformed(evt);
            }
        });
        this.btnDeleteSecondMovie.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteSecondMovie, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnDeleteSecondMovie.text"));
        this.btnDeleteSecondMovie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnDeleteSecondMovieActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnNoDuplicate, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnNoDuplicate.text"));
        this.btnNoDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnNoDuplicateActionPerformed(evt);
            }
        });
        this.btnOpenFirst.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenFirst, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnOpenFirst.text"));
        this.btnOpenFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnOpenFirstActionPerformed(evt);
            }
        });
        this.btnOpenSecond.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenSecond, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnOpenSecond.text"));
        this.btnOpenSecond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnOpenSecondActionPerformed(evt);
            }
        });
        this.btnOpenBothSameInstance.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenBothSameInstance, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnOpenBothSameInstance.text"));
        this.btnOpenBothSameInstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnOpenBothSameInstanceActionPerformed(evt);
            }
        });
        this.btnOpenBothSeparateInstance.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenBothSeparateInstance, (String)NbBundle.getMessage(CompareMoviesPanel.class, (String)"CompareMoviesPanel.btnOpenBothSeparateInstance.text"));
        this.btnOpenBothSeparateInstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareMoviesPanel.this.btnOpenBothSeparateInstanceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbCompareTable).addComponent(this.btnDeleteFirstMovie).addComponent(this.btnDeleteSecondMovie).addComponent(this.btnNoDuplicate).addGroup(layout.createSequentialGroup().addComponent(this.btnOpenFirst).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenSecond)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnOpenBothSeparateInstance, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnOpenBothSameInstance, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(38, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbCompareTable).addGap(29, 29, 29).addComponent(this.btnDeleteFirstMovie).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDeleteSecondMovie).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpenFirst).addComponent(this.btnOpenSecond)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenBothSameInstance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenBothSeparateInstance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNoDuplicate).addContainerGap(60, Short.MAX_VALUE)));
    }

    private void btnDeleteFirstMovieActionPerformed(ActionEvent evt) {
        this.deleteMovie(this.firstNode);
    }

    private void btnDeleteSecondMovieActionPerformed(ActionEvent evt) {
        this.deleteMovie(this.secondNode);
    }

    private void btnNoDuplicateActionPerformed(ActionEvent evt) {
        this.markAsNoDuplicate(this.first, this.second);
    }

    private void btnOpenFirstActionPerformed(ActionEvent evt) {
        this.openVlc(this.first);
    }

    private void btnOpenSecondActionPerformed(ActionEvent evt) {
        this.openVlc(this.second);
    }

    private void btnOpenBothSameInstanceActionPerformed(ActionEvent evt) {
        this.openInSameInstance();
    }

    private void btnOpenBothSeparateInstanceActionPerformed(ActionEvent evt) {
        this.openInSeparateInstance();
    }

    private void openInSeparateInstance() {
        this.openVlc(this.first);
        this.openVlc(this.second);
    }

    private void openInSameInstance() {
        PlaylistEntry eFirst = new PlaylistEntry();
        eFirst.setMovie(this.first);
        PlaylistEntry eSecond = new PlaylistEntry();
        eSecond.setMovie(this.second);
        Playlist p = new Playlist();
        p.getEntries(false).add(eFirst);
        p.getEntries(false).add(eSecond);
        this.openVlc(p);
    }

    private void openVlc(Playlist p) {
        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null) {
            ((MovieListTopComponent)movieList).openVlc(p, true, false);
        }
    }

    private void openVlc(Movie m) {
        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null) {
            ((MovieListTopComponent)movieList).openVlc(m.getTitle(), m, null, null, null, true);
        }
    }

    private void deleteMovie(Node node) {
        Movie movie = (Movie)node.getValue("movie");
        List mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
        Object mfs = "";
        for (MediumFile mf : mediumFiles) {
            mfs = (String)mfs + mf.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + "]<br>";
        }
        int deleteConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Should we delete " + movie.getTitle() + "?<br><br>Following medium files will get deleted:<br>" + (String)mfs + "</html>", "Delete movie?", 0, 1);
        if (deleteConfirmDialog == 0) {
            long fileSize = 0L;
            for (MediumFile mf : mediumFiles) {
                fileSize += mf.getFileSize().longValue();
            }
            for (MediumFile mf : mediumFiles) {
                File f = new File(mf.getFileCompletePath());
                boolean deleted = f.delete();
                if (!deleted) {
                    JOptionPane.showMessageDialog(null, "File '" + mf.getFileCompletePath() + "' could not be deleted!", "Error", 0);
                    continue;
                }
                DeletedMedium dm = new DeletedMedium();
                dm.setHashValue(mf.getHashValue());
                dm = (DeletedMedium)this.db.getEntityService().save((AbstractEntity)dm);
                LOG.info("Delete screencaps");
                try {
                    Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), new FileVisitOption[0]).filter(p -> p.getFileName().toString().startsWith(movie.getId() + "_"));
                    try {
                        List screencaps = paths.collect(Collectors.toList());
                        LOG.info("found " + screencaps.size() + " screencaps to delete");
                        for (Path filePath : screencaps) {
                            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                            try {
                                LOG.finest("Possible screencap: " + filePath.toString());
                                if (new File(filePath.toString()).delete()) {
                                    LOG.info("Deleted screencap: " + filePath.toString());
                                    continue;
                                }
                                LOG.info("Error while deleting screencap: " + filePath.toString());
                            }
                            catch (Exception ex) {
                                LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                            }
                        }
                    }
                    finally {
                        if (paths == null) continue;
                        paths.close();
                    }
                }
                catch (IOException ex) {
                    LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                }
            }
            LOG.info("Delete medium file entities");
            for (MediumFile mf : mediumFiles) {
                mf.setMovie(null);
                boolean deleteMediumFile = this.db.deleteMediumFile(mf, true);
                LOG.info("DeleteMediumFile result: " + deleteMediumFile);
                new ScenerixxCommon().checkEmptyDirectoryAndDeleteIfWanted(mf);
            }
            StatisticInternal stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{g -> g.dateOfCreation.desc()}).findFirst();
            if (stats == null) {
                stats = new StatisticInternal();
            }
            stats.setSavedBytes(stats.getSavedBytes() + fileSize);
            stats = (StatisticInternal)this.db.getEntityService().save((AbstractEntity)stats);
            Movie movie2 = (Movie)this.db.getEntityService().load(Movie.class, movie.getId().longValue());
            this.db.deleteMovie(movie2);
            node.setDisplayName("<html><font color=\"" + ScenerixxCommonLib.RED + "\">Deleted!</font> <strike>" + node.getHtmlDisplayName() + "</strike> (this node will be removed with the next reload)</html>");
            AbstractTopComponent.notifyInfo("Deleted movie " + movie.getTitle());
            TopComponent playlist = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlist != null) {
                ((PlaylistTopComponent)playlist).reloadList(node.getParentNode());
            }
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.dirtyMediumFileList();
                AbstractTopComponent.dirtyPersonList();
                AbstractTopComponent.dirtyMovieList();
                AbstractTopComponent.dirtyStudiolist();
                AbstractTopComponent.reloadPlaylist();
            });
            this.closePanel();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadScreencaps(Long movieId, String path) {
        try (Stream<Path> paths = Files.walk(Paths.get(path, new String[0]), 1, new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    if (!filePath.getFileName().toString().startsWith(movieId + "_")) continue;
                    LOG.info("Found screencap: file:///" + filePath.toString());
                    String string = "file:///" + filePath.toString();
                    return string;
                }
                catch (Exception ex) {
                    LOG.finer("Error while trying to find screencaps: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            LOG.finer("Error while trying to find screencaps: " + ex.getMessage());
        }
        LOG.info("no screencap found for movie ID: " + movieId);
        return null;
    }

    private String shortenTitle(String title) {
        Object res = title;
        if (((String)res).length() > 55) {
            res = ((String)res).substring(0, title.length() / 2 - (title.length() - 50) / 2) + "[...]" + ((String)res).substring(title.length() / 2 + (title.length() - 50) / 2, title.length());
        }
        return res;
    }

    private void markAsNoDuplicate(Movie one, Movie other) {
        NoDuplicate findFirst = (NoDuplicate)this.db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)other.getId())).filter(f -> f.movieIdOther.eq((Object)one.getId())).findFirst();
        NoDuplicate findOther = (NoDuplicate)this.db.getEntityService().find((EntityPathBase)QNoDuplicate.noDuplicate).filter(f -> f.movieIdOne.eq((Object)one.getId())).filter(f -> f.movieIdOther.eq((Object)other.getId())).findFirst();
        if (findFirst != null || findOther != null) {
            AbstractTopComponent.notifyWarning("Movies were already marked as 'no duplicate'.");
        } else {
            NoDuplicate noDuplicate = new NoDuplicate(one.getId(), other.getId());
            this.db.getEntityService().save((AbstractEntity)noDuplicate);
            AbstractTopComponent.notifyInfo("Movies have been marked as 'no duplicate'.");
        }
        this.closePanel();
    }

    private void closePanel() {
        JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (parent != null) {
            LOG.finer("dispose compare movie panel");
            parent.dispose();
        } else {
            LOG.finer("parent is null");
        }
    }

    private String getPlaylistLabel(Movie currentMovie) {
        List anyPlaylist = this.ps.getPlaylists(Scenerixx.unlocked, currentMovie);
        LOG.fine("checking " + anyPlaylist.size() + " playlists for movie " + currentMovie.getTitle() + "(" + currentMovie.getId() + ")");
        Object playlistLabel = "";
        for (Playlist playlist : anyPlaylist) {
            for (PlaylistEntry pe : playlist.getEntries(Scenerixx.unlocked)) {
                if (currentMovie == null || pe.getMovie() == null || !Objects.equals(pe.getMovie().getId(), currentMovie.getId())) continue;
                playlistLabel = (String)playlistLabel + "* " + playlist.getName() + " (at position " + pe.getPositionInList() + ")<br>";
            }
        }
        LOG.fine("playlist label: " + (String)playlistLabel);
        return playlistLabel;
    }

    private static /* synthetic */ Predicate lambda$new$0(Scene s, QStatistic stat) {
        return stat.scene.eq((Object)s);
    }
}

