/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class AddSeveralScenesAction
extends NodeAction
implements Presenter.Popup {
    public AddSeveralScenesAction() {
        Image image = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/paginator.png"), (int)7, (int)7);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int cntMovies = 0;
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
            Movie movie = (Movie)object;
            movies.add(movie);
            ++cntMovies;
        }
        SwingUtilities.invokeLater(() -> {
            if (movies.isEmpty()) {
                AbstractTopComponent.notifyWarning("No movie was selected. No scene was added.");
            } else {
                int newCreateScenes = new ScenerixxCommon().askHowManyScenesShouldBeCreated(movies, true);
                if (newCreateScenes > 0) {
                    AbstractTopComponent.notifyInfo("Added " + newCreateScenes + " scenes to " + movies.size() + " movies");
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add n scenes to movie";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

