/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class AddSceneAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(AddSceneAction.class.getName());

    public AddSceneAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, 128));
        Image image = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int cntMovies = 0;
        Movie tmpLastMovie = null;
        for (Node n : activatedNodes) {
            Movie m;
            Object object;
            if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
            tmpLastMovie = m = (Movie)object;
            LOG.fine(m.getTitle() + " - adding scene");
            SwingUtilities.invokeLater(() -> new ScenerixxCommon().addScene(m, false));
            ++cntMovies;
        }
        AbstractTopComponent.notifyInfo("Added a single scene to  " + cntMovies + " movies");
        Movie lastMovie = tmpLastMovie;
        SwingUtilities.invokeLater(() -> {
            MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                boolean nodeWasSelected;
                Node nextNode = movieList.getNextNode();
                Movie nextMovie = null;
                if (nextNode != null) {
                    LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode) + " - " + nextNode.getDisplayName());
                    if (nextNode.getValue("movie") != null && nextNode.getValue("movie") instanceof Movie) {
                        nextMovie = (Movie)nextNode.getValue("movie");
                    }
                } else {
                    LOG.fine("Next node to select as a fallback: " + String.valueOf(nextNode));
                }
                movieList.reloadListAndRefocus();
                if (lastMovie != null && !(nodeWasSelected = movieList.selectSceneNode((Scene)lastMovie.getScenes().get(lastMovie.getScenes().size() - 1))) && nextMovie != null) {
                    LOG.fine("Could not select scene, try to select next movie as fallback: " + nextMovie.getTitle());
                    movieList.selectMovieNode(nextMovie);
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add Scene";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

