/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.time.LocalDateTime;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class AddBookmarkAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(AddBookmarkAction.class.getName());
    private DB db = DB.getInstance();

    public AddBookmarkAction() {
        Image image = ImageUtilities.loadImage((String)"icons/greenbookmark.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int cntMovies = 0;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
            Movie movie = (Movie)n.getValue("movie");
            movie = (Movie)this.db.getEntityService().load(Movie.class, movie.getId().longValue());
            int newPos = -1;
            for (Bookmark b : movie.getBookmarks(true)) {
                if (newPos >= b.getPosition()) continue;
                newPos = b.getPosition();
            }
            Bookmark newBookmark = new Bookmark();
            newBookmark.setDateOfCreation(LocalDateTime.now());
            newBookmark.setPosition(newPos + 1);
            newBookmark.setMovie(movie);
            movie.getBookmarks(true).add(newBookmark);
            movie = (Movie)this.db.getEntityService().save((AbstractEntity)movie);
            LOG.finest("Added bookmark to " + movie.getTitle());
            AbstractTopComponent.reloadMovieList(true);
            Movie tmpLastMovie = movie;
            SwingUtilities.invokeLater(() -> {
                TopComponent movieList1 = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                if (movieList1 != null) {
                    ((MovieListTopComponent)movieList1).selectBookmarkNode((Bookmark)tmpLastMovie.getBookmarks(true).get(tmpLastMovie.getBookmarks(true).size() - 1));
                }
            });
            ++cntMovies;
        }
        AbstractTopComponent.notifyInfo("Added a bookmark to " + ScenerixxCommon.singularPlural(cntMovies, "movie", true));
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add Bookmark";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

