/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.util.MediaInformation;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class UpdateMediaInformationAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(UpdateMediaInformationAction.class.getName());
    private final DB db = DB.getInstance();
    private String name = "Update media information";
    private boolean save = false;
    private final MediaInformation media = new MediaInformation();
    private Node nodeToSelect = null;

    public UpdateMediaInformationAction() {
        Image image = ImageUtilities.loadImage((String)"icons2/51clock.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("mediumFile") == null || !((object = n.getValue("mediumFile")) instanceof MediumFile)) continue;
            MediumFile mf = (MediumFile)object;
            LOG.fine("Trying to retrieve media information for file " + mf.getFileCompletePath());
            try {
                String duration;
                String width;
                String height;
                if (mf.getHeight() == null && !(height = this.media.getMediaInfoValue("--Inform=Video;%Height%", mf.getFileCompletePath())).isEmpty()) {
                    mf.setHeight(Integer.valueOf(Integer.parseInt(height)));
                    this.save = true;
                }
                if (mf.getWidth() == null && !(width = this.media.getMediaInfoValue("--Inform=Video;%Width%", mf.getFileCompletePath())).isEmpty()) {
                    mf.setWidth(Integer.valueOf(width));
                    this.save = true;
                }
                if (mf.getDuration() == null && !(duration = this.media.getMediaInfoValue("--Inform=Video;%Duration%", mf.getFileCompletePath())).isEmpty()) {
                    if (duration.contains(".")) {
                        duration = duration.substring(0, duration.indexOf("."));
                    }
                    mf.setDuration(Integer.valueOf(duration));
                    this.save = true;
                }
            }
            catch (Exception ex) {
                AbstractTopComponent.notify("Could not retrieve media information: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
            }
            if (this.save) {
                this.db.getEntityService().save((AbstractEntity)mf);
                LOG.fine("Updated media information for file: " + mf.getFileCompletePath());
            }
            AbstractTopComponent.reloadMediumFileList(this.nodeToSelect);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNodeToSelect(Node nodeToSelect) {
        this.nodeToSelect = nodeToSelect;
    }
}

