/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action;

import java.awt.Image;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.util.Hashing;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class HashAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(HashAction.class.getName());
    private String name = "Hash file";
    private Hashing hashing = new Hashing();
    private Node nodeToSelect = null;

    public HashAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/script_binary.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("mediumFile") == null || !((object = n.getValue("mediumFile")) instanceof MediumFile)) continue;
            MediumFile mf = (MediumFile)object;
            if (Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                this.hashing.hashFile(mf);
            } else {
                JOptionPane.showMessageDialog(null, "Cannot hash file since we cannot find it. If this file resides on an external device make sure it's connected. Otherwise consider removing this file manually or start a purging process.", "File not found", 0);
            }
            AbstractTopComponent.reloadMediumFileList(this.nodeToSelect);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNodeToSelect(Node nodeToSelect) {
        this.nodeToSelect = nodeToSelect;
    }
}

