/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import api.api.ScenerixxRestApiApi;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.models.ScenerixxUser;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public final class RegisterAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private DB db = DB.getInstance();
    private static final Logger LOG = Logger.getLogger(RegisterAction.class.getName());
    private ScenerixxSettings settings = this.db.getScenerixxSettings();

    public RegisterAction() {
        if (this.settings != null && this.settings.getActivationKey() != null) {
            this.putValue("Name", "Already registered");
            this.setEnabled(false);
        } else {
            this.putValue("Name", "Start Registration");
        }
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"icons/Key.png", (boolean)false));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Register - Why / What / How <br><br>Since version 2.4 0 allows to share data with others via a server.<br>And for that Scenerixx needs a \"registration\". But don't worry. You don't need to provide any personal information. No bank account. No name. No email. <br>Scenerixx is just generating a unique value which will be saved with your installation and is assigned to your submissions and search requests.<br><br>At the moment you can only search for persons and studios (movies are coming in the future) and if the data is present on the server you just need to hit the save button. <br>And if the data is unknown to the server you can upload it yourself and share it with others.<br><br>But why is a registration necessary ?<br><br>At the moment it's from a technical point of view not really necessary. In the future Scenerixx might use it for following things:<br><br>  -  filter out low quality submissions from the same person<br>  -  throttle requests if a person hammers the server<br>  -  before a merging algorithm will be implemented it could be used for updating entities<br>  -  notifications for new data. If you searched for example for \"Jane Doe\" and no data was found you could be notified in the future as soon as data for Jane Doe is available.<br>  -  identifying contributing power users (who might influence the development roadmap)<br><br>None of this is implemented yet and that's just a few ideas. The whole thing is still in an alpha state!<br><br>What is stored / send to the server?<br><br>  -  the unique value that is assigned to you<br>  -  search requests and sumbissions that you submit<br>  -  a timestamp<br>  -  the version you are using<br><br>What is NOT stored? <br>Everything else which is not mentioned in the above paragraph. So: no information about your system, no filenames, private descriptions, IPs, your region or anything else <br>is transferred and therefore not stored.<br><br>Some legal stuff: If you submit some data you grant Scenerixx the right to use and reproduce this data. Even if Scenerixx should be monetized in the future.<br>Or in legal words:<br>In order to operate and provide our Services, you grant Scenerixx a worldwide, non-exclusive, royalty-free, sublicensable, and transferable license <br>to use, reproduce, distribute, create derivative works of, display, and perform the information (including the content) that you upload, submit, <br>store, send, or receive on or through our Services. The rights you grant in this license are for the limited purpose of operating and providing <br>our Services<br><br>This is an alpha feature and might not work as intended. Register now?</html>", "Register now?", 0, 1);
        if (showInternalConfirmDialog == 0) {
            LOG.fine("Start registration");
            this.register();
        } else {
            LOG.fine("Registration aborted");
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    private void register() {
        try {
            ScenerixxRestApiApi api = new ScenerixxRestApiApi();
            String register = api.register();
            ScenerixxUser scenerixxUser = (ScenerixxUser)ScenerixxCommonLib.getGsonBuilder().create().fromJson(register, ScenerixxUser.class);
            LOG.info("scenerixx user (ID: " + scenerixxUser.getId() + ") activation key: " + scenerixxUser.getActivationKey());
            this.settings.setActivationKey(scenerixxUser.getActivationKey());
            this.settings.setExternalId(scenerixxUser.getId());
            this.db.getEntityService().save((AbstractEntity)this.settings);
            AbstractTopComponent.notifyInfo("Registration successful! Go ahead and 'Synchronize' your collection in the 'Indexing...' window.");
            Scenerixx.registered = true;
            this.putValue("Name", "Already registered");
            this.setEnabled(false);
        }
        catch (Exception ex) {
            AbstractTopComponent.notifyError("Could not register?");
            JOptionPane.showMessageDialog(null, "<html>Registration failed<br><br>We could not contact the server. That could have following causes:<br><br>* the server is down<br>* your internet connection is broken<br>* you are blocked by a proxy<br><br><br>Try again later or drop me a note.</html>", "Well, that sucks...", 0);
            LOG.severe(ex.getMessage());
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public boolean isEnabled() {
        if (Scenerixx.registered) {
            this.putValue("Name", "Already registered");
        } else {
            this.putValue("Name", "Start Registration");
        }
        return !Scenerixx.registered;
    }
}

