/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule;

import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MediumFileShowHideFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MediumFileTypeFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MovieTypeFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByGender;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByMediumFile;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByMovie;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByPerson;
import xxx.scenerixx.scenerixxlib.model.enums.gui.ShowHideMovieFilter;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.LogFormatter;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioListTopComponent;

public class Initializer
extends ModuleInstall {
    public static final Logger LOG = Logger.getLogger(Initializer.class.getName());
    private DB db = DB.getInstance();

    public void restored() {
        Handler[] handlers;
        LogFormatter formatter = new LogFormatter();
        Logger logger = Logger.getLogger("");
        logger.info("Initializing system...");
        for (Handler handler : handlers = logger.getHandlers()) {
            handler.setFormatter(formatter);
        }
    }

    public void close() {
        Logger logger = Logger.getLogger("");
        logger.info("Shutting down Scenerixx");
        ScenerixxSettings scenerixxSettings = this.db.getScenerixxSettings();
        LOG.info("dupFinder: " + scenerixxSettings.getDupFinderEnd() + " - " + String.valueOf(scenerixxSettings.getDupFinderAbortDate()));
        this.saveUiState();
        logger.info("Wait to collect all ui states");
        try {
            Thread.sleep(2000L);
        }
        catch (Exception ex) {
            logger.info("oh no... how good we were leaving anyway");
            ex.printStackTrace();
        }
        logger.info("done");
        logger.info("Closing database connection");
        this.db.getEntityService().getEntityManager().close();
        logger.info("Closed database connection");
        this.makeBackup(scenerixxSettings, scenerixxSettings.isBackup(), logger);
        Scenerixx.scenerixxSessionStatistic.end();
        LOG.info(Scenerixx.scenerixxSessionStatistic.toString());
        logger.info("See you next time. Bye.");
    }

    private UiState saveUiState() {
        TopComponent mediumfilelistTC;
        TopComponent playlistTC;
        TopComponent studioListTC;
        TopComponent personListTC;
        TopComponent movieListTC;
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        if ((movieListTC = WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null && movieListTC instanceof MovieListTopComponent) {
            MovieListTopComponent movieList = (MovieListTopComponent)movieListTC;
            uiState.setMovielistAsc(movieList.toggleBtnAsc.isSelected());
            uiState.setMovielistCounter(movieList.cbShowCounter.isSelected());
            uiState.setMovielistICameCounter(movieList.cbShowLikeCounter.isSelected());
            uiState.setMovielistMovieOrderByMovie((OrderByMovie)movieList.comboOrderByMovie.getSelectedItem());
            uiState.setMovielistMovieShowHideMovieFilter((ShowHideMovieFilter)movieList.comboShowHideFilter.getSelectedItem());
            uiState.setMovielistMovieTypeFilter((MovieTypeFilter)movieList.comboMovieTypeFilter.getSelectedItem());
            uiState.setMovielistPosition(movieList.cbShowPosition.isSelected());
            uiState.setMovielistRating(movieList.cbShowRating.isSelected());
            uiState.setMovielistRuntime(movieList.cbShowRuntime.isSelected());
            uiState.setMovielistYear(movieList.cbShowYear.isSelected());
            uiState.setMovielistResolution(movieList.cbShowResolution.isSelected());
            uiState.setPrefixMetadata(movieList.cbPrefixMetaData.isSelected());
            uiState.setSearchMovie(movieList.getTfSearch().getText());
            if (movieList.getPlaylistToShow() != null && movieList.getPlaylistToShow().getId() != null) {
                Playlist reloadedPlaylist = (Playlist)this.db.getEntityService().load(Playlist.class, movieList.getPlaylistToShow().getId().longValue());
                uiState.setMovielistPlaylistToShow(reloadedPlaylist);
            } else {
                uiState.setMovielistPlaylistToShow(null);
            }
            LOG.info("ui state on close: " + String.valueOf(uiState.getMovielistMovieShowHideMovieFilter()));
            LOG.info("show hideon close: " + String.valueOf((ShowHideMovieFilter)movieList.comboShowHideFilter.getSelectedItem()));
        }
        if ((personListTC = WindowManager.getDefault().findTopComponent("PersonListTopComponent")) != null && personListTC instanceof PersonListTopComponent) {
            PersonListTopComponent personList = (PersonListTopComponent)personListTC;
            uiState.setPersonlistMovieOrderByGender((OrderByGender)personList.comboOrderByGender.getSelectedItem());
            uiState.setPersonlistMovieOrderByPerson((OrderByPerson)personList.comboOrderByPerson.getSelectedItem());
            uiState.setPersonlistAsc(personList.toggleBtnAsc.isSelected());
            uiState.setPersonlistRating(personList.cbShowRating.isSelected());
            uiState.setPersonlistRuntime(personList.cbShowRuntime.isSelected());
            uiState.setPersonlistAliases(personList.cbShowAliases.isSelected());
            uiState.setPersonlistPosition(personList.cbShowPosition.isSelected());
            uiState.setPersonlistCounter(personList.cbShowCounter.isSelected());
            uiState.setPersonlistCounterICame(personList.cbShowLikeCounter.isSelected());
            uiState.setSearchPerson(personList.getTfSearch().getText());
        }
        if ((studioListTC = WindowManager.getDefault().findTopComponent("StudioListTopComponent")) != null && studioListTC instanceof StudioListTopComponent) {
            StudioListTopComponent studioList = (StudioListTopComponent)studioListTC;
            uiState.setStudiolistAsc(studioList.toggleBtnAsc.isSelected());
            uiState.setStudiolistShowPosition(studioList.cbShowPosition.isSelected());
            uiState.setStudiolistSortByAmount(studioList.rbSortAmount.isSelected());
            uiState.setStudiolistSortByName(studioList.rbSortName.isSelected());
            uiState.setSearchStudio(studioList.getTfSearch().getText());
        }
        if ((playlistTC = WindowManager.getDefault().findTopComponent("PlaylistTopComponent")) != null && playlistTC instanceof PlaylistTopComponent) {
            PlaylistTopComponent playlist = (PlaylistTopComponent)playlistTC;
            uiState.setPlaylistAsc(playlist.toggleBtnAsc.isSelected());
            uiState.setPlaylistOrderByCreation(playlist.rbOrderByDateOfCreation.isSelected());
            uiState.setPlaylistOrderByName(playlist.rbOrderByName.isSelected());
            uiState.setPlaylistShowPosition(playlist.cbShowPosition.isSelected());
        }
        if ((mediumfilelistTC = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent")) != null && mediumfilelistTC instanceof MediumFileListTopComponent) {
            MediumFileListTopComponent mfList = (MediumFileListTopComponent)mediumfilelistTC;
            uiState.setMediumfilelistOrderBy((OrderByMediumFile)mfList.comboOrderBy.getSelectedItem());
            uiState.setMediumfilelistTypeFilter((MediumFileTypeFilter)mfList.comboFilter.getSelectedItem());
            uiState.setMediumfilelistShowHideFilter((MediumFileShowHideFilter)mfList.comboShowHideFilter.getSelectedItem());
            uiState.setMediumfilelistAsc(mfList.toggleBtnAsc.isSelected());
            uiState.setMediumfilelistCounter(mfList.cbShowCounter.isSelected());
            uiState.setMediumfilelistDirectory(mfList.cbShowDirectory.isSelected());
            uiState.setMediumfilelistPosition(mfList.cbShowPosition.isSelected());
            uiState.setMediumfilelistFilesize(mfList.cbShowFileSize.isSelected());
            uiState.setSearchMedium(mfList.getTfSearch().getText());
        }
        uiState = (UiState)this.db.getEntityService().save((AbstractEntity)uiState);
        LOG.info("saved ui state: " + String.valueOf(uiState.getMovielistMovieShowHideMovieFilter()));
        return uiState;
    }

    public String makeBackup(ScenerixxSettings scenerixxSettings, boolean makeBackup, Logger logger) {
        Object writtenBackupFile = "";
        if (makeBackup) {
            logger.info("Make backup before shutting down.");
            String formatDate = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss").format(new Date());
            String formatDateWithoutSpaces = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
            String scenerixxDir = System.getProperty("user.home") + File.separator + "scenerixx" + File.separator;
            boolean embedded = false;
            String mysqlconf = scenerixxDir + "mysql.conf";
            if (new File(mysqlconf).exists()) {
                embedded = false;
                Properties props = new Properties();
                logger.info(mysqlconf + " exists, create MySql dump.");
                try {
                    props.load(new FileInputStream(mysqlconf));
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(EntityService.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(EntityService.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    BufferedReader in;
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add("mysqldump");
                    cmd.add("-u" + props.getProperty("jakarta.persistence.jdbc.user"));
                    cmd.add("-p" + props.getProperty("jakarta.persistence.jdbc.password"));
                    cmd.add("scenerixx");
                    logger.info("Parameters to create dump: " + cmd.stream().map(x -> x).collect(Collectors.joining(" ")));
                    ProcessBuilder ps = new ProcessBuilder(new String[0]);
                    ps.redirectErrorStream(true);
                    ps.command(cmd);
                    Process pr = ps.start();
                    writtenBackupFile = scenerixxDir + "backups" + File.separator + formatDateWithoutSpaces + ".sql";
                    try (FileWriter myWriter = new FileWriter((String)writtenBackupFile);){
                        in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            myWriter.write(line + System.lineSeparator());
                        }
                    }
                    pr.waitFor();
                    in.close();
                }
                catch (IOException | InterruptedException e) {
                    logger.severe("Could not create database dump! " + e.getMessage());
                }
            } else {
                embedded = true;
                logger.info("Create backup from embedded database.");
                try {
                    String dest = scenerixxDir + "backups" + File.separator + formatDate;
                    writtenBackupFile = dest;
                    Files.createDirectories(Paths.get(dest, new String[0]), new FileAttribute[0]);
                    ScenerixxCommonLib.copyFolder((Path)Paths.get(System.getProperty("user.home") + "scenerixx" + Scenerixx.scenerixxDataDir, new String[0]), (Path)Paths.get(dest, new String[0]));
                }
                catch (IOException ex) {
                    logger.severe("Could not create backup. Yolo.");
                }
            }
            logger.info("Cleaning up old backups.");
            try (Stream<Path> fileStream = Files.list(Paths.get(scenerixxSettings.getBackupPath(), new String[0]));){
                Predicate<File> isDirectoryOrFile = f -> f.isDirectory();
                if (!embedded) {
                    isDirectoryOrFile = f -> !f.isDirectory();
                }
                List backupDirs = fileStream.map(Path::toFile).filter(isDirectoryOrFile).sorted(Comparator.comparing(File::lastModified)).collect(Collectors.toList());
                Collections.reverse(backupDirs);
                if (backupDirs.size() > scenerixxSettings.getMaxBackupFiles()) {
                    for (int i = scenerixxSettings.getMaxBackupFiles(); i < backupDirs.size(); ++i) {
                        logger.info("Deleting backup directory " + i + ": " + ((File)backupDirs.get(i)).getAbsolutePath());
                        FileUtils.delete((File)((File)backupDirs.get(i)));
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            logger.info("Do not make a backup. You can activate this in the settings if you want.");
        }
        return writtenBackupFile;
    }
}

