/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class CollectionUtils {
    private static final Set<Class<?>> UNMODIFIABLE_TYPES;

    public static boolean isUnmodifiableType(Class<?> clazz) {
        while (clazz != null) {
            if (UNMODIFIABLE_TYPES.contains(clazz)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static <T> List<T> unmodifiableList(List<T> list) {
        if (CollectionUtils.isUnmodifiableType(list.getClass())) {
            return list;
        }
        return switch (list.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(list.get(0));
            default -> Collections.unmodifiableList(new ArrayList<T>(list));
        };
    }

    public static <T> Set<T> unmodifiableSet(Set<T> set) {
        if (CollectionUtils.isUnmodifiableType(set.getClass())) {
            return set;
        }
        return switch (set.size()) {
            case 0 -> Collections.emptySet();
            case 1 -> Collections.singleton(set.iterator().next());
            default -> Collections.unmodifiableSet((Set)(set instanceof LinkedHashSet ? ((LinkedHashSet)set).clone() : (set instanceof TreeSet ? ((TreeSet)set).clone() : (set instanceof HashSet ? ((HashSet)set).clone() : new LinkedHashSet<T>(set)))));
        };
    }

    public static <T> List<List<T>> partition(List<T> list, int batchSize) {
        return IntStream.range(0, list.size() / batchSize + 1).mapToObj(i -> list.subList(i * batchSize, Math.min(i * batchSize + batchSize, list.size()))).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static <T> List<T> add(List<T> list, T element) {
        int size = list.size();
        if (size == 0) {
            return Collections.singletonList(element);
        }
        if (CollectionUtils.isUnmodifiableType(list.getClass())) {
            if (size == 1) {
                T val = list.get(0);
                list = new ArrayList<T>();
                list.add(val);
            } else {
                list = new ArrayList<T>(list);
            }
        }
        list.add(element);
        return list;
    }

    public static <T> List<T> copyOf(List<T> list) {
        if (CollectionUtils.isUnmodifiableType(list.getClass())) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    public static <T> Set<T> add(Set<T> set, T element) {
        int size = set.size();
        if (size == 0) {
            return Collections.singleton(element);
        }
        if (CollectionUtils.isUnmodifiableType(set.getClass())) {
            if (size == 1) {
                T val = set.iterator().next();
                set = new HashSet<T>();
                set.add(val);
            } else {
                set = new HashSet<T>(set);
            }
        }
        set.add(element);
        return set;
    }

    public static <T> Set<T> copyOf(Set<T> set) {
        if (CollectionUtils.isUnmodifiableType(set.getClass())) {
            return set;
        }
        return new HashSet<T>(set);
    }

    public static <T> Set<T> addSorted(Set<T> set, T element) {
        int size = set.size();
        if (size == 0) {
            return Collections.singleton(element);
        }
        if (CollectionUtils.isUnmodifiableType(set.getClass())) {
            if (size == 1) {
                T val = set.iterator().next();
                set = new LinkedHashSet<T>();
                set.add(val);
            } else {
                set = new LinkedHashSet<T>(set);
            }
        }
        set.add(element);
        return set;
    }

    public static <T> Set<T> removeSorted(Set<T> set, T element) {
        int size = set.size();
        if (size == 0 || size == 1 && set.contains(element)) {
            return Collections.emptySet();
        }
        set.remove(element);
        return set;
    }

    public static <T> Set<T> copyOfSorted(Set<T> set) {
        if (CollectionUtils.isUnmodifiableType(set.getClass())) {
            return set;
        }
        return new LinkedHashSet<T>(set);
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K key, V value) {
        int size = map.size();
        if (size == 0) {
            return Collections.singletonMap(key, value);
        }
        if (CollectionUtils.isUnmodifiableType(map.getClass())) {
            map = new HashMap<K, V>(map);
        }
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        if (CollectionUtils.isUnmodifiableType(map.getClass())) {
            return map;
        }
        return new HashMap<K, V>(map);
    }

    private CollectionUtils() {
    }

    static {
        HashSet unmodifiableTypes = new HashSet();
        unmodifiableTypes.add(Collections.emptyList().getClass());
        unmodifiableTypes.add(Collections.emptySet().getClass());
        unmodifiableTypes.add(Collections.emptyNavigableSet().getClass());
        unmodifiableTypes.add(Collections.emptySortedSet().getClass());
        unmodifiableTypes.add(Collections.emptyMap().getClass());
        unmodifiableTypes.add(Collections.emptySortedMap().getClass());
        unmodifiableTypes.add(Collections.emptyNavigableMap().getClass());
        unmodifiableTypes.add(Collections.singleton(1).getClass());
        unmodifiableTypes.add(Collections.singletonList(1).getClass());
        unmodifiableTypes.add(Collections.singletonMap(1, 1).getClass());
        unmodifiableTypes.add(Collections.unmodifiableList(Collections.emptyList()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableCollection(Collections.emptyList()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableSet(Collections.emptySet()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableMap(Collections.emptyMap()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass());
        unmodifiableTypes.add(Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass());
        try {
            unmodifiableTypes.add(Class.forName("com.google.common.collect.ImmutableSet"));
            unmodifiableTypes.add(Class.forName("com.google.common.collect.ImmutableList"));
            unmodifiableTypes.add(Class.forName("com.google.common.collect.ImmutableMap"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            unmodifiableTypes.add(Class.forName("java.util.ImmutableCollections$AbstractImmutableCollection"));
            unmodifiableTypes.add(Class.forName("java.util.ImmutableCollections$AbstractImmutableMap"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        UNMODIFIABLE_TYPES = Collections.unmodifiableSet(unmodifiableTypes);
    }
}

