/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.annotations.Immutable;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionBase;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.CollectionUtils;
import com.querydsl.core.util.PrimitiveUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Unmodifiable;

@Immutable
public class OperationImpl<T>
extends ExpressionBase<T>
implements Operation<T> {
    private static final long serialVersionUID = 4796432056083507588L;
    private final @Unmodifiable List<Expression<?>> args;
    private final Operator operator;

    protected OperationImpl(Class<? extends T> type, Operator operator, Expression<?> ... args) {
        this(type, operator, Arrays.asList(args));
    }

    protected OperationImpl(Class<? extends T> type, Operator operator, List<Expression<?>> args) {
        super(type);
        Class<? extends T> wrapped = PrimitiveUtils.wrap(type);
        if (!operator.getType().isAssignableFrom(wrapped)) {
            throw new IllegalArgumentException(operator.name());
        }
        this.operator = operator;
        this.args = CollectionUtils.unmodifiableList(args);
    }

    @Override
    public final Expression<?> getArg(int i) {
        return this.args.get(i);
    }

    @Override
    public final @Unmodifiable List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public final Operator getOperator() {
        return this.operator;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Operation) {
            Operation op = (Operation)o;
            return op.getOperator() == this.operator && op.getArgs().equals(this.args) && op.getType().equals(this.getType());
        }
        return false;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }
}

