/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.MathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumberConversions<T>
extends FactoryExpressionBase<T> {
    private static final long serialVersionUID = -7834053123363933721L;
    private final FactoryExpression<T> expr;
    private final Map<Class<?>, Enum<?>[]> values = new HashMap();

    public NumberConversions(FactoryExpression<T> expr) {
        super(expr.getType());
        this.expr = expr;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.expr.getArgs();
    }

    private <E extends Enum<E>> Enum<E>[] getValues(Class<E> enumClass) {
        Enum<?>[] values = this.values.get(enumClass);
        if (values == null) {
            values = (Enum[])enumClass.getEnumConstants();
            this.values.put(enumClass, values);
        }
        return values;
    }

    @Override
    public T newInstance(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = this.expr.getArgs().get(i).getType();
            if (Enum.class.isAssignableFrom(type) && !type.isInstance(args[i])) {
                Object object = args[i];
                if (object instanceof String) {
                    String string = (String)object;
                    args[i] = Enum.valueOf(type, string);
                    continue;
                }
                object = args[i];
                if (!(object instanceof Number)) continue;
                Number number = (Number)object;
                args[i] = this.getValues(type)[number.intValue()];
                continue;
            }
            Object object = args[i];
            if (!(object instanceof Number)) continue;
            Number number = (Number)object;
            if (type.isInstance(args[i])) continue;
            if (type.equals(Boolean.class)) {
                args[i] = number.intValue() > 0;
                continue;
            }
            if (!Number.class.isAssignableFrom(type)) continue;
            args[i] = MathUtils.cast(number, type);
        }
        return this.expr.newInstance(args);
    }
}

