/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Visitor;
import java.util.Collections;
import java.util.List;

public class EnumConversion<T>
extends FactoryExpressionBase<T> {
    private static final long serialVersionUID = 7840412008633901748L;
    private final List<Expression<?>> exprs;
    private final T[] values;

    public EnumConversion(Expression<T> expr) {
        super(expr.getType());
        Class type = this.getType();
        if (!type.isEnum()) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not an enum");
        }
        this.exprs = Collections.singletonList(expr);
        this.values = type.getEnumConstants();
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.exprs;
    }

    @Override
    public T newInstance(Object ... args) {
        if (args[0] != null) {
            if (args[0] instanceof String || args[0] instanceof Character) {
                Enum rv = Enum.valueOf(this.getType().asSubclass(Enum.class), args[0].toString());
                return (T)rv;
            }
            Object rv = args[0];
            if (rv instanceof Number) {
                Number number = (Number)rv;
                return this.values[number.intValue()];
            }
            rv = args[0];
            return (T)rv;
        }
        return null;
    }
}

