/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.EclipseLinkClassWriter;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class DynamicException
extends EclipseLinkException {
    public static final int INVALID_PROPERTY_NAME = 51000;
    public static final int INVALID_PROPERTY_GET_WRONG_TYPE = 51001;
    public static final int INVALID_PROPERTY_SET_WRONG_TYPE = 51002;
    public static final int INVALID_PROPERTY_INDEX = 51003;
    public static final int ILLEGAL_DYNAMIC_CLASSWRITER = 51004;
    public static final int DYNAMIC_ENTITY_NOT_FOUND = 51005;
    public static final int DYNAMIC_ENTITY_HAS_NULL_TYPE = 51006;
    public static final int ILLEGAL_PARENT_CLASSNAME = 51007;
    public static final int INCOMPATIBLE_DYNAMIC_CLASSWRITERS = 51008;

    protected DynamicException(String message) {
        super(message);
    }

    protected DynamicException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static DynamicException invalidPropertyName(DynamicType type, String propertyName) {
        DynamicException de = new DynamicException("Invalid DynamicEntity[" + String.valueOf(type) + "] property name: " + propertyName);
        de.setErrorCode(51000);
        return de;
    }

    public static DynamicException invalidGetPropertyType(DatabaseMapping mapping, ClassCastException cce) {
        DynamicException de = new DynamicException("DynamicEntity:: Cannot return: " + String.valueOf(mapping) + ": " + cce.getMessage(), cce);
        de.setErrorCode(51001);
        return de;
    }

    public static DynamicException invalidSetPropertyType(DatabaseMapping mapping, Object value) {
        DynamicException de = new DynamicException("DynamicEntity:: Cannot set: " + String.valueOf(mapping) + " with: " + String.valueOf(value));
        de.setErrorCode(51002);
        return de;
    }

    public static DynamicException invalidPropertyIndex(DynamicType type, int propertyIndex) {
        DynamicException de = new DynamicException("Invalid DynamicEntity[" + String.valueOf(type) + "] property index: " + propertyIndex);
        de.setErrorCode(51003);
        return de;
    }

    public static DynamicException illegalDynamicClassWriter(DynamicClassLoader loader, String parentClassName) {
        DynamicException de = new DynamicException("Illegal DynamicClassWriter(" + String.valueOf(loader) + ", " + parentClassName + ")");
        de.setErrorCode(51004);
        return de;
    }

    public static DynamicException entityNotFoundException(String message) {
        DynamicException de = new DynamicException("DynamicEntity not found: " + message);
        de.setErrorCode(51005);
        return de;
    }

    public static DynamicException entityHasNullType(DynamicEntity entity) {
        DynamicException de = new DynamicException("DynamicEntity has null type: " + String.valueOf(entity));
        de.setErrorCode(51006);
        return de;
    }

    public static DynamicException illegalParentClassName(String parentClassName) {
        DynamicException de = new DynamicException("Illegal parent class name for dynamic type: " + parentClassName);
        de.setErrorCode(51007);
        return de;
    }

    public static DynamicException incompatibleDuplicateWriters(String className, EclipseLinkClassWriter existingWriter, EclipseLinkClassWriter writer) {
        DynamicException de = new DynamicException("Duplicate addClass request with incompatible writer: " + className + " - existing: " + String.valueOf(existingWriter) + " - new: " + String.valueOf(writer));
        de.setErrorCode(51008);
        return de;
    }
}

