/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.event;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.event.BufferSizeEvent;
import org.freedesktop.gstreamer.event.CapsEvent;
import org.freedesktop.gstreamer.event.EOSEvent;
import org.freedesktop.gstreamer.event.EventType;
import org.freedesktop.gstreamer.event.FlushStartEvent;
import org.freedesktop.gstreamer.event.FlushStopEvent;
import org.freedesktop.gstreamer.event.LatencyEvent;
import org.freedesktop.gstreamer.event.NavigationEvent;
import org.freedesktop.gstreamer.event.QOSEvent;
import org.freedesktop.gstreamer.event.ReconfigureEvent;
import org.freedesktop.gstreamer.event.SeekEvent;
import org.freedesktop.gstreamer.event.SegmentEvent;
import org.freedesktop.gstreamer.event.StepEvent;
import org.freedesktop.gstreamer.event.StreamStartEvent;
import org.freedesktop.gstreamer.event.TagEvent;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstEventAPI;
import org.freedesktop.gstreamer.lowlevel.ReferenceManager;
import org.freedesktop.gstreamer.lowlevel.annotations.HasSubtype;

@HasSubtype
public class Event
extends MiniObject {
    public static final String GTYPE_NAME = "GstEvent";
    private static final Map<EventType, Function<NativeObject.Initializer, Event>> TYPE_MAP = new EnumMap<EventType, Function<NativeObject.Initializer, Event>>(EventType.class);

    Event(NativeObject.Initializer init) {
        super(init);
    }

    public Structure getStructure() {
        return ReferenceManager.addKeepAliveReference(GstEventAPI.GSTEVENT_API.gst_event_get_structure(this), this);
    }

    private static Event create(NativeObject.Initializer init) {
        GstEventAPI.EventStruct struct = new GstEventAPI.EventStruct(init.ptr.getPointer());
        EventType type = (EventType)struct.readField("type");
        return TYPE_MAP.getOrDefault(type, Event::new).apply(init);
    }

    static {
        TYPE_MAP.put(EventType.BUFFERSIZE, BufferSizeEvent::new);
        TYPE_MAP.put(EventType.EOS, EOSEvent::new);
        TYPE_MAP.put(EventType.CAPS, CapsEvent::new);
        TYPE_MAP.put(EventType.RECONFIGURE, ReconfigureEvent::new);
        TYPE_MAP.put(EventType.STREAM_START, StreamStartEvent::new);
        TYPE_MAP.put(EventType.LATENCY, LatencyEvent::new);
        TYPE_MAP.put(EventType.FLUSH_START, FlushStartEvent::new);
        TYPE_MAP.put(EventType.FLUSH_STOP, FlushStopEvent::new);
        TYPE_MAP.put(EventType.NAVIGATION, NavigationEvent::new);
        TYPE_MAP.put(EventType.SEGMENT, SegmentEvent::new);
        TYPE_MAP.put(EventType.SEEK, SeekEvent::new);
        TYPE_MAP.put(EventType.TAG, TagEvent::new);
        TYPE_MAP.put(EventType.QOS, QOSEvent::new);
        TYPE_MAP.put(EventType.STEP, StepEvent::new);
    }

    public static class Types
    implements NativeObject.TypeProvider {
        @Override
        public Stream<NativeObject.TypeRegistration<?>> types() {
            return Stream.of(Natives.registration(Event.class, Event.GTYPE_NAME, x$0 -> Event.create(x$0)));
        }
    }
}

