/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.elements;

import com.sun.jna.ptr.LongByReference;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.elements.BaseSrc;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.AppAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;

public class AppSrc
extends BaseSrc {
    public static final String GST_NAME = "appsrc";
    public static final String GTYPE_NAME = "GstAppSrc";

    AppSrc(NativeObject.Initializer init) {
        super(init);
    }

    public AppSrc(String name) {
        this(AppSrc.makeRawElement(GST_NAME, name));
    }

    @Override
    public void setCaps(Caps caps) {
        AppAPI.APP_API.gst_app_src_set_caps(this, caps);
    }

    public Caps getCaps() {
        return AppAPI.APP_API.gst_app_src_get_caps(this);
    }

    public void setSize(long size) {
        AppAPI.APP_API.gst_app_src_set_size(this, size);
    }

    public long getSize() {
        return AppAPI.APP_API.gst_app_src_get_size(this);
    }

    public void setStreamType(StreamType type) {
        AppAPI.APP_API.gst_app_src_set_stream_type(this, type);
    }

    public StreamType getStreamType() {
        return AppAPI.APP_API.gst_app_src_get_stream_type(this);
    }

    public void setMaxBytes(long max) {
        AppAPI.APP_API.gst_app_src_set_max_bytes(this, max);
    }

    public long getMaxBytes() {
        return AppAPI.APP_API.gst_app_src_get_max_bytes(this);
    }

    public void setLatency(long min, long max) {
        AppAPI.APP_API.gst_app_src_set_latency(this, min, max);
    }

    public long[] getLatency() {
        LongByReference minRef = new LongByReference();
        LongByReference maxRef = new LongByReference();
        AppAPI.APP_API.gst_app_src_get_latency(this, minRef, minRef);
        return new long[]{minRef.getValue(), maxRef.getValue()};
    }

    public FlowReturn pushBuffer(Buffer buffer) {
        return AppAPI.APP_API.gst_app_src_push_buffer(this, buffer);
    }

    public FlowReturn endOfStream() {
        return AppAPI.APP_API.gst_app_src_end_of_stream(this);
    }

    public void connect(final ENOUGH_DATA listener) {
        this.connect(ENOUGH_DATA.class, listener, new GstAPI.GstCallback(){

            public void callback(AppSrc elem) {
                listener.enoughData(elem);
            }
        });
    }

    public void disconnect(ENOUGH_DATA listener) {
        this.disconnect(ENOUGH_DATA.class, listener);
    }

    public void connect(final NEED_DATA listener) {
        this.connect(NEED_DATA.class, listener, new GstAPI.GstCallback(){

            public void callback(AppSrc elem, int size) {
                listener.needData(elem, size);
            }
        });
    }

    public void disconnect(NEED_DATA listener) {
        this.disconnect(NEED_DATA.class, listener);
    }

    public void connect(final SEEK_DATA listener) {
        this.connect(SEEK_DATA.class, listener, new GstAPI.GstCallback(){

            public boolean callback(AppSrc elem, long position) {
                return listener.seekData(elem, position);
            }
        });
    }

    public void disconnect(SEEK_DATA listener) {
        this.disconnect(SEEK_DATA.class, listener);
    }

    public static enum StreamType implements NativeEnum<StreamType>
    {
        STREAM(0),
        SEEKABLE(1),
        RANDOM_ACCESS(2);

        private final int value;

        private StreamType(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }
    }

    public static interface SEEK_DATA {
        public boolean seekData(AppSrc var1, long var2);
    }

    public static interface NEED_DATA {
        public void needData(AppSrc var1, int var2);
    }

    public static interface ENOUGH_DATA {
        public void enoughData(AppSrc var1);
    }
}

