/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.gstreamer.DateTime;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.TagMergeMode;
import org.freedesktop.gstreamer.glib.GDate;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstTagAPI;
import org.freedesktop.gstreamer.lowlevel.GstTagListAPI;

public class TagList
extends MiniObject {
    public static final String GTYPE_NAME = "GstTagList";

    TagList(NativeObject.Initializer init) {
        super(init);
    }

    public TagList() {
        super(TagList.initializer());
    }

    private static NativeObject.Initializer initializer() {
        Pointer ptr_new_tag_list = GstTagListAPI.GSTTAGLIST_API.ptr_gst_tag_list_new_empty();
        return Natives.initializer(ptr_new_tag_list);
    }

    public int getValueCount(String tag) {
        return GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_tag_size(this, tag);
    }

    public List<Object> getValues(final String tag) {
        final int size = this.getValueCount(tag);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public Object get(int index) {
                return TagList.this.getValue(tag, index);
            }
        };
    }

    public Object getValue(String tag, int index) {
        TagGetter get = (TagGetter)MapHolder.getterMap.get((Object)TagList.getTagType(tag));
        return get != null ? get.get(this, tag, index) : "";
    }

    public String getString(String tag, int index) {
        return this.getValue(tag, index).toString();
    }

    public Number getNumber(String tag, int index) {
        Object data = this.getValue(tag, index);
        if (!(data instanceof Number)) {
            throw new IllegalArgumentException("Tag [" + tag + "] is not a number");
        }
        return (Number)data;
    }

    public List<String> getTagNames() {
        final LinkedList<String> list = new LinkedList<String>();
        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_foreach(this, new GstTagListAPI.TagForeachFunc(){

            @Override
            public void callback(Pointer ptr, String tag, Pointer user_data) {
                list.add(tag);
            }
        }, null);
        return list;
    }

    public TagList merge(TagList list2, TagMergeMode mode) {
        return GstTagListAPI.GSTTAGLIST_API.gst_tag_list_merge(this, list2, mode);
    }

    private static GType getTagType(String tag) {
        GType type = (GType)((Object)MapHolder.tagTypeMap.get(tag));
        if (type != null) {
            return type;
        }
        type = GstTagAPI.GSTTAG_API.gst_tag_get_type(tag);
        MapHolder.tagTypeMap.put(tag, type);
        return type;
    }

    private static final class MapHolder {
        private static final Map<GType, TagGetter> getterMap = new HashMap<GType, TagGetter>(){
            {
                this.put(GType.INT, new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        int[] value = new int[]{0};
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_int_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.UINT, new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        int[] value = new int[]{0};
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_uint_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.INT64, new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        long[] value = new long[]{0L};
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_int64_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.DOUBLE, new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        double[] value = new double[]{0.0};
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_double_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.STRING, new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        Pointer[] value = new Pointer[]{null};
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_string_index(tl, tag, index, value);
                        if (value[0] == null) {
                            return null;
                        }
                        String ret = value[0].getString(0L);
                        GlibAPI.GLIB_API.g_free(value[0]);
                        return ret;
                    }
                });
                this.put(GType.valueOf("GDate"), new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        PointerByReference value = new PointerByReference();
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_date_index(tl, tag, index, value);
                        if (value.getValue() == null) {
                            return null;
                        }
                        return Natives.objectFor(value.getValue(), GDate.class, false, true);
                    }
                });
                this.put(GType.valueOf("GstDateTime"), new TagGetter(){

                    @Override
                    public Object get(TagList tl, String tag, int index) {
                        PointerByReference value = new PointerByReference();
                        GstTagListAPI.GSTTAGLIST_API.gst_tag_list_get_date_time_index(tl, tag, index, value);
                        if (value.getValue() == null) {
                            return null;
                        }
                        return new DateTime(value.getValue(), false, true);
                    }
                });
            }
        };
        private static final Map<String, GType> tagTypeMap = new ConcurrentHashMap<String, GType>();

        private MapHolder() {
        }
    }

    private static interface TagGetter {
        public Object get(TagList var1, String var2, int var3);
    }
}

