/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.ControlBinding;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GObjectAPI;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstControlBindingPtr;
import org.freedesktop.gstreamer.lowlevel.GstObjectAPI;
import org.freedesktop.gstreamer.lowlevel.GstObjectPtr;
import org.freedesktop.gstreamer.lowlevel.GstValueAPI;

public class GstObject
extends GObject {
    private static Logger LOG = Logger.getLogger(GstObject.class.getName());
    private final Handle handle;

    protected GstObject(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstObjectPtr.class, GstObjectPtr::new), init.ownsHandle), init.needRef);
    }

    protected GstObject(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    public void setAsString(String property, String data) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        boolean success = GstValueAPI.GSTVALUE_API.gst_value_deserialize(propValue, data);
        if (success) {
            GObjectAPI.GOBJECT_API.g_param_value_validate(propertySpec, propValue);
            GObjectAPI.GOBJECT_API.g_object_set_property(this, property, propValue);
        }
        GValueAPI.GVALUE_API.g_value_unset(propValue);
        if (!success) {
            throw new IllegalArgumentException("Unable to deserialize data to required type: " + propType.getTypeName());
        }
    }

    public String getAsString(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        GObjectAPI.GOBJECT_API.g_object_get_property(this, property, propValue);
        Pointer ptr = GstValueAPI.GSTVALUE_API.gst_value_serialize(propValue);
        String ret = ptr.getString(0L);
        GlibAPI.GLIB_API.g_free(ptr);
        return ret;
    }

    private GObjectAPI.GParamSpec findProperty(String propertyName) {
        Pointer ptr = GObjectAPI.GOBJECT_API.g_object_class_find_property(this.getRawPointer().getPointer(0L), propertyName);
        if (ptr == null) {
            return null;
        }
        return new GObjectAPI.GParamSpec(ptr);
    }

    public boolean setName(String name) {
        LOG.entering("GstObject", "setName", name);
        return GstObjectAPI.GSTOBJECT_API.gst_object_set_name(this, name);
    }

    public String getName() {
        LOG.entering("GstObject", "getName");
        return GstObjectAPI.GSTOBJECT_API.gst_object_get_name(this);
    }

    public GstObject getParent() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_get_parent(this);
    }

    public long suggestNextSync() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_suggest_next_sync(this.handle.getPointer());
    }

    public boolean syncValues(long timestamp) {
        return GstObjectAPI.GSTOBJECT_API.gst_object_sync_values(this.handle.getPointer(), timestamp);
    }

    public boolean hasActiveControlBindings() {
        return GstObjectAPI.GSTOBJECT_API.gst_object_has_active_control_bindings(this.handle.getPointer());
    }

    public void setControlBindingsDisabled(boolean disabled) {
        GstObjectAPI.GSTOBJECT_API.gst_object_set_control_bindings_disabled(this.handle.getPointer(), disabled);
    }

    public void setControlBindingDisabled(String propertyName, boolean disabled) {
        GstObjectAPI.GSTOBJECT_API.gst_object_set_control_binding_disabled(this.handle.getPointer(), propertyName, disabled);
    }

    public void addControlBinding(ControlBinding binding) {
        GstControlBindingPtr bindingPtr = Natives.getPointer(binding).as(GstControlBindingPtr.class, GstControlBindingPtr::new);
        boolean ok = GstObjectAPI.GSTOBJECT_API.gst_object_add_control_binding(this.handle.getPointer(), bindingPtr);
        if (!ok) {
            throw new IllegalStateException();
        }
    }

    public ControlBinding getControlBinding(String propertyName) {
        GstControlBindingPtr ptr = GstObjectAPI.GSTOBJECT_API.gst_object_get_control_binding(this.handle.getPointer(), propertyName);
        return ptr == null ? null : Natives.callerOwnsReturn(ptr, ControlBinding.class);
    }

    public boolean removeControlBinding(ControlBinding binding) {
        GstControlBindingPtr bindingPtr = Natives.getPointer(binding).as(GstControlBindingPtr.class, GstControlBindingPtr::new);
        return GstObjectAPI.GSTOBJECT_API.gst_object_remove_control_binding(this.handle.getPointer(), bindingPtr);
    }

    @Override
    public String toString() {
        return String.format("%s: [%s]", this.getClass().getSimpleName(), this.getName());
    }

    protected static class Handle
    extends GObject.Handle {
        public Handle(GstObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void ref() {
            GstObjectAPI.GSTOBJECT_API.gst_object_ref(this.getPointer());
        }

        @Override
        protected void sink() {
            GstObjectAPI.GSTOBJECT_API.gst_object_ref_sink(this.getPointer());
        }

        @Override
        protected void unref() {
            GstObjectAPI.GSTOBJECT_API.gst_object_unref(this.getPointer());
        }

        @Override
        protected GstObjectPtr getPointer() {
            return (GstObjectPtr)super.getPointer();
        }
    }
}

