/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableSet;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;

public interface SpreadsheetCell {
    public static final EventType<Event> EDITABLE_EVENT_TYPE = new EventType("EditableEventType" + UUID.randomUUID().toString());
    public static final EventType<Event> WRAP_EVENT_TYPE = new EventType("WrapTextEventType" + UUID.randomUUID().toString());
    public static final EventType<Event> CORNER_EVENT_TYPE = new EventType("CornerEventType" + UUID.randomUUID().toString());

    public boolean match(Object var1);

    public void setItem(Object var1);

    public Object getItem();

    public ObjectProperty<Object> itemProperty();

    public boolean isEditable();

    public void setEditable(boolean var1);

    public boolean isWrapText();

    public boolean isCellGraphic();

    public void setCellGraphic(boolean var1);

    public void setWrapText(boolean var1);

    public List<Object> getOptionsForEditor();

    public boolean hasPopup();

    public void setHasPopup(boolean var1);

    public List<MenuItem> getPopupItems();

    public void setStyle(String var1);

    public String getStyle();

    public StringProperty styleProperty();

    public void activateCorner(CornerPosition var1);

    public void deactivateCorner(CornerPosition var1);

    public boolean isCornerActivated(CornerPosition var1);

    public StringProperty formatProperty();

    public String getFormat();

    public void setFormat(String var1);

    public ReadOnlyStringProperty textProperty();

    public String getText();

    public SpreadsheetCellType getCellType();

    public int getRow();

    public int getColumn();

    public int getRowSpan();

    public void setRowSpan(int var1);

    public int getColumnSpan();

    public void setColumnSpan(int var1);

    public ObservableSet<String> getStyleClass();

    public ObjectProperty<Node> graphicProperty();

    public void setGraphic(Node var1);

    public Node getGraphic();

    public Optional<String> getTooltip();

    public <E extends Event> void addEventHandler(EventType<E> var1, EventHandler<? super E> var2);

    public <E extends Event> void removeEventHandler(EventType<E> var1, EventHandler<? super E> var2);

    public static enum CornerPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }
}

