/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.documentgroup;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.documentgroup.DocumentGroupImpl;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GroupsManager {
    private static GroupsManager theInstance;
    private static final String SEL_GROUP = "selectedDocumentGroup";
    private static final String DEFAULT_GROUP_NAME = "group";
    private static final String DISPLAY_NAME = "displayName";
    private static final String CONFIG = "config";
    private static final String SETTINGS = "settings";
    private static final String WSMODE = "wsmode";
    private static final String WINDOWS2_LOCAL = "Windows2Local";
    private static final String COMPONENTS = "Components";
    private static final String MODES = "Modes";
    private static final String DOCUMENT_GROUPS = "DocumentGroups";
    private static final String ID_SEPARATOR = ":";
    private static final String SELECTED_ID = "_selectedId";
    private static final Logger LOG;

    private GroupsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupsManager getDefault() {
        Class<GroupsManager> clazz = GroupsManager.class;
        synchronized (GroupsManager.class) {
            if (null == theInstance) {
                theInstance = new GroupsManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    void addGroup(String displayName) {
        Preferences prefs = GroupsManager.getPreferences();
        int groupIndex = this.getGroups().size();
        String groupName = DEFAULT_GROUP_NAME + groupIndex;
        try {
            while (prefs.nodeExists(groupName = DEFAULT_GROUP_NAME + ++groupIndex)) {
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        prefs.put(SEL_GROUP, groupName);
        prefs.node(groupName).put(DISPLAY_NAME, displayName);
    }

    void removeAllGroups() {
        List<DocumentGroupImpl> groups = this.getGroups();
        for (DocumentGroupImpl group : groups) {
            this.removeGroup(group);
        }
    }

    DocumentGroupImpl getCurrentGroup() {
        String selGroupName = GroupsManager.getPreferences().get(SEL_GROUP, "");
        return selGroupName.isEmpty() ? null : this.createGroup(selGroupName);
    }

    private DocumentGroupImpl createGroup(String groupName) {
        Preferences prefs = GroupsManager.getPreferences().node(groupName);
        String displayName = prefs.get(DISPLAY_NAME, groupName);
        return new DocumentGroupImpl(groupName, displayName);
    }

    List<DocumentGroupImpl> getGroups() {
        Preferences prefs = GroupsManager.getPreferences();
        try {
            String[] names = prefs.childrenNames();
            ArrayList<DocumentGroupImpl> res = new ArrayList<DocumentGroupImpl>(names.length);
            for (String name : names) {
                res.add(this.createGroup(name));
            }
            Collections.sort(res);
            return res;
        }
        catch (BackingStoreException e) {
            LOG.log(Level.INFO, null, e);
            return Collections.emptyList();
        }
    }

    static Preferences getPreferences() {
        return NbPreferences.forModule(DocumentGroupImpl.class).node(DOCUMENT_GROUPS);
    }

    /*
     * WARNING - void declaration
     */
    boolean openGroup(DocumentGroupImpl group) {
        DocumentGroupImpl current = this.getCurrentGroup();
        if (null != current && !current.close()) {
            return false;
        }
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        for (Object tc : TopComponent.getRegistry().getOpened()) {
            if (!wmi.isEditorTopComponent((TopComponent)tc) || tc.close()) continue;
            return false;
        }
        ArrayList<ModeImpl> emptyModes = new ArrayList<ModeImpl>(10);
        for (ModeImpl modeImpl : wmi.getModes()) {
            if (modeImpl.isPermanent() || modeImpl.getKind() != 1 || !modeImpl.getOpenedTopComponentsIDs().isEmpty()) continue;
            emptyModes.add(modeImpl);
        }
        for (ModeImpl modeImpl : emptyModes) {
            wmi.removeMode(modeImpl);
        }
        String name = group.getName();
        Preferences preferences = GroupsManager.getPreferences().node(name);
        File userDir = Places.getUserDirectory();
        File root = new File(new File(userDir, CONFIG), DOCUMENT_GROUPS);
        File groupDir = new File(root, name);
        FileObject groupFO = FileUtil.toFileObject((File)groupDir);
        if (null != groupFO) {
            void var18_30;
            HashMap<ModeImpl, ModeConfig> mode2config = new HashMap<ModeImpl, ModeConfig>(10);
            HashMap<String, ModeImpl> tcid2mode = new HashMap<String, ModeImpl>(50);
            for (FileObject fileObject : groupFO.getChildren()) {
                if (!fileObject.isData() || !WSMODE.equals(fileObject.getExt())) continue;
                try {
                    String[] ids;
                    ModeConfig config = WindowManagerParser.loadModeConfigFrom(fileObject);
                    String string = preferences.get(config.name, "");
                    if (string.isEmpty()) continue;
                    ModeImpl mode = (ModeImpl)wmi.findMode(config.name);
                    if (null == mode) {
                        mode = this.createMode(config);
                    } else {
                        mode.setConstraints(config.constraints);
                    }
                    mode2config.put(mode, config);
                    for (String id : ids = string.split(ID_SEPARATOR)) {
                        tcid2mode.put(id, mode);
                        mode.addUnloadedTopComponent(id);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
            DataLoader settingsLoader = null;
            Enumeration loaders = DataLoaderPool.getDefault().producersOf(InstanceDataObject.class);
            while (loaders.hasMoreElements()) {
                settingsLoader = (DataLoader)loaders.nextElement();
            }
            HashMap<String, TopComponent> id2tc = new HashMap<String, TopComponent>(50);
            FileObject[] fileObjectArray = groupFO.getChildren();
            int n = fileObjectArray.length;
            boolean bl = false;
            while (var18_30 < n) {
                FileObject fo = fileObjectArray[var18_30];
                if (fo.isData() && SETTINGS.equals(fo.getExt())) {
                    try {
                        DataLoaderPool.setPreferredLoader((FileObject)fo, (DataLoader)settingsLoader);
                        DataObject dob = DataObject.find((FileObject)fo);
                        DataLoaderPool.setPreferredLoader((FileObject)fo, null);
                        InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                        if (null != ic) {
                            TopComponent tc = (TopComponent)ic.instanceCreate();
                            id2tc.put(fo.getName(), tc);
                        } else {
                            String excAnnotation = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_BrokenTCSetting", (Object)fo.getName());
                            LOG.log(Level.INFO, "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + fo.getName() + "'. Reason: " + excAnnotation);
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
                ++var18_30;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(id2tc.size());
            for (Map.Entry entry : id2tc.entrySet()) {
                String oldId = (String)entry.getKey();
                TopComponent tc = (TopComponent)entry.getValue();
                ModeImpl mode = (ModeImpl)tcid2mode.get(oldId);
                if (null != mode) {
                    mode.dockInto(tc);
                }
                tc.open();
                hashMap.put(oldId, wmi.findTopComponentID(tc));
            }
            for (ModeImpl modeImpl : wmi.getModes()) {
                TopComponent tc;
                ModeConfig config = (ModeConfig)mode2config.get(modeImpl);
                if (null == config) continue;
                String selectedId = config.selectedTopComponentID;
                if (null != selectedId) {
                    selectedId = (String)hashMap.get(selectedId);
                }
                if (null == selectedId || !modeImpl.getOpenedTopComponentsIDs().contains(selectedId) || null == (tc = wmi.findTopComponent(selectedId))) continue;
                modeImpl.setSelectedTopComponent(tc);
            }
        }
        GroupsManager.getPreferences().put(SEL_GROUP, group.getName());
        return true;
    }

    boolean closeGroup(DocumentGroupImpl group) {
        TopComponent welcomeTc = WindowManager.getDefault().findTopComponent("Welcome");
        boolean welcomeWasOpened = null != welcomeTc && welcomeTc.isOpened();
        ((WindowSystem)Lookup.getDefault().lookup(WindowSystem.class)).save();
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        ArrayList<TopComponent> documents = new ArrayList<TopComponent>(TopComponent.getRegistry().getOpened().size());
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            if (!wmi.isEditorTopComponent(tc)) continue;
            documents.add(tc);
        }
        String name = group.getName();
        File userDir = Places.getUserDirectory();
        File root = new File(new File(userDir, CONFIG), DOCUMENT_GROUPS);
        File groupDir = new File(root, name);
        GroupsManager.deleteAll(groupDir);
        groupDir.mkdirs();
        FileObject groupFO = FileUtil.toFileObject((File)groupDir);
        Preferences prefs = GroupsManager.getPreferences().node(name);
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        prefs.put(DISPLAY_NAME, group.toString());
        File configRoot = new File(new File(Places.getUserDirectory(), CONFIG), WINDOWS2_LOCAL);
        File modesRoot = new File(configRoot, MODES);
        for (ModeImpl modeImpl : wmi.getModes()) {
            String modeName;
            FileObject modeFO;
            if (modeImpl.getKind() != 1 || null == (modeFO = FileUtil.toFileObject((File)new File(modesRoot, (modeName = modeImpl.getName()) + ".wsmode")))) continue;
            try {
                modeFO.copy(groupFO, modeName, WSMODE);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (String id : modeImpl.getOpenedTopComponentsIDs()) {
                sb.append(id);
                sb.append(ID_SEPARATOR);
            }
            prefs.put(modeName, sb.toString());
        }
        File componentRoot = new File(configRoot, COMPONENTS);
        for (TopComponent tc : documents) {
            FileObject tcFO;
            String id = wmi.findTopComponentID(tc);
            if (tc.equals(welcomeTc) && !welcomeWasOpened || tc.getPersistenceType() == 2 || (tcFO = FileUtil.toFileObject((File)new File(componentRoot, id + ".settings"))) == null) continue;
            try {
                tcFO.copy(groupFO, id, SETTINGS);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        GroupsManager.getPreferences().put(SEL_GROUP, "");
        return true;
    }

    private ModeImpl createMode(ModeConfig config) {
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        ModeImpl res = wmi.createMode(config.name, config.kind, config.state, false, config.constraints);
        Rectangle absBounds = config.bounds == null ? new Rectangle() : config.bounds;
        Rectangle relBounds = config.relativeBounds == null ? new Rectangle() : config.relativeBounds;
        Rectangle bounds = PersistenceHandler.computeBounds(false, false, absBounds.x, absBounds.y, absBounds.width, absBounds.height, (float)relBounds.x / 100.0f, (float)relBounds.y / 100.0f, (float)relBounds.width / 100.0f, (float)relBounds.height / 100.0f);
        res.setBounds(bounds);
        res.setFrameState(config.frameState);
        res.setMinimized(config.minimized);
        return res;
    }

    void removeGroup(DocumentGroupImpl group) {
        try {
            Preferences prefs = GroupsManager.getPreferences();
            if (group.getName().equals(prefs.get(SEL_GROUP, ""))) {
                prefs.put(SEL_GROUP, "");
            }
            prefs = prefs.node(group.getName());
            prefs.removeNode();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to remove document group '" + group.toString() + "'", e);
        }
    }

    private static void deleteAll(File dir) {
        File[] dirContents = dir.listFiles();
        if (null == dirContents) {
            return;
        }
        for (File f : dirContents) {
            if (f.isDirectory()) {
                GroupsManager.deleteAll(f);
            }
            f.delete();
        }
    }

    static boolean closeAllDocuments() {
        TopComponent[] tcs;
        for (TopComponent tc : tcs = WindowManagerImpl.getInstance().getEditorTopComponents()) {
            if (!Switches.isClosingEnabled(tc)) continue;
            tc.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
            if (tc.close()) continue;
            return false;
        }
        return true;
    }

    static {
        LOG = Logger.getLogger(GroupsManager.class.getName());
    }
}

