function descriptor()

  return { title = "Scenerixx VLC Bridge",
    version = "0.2",
    author = "ScenerixxDev",
    url = "www.scenerixx.com",
	shortdesc = "Scenerixx VLC Bridge - More",
	description = "This plugin is a bridge into your local Scenerixx installation",
	capabilities = {"menu", "input-listener", "meta-listener", "playing-listener"},
  }
end

function get(url)
  vlc.msg.dbg("passed url: "..url)
  local u = vlc.net.url_parse(url)
  vlc.msg.dbg("passed options: "..u["option"])
  local host, port, path, params = u["host"], u["port"], u["path"], u["option"]
  local header = {
    "GET "..path.."?"..params.." HTTP/1.1",
    "Host: "..host,
    "",
    ""
  }
  --vlc.msg.dbg("header: "..header)
  local request = table.concat(header, "\r\n")
  vlc.msg.dbg("request: "..request)
  return http_req(host, port, request)
end

function http_req(host, port, request)
  vlc.msg.dbg("host "..host)
  vlc.msg.dbg("port "..port)
  vlc.msg.dbg("request "..request)
  local fd = vlc.net.connect_tcp(host, port)
  if not fd then return false end
  local pollfds = {}

  pollfds[fd] = vlc.net.POLLIN
  vlc.net.send(fd, request)
  vlc.net.poll(pollfds)

vlc.msg.dbg("start receivingX")
  local chunk = vlc.net.recv(fd, 2048)
  vlc.msg.dbg("chunk: "..chunk)
---  while chunk do
---    vlc.msg.dbg("chunk "..chunk)
---    chunk = vlc.net.poll(pollfds)
    --chunk = vlc.net.recv(fd, 1024)
	  --  vlc.net.poll(pollfds)
---  end
	for i = 1,10,1 
	do 
	--	vlc.net.poll(pollfds)
	end
  vlc.msg.dbg("close now ")
  vlc.net.close(fd)
  return chunk
end

function activate()
vlc.msg.dbg("activate")
  return true
end

function getFormatedTime()
  local duration = getTimePassed()
  duration = duration / 1000 / 1000
  vlc.msg.dbg("duration raw: "..duration)
  --globalstart = duration
  
  local formatedTime = string.format("%02d:%02d:%02d",
                         math.floor(duration/3600),
                         math.floor(duration/60)%60,
                         math.floor(duration%60))
						 	
							vlc.msg.dbg("hi: "..formatedTime)
	if (formatedTime == nil) then
		return -1
	else
		return formatedTime	
	end
end

function getCurrentFile()
		local item = vlc.input.item()
		local uri = item:uri()
		vlc.msg.dbg("current uri: "..uri)
		uri = string.gsub(uri, '&', '%%26')
		uri = string.gsub(uri, '^file:///', '')
		uri = string.gsub(uri, '\\', '\\\\')
		vlc.msg.dbg("current file "..uri)
		return uri
end

function close()
  vlc.msg.dbg("[Scenerixx Bridge] Close")
end

function deactivate()

  local duration = getTimePassed()
  duration = duration / 1000 / 1000
  vlc.msg.dbg("time passed on deactivation: "..duration)
end

function menu()
    -- related to capabilities={"menu"} in descriptor()
    -- menu occurs in VLC menu: View > Extension title > ...
    return {
	"Add scene starting at current position", 
	"Set end time for scene", 
	"Add bookmark starting at current position", 
	"Set end time for bookmark"
	}
end

-- Function triggered when an element from the menu is selected
function trigger_menu(id)
    if(id == 1) then
		addScene()
    elseif(id == 2) then
		setSceneEndtime()
    elseif(id == 3) then
		addBookmark()
    elseif(id == 4) then
		setBookmarkEndtime()
    end
end

function addScene()
    vlc.msg.dbg("add scene: "..getFormatedTime())
    local res = get("http://localhost:7679/api/v1/addScene?filename="..getCurrentFile().."&time="..getFormatedTime())
    if(string.find(res, "Added scene ")) then
        vlc.osd.message("Added scene at "..getFormatedTime())
    else
	vlc.osd.message("An error occured - Could not find movie")
    end
end

function setSceneEndtime()
    vlc.msg.dbg("set scene endtime: "..getFormatedTime())
    local res = get("http://localhost:7679/api/v1/setSceneEndTime?filename="..getCurrentFile().."&time="..getFormatedTime())
    if(string.find(res, "Set end time on scene")) then
        vlc.osd.message("Added scene endtime at "..getFormatedTime())
    else
	vlc.osd.message("An error occured - probably no start time set yet")
    end
end

function addBookmark()
    vlc.msg.dbg("add bookmark: "..getFormatedTime())
    local res = get("http://localhost:7679/api/v1/addBookmark?filename="..getCurrentFile().."&time="..getFormatedTime())
    if(string.find(res, "Added bookmark to")) then
        vlc.osd.message("Added bookmark at "..getFormatedTime())
    else
	vlc.osd.message("An error occured - Scene or movie not found")		
    end
end

function setBookmarkEndtime()
    vlc.msg.dbg("set bookmark endtime: "..getFormatedTime())
    local res = get("http://localhost:7679/api/v1/setBookmarkEndTime?filename="..getCurrentFile().."&time="..getFormatedTime())
    if(string.find(res, "Set end time on bookmark")) then
        vlc.osd.message("Added bookmark endtime at "..getFormatedTime())
    else
	vlc.osd.message("An error occured - probably no start time set yet")		
    end
end

function getTimePassed()
    if (vlc.object.input() == nil) then
	return -1
    else
        return vlc.var.get(vlc.object.input(), "time")
    end
end

function input_changed()
   -- related to capabilities={"input-listener"} in descriptor()
   -- triggered by Start/Stop media input event
   vlc.msg.dbg("input changed " .. vlc.playlist.status())
end

function playing_changed()
   -- related to capabilities={"playing-listener"} in descriptor()
   -- triggered by Pause/Play madia input event
	vlc.msg.dbg("playing changed " .. vlc.playlist.status())
end

function meta_changed()
	vlc.msg.dbg("meta changed " .. vlc.playlist.status())
end