(function ($) {
    var f_name = 'movie_slider';

    $.fn.init[f_name] = function (element, options) {
        var original_width = 0;
        if ($(window).width() > 400) {
//            original_width = '250px';
            original_width = '90%';
        } else {
//            original_width = '200px';
            original_width = '80%';
        }
        var def = {
            width: false,
            ratio: 1,
            url: [],
            width: original_width
        };
        options = $.extend(def, options);
        var e_width = options['width'];
        var parent = $(element);
        var elements = parent.find('.element');
        var videourl = new Array();

        for (let i = 0; i < elements.length; i++) {
            let el = $(elements[i]);
            let source = el.find("video source").get(0);
//            let source = el.find("video").get(0);
            videourl.push(source.src);
        }
        const delay = 600;

        if (elements.length > 0 && videourl.length > 0) {
            let activated_netflix_function = false;
            function remove_active_description(search_div) {
                let find_active_popup = $(".video_description.active");
                if (find_active_popup.length > 0) {
                    let video = find_active_popup.find("video").get(0);
                    video.pause();
                    find_active_popup.removeClass("active");
                }
                search_div.addClass("active");
            }
            function remove_active_element(el) {
                let find_active_popup = $(".element.n_focus");
                find_active_popup.data("activated", false);
                if (find_active_popup.length > 0) {
                    find_active_popup.removeClass("n_focus");
                }
                el.addClass("n_focus");
            }
            function control_element_actions(el, id) {
                el.data("activated", false);
                el.data("fromtop", el.offset().top - parseFloat(el.parent().css("marginTop")));
                let search_div = $(".video_description[tg=" + id + "]");
                let isMute = false;
                let theVideo;
                let theVideoSrc;
                let muteButton;
                if (search_div.length > 0) {
                    theVideo = search_div.find("video");
                    muteButton = search_div.find(".v_pause");
                    theVideoSrc = theVideo.find('source')[0];
                    theVideo = theVideo[0];
                    muteButton.click(function (e) {
                        e.stopPropagation();
                        $(this).toggleClass("mute");
                        if (!isMute) {
                            isMute = true;
                            theVideo.volume = 0;
                        } else {
                            isMute = false;
                            theVideo.volume = 1;
                        }
                    });
                }
                function activate() {

                    el.data("activated", true);
                    remove_active_element(el);
                    remove_active_description(search_div);

                    if (search_div.length > 0) {
                        let fromtop = el.data("fromtop");
                        $("html,document").animate({
                            scrollTop: fromtop + "px"
                        }, 500);
                        //remove_active_description();
                        search_div.addClass("active");
                        el.data("video").pause();
                        el.data("video").volume = 0;

                        let audio = el.data("audio");
                        audio.hide();

                        try {
                            let rgexp = new RegExp(window.location.href);
                            if (rgexp.test(theVideoSrc.src)) {
                                theVideoSrc.src = el.data("videoSrc");
                                theVideo.load();
                            } else {
                                theVideo.play();
                                theVideo.currentTime = el.data("video").currentTime;

                                if (isMute) {
                                    muteButton.click();
                                }
                            }

                            theVideo.addEventListener("timeupdate", function () {
                                el.data("where", this.currentTime);
                            });
                            let time = el.data("video").currentTime;
                            let firstTime = true;
                            theVideo.addEventListener('canplay', function () {

                                if (firstTime) {
                                    firstTime = false;
                                    $(this).click();
                                    this.play();
                                    this.currentTime = time;
                                    this.volume = 1;
                                }

                            });
                        } catch (e) {
                            console.log(e);
                        }
                        //always starts video from time 0
                        el.data("videoSrc", theVideoSrc);
                        el.data('video', theVideo[0]);
                        let close_button = search_div.find(".close");
                        close_button.click(function () {
                            el.removeClass("n_focus");
                            search_div.removeClass("active");
                            activated_netflix_function = false;
                            theVideo.pause();
                            el.data("activated", false);
                            el.mouseleave();
                        });


                        // request fullscreen
                        let playbutton = search_div.find(".text_container").find(".actions_container").find(".play_button");
                        $(playbutton).click(function () {
                            let find_active_popup = $(".video_description.active");
                            if (find_active_popup.length > 0) {
                                let video = find_active_popup.find("video").get(0);
                                // show controls in fullscreen
                                video.setAttribute('controls', true);
                                if (video.requestFullscreen) {
                                    video.requestFullscreen();
                                } else if (video.mozRequestFullScreen) {
                                    video.mozRequestFullScreen();
                                } else if (video.webkitRequestFullscreen) {
                                    video.webkitRequestFullscreen();
                                } else if (video.msRequestFullscreen) {
                                    video.msRequestFullscreen();
                                }
                            } else
                            {
                                // hide controls if not in fullscreen
                                video.setAttribute('controls', false);
                            }

                        });

                        let y = el.data("fromtop") - 4
                        let height = parseFloat(el.height());
                        let top = y + height + "px";
                        search_div.css({
                            top: top
                        });
                    }
                }

                let down_array = el.find(".description");
                $(down_array).click(function () {
                    el.mouseleave();
                    if (!activated_netflix_function) {
                        activated_netflix_function = true;
                        activate();
                    }
                });

                el.on("mouseover", function () {
                    if (activated_netflix_function) {
                        if (el.data("activated") == false) {
                            let fromtop = el.data("fromtop");
                            $("html,document").animate({
                                scrollTop: fromtop + "px"
                            }, 500);
                            activate();
                        }
                    }
                });
            }
            $.each(elements, function (j, e) {
                var el = $(e);
                el.css('width', e_width);
                el.data('firstHover', true);
                el.data("isLoadedVideo", false);
                el.data("where", 0);
                el.data("volume", false);
                let audio = el.find(".audio");
                el.data("audio", audio);
                let id = parseInt(el.attr("tg"));
                control_element_actions(el, id);
                el.data('ishover', false);
                audio.on("click", function () {
                    let video = $(this).parent().parent().find("video").get(0);
                    let n_class = $(this).attr("class");
                    if (n_class.indexOf("mute") >= 0) {
                        audio.removeClass("mute");
                        video.volume = 1;
                    } else {
                        audio.addClass("mute");
                        video.volume = 0;
                    }
                });
                el.on('mouseover', function () {
                    if (!activated_netflix_function) {
                        var firstHover = $(this).data('firstHover');
                        if (firstHover) {
                            $(this).data('firstHover', false);
                            $(this).data('v_preloader').show(0);
                            try {
                                $(this).data('video').load();
                            } catch (e) {
                            }
                        }
                        let audio = $(this).data("audio");
                        audio.show();
                        if (!activated_netflix_function) {
                            try {
                                let n_class = audio.attr("class");
                                if (n_class.indexOf("mute") >= 0) {
                                    audio.removeClass("mute");
                                }
                                let video = $(this).data("video");
                                video.volume = 1;
                                let volume = $(this).data("volume");
                                let ctx = $(this);
                                if ($(this).data("isLoadedVideo")) {

                                    let p = window.setInterval(function () {
                                        window.clearInterval(p);

                                        if (!volume) {
                                            video.play();
                                            ctx.data("volume", true);
                                        }
                                    }, 800);
                                }
                            } catch (e) {
                            }
                        }

                        var ishover = $(this).data('ishover');
                        if (!ishover) {
                            $(this).addClass('focus');
                            $(this).data('ishover', true);

                        }
                    }
                });
                el.on('mouseleave', function () {
                    var ishover = $(this).data('ishover');
                    if (!activated_netflix_function) {
                        let video = $(this).data("video");
                        let seconds = $(this).data("where");
                        let ctx = $(this);
                        let t = window.setTimeout(function () {
                            video.pause();
                            ctx.data("volume", false);
                        }, 1000);

                        if (seconds > 0) {
                            video.currentTime = seconds;
                        }
                        if ($(this).data("isLoadedVideo")) {

                            video.volume = 0;
                            try {
                                let audio = $(this).data("audio");
                                let n_class = audio.attr("class");
                                if (n_class.indexOf("mute") < 0) {
                                    audio.addClass("mute");
                                }
                                audio.show();
                            } catch (e) {
                            }
                        }
                    }
                    if (ishover) {
                        $(this).removeClass('focus');
                        $(this).data('ishover', false);
                    }
                });
                var video_container = el.find('.video_container');

//                video_container.on("show keydown", function (event) {
//                    console.info("Kkkkkey down")
//                    if (event.code === 'Escape') {
//remove_active_description(search_div);
////                        let close_button = search_div.find(".close");
////                        close_button.click();
//
//                        console.info("Keydown");
//
//                    }
//
//                });
//
//
//
//
                // on doubleclick request fullscreen
                video_container.dblclick(function () {
                    let video = video_container.find('video');
                    video = video[0];
                    // show controls in fullscreen
                    video.setAttribute('controls', true);
                    if (video.requestFullscreen) {
                        video.requestFullscreen();
                    } else if (video.mozRequestFullScreen) {
                        video.mozRequestFullScreen();
                    } else if (video.webkitRequestFullscreen) {
                        video.webkitRequestFullscreen();
                    } else if (video.msRequestFullscreen) {
                        video.msRequestFullscreen();
                    }
                });



                var theVideo = video_container.find('video');
                var theVideoSrc = theVideo.find('source');
                el.data("videoSrc", videourl[j]);
                el.data('video', theVideo[0]);
                theVideoSrc[0].src = videourl[j];
                let first_time = true;
                theVideo = theVideo[0];
                var v_preloader = el.find('.v_preloader');
                el.data('v_preloader', v_preloader);
                theVideo.addEventListener('canplay', function () {

                    $(this).click();
                    if (first_time) {
                        first_time = false;

                        try {
                            this.play();
                        } catch (e) {
                        }
                    }

                    var p = $(this).parent().parent();

                    p.data('v_preloader').fadeOut(200);
                    p.data("isLoadedVideo", true);
                });

            });
        }
    };

    $.fn[f_name] = function (options) {
        return this.each(function () {
            if (!$.data(this, f_name)) {
                $.data(this, f_name, new $.fn.init[f_name](this, options));
            }
        });
    }
}(jQuery));


$(document).ready(function () {
    $('.slider').movie_slider();
});