/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.controller;

import org.freedesktop.gstreamer.ControlSource;
import org.freedesktop.gstreamer.controller.LFOWaveform;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstControllerAPI;
import org.freedesktop.gstreamer.lowlevel.GstLFOControlSourcePtr;

public class LFOControlSource
extends ControlSource {
    public static final String GTYPE_NAME = "GstLFOControlSource";

    public LFOControlSource() {
        this(new Handle(GstControllerAPI.GSTCONTROLLER_API.gst_lfo_control_source_new(), true), false);
    }

    LFOControlSource(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstLFOControlSourcePtr.class, GstLFOControlSourcePtr::new), init.ownsHandle), init.needRef);
    }

    private LFOControlSource(Handle handle, boolean needRef) {
        super(handle, needRef);
    }

    public LFOControlSource setAmplitude(double value) {
        this.set("amplitude", value);
        return this;
    }

    public double getAmplitude() {
        Object val = this.get("amplitude");
        if (val instanceof Double) {
            return (Double)val;
        }
        return 1.0;
    }

    public LFOControlSource setFrequency(double value) {
        this.set("frequency", value);
        return this;
    }

    public double getFrequency() {
        Object val = this.get("frequency");
        if (val instanceof Double) {
            return (Double)val;
        }
        return 1.0;
    }

    public LFOControlSource setOffset(double value) {
        this.set("offset", value);
        return this;
    }

    public double getOffset() {
        Object val = this.get("offset");
        if (val instanceof Double) {
            return (Double)val;
        }
        return 1.0;
    }

    public LFOControlSource setTimeshift(long value) {
        this.set("timeshift", value);
        return this;
    }

    public long getTimeshift() {
        Object val = this.get("timeshift");
        if (val instanceof Long) {
            return (Long)val;
        }
        return 1L;
    }

    public LFOControlSource setWaveform(LFOWaveform value) {
        this.set("waveform", value.intValue());
        return this;
    }

    public LFOWaveform getWaveform() {
        Object val = this.get("waveform");
        if (val instanceof Integer) {
            int nativeInt = (Integer)val;
            return NativeEnum.fromInt(LFOWaveform.class, nativeInt);
        }
        return LFOWaveform.SINE;
    }

    private static class Handle
    extends ControlSource.Handle {
        public Handle(GstLFOControlSourcePtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }
    }
}

