/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.BusSyncHandler;
import org.freedesktop.gstreamer.BusSyncReply;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.TagList;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.lowlevel.GstBusAPI;
import org.freedesktop.gstreamer.lowlevel.GstBusPtr;
import org.freedesktop.gstreamer.lowlevel.GstMessageAPI;
import org.freedesktop.gstreamer.lowlevel.GstMessagePtr;
import org.freedesktop.gstreamer.lowlevel.GstMiniObjectAPI;
import org.freedesktop.gstreamer.message.Message;
import org.freedesktop.gstreamer.message.MessageType;

public class Bus
extends GstObject {
    public static final String GTYPE_NAME = "GstBus";
    private static final Logger LOG = Logger.getLogger(Bus.class.getName());
    private static final SyncCallback SYNC_CALLBACK = new SyncCallback();
    private volatile BusSyncHandler syncHandler = null;
    private final Object lock = new Object();
    private final List<MessageProxy<?>> messageProxies = new CopyOnWriteArrayList();
    private boolean watchAdded = false;

    Bus(NativeObject.Initializer init) {
        super(init);
        GstBusAPI.GSTBUS_API.gst_bus_set_sync_handler(this, null, null, null);
        GstBusAPI.GSTBUS_API.gst_bus_set_sync_handler(this, SYNC_CALLBACK, null, null);
    }

    public void setFlushing(boolean flushing) {
        GstBusAPI.GSTBUS_API.gst_bus_set_flushing(this, flushing ? 1 : 0);
    }

    public void connect(final EOS listener) {
        this.connect((Class)EOS.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                listener.endOfStream(Natives.objectFor(msg.getSource(), GstObject.class, true, true));
                return true;
            }
        });
    }

    public void disconnect(EOS listener) {
        this.disconnect(EOS.class, listener);
    }

    public void connect(final ERROR listener) {
        this.connect((Class)ERROR.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_error(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.errorMessage(source, error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(ERROR listener) {
        this.disconnect(ERROR.class, listener);
    }

    public void connect(final WARNING listener) {
        this.connect((Class)WARNING.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_warning(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.warningMessage(source, error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(WARNING listener) {
        this.disconnect(WARNING.class, listener);
    }

    public void connect(final INFO listener) {
        this.connect((Class)INFO.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_info(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.infoMessage(source, error.getCode(), error.getMessage());
                GlibAPI.GLIB_API.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(INFO listener) {
        this.disconnect(INFO.class, listener);
    }

    public void connect(final STATE_CHANGED listener) {
        this.connect((Class)STATE_CHANGED.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                IntByReference oldPtr = new IntByReference();
                IntByReference currentPtr = new IntByReference();
                IntByReference pendingPtr = new IntByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_state_changed(msg, oldPtr, currentPtr, pendingPtr);
                State old = NativeEnum.fromInt(State.class, oldPtr.getValue());
                State current = NativeEnum.fromInt(State.class, currentPtr.getValue());
                State pending = NativeEnum.fromInt(State.class, pendingPtr.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.stateChanged(source, old, current, pending);
                return true;
            }
        });
    }

    public void disconnect(STATE_CHANGED listener) {
        this.disconnect(STATE_CHANGED.class, listener);
    }

    public void connect(final TAG listener) {
        this.connect((Class)TAG.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                PointerByReference list = new PointerByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_tag(msg, list);
                TagList tl = new TagList(Natives.initializer(list.getValue()));
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.tagsFound(source, tl);
                return true;
            }
        });
    }

    public void disconnect(TAG listener) {
        this.disconnect(TAG.class, listener);
    }

    public void connect(final BUFFERING listener) {
        this.connect((Class)BUFFERING.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                IntByReference percent = new IntByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_buffering(msg, percent);
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.bufferingData(source, percent.getValue());
                return true;
            }
        });
    }

    public void disconnect(BUFFERING listener) {
        this.disconnect(BUFFERING.class, listener);
    }

    public void connect(final DURATION_CHANGED listener) {
        this.connect((Class)DURATION_CHANGED.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.durationChanged(source);
                return true;
            }
        });
    }

    public void disconnect(DURATION_CHANGED listener) {
        this.disconnect(DURATION_CHANGED.class, listener);
    }

    public void connect(final SEGMENT_START listener) {
        this.connect((Class)SEGMENT_START.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                IntByReference formatPtr = new IntByReference();
                LongByReference positionPtr = new LongByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_segment_start(msg, formatPtr, positionPtr);
                Format format = NativeEnum.fromInt(Format.class, formatPtr.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.segmentStart(source, format, positionPtr.getValue());
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_START listener) {
        this.disconnect(SEGMENT_START.class, listener);
    }

    public void connect(final SEGMENT_DONE listener) {
        this.connect((Class)SEGMENT_DONE.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                IntByReference formatPtr = new IntByReference();
                LongByReference positionPtr = new LongByReference();
                GstMessageAPI.GSTMESSAGE_API.gst_message_parse_segment_done(msg, formatPtr, positionPtr);
                Format format = NativeEnum.fromInt(Format.class, formatPtr.getValue());
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.segmentDone(source, format, positionPtr.getValue());
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_DONE listener) {
        this.disconnect(SEGMENT_DONE.class, listener);
    }

    public void connect(final ASYNC_DONE listener) {
        this.connect((Class)ASYNC_DONE.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                GstObject source = Natives.objectFor(msg.getSource(), GstObject.class, true, true);
                listener.asyncDone(source);
                return true;
            }
        });
    }

    public void disconnect(ASYNC_DONE listener) {
        this.disconnect(ASYNC_DONE.class, listener);
    }

    public void connect(final MESSAGE listener) {
        this.connect((Class)MESSAGE.class, (Object)listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                listener.busMessage(Bus.this, Natives.objectFor(msg, Message.class, true, true));
                return true;
            }
        });
    }

    public void connect(String signal, final MESSAGE listener) {
        if (signal.contains("::")) {
            signal = signal.substring(signal.lastIndexOf("::") + 2);
        }
        this.connect(signal, MESSAGE.class, listener, new GstBusAPI.BusCallback(){

            @Override
            public boolean callback(GstBusPtr bus, GstMessagePtr msg, Pointer user_data) {
                listener.busMessage(Bus.this, Natives.objectFor(msg, Message.class, true, true));
                return true;
            }
        });
    }

    public void disconnect(MESSAGE listener) {
        this.disconnect(MESSAGE.class, listener);
    }

    public boolean post(Message message) {
        return GstBusAPI.GSTBUS_API.gst_bus_post(this, message);
    }

    public void setSyncHandler(BusSyncHandler handler) {
        this.syncHandler = handler;
    }

    public void clearSyncHandler() {
        this.setSyncHandler(null);
    }

    public BusSyncHandler getSyncHandler() {
        return this.syncHandler;
    }

    private <T> void connect(Class<T> listenerClass, T listener, GstBusAPI.BusCallback callback) {
        String className = listenerClass.getSimpleName();
        MessageType type = "MESSAGE".equals(className) ? MessageType.ANY : MessageType.valueOf(listenerClass.getSimpleName());
        this.addMessageProxy(type, listenerClass, listener, callback);
    }

    @Override
    public <T> void connect(String signal, Class<T> listenerClass, T listener, Callback callback) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.connect(signal, listenerClass, listener, callback);
        } else {
            MessageType type = "message".equals(signal) ? MessageType.ANY : MessageType.valueOf(signal.toUpperCase(Locale.ROOT).replace('-', '_'));
            this.addMessageProxy(type, listenerClass, listener, (GstBusAPI.BusCallback)callback);
        }
    }

    private synchronized <T> void addMessageProxy(MessageType type, Class<T> listenerClass, T listener, GstBusAPI.BusCallback callback) {
        this.messageProxies.add(new MessageProxy<T>(type, listenerClass, listener, callback));
        this.addWatch();
    }

    @Override
    public <T> void disconnect(Class<T> listenerClass, T listener) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.disconnect(listenerClass, listener);
        } else {
            this.removeMessageProxy(listenerClass, listener);
        }
    }

    private synchronized <T> void removeMessageProxy(Class<T> listenerClass, T listener) {
        this.messageProxies.removeIf(p -> ((MessageProxy)p).listener == listener);
        if (this.messageProxies.isEmpty()) {
            this.removeWatch();
        }
    }

    private void dispatchMessage(GstBusPtr busPtr, GstMessagePtr msgPtr) {
        this.messageProxies.forEach(p -> {
            try {
                p.busMessage(busPtr, msgPtr);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception thrown by bus message handler", t);
            }
        });
        GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_unref(msgPtr);
    }

    @Override
    public void dispose() {
        this.removeWatch();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWatch() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.watchAdded) {
                LOG.fine("Add watch");
                GstBusAPI.GSTBUS_API.gst_bus_add_signal_watch(this);
                this.watchAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWatch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.watchAdded) {
                LOG.fine("Remove watch");
                GstBusAPI.GSTBUS_API.gst_bus_remove_signal_watch(this);
                this.watchAdded = false;
            }
        }
    }

    private static class SyncCallback
    implements GstBusAPI.BusSyncHandler {
        private SyncCallback() {
            Native.setCallbackThreadInitializer((Callback)this, (CallbackThreadInitializer)new CallbackThreadInitializer(true, Boolean.getBoolean("glib.detachCallbackThreads"), Bus.GTYPE_NAME));
        }

        @Override
        public BusSyncReply callback(GstBusPtr busPtr, GstMessagePtr msgPtr, Pointer userData) {
            Bus bus = Natives.objectFor(busPtr, Bus.class, true, true);
            BusSyncHandler syncHandler = bus.syncHandler;
            if (syncHandler != null) {
                Message msg = Natives.objectFor(msgPtr, Message.class, true, true);
                BusSyncReply reply = syncHandler.syncMessage(msg);
                if (reply != BusSyncReply.DROP) {
                    Gst.getExecutor().execute(() -> bus.dispatchMessage(busPtr, msgPtr));
                } else {
                    GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_unref(msgPtr);
                }
            } else {
                Gst.getExecutor().execute(() -> bus.dispatchMessage(busPtr, msgPtr));
            }
            return BusSyncReply.DROP;
        }
    }

    private static class MessageProxy<T> {
        private final MessageType type;
        private final Class<T> listenerClass;
        private final Object listener;
        private final GstBusAPI.BusCallback callback;

        MessageProxy(MessageType type, Class<T> listenerClass, T listener, GstBusAPI.BusCallback callback) {
            this.type = type;
            this.listenerClass = listenerClass;
            this.listener = listener;
            this.callback = callback;
        }

        void busMessage(GstBusPtr bus, GstMessagePtr msg) {
            if (this.type == MessageType.ANY || this.type.intValue() == msg.getMessageType()) {
                this.callback.callback(bus, msg, null);
            }
        }
    }

    public static interface MESSAGE {
        public void busMessage(Bus var1, Message var2);
    }

    public static interface ASYNC_DONE {
        public void asyncDone(GstObject var1);
    }

    public static interface SEGMENT_DONE {
        public void segmentDone(GstObject var1, Format var2, long var3);
    }

    public static interface SEGMENT_START {
        public void segmentStart(GstObject var1, Format var2, long var3);
    }

    public static interface DURATION_CHANGED {
        public void durationChanged(GstObject var1);
    }

    public static interface BUFFERING {
        public void bufferingData(GstObject var1, int var2);
    }

    public static interface STATE_CHANGED {
        public void stateChanged(GstObject var1, State var2, State var3, State var4);
    }

    public static interface TAG {
        public void tagsFound(GstObject var1, TagList var2);
    }

    public static interface INFO {
        public void infoMessage(GstObject var1, int var2, String var3);
    }

    public static interface WARNING {
        public void warningMessage(GstObject var1, int var2, String var3);
    }

    public static interface ERROR {
        public void errorMessage(GstObject var1, int var2, String var3);
    }

    public static interface EOS {
        public void endOfStream(GstObject var1);
    }
}

