/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import org.jetbrains.annotations.Nullable;

public abstract class ComparableExpressionBase<T extends Comparable>
extends SimpleExpression<T> {
    private static final long serialVersionUID = 1460921109546656911L;
    @Nullable
    private volatile transient OrderSpecifier<T> asc;
    @Nullable
    private volatile transient OrderSpecifier<T> desc;

    public ComparableExpressionBase(Expression<T> mixin) {
        super(mixin);
    }

    public OrderSpecifier<T> asc() {
        if (this.asc == null) {
            this.asc = new OrderSpecifier(Order.ASC, this.mixin);
        }
        return this.asc;
    }

    public ComparableExpressionBase<T> coalesce(Expression<T> expr) {
        Coalesce<Expression<T>> coalesce = new Coalesce<Expression<T>>(this.getType(), this.mixin);
        coalesce.add(expr);
        return coalesce.getValue();
    }

    public ComparableExpressionBase<T> coalesce(Expression<T> ... exprs) {
        Coalesce<Expression<T>> coalesce = new Coalesce<Expression<T>>(this.getType(), this.mixin);
        for (Expression<T> expr : exprs) {
            coalesce.add(expr);
        }
        return coalesce.getValue();
    }

    public ComparableExpressionBase<T> coalesce(T arg) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        coalesce.add(arg);
        return coalesce.getValue();
    }

    public ComparableExpressionBase<T> coalesce(T ... args) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        for (T arg : args) {
            coalesce.add(arg);
        }
        return coalesce.getValue();
    }

    @Override
    public ComparableExpressionBase<T> nullif(Expression<T> other) {
        return Expressions.comparableOperation(this.getType(), Ops.NULLIF, this.mixin, other);
    }

    @Override
    public ComparableExpressionBase<T> nullif(T other) {
        return this.nullif((Expression)ConstantImpl.create(other));
    }

    public OrderSpecifier<T> desc() {
        if (this.desc == null) {
            this.desc = new OrderSpecifier(Order.DESC, this.mixin);
        }
        return this.desc;
    }

    public ComparableExpressionBase<T> min() {
        return Expressions.comparableOperation(this.getType(), Ops.AggOps.MIN_AGG, this.mixin);
    }

    public ComparableExpressionBase<T> max() {
        return Expressions.comparableOperation(this.getType(), Ops.AggOps.MAX_AGG, this.mixin);
    }
}

